/*
 * Decompiled with CFR 0.152.
 */
package javafx.beans.property;

import com.sun.javafx.binding.ListExpressionHelper;
import javafx.beans.InvalidationListener;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.ReadOnlyListProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.beans.value.ChangeListener;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;

public class ReadOnlyListWrapper<E>
extends SimpleListProperty<E> {
    private ReadOnlyPropertyImpl readOnlyProperty;

    public ReadOnlyListWrapper() {
    }

    public ReadOnlyListWrapper(ObservableList<E> initialValue) {
        super(initialValue);
    }

    public ReadOnlyListWrapper(Object bean, String name) {
        super(bean, name);
    }

    public ReadOnlyListWrapper(Object bean, String name, ObservableList<E> initialValue) {
        super(bean, name, initialValue);
    }

    public ReadOnlyListProperty<E> getReadOnlyProperty() {
        if (this.readOnlyProperty == null) {
            this.readOnlyProperty = new ReadOnlyPropertyImpl();
        }
        return this.readOnlyProperty;
    }

    @Override
    public void addListener(InvalidationListener listener) {
        this.getReadOnlyProperty().addListener(listener);
    }

    @Override
    public void removeListener(InvalidationListener listener) {
        if (this.readOnlyProperty != null) {
            this.readOnlyProperty.removeListener(listener);
        }
    }

    @Override
    public void addListener(ChangeListener<? super ObservableList<E>> listener) {
        this.getReadOnlyProperty().addListener(listener);
    }

    @Override
    public void removeListener(ChangeListener<? super ObservableList<E>> listener) {
        if (this.readOnlyProperty != null) {
            this.readOnlyProperty.removeListener(listener);
        }
    }

    @Override
    public void addListener(ListChangeListener<? super E> listener) {
        this.getReadOnlyProperty().addListener(listener);
    }

    @Override
    public void removeListener(ListChangeListener<? super E> listener) {
        if (this.readOnlyProperty != null) {
            this.readOnlyProperty.removeListener(listener);
        }
    }

    @Override
    protected void fireValueChangedEvent() {
        if (this.readOnlyProperty != null) {
            this.readOnlyProperty.fireValueChangedEvent();
        }
    }

    @Override
    protected void fireValueChangedEvent(ListChangeListener.Change<? extends E> change) {
        if (this.readOnlyProperty != null) {
            this.readOnlyProperty.fireValueChangedEvent(change);
        }
    }

    private class ReadOnlyPropertyImpl
    extends ReadOnlyListProperty<E> {
        private ListExpressionHelper<E> helper = null;

        private ReadOnlyPropertyImpl() {
        }

        @Override
        public ObservableList<E> get() {
            return ReadOnlyListWrapper.this.get();
        }

        @Override
        public void addListener(InvalidationListener listener) {
            this.helper = ListExpressionHelper.addListener(this.helper, this, listener);
        }

        @Override
        public void removeListener(InvalidationListener listener) {
            this.helper = ListExpressionHelper.removeListener(this.helper, listener);
        }

        @Override
        public void addListener(ChangeListener<? super ObservableList<E>> listener) {
            this.helper = ListExpressionHelper.addListener(this.helper, this, listener);
        }

        @Override
        public void removeListener(ChangeListener<? super ObservableList<E>> listener) {
            this.helper = ListExpressionHelper.removeListener(this.helper, listener);
        }

        @Override
        public void addListener(ListChangeListener<? super E> listener) {
            this.helper = ListExpressionHelper.addListener(this.helper, this, listener);
        }

        @Override
        public void removeListener(ListChangeListener<? super E> listener) {
            this.helper = ListExpressionHelper.removeListener(this.helper, listener);
        }

        private void fireValueChangedEvent() {
            ListExpressionHelper.fireValueChangedEvent(this.helper);
        }

        private void fireValueChangedEvent(ListChangeListener.Change<? extends E> change) {
            ListExpressionHelper.fireValueChangedEvent(this.helper, change);
        }

        @Override
        public Object getBean() {
            return ReadOnlyListWrapper.this.getBean();
        }

        @Override
        public String getName() {
            return ReadOnlyListWrapper.this.getName();
        }

        @Override
        public ReadOnlyIntegerProperty sizeProperty() {
            return ReadOnlyListWrapper.this.sizeProperty();
        }

        @Override
        public ReadOnlyBooleanProperty emptyProperty() {
            return ReadOnlyListWrapper.this.emptyProperty();
        }
    }
}

