/*
 * Decompiled with CFR 0.152.
 */
package javafx.beans.property;

import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.binding.LongExpression;
import javafx.beans.property.ReadOnlyLongProperty$1$$Lambda$1;
import javafx.beans.property.ReadOnlyLongProperty$2$$Lambda$1;
import javafx.beans.property.ReadOnlyLongPropertyBase;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectPropertyBase;
import javafx.beans.property.ReadOnlyProperty;

public abstract class ReadOnlyLongProperty
extends LongExpression
implements ReadOnlyProperty<Number> {
    public String toString() {
        Object bean = this.getBean();
        String name = this.getName();
        StringBuilder result = new StringBuilder("ReadOnlyLongProperty [");
        if (bean != null) {
            result.append("bean: ").append(bean).append(", ");
        }
        if (name != null && !name.equals("")) {
            result.append("name: ").append(name).append(", ");
        }
        result.append("value: ").append(this.get()).append("]");
        return result.toString();
    }

    public static <T extends Number> ReadOnlyLongProperty readOnlyLongProperty(final ReadOnlyProperty<T> property) {
        if (property == null) {
            throw new NullPointerException("Property cannot be null");
        }
        return property instanceof ReadOnlyLongProperty ? (ReadOnlyLongProperty)property : new ReadOnlyLongPropertyBase(){
            private boolean valid = true;
            private final InvalidationListener listener = ReadOnlyLongProperty$1$$Lambda$1.lambdaFactory$(this);
            {
                property.addListener(new WeakInvalidationListener(this.listener));
            }

            @Override
            public long get() {
                this.valid = true;
                Number value = (Number)property.getValue();
                return value == null ? 0L : value.longValue();
            }

            @Override
            public Object getBean() {
                return null;
            }

            @Override
            public String getName() {
                return property.getName();
            }

            private /* synthetic */ void lambda$$9(Observable observable) {
                if (this.valid) {
                    this.valid = false;
                    this.fireValueChangedEvent();
                }
            }

            static /* synthetic */ void access$lambda$0(1 var0, Observable observable) {
                var0.lambda$$9(observable);
            }
        };
    }

    public ReadOnlyObjectProperty<Long> asObject() {
        return new ReadOnlyObjectPropertyBase<Long>(){
            private boolean valid = true;
            private final InvalidationListener listener = ReadOnlyLongProperty$2$$Lambda$1.lambdaFactory$(this);
            {
                ReadOnlyLongProperty.this.addListener(new WeakInvalidationListener(this.listener));
            }

            @Override
            public Object getBean() {
                return null;
            }

            @Override
            public String getName() {
                return ReadOnlyLongProperty.this.getName();
            }

            @Override
            public Long get() {
                this.valid = true;
                return ReadOnlyLongProperty.this.getValue();
            }

            private /* synthetic */ void lambda$$10(Observable observable) {
                if (this.valid) {
                    this.valid = false;
                    this.fireValueChangedEvent();
                }
            }

            static /* synthetic */ void access$lambda$0(2 var0, Observable observable) {
                var0.lambda$$10(observable);
            }
        };
    }
}

