/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.chart;

import com.sun.javafx.charts.Legend;
import com.sun.javafx.css.converters.SizeConverter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javafx.animation.Animation;
import javafx.animation.FadeTransition;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.ParallelTransition;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.NamedArg;
import javafx.beans.property.DoubleProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.PseudoClass;
import javafx.css.Styleable;
import javafx.css.StyleableDoubleProperty;
import javafx.css.StyleableProperty;
import javafx.event.ActionEvent;
import javafx.geometry.Orientation;
import javafx.scene.AccessibleRole;
import javafx.scene.Node;
import javafx.scene.chart.Axis;
import javafx.scene.chart.BarChart$$Lambda$1;
import javafx.scene.chart.BarChart$$Lambda$2;
import javafx.scene.chart.BarChart$$Lambda$3;
import javafx.scene.chart.BarChart$$Lambda$4;
import javafx.scene.chart.BarChart$$Lambda$5;
import javafx.scene.chart.CategoryAxis;
import javafx.scene.chart.ValueAxis;
import javafx.scene.chart.XYChart;
import javafx.scene.layout.StackPane;
import javafx.util.Duration;

public class BarChart<X, Y>
extends XYChart<X, Y> {
    private Map<XYChart.Series<X, Y>, Map<String, XYChart.Data<X, Y>>> seriesCategoryMap = new HashMap<XYChart.Series<X, Y>, Map<String, XYChart.Data<X, Y>>>();
    private Legend legend = new Legend();
    private final Orientation orientation;
    private CategoryAxis categoryAxis;
    private ValueAxis valueAxis;
    private Timeline dataRemoveTimeline;
    private double bottomPos = 0.0;
    private static String NEGATIVE_STYLE = "negative";
    private ParallelTransition pt;
    private Map<XYChart.Data<X, Y>, Double> XYValueMap = new HashMap<XYChart.Data<X, Y>, Double>();
    private DoubleProperty barGap = new StyleableDoubleProperty(4.0){

        @Override
        protected void invalidated() {
            this.get();
            BarChart.this.requestChartLayout();
        }

        @Override
        public Object getBean() {
            return BarChart.this;
        }

        @Override
        public String getName() {
            return "barGap";
        }

        @Override
        public CssMetaData<BarChart<?, ?>, Number> getCssMetaData() {
            return StyleableProperties.BAR_GAP;
        }
    };
    private DoubleProperty categoryGap = new StyleableDoubleProperty(10.0){

        @Override
        protected void invalidated() {
            this.get();
            BarChart.this.requestChartLayout();
        }

        @Override
        public Object getBean() {
            return BarChart.this;
        }

        @Override
        public String getName() {
            return "categoryGap";
        }

        @Override
        public CssMetaData<BarChart<?, ?>, Number> getCssMetaData() {
            return StyleableProperties.CATEGORY_GAP;
        }
    };
    private static final PseudoClass VERTICAL_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass("vertical");
    private static final PseudoClass HORIZONTAL_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass("horizontal");

    public final double getBarGap() {
        return this.barGap.getValue();
    }

    public final void setBarGap(double value) {
        this.barGap.setValue(value);
    }

    public final DoubleProperty barGapProperty() {
        return this.barGap;
    }

    public final double getCategoryGap() {
        return this.categoryGap.getValue();
    }

    public final void setCategoryGap(double value) {
        this.categoryGap.setValue(value);
    }

    public final DoubleProperty categoryGapProperty() {
        return this.categoryGap;
    }

    public BarChart(@NamedArg(value="xAxis") Axis<X> xAxis, @NamedArg(value="yAxis") Axis<Y> yAxis) {
        this(xAxis, yAxis, FXCollections.observableArrayList());
    }

    public BarChart(@NamedArg(value="xAxis") Axis<X> xAxis, @NamedArg(value="yAxis") Axis<Y> yAxis, @NamedArg(value="data") ObservableList<XYChart.Series<X, Y>> data) {
        super(xAxis, yAxis);
        this.getStyleClass().add("bar-chart");
        this.setLegend(this.legend);
        if (!(xAxis instanceof ValueAxis && yAxis instanceof CategoryAxis || yAxis instanceof ValueAxis && xAxis instanceof CategoryAxis)) {
            throw new IllegalArgumentException("Axis type incorrect, one of X,Y should be CategoryAxis and the other NumberAxis");
        }
        if (xAxis instanceof CategoryAxis) {
            this.categoryAxis = (CategoryAxis)xAxis;
            this.valueAxis = (ValueAxis)yAxis;
            this.orientation = Orientation.VERTICAL;
        } else {
            this.categoryAxis = (CategoryAxis)yAxis;
            this.valueAxis = (ValueAxis)xAxis;
            this.orientation = Orientation.HORIZONTAL;
        }
        this.pseudoClassStateChanged(HORIZONTAL_PSEUDOCLASS_STATE, this.orientation == Orientation.HORIZONTAL);
        this.pseudoClassStateChanged(VERTICAL_PSEUDOCLASS_STATE, this.orientation == Orientation.VERTICAL);
        this.setData(data);
    }

    public BarChart(@NamedArg(value="xAxis") Axis<X> xAxis, @NamedArg(value="yAxis") Axis<Y> yAxis, @NamedArg(value="data") ObservableList<XYChart.Series<X, Y>> data, @NamedArg(value="categoryGap") double categoryGap) {
        this(xAxis, yAxis);
        this.setData(data);
        this.setCategoryGap(categoryGap);
    }

    @Override
    protected void dataItemAdded(XYChart.Series<X, Y> series, int itemIndex, XYChart.Data<X, Y> item) {
        String category = this.orientation == Orientation.VERTICAL ? (String)item.getXValue() : (String)item.getYValue();
        Map<String, XYChart.Data<X, Y>> categoryMap = this.seriesCategoryMap.get(series);
        if (categoryMap == null) {
            categoryMap = new HashMap<String, XYChart.Data<X, Y>>();
            this.seriesCategoryMap.put(series, categoryMap);
        }
        if (!this.categoryAxis.getCategories().contains(category)) {
            this.categoryAxis.getCategories().add(itemIndex, category);
        } else if (categoryMap.containsKey(category)) {
            XYChart.Data<X, Y> data = categoryMap.get(category);
            this.getPlotChildren().remove(data.getNode());
            this.removeDataItemFromDisplay(series, data);
            this.requestChartLayout();
            categoryMap.remove(category);
        }
        categoryMap.put(category, item);
        Node bar = this.createBar(series, this.getData().indexOf(series), item, itemIndex);
        if (this.shouldAnimate()) {
            this.animateDataAdd(item, bar);
        } else {
            this.getPlotChildren().add(bar);
        }
    }

    @Override
    protected void dataItemRemoved(XYChart.Data<X, Y> item, XYChart.Series<X, Y> series) {
        Node bar = item.getNode();
        if (bar != null) {
            bar.focusTraversableProperty().unbind();
        }
        if (this.shouldAnimate()) {
            this.XYValueMap.clear();
            this.dataRemoveTimeline = this.createDataRemoveTimeline(item, bar, series);
            this.dataRemoveTimeline.setOnFinished(BarChart$$Lambda$1.lambdaFactory$(this, item, series));
            this.dataRemoveTimeline.play();
        } else {
            this.processDataRemove(series, item);
            this.removeDataItemFromDisplay(series, item);
        }
    }

    @Override
    protected void dataItemChanged(XYChart.Data<X, Y> item) {
        double currentVal;
        double barVal;
        if (this.orientation == Orientation.VERTICAL) {
            barVal = ((Number)item.getYValue()).doubleValue();
            currentVal = ((Number)item.getCurrentY()).doubleValue();
        } else {
            barVal = ((Number)item.getXValue()).doubleValue();
            currentVal = ((Number)item.getCurrentX()).doubleValue();
        }
        if (currentVal > 0.0 && barVal < 0.0) {
            item.getNode().getStyleClass().add(NEGATIVE_STYLE);
        } else if (currentVal < 0.0 && barVal > 0.0) {
            item.getNode().getStyleClass().remove(NEGATIVE_STYLE);
        }
    }

    @Override
    protected void seriesAdded(XYChart.Series<X, Y> series, int seriesIndex) {
        HashMap<String, XYChart.Data> categoryMap = new HashMap<String, XYChart.Data>();
        for (int j = 0; j < series.getData().size(); ++j) {
            double barVal;
            XYChart.Data item = (XYChart.Data)series.getData().get(j);
            Node bar = this.createBar(series, seriesIndex, item, j);
            String category = this.orientation == Orientation.VERTICAL ? (String)item.getXValue() : (String)item.getYValue();
            categoryMap.put(category, item);
            if (this.shouldAnimate()) {
                this.animateDataAdd(item, bar);
                continue;
            }
            double d = barVal = this.orientation == Orientation.VERTICAL ? ((Number)item.getYValue()).doubleValue() : ((Number)item.getXValue()).doubleValue();
            if (barVal < 0.0) {
                bar.getStyleClass().add(NEGATIVE_STYLE);
            }
            this.getPlotChildren().add(bar);
        }
        if (categoryMap.size() > 0) {
            this.seriesCategoryMap.put(series, categoryMap);
        }
    }

    @Override
    protected void seriesRemoved(XYChart.Series<X, Y> series) {
        this.updateDefaultColorIndex(series);
        if (this.shouldAnimate()) {
            this.pt = new ParallelTransition();
            this.pt.setOnFinished(BarChart$$Lambda$2.lambdaFactory$(this, series));
            boolean lastSeries = this.getSeriesSize() <= 1;
            this.XYValueMap.clear();
            for (XYChart.Data data : series.getData()) {
                Node bar = data.getNode();
                if (!lastSeries) {
                    Timeline t = this.createDataRemoveTimeline(data, bar, series);
                    this.pt.getChildren().add(t);
                    continue;
                }
                FadeTransition ft = new FadeTransition(Duration.millis(700.0), bar);
                ft.setFromValue(1.0);
                ft.setToValue(0.0);
                ft.setOnFinished(BarChart$$Lambda$3.lambdaFactory$(this, series, data, bar));
                this.pt.getChildren().add(ft);
            }
            this.pt.play();
        } else {
            for (XYChart.Data data : series.getData()) {
                Node node = data.getNode();
                this.getPlotChildren().remove(node);
                this.updateMap(series, data);
            }
            this.removeSeriesFromDisplay(series);
        }
    }

    @Override
    protected void layoutPlotChildren() {
        double zeroPos;
        double catSpace = this.categoryAxis.getCategorySpacing();
        double avilableBarSpace = catSpace - (this.getCategoryGap() + this.getBarGap());
        double barWidth = avilableBarSpace / (double)this.getSeriesSize() - this.getBarGap();
        double barOffset = -((catSpace - this.getCategoryGap()) / 2.0);
        double d = zeroPos = this.valueAxis.getLowerBound() > 0.0 ? this.valueAxis.getDisplayPosition(this.valueAxis.getLowerBound()) : this.valueAxis.getZeroPosition();
        if (barWidth <= 0.0) {
            barWidth = 1.0;
        }
        int catIndex = 0;
        for (String category : this.categoryAxis.getCategories()) {
            int index = 0;
            Iterator sit = this.getDisplayedSeriesIterator();
            while (sit.hasNext()) {
                double valPos;
                double categoryPos;
                XYChart.Series series = sit.next();
                XYChart.Data item = this.getDataItem(series, index, catIndex, category);
                if (item == null) continue;
                Node bar = item.getNode();
                if (this.orientation == Orientation.VERTICAL) {
                    categoryPos = this.getXAxis().getDisplayPosition(item.getCurrentX());
                    valPos = this.getYAxis().getDisplayPosition(item.getCurrentY());
                } else {
                    categoryPos = this.getYAxis().getDisplayPosition(item.getCurrentY());
                    valPos = this.getXAxis().getDisplayPosition(item.getCurrentX());
                }
                if (Double.isNaN(categoryPos) || Double.isNaN(valPos)) continue;
                double bottom = Math.min(valPos, zeroPos);
                double top = Math.max(valPos, zeroPos);
                this.bottomPos = bottom;
                if (this.orientation == Orientation.VERTICAL) {
                    bar.resizeRelocate(categoryPos + barOffset + (barWidth + this.getBarGap()) * (double)index, bottom, barWidth, top - bottom);
                } else {
                    bar.resizeRelocate(bottom, categoryPos + barOffset + (barWidth + this.getBarGap()) * (double)index, top - bottom, barWidth);
                }
                ++index;
            }
            ++catIndex;
        }
    }

    @Override
    protected void updateLegend() {
        this.legend.getItems().clear();
        if (this.getData() != null) {
            for (int seriesIndex = 0; seriesIndex < this.getData().size(); ++seriesIndex) {
                XYChart.Series series = (XYChart.Series)this.getData().get(seriesIndex);
                Legend.LegendItem legenditem = new Legend.LegendItem(series.getName());
                legenditem.getSymbol().getStyleClass().addAll((String[])new String[]{"chart-bar", "series" + seriesIndex, "bar-legend-symbol", series.defaultColorStyleClass});
                this.legend.getItems().add(legenditem);
            }
        }
        if (this.legend.getItems().size() > 0) {
            if (this.getLegend() == null) {
                this.setLegend(this.legend);
            }
        } else {
            this.setLegend(null);
        }
    }

    private void updateMap(XYChart.Series<X, Y> series, XYChart.Data<X, Y> item) {
        String category = this.orientation == Orientation.VERTICAL ? (String)item.getXValue() : (String)item.getYValue();
        Map<String, XYChart.Data<X, Y>> categoryMap = this.seriesCategoryMap.get(series);
        if (categoryMap != null) {
            categoryMap.remove(category);
            if (categoryMap.isEmpty()) {
                this.seriesCategoryMap.remove(series);
            }
        }
        if (this.seriesCategoryMap.isEmpty() && this.categoryAxis.isAutoRanging()) {
            this.categoryAxis.getCategories().clear();
        }
    }

    private void processDataRemove(XYChart.Series<X, Y> series, XYChart.Data<X, Y> item) {
        Node bar = item.getNode();
        this.getPlotChildren().remove(bar);
        this.updateMap(series, item);
    }

    private void animateDataAdd(XYChart.Data<X, Y> item, Node bar) {
        if (this.orientation == Orientation.VERTICAL) {
            double barVal = ((Number)item.getYValue()).doubleValue();
            if (barVal < 0.0) {
                bar.getStyleClass().add(NEGATIVE_STYLE);
            }
            item.setCurrentY(this.getYAxis().toRealValue(barVal < 0.0 ? -this.bottomPos : this.bottomPos));
            this.getPlotChildren().add(bar);
            item.setYValue(this.getYAxis().toRealValue(barVal));
            this.animate(new KeyFrame(Duration.ZERO, new KeyValue(item.currentYProperty(), item.getCurrentY())), new KeyFrame(Duration.millis(700.0), new KeyValue(item.currentYProperty(), item.getYValue(), Interpolator.EASE_BOTH)));
        } else {
            double barVal = ((Number)item.getXValue()).doubleValue();
            if (barVal < 0.0) {
                bar.getStyleClass().add(NEGATIVE_STYLE);
            }
            item.setCurrentX(this.getXAxis().toRealValue(barVal < 0.0 ? -this.bottomPos : this.bottomPos));
            this.getPlotChildren().add(bar);
            item.setXValue(this.getXAxis().toRealValue(barVal));
            this.animate(new KeyFrame(Duration.ZERO, new KeyValue(item.currentXProperty(), item.getCurrentX())), new KeyFrame(Duration.millis(700.0), new KeyValue(item.currentXProperty(), item.getXValue(), Interpolator.EASE_BOTH)));
        }
    }

    private Timeline createDataRemoveTimeline(XYChart.Data<X, Y> item, Node bar, XYChart.Series<X, Y> series) {
        Timeline t = new Timeline();
        if (this.orientation == Orientation.VERTICAL) {
            this.XYValueMap.put(item, ((Number)item.getYValue()).doubleValue());
            item.setYValue(this.getYAxis().toRealValue(this.bottomPos));
            t.getKeyFrames().addAll((KeyFrame[])new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue(item.currentYProperty(), item.getCurrentY())), new KeyFrame(Duration.millis(700.0), BarChart$$Lambda$4.lambdaFactory$(this, series, item), new KeyValue(item.currentYProperty(), item.getYValue(), Interpolator.EASE_BOTH))});
        } else {
            this.XYValueMap.put(item, ((Number)item.getXValue()).doubleValue());
            item.setXValue(this.getXAxis().toRealValue(this.getXAxis().getZeroPosition()));
            t.getKeyFrames().addAll((KeyFrame[])new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue(item.currentXProperty(), item.getCurrentX())), new KeyFrame(Duration.millis(700.0), BarChart$$Lambda$5.lambdaFactory$(this, series, item), new KeyValue(item.currentXProperty(), item.getXValue(), Interpolator.EASE_BOTH))});
        }
        return t;
    }

    @Override
    void dataBeingRemovedIsAdded(XYChart.Data<X, Y> item, XYChart.Series<X, Y> series) {
        if (this.dataRemoveTimeline != null) {
            this.dataRemoveTimeline.setOnFinished(null);
            this.dataRemoveTimeline.stop();
        }
        this.processDataRemove(series, item);
        item.setSeries(null);
        this.removeDataItemFromDisplay(series, item);
        this.restoreDataValues(item);
        this.XYValueMap.clear();
    }

    private void restoreDataValues(XYChart.Data item) {
        Double value = this.XYValueMap.get(item);
        if (value != null) {
            if (this.orientation.equals((Object)Orientation.VERTICAL)) {
                item.setYValue(value);
                item.setCurrentY(value);
            } else {
                item.setXValue(value);
                item.setCurrentX(value);
            }
        }
    }

    @Override
    void seriesBeingRemovedIsAdded(XYChart.Series<X, Y> series) {
        boolean lastSeries;
        boolean bl = lastSeries = this.pt.getChildren().size() == 1;
        if (this.pt != null) {
            if (!this.pt.getChildren().isEmpty()) {
                for (Animation animation : this.pt.getChildren()) {
                    animation.setOnFinished(null);
                }
            }
            for (XYChart.Data data : series.getData()) {
                this.processDataRemove(series, data);
                if (lastSeries) continue;
                this.restoreDataValues(data);
            }
            this.XYValueMap.clear();
            this.pt.setOnFinished(null);
            this.pt.getChildren().clear();
            this.pt.stop();
            this.removeSeriesFromDisplay(series);
        }
    }

    private void updateDefaultColorIndex(XYChart.Series<X, Y> series) {
        int clearIndex = (Integer)this.seriesColorMap.get(series);
        for (XYChart.Data data : series.getData()) {
            Node bar = data.getNode();
            if (bar == null) continue;
            bar.getStyleClass().remove(DEFAULT_COLOR + clearIndex);
        }
    }

    private Node createBar(XYChart.Series<X, Y> series, int seriesIndex, XYChart.Data<X, Y> item, int itemIndex) {
        Node bar = item.getNode();
        if (bar == null) {
            bar = new StackPane();
            bar.setAccessibleRole(AccessibleRole.TEXT);
            bar.setAccessibleRoleDescription("Bar");
            bar.focusTraversableProperty().bind(Platform.accessibilityActiveProperty());
            item.setNode(bar);
        }
        bar.getStyleClass().addAll((String[])new String[]{"chart-bar", "series" + seriesIndex, "data" + itemIndex, series.defaultColorStyleClass});
        return bar;
    }

    private XYChart.Data<X, Y> getDataItem(XYChart.Series<X, Y> series, int seriesIndex, int itemIndex, String category) {
        Map<String, XYChart.Data<X, Y>> catmap = this.seriesCategoryMap.get(series);
        return catmap != null ? catmap.get(category) : null;
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return BarChart.getClassCssMetaData();
    }

    private /* synthetic */ void lambda$createDataRemoveTimeline$564(XYChart.Series series, XYChart.Data item, ActionEvent actionEvent) {
        this.processDataRemove(series, item);
        this.XYValueMap.clear();
    }

    private /* synthetic */ void lambda$createDataRemoveTimeline$563(XYChart.Series series, XYChart.Data item, ActionEvent actionEvent) {
        this.processDataRemove(series, item);
        this.XYValueMap.clear();
    }

    private /* synthetic */ void lambda$seriesRemoved$562(XYChart.Series series, XYChart.Data d, Node bar, ActionEvent actionEvent) {
        this.processDataRemove(series, d);
        bar.setOpacity(1.0);
    }

    private /* synthetic */ void lambda$seriesRemoved$561(XYChart.Series series, ActionEvent event) {
        this.removeSeriesFromDisplay(series);
    }

    private /* synthetic */ void lambda$dataItemRemoved$560(XYChart.Data item, XYChart.Series series, ActionEvent event) {
        item.setSeries(null);
        this.removeDataItemFromDisplay(series, item);
    }

    static /* synthetic */ void access$lambda$0(BarChart barChart, XYChart.Data data, XYChart.Series series, ActionEvent actionEvent) {
        barChart.lambda$dataItemRemoved$560(data, series, actionEvent);
    }

    static /* synthetic */ void access$lambda$1(BarChart barChart, XYChart.Series series, ActionEvent actionEvent) {
        barChart.lambda$seriesRemoved$561(series, actionEvent);
    }

    static /* synthetic */ void access$lambda$2(BarChart barChart, XYChart.Series series, XYChart.Data data, Node node, ActionEvent actionEvent) {
        barChart.lambda$seriesRemoved$562(series, data, node, actionEvent);
    }

    static /* synthetic */ void access$lambda$3(BarChart barChart, XYChart.Series series, XYChart.Data data, ActionEvent actionEvent) {
        barChart.lambda$createDataRemoveTimeline$563(series, data, actionEvent);
    }

    static /* synthetic */ void access$lambda$4(BarChart barChart, XYChart.Series series, XYChart.Data data, ActionEvent actionEvent) {
        barChart.lambda$createDataRemoveTimeline$564(series, data, actionEvent);
    }

    private static class StyleableProperties {
        private static final CssMetaData<BarChart<?, ?>, Number> BAR_GAP = new CssMetaData<BarChart<?, ?>, Number>("-fx-bar-gap", SizeConverter.getInstance(), 4.0){

            @Override
            public boolean isSettable(BarChart<?, ?> node) {
                return ((BarChart)node).barGap == null || !((BarChart)node).barGap.isBound();
            }

            @Override
            public StyleableProperty<Number> getStyleableProperty(BarChart<?, ?> node) {
                return (StyleableProperty)((Object)node.barGapProperty());
            }
        };
        private static final CssMetaData<BarChart<?, ?>, Number> CATEGORY_GAP = new CssMetaData<BarChart<?, ?>, Number>("-fx-category-gap", SizeConverter.getInstance(), 10.0){

            @Override
            public boolean isSettable(BarChart<?, ?> node) {
                return ((BarChart)node).categoryGap == null || !((BarChart)node).categoryGap.isBound();
            }

            @Override
            public StyleableProperty<Number> getStyleableProperty(BarChart<?, ?> node) {
                return (StyleableProperty)((Object)node.categoryGapProperty());
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList styleables = new ArrayList(XYChart.getClassCssMetaData());
            styleables.add(BAR_GAP);
            styleables.add(CATEGORY_GAP);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

