/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.chart;

import com.sun.javafx.charts.Legend;
import java.util.ArrayList;
import java.util.Iterator;
import javafx.animation.FadeTransition;
import javafx.animation.ParallelTransition;
import javafx.beans.NamedArg;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.scene.Node;
import javafx.scene.chart.Axis;
import javafx.scene.chart.BubbleChart$$Lambda$1;
import javafx.scene.chart.BubbleChart$$Lambda$2;
import javafx.scene.chart.BubbleChart$$Lambda$3;
import javafx.scene.chart.CategoryAxis;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.ValueAxis;
import javafx.scene.chart.XYChart;
import javafx.scene.layout.StackPane;
import javafx.scene.shape.Ellipse;
import javafx.util.Duration;

public class BubbleChart<X, Y>
extends XYChart<X, Y> {
    private Legend legend = new Legend();

    public BubbleChart(@NamedArg(value="xAxis") Axis<X> xAxis, @NamedArg(value="yAxis") Axis<Y> yAxis) {
        this(xAxis, yAxis, FXCollections.observableArrayList());
    }

    public BubbleChart(@NamedArg(value="xAxis") Axis<X> xAxis, @NamedArg(value="yAxis") Axis<Y> yAxis, @NamedArg(value="data") ObservableList<XYChart.Series<X, Y>> data) {
        super(xAxis, yAxis);
        this.setLegend(this.legend);
        if (!(xAxis instanceof ValueAxis) || !(yAxis instanceof ValueAxis)) {
            throw new IllegalArgumentException("Axis type incorrect, X and Y should both be NumberAxis");
        }
        this.setData(data);
    }

    private static double getDoubleValue(Object number, double nullDefault) {
        return !(number instanceof Number) ? nullDefault : ((Number)number).doubleValue();
    }

    @Override
    protected void layoutPlotChildren() {
        for (int seriesIndex = 0; seriesIndex < this.getDataSize(); ++seriesIndex) {
            XYChart.Series series = (XYChart.Series)this.getData().get(seriesIndex);
            Iterator iter = this.getDisplayedDataIterator(series);
            while (iter.hasNext()) {
                Ellipse ellipse;
                Node bubble;
                XYChart.Data item = iter.next();
                double x = this.getXAxis().getDisplayPosition(item.getCurrentX());
                double y = this.getYAxis().getDisplayPosition(item.getCurrentY());
                if (Double.isNaN(x) || Double.isNaN(y) || (bubble = item.getNode()) == null || !(bubble instanceof StackPane)) continue;
                StackPane region = (StackPane)item.getNode();
                if (region.getShape() == null) {
                    ellipse = new Ellipse(BubbleChart.getDoubleValue(item.getExtraValue(), 1.0), BubbleChart.getDoubleValue(item.getExtraValue(), 1.0));
                } else if (region.getShape() instanceof Ellipse) {
                    ellipse = (Ellipse)region.getShape();
                } else {
                    return;
                }
                ellipse.setRadiusX(BubbleChart.getDoubleValue(item.getExtraValue(), 1.0) * (this.getXAxis() instanceof NumberAxis ? Math.abs(((NumberAxis)this.getXAxis()).getScale()) : 1.0));
                ellipse.setRadiusY(BubbleChart.getDoubleValue(item.getExtraValue(), 1.0) * (this.getYAxis() instanceof NumberAxis ? Math.abs(((NumberAxis)this.getYAxis()).getScale()) : 1.0));
                region.setShape(null);
                region.setShape(ellipse);
                region.setScaleShape(false);
                region.setCenterShape(false);
                region.setCacheShape(false);
                bubble.setLayoutX(x);
                bubble.setLayoutY(y);
            }
        }
    }

    @Override
    protected void dataItemAdded(XYChart.Series<X, Y> series, int itemIndex, XYChart.Data<X, Y> item) {
        Node bubble = this.createBubble(series, this.getData().indexOf(series), item, itemIndex);
        if (this.shouldAnimate()) {
            bubble.setOpacity(0.0);
            this.getPlotChildren().add(bubble);
            FadeTransition ft = new FadeTransition(Duration.millis(500.0), bubble);
            ft.setToValue(1.0);
            ft.play();
        } else {
            this.getPlotChildren().add(bubble);
        }
    }

    @Override
    protected void dataItemRemoved(XYChart.Data<X, Y> item, XYChart.Series<X, Y> series) {
        Node bubble = item.getNode();
        if (this.shouldAnimate()) {
            FadeTransition ft = new FadeTransition(Duration.millis(500.0), bubble);
            ft.setToValue(0.0);
            ft.setOnFinished(BubbleChart$$Lambda$1.lambdaFactory$(this, bubble, series, item));
            ft.play();
        } else {
            this.getPlotChildren().remove(bubble);
            this.removeDataItemFromDisplay(series, item);
        }
    }

    @Override
    protected void dataItemChanged(XYChart.Data<X, Y> item) {
    }

    @Override
    protected void seriesAdded(XYChart.Series<X, Y> series, int seriesIndex) {
        for (int j = 0; j < series.getData().size(); ++j) {
            XYChart.Data item = (XYChart.Data)series.getData().get(j);
            Node bubble = this.createBubble(series, seriesIndex, item, j);
            if (this.shouldAnimate()) {
                bubble.setOpacity(0.0);
                this.getPlotChildren().add(bubble);
                FadeTransition ft = new FadeTransition(Duration.millis(500.0), bubble);
                ft.setToValue(1.0);
                ft.play();
                continue;
            }
            this.getPlotChildren().add(bubble);
        }
    }

    @Override
    protected void seriesRemoved(XYChart.Series<X, Y> series) {
        if (this.shouldAnimate()) {
            ParallelTransition pt = new ParallelTransition();
            pt.setOnFinished(BubbleChart$$Lambda$2.lambdaFactory$(this, series));
            for (XYChart.Data data : series.getData()) {
                Node bubble = data.getNode();
                FadeTransition ft = new FadeTransition(Duration.millis(500.0), bubble);
                ft.setToValue(0.0);
                ft.setOnFinished(BubbleChart$$Lambda$3.lambdaFactory$(this, bubble));
                pt.getChildren().add(ft);
            }
            pt.play();
        } else {
            for (XYChart.Data data : series.getData()) {
                Node node = data.getNode();
                this.getPlotChildren().remove(node);
            }
            this.removeSeriesFromDisplay(series);
        }
    }

    private Node createBubble(XYChart.Series<X, Y> series, int seriesIndex, XYChart.Data<X, Y> item, int itemIndex) {
        Node bubble = item.getNode();
        if (bubble == null) {
            bubble = new StackPane();
            item.setNode(bubble);
        }
        bubble.getStyleClass().setAll((String[])new String[]{"chart-bubble", "series" + seriesIndex, "data" + itemIndex, series.defaultColorStyleClass});
        return bubble;
    }

    @Override
    protected void updateAxisRange() {
        Axis xa = this.getXAxis();
        Axis ya = this.getYAxis();
        ArrayList xData = null;
        ArrayList yData = null;
        if (xa.isAutoRanging()) {
            xData = new ArrayList();
        }
        if (ya.isAutoRanging()) {
            yData = new ArrayList();
        }
        boolean xIsCategory = xa instanceof CategoryAxis;
        boolean yIsCategory = ya instanceof CategoryAxis;
        if (xData != null || yData != null) {
            for (XYChart.Series series : this.getData()) {
                for (XYChart.Data data : series.getData()) {
                    if (xData != null) {
                        if (xIsCategory) {
                            xData.add(data.getXValue());
                        } else {
                            xData.add(xa.toRealValue(xa.toNumericValue(data.getXValue()) + BubbleChart.getDoubleValue(data.getExtraValue(), 0.0)));
                            xData.add(xa.toRealValue(xa.toNumericValue(data.getXValue()) - BubbleChart.getDoubleValue(data.getExtraValue(), 0.0)));
                        }
                    }
                    if (yData == null) continue;
                    if (yIsCategory) {
                        yData.add(data.getYValue());
                        continue;
                    }
                    yData.add(ya.toRealValue(ya.toNumericValue(data.getYValue()) + BubbleChart.getDoubleValue(data.getExtraValue(), 0.0)));
                    yData.add(ya.toRealValue(ya.toNumericValue(data.getYValue()) - BubbleChart.getDoubleValue(data.getExtraValue(), 0.0)));
                }
            }
            if (xData != null) {
                xa.invalidateRange(xData);
            }
            if (yData != null) {
                ya.invalidateRange(yData);
            }
        }
    }

    @Override
    protected void updateLegend() {
        this.legend.getItems().clear();
        if (this.getData() != null) {
            for (int seriesIndex = 0; seriesIndex < this.getData().size(); ++seriesIndex) {
                XYChart.Series series = (XYChart.Series)this.getData().get(seriesIndex);
                Legend.LegendItem legenditem = new Legend.LegendItem(series.getName());
                legenditem.getSymbol().getStyleClass().addAll((String[])new String[]{"series" + seriesIndex, "chart-bubble", "bubble-legend-symbol", series.defaultColorStyleClass});
                this.legend.getItems().add(legenditem);
            }
        }
        if (this.legend.getItems().size() > 0) {
            if (this.getLegend() == null) {
                this.setLegend(this.legend);
            }
        } else {
            this.setLegend(null);
        }
    }

    private /* synthetic */ void lambda$seriesRemoved$568(Node bubble, ActionEvent actionEvent) {
        this.getPlotChildren().remove(bubble);
        bubble.setOpacity(1.0);
    }

    private /* synthetic */ void lambda$seriesRemoved$567(XYChart.Series series, ActionEvent event) {
        this.removeSeriesFromDisplay(series);
    }

    private /* synthetic */ void lambda$dataItemRemoved$566(Node bubble, XYChart.Series series, XYChart.Data item, ActionEvent actionEvent) {
        this.getPlotChildren().remove(bubble);
        this.removeDataItemFromDisplay(series, item);
        bubble.setOpacity(1.0);
    }

    static /* synthetic */ void access$lambda$0(BubbleChart bubbleChart, Node node, XYChart.Series series, XYChart.Data data, ActionEvent actionEvent) {
        bubbleChart.lambda$dataItemRemoved$566(node, series, data, actionEvent);
    }

    static /* synthetic */ void access$lambda$1(BubbleChart bubbleChart, XYChart.Series series, ActionEvent actionEvent) {
        bubbleChart.lambda$seriesRemoved$567(series, actionEvent);
    }

    static /* synthetic */ void access$lambda$2(BubbleChart bubbleChart, Node node, ActionEvent actionEvent) {
        bubbleChart.lambda$seriesRemoved$568(node, actionEvent);
    }
}

