/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.chart;

import com.sun.javafx.charts.Legend;
import java.util.Collection;
import java.util.Iterator;
import javafx.animation.FadeTransition;
import javafx.animation.ParallelTransition;
import javafx.application.Platform;
import javafx.beans.NamedArg;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.scene.AccessibleRole;
import javafx.scene.Node;
import javafx.scene.chart.Axis;
import javafx.scene.chart.ScatterChart$$Lambda$1;
import javafx.scene.chart.ScatterChart$$Lambda$2;
import javafx.scene.chart.ScatterChart$$Lambda$3;
import javafx.scene.chart.XYChart;
import javafx.scene.layout.StackPane;
import javafx.util.Duration;

public class ScatterChart<X, Y>
extends XYChart<X, Y> {
    private Legend legend = new Legend();

    public ScatterChart(@NamedArg(value="xAxis") Axis<X> xAxis, @NamedArg(value="yAxis") Axis<Y> yAxis) {
        this(xAxis, yAxis, FXCollections.observableArrayList());
    }

    public ScatterChart(@NamedArg(value="xAxis") Axis<X> xAxis, @NamedArg(value="yAxis") Axis<Y> yAxis, @NamedArg(value="data") ObservableList<XYChart.Series<X, Y>> data) {
        super(xAxis, yAxis);
        this.setLegend(this.legend);
        this.setData(data);
    }

    @Override
    protected void dataItemAdded(XYChart.Series<X, Y> series, int itemIndex, XYChart.Data<X, Y> item) {
        Node symbol = item.getNode();
        if (symbol == null) {
            symbol = new StackPane();
            symbol.setAccessibleRole(AccessibleRole.TEXT);
            symbol.setAccessibleRoleDescription("Point");
            symbol.focusTraversableProperty().bind(Platform.accessibilityActiveProperty());
            item.setNode(symbol);
        }
        symbol.getStyleClass().setAll((String[])new String[]{"chart-symbol", "series" + this.getData().indexOf(series), "data" + itemIndex, series.defaultColorStyleClass});
        if (this.shouldAnimate()) {
            symbol.setOpacity(0.0);
            this.getPlotChildren().add(symbol);
            FadeTransition ft = new FadeTransition(Duration.millis(500.0), symbol);
            ft.setToValue(1.0);
            ft.play();
        } else {
            this.getPlotChildren().add(symbol);
        }
    }

    @Override
    protected void dataItemRemoved(XYChart.Data<X, Y> item, XYChart.Series<X, Y> series) {
        Node symbol = item.getNode();
        if (symbol != null) {
            symbol.focusTraversableProperty().unbind();
        }
        if (this.shouldAnimate()) {
            FadeTransition ft = new FadeTransition(Duration.millis(500.0), symbol);
            ft.setToValue(0.0);
            ft.setOnFinished(ScatterChart$$Lambda$1.lambdaFactory$(this, symbol, series, item));
            ft.play();
        } else {
            this.getPlotChildren().remove(symbol);
            this.removeDataItemFromDisplay(series, item);
        }
    }

    @Override
    protected void dataItemChanged(XYChart.Data<X, Y> item) {
    }

    @Override
    protected void seriesAdded(XYChart.Series<X, Y> series, int seriesIndex) {
        for (int j = 0; j < series.getData().size(); ++j) {
            this.dataItemAdded(series, j, (XYChart.Data)series.getData().get(j));
        }
    }

    @Override
    protected void seriesRemoved(XYChart.Series<X, Y> series) {
        if (this.shouldAnimate()) {
            ParallelTransition pt = new ParallelTransition();
            pt.setOnFinished(ScatterChart$$Lambda$2.lambdaFactory$(this, series));
            for (XYChart.Data data : series.getData()) {
                Node symbol = data.getNode();
                FadeTransition ft = new FadeTransition(Duration.millis(500.0), symbol);
                ft.setToValue(0.0);
                ft.setOnFinished(ScatterChart$$Lambda$3.lambdaFactory$(this, symbol));
                pt.getChildren().add(ft);
            }
            pt.play();
        } else {
            for (XYChart.Data data : series.getData()) {
                Node node = data.getNode();
                this.getPlotChildren().remove(node);
            }
            this.removeSeriesFromDisplay(series);
        }
    }

    @Override
    protected void layoutPlotChildren() {
        for (int seriesIndex = 0; seriesIndex < this.getDataSize(); ++seriesIndex) {
            XYChart.Series series = (XYChart.Series)this.getData().get(seriesIndex);
            Iterator it = this.getDisplayedDataIterator(series);
            while (it.hasNext()) {
                Node symbol;
                XYChart.Data item = it.next();
                double x = this.getXAxis().getDisplayPosition(item.getCurrentX());
                double y = this.getYAxis().getDisplayPosition(item.getCurrentY());
                if (Double.isNaN(x) || Double.isNaN(y) || (symbol = item.getNode()) == null) continue;
                double w = symbol.prefWidth(-1.0);
                double h = symbol.prefHeight(-1.0);
                symbol.resizeRelocate(x - w / 2.0, y - h / 2.0, w, h);
            }
        }
    }

    @Override
    protected void updateLegend() {
        this.legend.getItems().clear();
        if (this.getData() != null) {
            for (int seriesIndex = 0; seriesIndex < this.getData().size(); ++seriesIndex) {
                XYChart.Series series = (XYChart.Series)this.getData().get(seriesIndex);
                Legend.LegendItem legenditem = new Legend.LegendItem(series.getName());
                if (!series.getData().isEmpty() && ((XYChart.Data)series.getData().get(0)).getNode() != null) {
                    legenditem.getSymbol().getStyleClass().addAll((Collection<String>)((XYChart.Data)series.getData().get(0)).getNode().getStyleClass());
                }
                this.legend.getItems().add(legenditem);
            }
        }
        if (this.legend.getItems().size() > 0) {
            if (this.getLegend() == null) {
                this.setLegend(this.legend);
            }
        } else {
            this.setLegend(null);
        }
    }

    private /* synthetic */ void lambda$seriesRemoved$579(Node symbol, ActionEvent actionEvent) {
        this.getPlotChildren().remove(symbol);
        symbol.setOpacity(1.0);
    }

    private /* synthetic */ void lambda$seriesRemoved$578(XYChart.Series series, ActionEvent event) {
        this.removeSeriesFromDisplay(series);
    }

    private /* synthetic */ void lambda$dataItemRemoved$577(Node symbol, XYChart.Series series, XYChart.Data item, ActionEvent actionEvent) {
        this.getPlotChildren().remove(symbol);
        this.removeDataItemFromDisplay(series, item);
        symbol.setOpacity(1.0);
    }

    static /* synthetic */ void access$lambda$0(ScatterChart scatterChart, Node node, XYChart.Series series, XYChart.Data data, ActionEvent actionEvent) {
        scatterChart.lambda$dataItemRemoved$577(node, series, data, actionEvent);
    }

    static /* synthetic */ void access$lambda$1(ScatterChart scatterChart, XYChart.Series series, ActionEvent actionEvent) {
        scatterChart.lambda$seriesRemoved$578(series, actionEvent);
    }

    static /* synthetic */ void access$lambda$2(ScatterChart scatterChart, Node node, ActionEvent actionEvent) {
        scatterChart.lambda$seriesRemoved$579(node, actionEvent);
    }
}

