/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.chart;

import com.sun.javafx.charts.Legend;
import com.sun.javafx.css.converters.BooleanConverter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javafx.animation.FadeTransition;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.NamedArg;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.css.StyleableBooleanProperty;
import javafx.css.StyleableProperty;
import javafx.event.ActionEvent;
import javafx.scene.AccessibleRole;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.chart.Axis;
import javafx.scene.chart.StackedAreaChart$$Lambda$1;
import javafx.scene.chart.StackedAreaChart$$Lambda$2;
import javafx.scene.chart.StackedAreaChart$$Lambda$3;
import javafx.scene.chart.StackedAreaChart$$Lambda$4;
import javafx.scene.chart.ValueAxis;
import javafx.scene.chart.XYChart;
import javafx.scene.layout.StackPane;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.StrokeLineJoin;
import javafx.util.Duration;

public class StackedAreaChart<X, Y>
extends XYChart<X, Y> {
    private Map<XYChart.Series<X, Y>, DoubleProperty> seriesYMultiplierMap = new HashMap<XYChart.Series<X, Y>, DoubleProperty>();
    private Legend legend = new Legend();
    private BooleanProperty createSymbols = new StyleableBooleanProperty(true){

        @Override
        protected void invalidated() {
            for (int seriesIndex = 0; seriesIndex < StackedAreaChart.this.getData().size(); ++seriesIndex) {
                XYChart.Series series = (XYChart.Series)StackedAreaChart.this.getData().get(seriesIndex);
                for (int itemIndex = 0; itemIndex < series.getData().size(); ++itemIndex) {
                    XYChart.Data item = (XYChart.Data)series.getData().get(itemIndex);
                    Node symbol = item.getNode();
                    if (this.get() && symbol == null) {
                        symbol = StackedAreaChart.this.createSymbol(series, StackedAreaChart.this.getData().indexOf(series), item, itemIndex);
                        if (null == symbol) continue;
                        StackedAreaChart.this.getPlotChildren().add(symbol);
                        continue;
                    }
                    if (this.get() || symbol == null) continue;
                    StackedAreaChart.this.getPlotChildren().remove(symbol);
                    symbol = null;
                    item.setNode(null);
                }
            }
            StackedAreaChart.this.requestChartLayout();
        }

        @Override
        public Object getBean() {
            return this;
        }

        @Override
        public String getName() {
            return "createSymbols";
        }

        @Override
        public CssMetaData<StackedAreaChart<?, ?>, Boolean> getCssMetaData() {
            return StyleableProperties.CREATE_SYMBOLS;
        }
    };

    public final boolean getCreateSymbols() {
        return this.createSymbols.getValue();
    }

    public final void setCreateSymbols(boolean value) {
        this.createSymbols.setValue(value);
    }

    public final BooleanProperty createSymbolsProperty() {
        return this.createSymbols;
    }

    public StackedAreaChart(@NamedArg(value="xAxis") Axis<X> xAxis, @NamedArg(value="yAxis") Axis<Y> yAxis) {
        this(xAxis, yAxis, FXCollections.observableArrayList());
    }

    public StackedAreaChart(@NamedArg(value="xAxis") Axis<X> xAxis, @NamedArg(value="yAxis") Axis<Y> yAxis, @NamedArg(value="data") ObservableList<XYChart.Series<X, Y>> data) {
        super(xAxis, yAxis);
        if (!(yAxis instanceof ValueAxis)) {
            throw new IllegalArgumentException("Axis type incorrect, yAxis must be of ValueAxis type.");
        }
        this.setLegend(this.legend);
        this.setData(data);
    }

    private static double doubleValue(Number number) {
        return StackedAreaChart.doubleValue(number, 0.0);
    }

    private static double doubleValue(Number number, double nullDefault) {
        return number == null ? nullDefault : number.doubleValue();
    }

    @Override
    protected void dataItemAdded(XYChart.Series<X, Y> series, int itemIndex, XYChart.Data<X, Y> item) {
        Node symbol = this.createSymbol(series, this.getData().indexOf(series), item, itemIndex);
        if (this.shouldAnimate()) {
            boolean animate = false;
            if (itemIndex > 0 && itemIndex < series.getData().size() - 1) {
                animate = true;
                XYChart.Data p1 = (XYChart.Data)series.getData().get(itemIndex - 1);
                XYChart.Data p2 = (XYChart.Data)series.getData().get(itemIndex + 1);
                double x1 = this.getXAxis().toNumericValue(p1.getXValue());
                double y1 = this.getYAxis().toNumericValue(p1.getYValue());
                double x3 = this.getXAxis().toNumericValue(p2.getXValue());
                double y3 = this.getYAxis().toNumericValue(p2.getYValue());
                double x2 = this.getXAxis().toNumericValue(item.getXValue());
                double y2 = this.getYAxis().toNumericValue(item.getYValue());
                double y = (y3 - y1) / (x3 - x1) * x2 + (x3 * y1 - y3 * x1) / (x3 - x1);
                item.setCurrentY(this.getYAxis().toRealValue(y));
                item.setCurrentX(this.getXAxis().toRealValue(x2));
            } else if (itemIndex == 0 && series.getData().size() > 1) {
                animate = true;
                item.setCurrentX(((XYChart.Data)series.getData().get(1)).getXValue());
                item.setCurrentY(((XYChart.Data)series.getData().get(1)).getYValue());
            } else if (itemIndex == series.getData().size() - 1 && series.getData().size() > 1) {
                animate = true;
                int last = series.getData().size() - 2;
                item.setCurrentX(((XYChart.Data)series.getData().get(last)).getXValue());
                item.setCurrentY(((XYChart.Data)series.getData().get(last)).getYValue());
            } else if (symbol != null) {
                symbol.setOpacity(0.0);
                this.getPlotChildren().add(symbol);
                FadeTransition ft = new FadeTransition(Duration.millis(500.0), symbol);
                ft.setToValue(1.0);
                ft.play();
            }
            if (animate) {
                this.animate(new KeyFrame(Duration.ZERO, StackedAreaChart$$Lambda$1.lambdaFactory$(this, symbol), new KeyValue(item.currentYProperty(), item.getCurrentY()), new KeyValue(item.currentXProperty(), item.getCurrentX())), new KeyFrame(Duration.millis(800.0), new KeyValue(item.currentYProperty(), item.getYValue(), Interpolator.EASE_BOTH), new KeyValue(item.currentXProperty(), item.getXValue(), Interpolator.EASE_BOTH)));
            }
        } else if (symbol != null) {
            this.getPlotChildren().add(symbol);
        }
    }

    @Override
    protected void dataItemRemoved(XYChart.Data<X, Y> item, XYChart.Series<X, Y> series) {
        Node symbol = item.getNode();
        if (symbol != null) {
            symbol.focusTraversableProperty().unbind();
        }
        int itemIndex = series.getItemIndex(item);
        if (this.shouldAnimate()) {
            boolean animate = false;
            int dataSize = series.getDataSize();
            int dataListSize = series.getData().size();
            if (itemIndex > 0 && itemIndex < dataSize - 1) {
                animate = true;
                XYChart.Data<X, Y> p1 = series.getItem(itemIndex - 1);
                XYChart.Data<X, Y> p2 = series.getItem(itemIndex + 1);
                double x1 = this.getXAxis().toNumericValue(p1.getXValue());
                double y1 = this.getYAxis().toNumericValue(p1.getYValue());
                double x3 = this.getXAxis().toNumericValue(p2.getXValue());
                double y3 = this.getYAxis().toNumericValue(p2.getYValue());
                double x2 = this.getXAxis().toNumericValue(item.getXValue());
                double y2 = this.getYAxis().toNumericValue(item.getYValue());
                double y = (y3 - y1) / (x3 - x1) * x2 + (x3 * y1 - y3 * x1) / (x3 - x1);
                item.setCurrentX(this.getXAxis().toRealValue(x2));
                item.setCurrentY(this.getYAxis().toRealValue(y2));
                item.setXValue(this.getXAxis().toRealValue(x2));
                item.setYValue(this.getYAxis().toRealValue(y));
            } else if (itemIndex == 0 && dataListSize > 1) {
                animate = true;
                item.setXValue(((XYChart.Data)series.getData().get(0)).getXValue());
                item.setYValue(((XYChart.Data)series.getData().get(0)).getYValue());
            } else if (itemIndex == dataSize - 1 && dataListSize > 1) {
                animate = true;
                int last = dataListSize - 1;
                item.setXValue(((XYChart.Data)series.getData().get(last)).getXValue());
                item.setYValue(((XYChart.Data)series.getData().get(last)).getYValue());
            } else if (symbol != null) {
                symbol.setOpacity(0.0);
                FadeTransition ft = new FadeTransition(Duration.millis(500.0), symbol);
                ft.setToValue(0.0);
                ft.setOnFinished(StackedAreaChart$$Lambda$2.lambdaFactory$(this, symbol, series, item));
                ft.play();
            }
            if (animate) {
                this.animate(new KeyFrame(Duration.ZERO, new KeyValue(item.currentYProperty(), item.getCurrentY()), new KeyValue(item.currentXProperty(), item.getCurrentX())), new KeyFrame(Duration.millis(800.0), StackedAreaChart$$Lambda$3.lambdaFactory$(this, symbol, series, item), new KeyValue(item.currentYProperty(), item.getYValue(), Interpolator.EASE_BOTH), new KeyValue(item.currentXProperty(), item.getXValue(), Interpolator.EASE_BOTH)));
            }
        } else {
            this.getPlotChildren().remove(symbol);
            this.removeDataItemFromDisplay(series, item);
        }
    }

    @Override
    protected void dataItemChanged(XYChart.Data<X, Y> item) {
    }

    @Override
    protected void seriesChanged(ListChangeListener.Change<? extends XYChart.Series> c) {
        for (int i = 0; i < this.getDataSize(); ++i) {
            XYChart.Series s = (XYChart.Series)this.getData().get(i);
            Path seriesLine = (Path)((Group)s.getNode()).getChildren().get(1);
            Path fillPath = (Path)((Group)s.getNode()).getChildren().get(0);
            seriesLine.getStyleClass().setAll((String[])new String[]{"chart-series-area-line", "series" + i, s.defaultColorStyleClass});
            fillPath.getStyleClass().setAll((String[])new String[]{"chart-series-area-fill", "series" + i, s.defaultColorStyleClass});
            for (int j = 0; j < s.getData().size(); ++j) {
                XYChart.Data item = (XYChart.Data)s.getData().get(j);
                Node node = item.getNode();
                if (node == null) continue;
                node.getStyleClass().setAll((String[])new String[]{"chart-area-symbol", "series" + i, "data" + j, s.defaultColorStyleClass});
            }
        }
    }

    @Override
    protected void seriesAdded(XYChart.Series<X, Y> series, int seriesIndex) {
        Path seriesLine = new Path();
        Path fillPath = new Path();
        seriesLine.setStrokeLineJoin(StrokeLineJoin.BEVEL);
        fillPath.setStrokeLineJoin(StrokeLineJoin.BEVEL);
        Group areaGroup = new Group(fillPath, seriesLine);
        series.setNode(areaGroup);
        SimpleDoubleProperty seriesYAnimMultiplier = new SimpleDoubleProperty(this, "seriesYMultiplier");
        this.seriesYMultiplierMap.put(series, seriesYAnimMultiplier);
        if (this.shouldAnimate()) {
            seriesYAnimMultiplier.setValue(0.0);
        } else {
            seriesYAnimMultiplier.setValue(1.0);
        }
        this.getPlotChildren().add(areaGroup);
        ArrayList<KeyFrame> keyFrames = new ArrayList<KeyFrame>();
        if (this.shouldAnimate()) {
            keyFrames.add(new KeyFrame(Duration.ZERO, new KeyValue(areaGroup.opacityProperty(), 0), new KeyValue(seriesYAnimMultiplier, 0)));
            keyFrames.add(new KeyFrame(Duration.millis(200.0), new KeyValue(areaGroup.opacityProperty(), 1)));
            keyFrames.add(new KeyFrame(Duration.millis(500.0), new KeyValue(seriesYAnimMultiplier, 1)));
        }
        for (int j = 0; j < series.getData().size(); ++j) {
            XYChart.Data item = (XYChart.Data)series.getData().get(j);
            Node symbol = this.createSymbol(series, seriesIndex, item, j);
            if (symbol == null) continue;
            if (this.shouldAnimate()) {
                symbol.setOpacity(0.0);
            }
            this.getPlotChildren().add(symbol);
            if (!this.shouldAnimate()) continue;
            keyFrames.add(new KeyFrame(Duration.ZERO, new KeyValue(symbol.opacityProperty(), 0)));
            keyFrames.add(new KeyFrame(Duration.millis(200.0), new KeyValue(symbol.opacityProperty(), 1)));
        }
        if (this.shouldAnimate()) {
            this.animate(keyFrames.toArray(new KeyFrame[keyFrames.size()]));
        }
    }

    @Override
    protected void seriesRemoved(XYChart.Series<X, Y> series) {
        this.seriesYMultiplierMap.remove(series);
        if (this.shouldAnimate()) {
            Timeline tl = new Timeline(this.createSeriesRemoveTimeLine(series, 400L));
            tl.play();
        } else {
            this.getPlotChildren().remove(series.getNode());
            for (XYChart.Data data : series.getData()) {
                this.getPlotChildren().remove(data.getNode());
            }
            this.removeSeriesFromDisplay(series);
        }
    }

    @Override
    protected void updateAxisRange() {
        Axis xa = this.getXAxis();
        Axis ya = this.getYAxis();
        if (xa.isAutoRanging()) {
            ArrayList xData = new ArrayList();
            for (XYChart.Series series : this.getData()) {
                for (XYChart.Data data : series.getData()) {
                    xData.add(data.getXValue());
                }
            }
            xa.invalidateRange(xData);
        }
        if (ya.isAutoRanging()) {
            double totalMinY = Double.MAX_VALUE;
            Iterator iterator = this.getDisplayedSeriesIterator();
            boolean first = true;
            TreeMap<Double, Double> treeMap = new TreeMap<Double, Double>();
            TreeMap<Double, Double> prevAccum = new TreeMap<Double, Double>();
            TreeMap<Double, Double> currentValues = new TreeMap<Double, Double>();
            while (iterator.hasNext()) {
                currentValues.clear();
                XYChart.Series series = iterator.next();
                for (XYChart.Data data : series.getData()) {
                    if (data == null) continue;
                    double xv = xa.toNumericValue(data.getXValue());
                    double yv = ya.toNumericValue(data.getYValue());
                    currentValues.put(xv, yv);
                    if (first) {
                        treeMap.put(xv, yv);
                        totalMinY = Math.min(totalMinY, yv);
                        continue;
                    }
                    if (prevAccum.containsKey(xv)) {
                        treeMap.put(xv, (Double)prevAccum.get(xv) + yv);
                        continue;
                    }
                    Map.Entry he = prevAccum.higherEntry(xv);
                    Map.Entry le = prevAccum.lowerEntry(xv);
                    if (he != null && le != null) {
                        treeMap.put(xv, (xv - le.getKey()) / (he.getKey() - le.getKey()) * ((Double)le.getValue() + (Double)he.getValue()) + yv);
                        continue;
                    }
                    if (he != null) {
                        treeMap.put(xv, (Double)he.getValue() + yv);
                        continue;
                    }
                    if (le != null) {
                        treeMap.put(xv, (Double)le.getValue() + yv);
                        continue;
                    }
                    treeMap.put(xv, yv);
                }
                for (Map.Entry entry : prevAccum.entrySet()) {
                    if (treeMap.keySet().contains(entry.getKey())) continue;
                    Double k = (Double)entry.getKey();
                    Double v = (Double)entry.getValue();
                    Map.Entry he = currentValues.higherEntry(k);
                    Map.Entry le = currentValues.lowerEntry(k);
                    if (he != null && le != null) {
                        treeMap.put(k, (k - le.getKey()) / (he.getKey() - le.getKey()) * ((Double)le.getValue() + (Double)he.getValue()) + v);
                        continue;
                    }
                    if (he != null) {
                        treeMap.put(k, (Double)he.getValue() + v);
                        continue;
                    }
                    if (le != null) {
                        treeMap.put(k, (Double)le.getValue() + v);
                        continue;
                    }
                    treeMap.put(k, v);
                }
                prevAccum.clear();
                prevAccum.putAll(treeMap);
                treeMap.clear();
                first = totalMinY == Double.MAX_VALUE;
            }
            if (totalMinY != Double.MAX_VALUE) {
                ya.invalidateRange(Arrays.asList(ya.toRealValue(totalMinY), ya.toRealValue((Double)Collections.max(prevAccum.values()))));
            }
        }
    }

    @Override
    protected void layoutPlotChildren() {
        ArrayList<DataPointInfo<X, Y>> currentSeriesData = new ArrayList<DataPointInfo<X, Y>>();
        ArrayList<DataPointInfo<X, Y>> aggregateData = new ArrayList<DataPointInfo<X, Y>>();
        for (int seriesIndex = 0; seriesIndex < this.getDataSize(); ++seriesIndex) {
            XYChart.Series series = (XYChart.Series)this.getData().get(seriesIndex);
            aggregateData.clear();
            for (DataPointInfo dataPointInfo : currentSeriesData) {
                dataPointInfo.partOf = PartOf.PREVIOUS;
                aggregateData.add(dataPointInfo);
            }
            currentSeriesData.clear();
            Iterator it = this.getDisplayedDataIterator(series);
            while (it.hasNext()) {
                XYChart.Data data = it.next();
                DataPointInfo itemInfo = new DataPointInfo(data, data.getXValue(), data.getYValue(), PartOf.CURRENT);
                aggregateData.add(itemInfo);
            }
            DoubleProperty seriesYAnimMultiplier = this.seriesYMultiplierMap.get(series);
            Path path = (Path)((Group)series.getNode()).getChildren().get(1);
            Path fillPath = (Path)((Group)series.getNode()).getChildren().get(0);
            path.getElements().clear();
            fillPath.getElements().clear();
            int dataIndex = 0;
            this.sortAggregateList(aggregateData);
            Axis yAxis = this.getYAxis();
            Axis xAxis = this.getXAxis();
            boolean firstCurrent = false;
            boolean lastCurrent = false;
            int firstCurrentIndex = this.findNextCurrent(aggregateData, -1);
            int lastCurrentIndex = this.findPreviousCurrent(aggregateData, aggregateData.size());
            double basePosition = yAxis.getZeroPosition();
            if (Double.isNaN(basePosition)) {
                ValueAxis valueYAxis = (ValueAxis)yAxis;
                basePosition = valueYAxis.getLowerBound() > 0.0 ? valueYAxis.getDisplayPosition(valueYAxis.getLowerBound()) : valueYAxis.getDisplayPosition(valueYAxis.getUpperBound());
            }
            for (DataPointInfo dataPointInfo : aggregateData) {
                DataPointInfo<X, Y> nextPoint;
                DataPointInfo<X, Y> prevPoint;
                double x;
                int nIndex;
                int pIndex;
                if (dataIndex == lastCurrentIndex) {
                    lastCurrent = true;
                }
                if (dataIndex == firstCurrentIndex) {
                    firstCurrent = true;
                }
                XYChart.Data item = dataPointInfo.dataItem;
                if (dataPointInfo.partOf.equals((Object)PartOf.CURRENT)) {
                    pIndex = this.findPreviousPrevious(aggregateData, dataIndex);
                    nIndex = this.findNextPrevious(aggregateData, dataIndex);
                    if (pIndex == -1 || nIndex == -1 && !aggregateData.get((int)pIndex).x.equals(dataPointInfo.x)) {
                        if (firstCurrent) {
                            XYChart.Data ddItem = new XYChart.Data(dataPointInfo.x, 0);
                            this.addDropDown(currentSeriesData, ddItem, ddItem.getXValue(), ddItem.getYValue(), xAxis.getDisplayPosition(ddItem.getCurrentX()), basePosition);
                        }
                        x = xAxis.getDisplayPosition(item.getCurrentX());
                        double y = yAxis.getDisplayPosition(yAxis.toRealValue(yAxis.toNumericValue(item.getCurrentY()) * seriesYAnimMultiplier.getValue()));
                        this.addPoint(currentSeriesData, item, item.getXValue(), item.getYValue(), x, y, PartOf.CURRENT, false, !firstCurrent);
                        if (dataIndex == lastCurrentIndex) {
                            XYChart.Data ddItem = new XYChart.Data(dataPointInfo.x, 0);
                            this.addDropDown(currentSeriesData, ddItem, ddItem.getXValue(), ddItem.getYValue(), xAxis.getDisplayPosition(ddItem.getCurrentX()), basePosition);
                        }
                    } else {
                        prevPoint = aggregateData.get(pIndex);
                        if (prevPoint.x.equals(dataPointInfo.x)) {
                            if (prevPoint.dropDown) {
                                pIndex = this.findPreviousPrevious(aggregateData, pIndex);
                                prevPoint = aggregateData.get(pIndex);
                            }
                            if (prevPoint.x.equals(dataPointInfo.x)) {
                                x = xAxis.getDisplayPosition(item.getCurrentX());
                                double yv = yAxis.toNumericValue(item.getCurrentY()) + yAxis.toNumericValue(prevPoint.y);
                                double y = yAxis.getDisplayPosition(yAxis.toRealValue(yv * seriesYAnimMultiplier.getValue()));
                                this.addPoint(currentSeriesData, item, dataPointInfo.x, yAxis.toRealValue(yv), x, y, PartOf.CURRENT, false, !firstCurrent);
                            }
                            if (lastCurrent) {
                                this.addDropDown(currentSeriesData, item, prevPoint.x, prevPoint.y, prevPoint.displayX, prevPoint.displayY);
                            }
                        } else {
                            nextPoint = nIndex == -1 ? null : aggregateData.get(nIndex);
                            prevPoint = pIndex == -1 ? null : aggregateData.get(pIndex);
                            double yValue = yAxis.toNumericValue(item.getCurrentY());
                            if (prevPoint != null && nextPoint != null) {
                                double x2 = xAxis.getDisplayPosition(item.getCurrentX());
                                double displayY = this.interpolate(prevPoint.displayX, prevPoint.displayY, nextPoint.displayX, nextPoint.displayY, x2);
                                double dataY = this.interpolate(xAxis.toNumericValue(prevPoint.x), yAxis.toNumericValue(prevPoint.y), xAxis.toNumericValue(nextPoint.x), yAxis.toNumericValue(nextPoint.y), xAxis.toNumericValue(dataPointInfo.x));
                                if (firstCurrent) {
                                    XYChart.Data ddItem = new XYChart.Data(dataPointInfo.x, dataY);
                                    this.addDropDown(currentSeriesData, ddItem, dataPointInfo.x, yAxis.toRealValue(dataY), x2, displayY);
                                }
                                double y = yAxis.getDisplayPosition(yAxis.toRealValue((yValue + dataY) * seriesYAnimMultiplier.getValue()));
                                this.addPoint(currentSeriesData, item, dataPointInfo.x, yAxis.toRealValue(yValue + dataY), x2, y, PartOf.CURRENT, false, !firstCurrent);
                                if (dataIndex == lastCurrentIndex) {
                                    XYChart.Data ddItem = new XYChart.Data(dataPointInfo.x, dataY);
                                    this.addDropDown(currentSeriesData, ddItem, dataPointInfo.x, yAxis.toRealValue(dataY), x2, displayY);
                                }
                            }
                        }
                    }
                } else {
                    pIndex = this.findPreviousCurrent(aggregateData, dataIndex);
                    nIndex = this.findNextCurrent(aggregateData, dataIndex);
                    if (dataPointInfo.dropDown) {
                        if (xAxis.toNumericValue(dataPointInfo.x) <= xAxis.toNumericValue(aggregateData.get((int)firstCurrentIndex).x) || xAxis.toNumericValue(dataPointInfo.x) > xAxis.toNumericValue(aggregateData.get((int)lastCurrentIndex).x)) {
                            this.addDropDown(currentSeriesData, item, dataPointInfo.x, dataPointInfo.y, dataPointInfo.displayX, dataPointInfo.displayY);
                        }
                    } else if (pIndex == -1 || nIndex == -1) {
                        this.addPoint(currentSeriesData, item, dataPointInfo.x, dataPointInfo.y, dataPointInfo.displayX, dataPointInfo.displayY, PartOf.CURRENT, true, false);
                    } else {
                        nextPoint = aggregateData.get(nIndex);
                        if (!nextPoint.x.equals(dataPointInfo.x)) {
                            prevPoint = aggregateData.get(pIndex);
                            x = xAxis.getDisplayPosition(item.getCurrentX());
                            double dataY = this.interpolate(xAxis.toNumericValue(prevPoint.x), yAxis.toNumericValue(prevPoint.y), xAxis.toNumericValue(nextPoint.x), yAxis.toNumericValue(nextPoint.y), xAxis.toNumericValue(dataPointInfo.x));
                            double yv = yAxis.toNumericValue(dataPointInfo.y) + dataY;
                            double y = yAxis.getDisplayPosition(yAxis.toRealValue(yv * seriesYAnimMultiplier.getValue()));
                            this.addPoint(currentSeriesData, new XYChart.Data(dataPointInfo.x, dataY), dataPointInfo.x, yAxis.toRealValue(yv), x, y, PartOf.CURRENT, true, true);
                        }
                    }
                }
                ++dataIndex;
                if (firstCurrent) {
                    firstCurrent = false;
                }
                if (!lastCurrent) continue;
                lastCurrent = false;
            }
            if (!currentSeriesData.isEmpty()) {
                path.getElements().add(new MoveTo(((DataPointInfo)currentSeriesData.get((int)0)).displayX, ((DataPointInfo)currentSeriesData.get((int)0)).displayY));
                fillPath.getElements().add(new MoveTo(((DataPointInfo)currentSeriesData.get((int)0)).displayX, ((DataPointInfo)currentSeriesData.get((int)0)).displayY));
            }
            for (DataPointInfo dataPointInfo : currentSeriesData) {
                Node symbol;
                if (dataPointInfo.lineTo) {
                    path.getElements().add(new LineTo(dataPointInfo.displayX, dataPointInfo.displayY));
                } else {
                    path.getElements().add(new MoveTo(dataPointInfo.displayX, dataPointInfo.displayY));
                }
                fillPath.getElements().add(new LineTo(dataPointInfo.displayX, dataPointInfo.displayY));
                if (dataPointInfo.skipSymbol || (symbol = dataPointInfo.dataItem.getNode()) == null) continue;
                double w = symbol.prefWidth(-1.0);
                double h = symbol.prefHeight(-1.0);
                symbol.resizeRelocate(dataPointInfo.displayX - w / 2.0, dataPointInfo.displayY - h / 2.0, w, h);
            }
            for (int i = aggregateData.size() - 1; i > 0; --i) {
                DataPointInfo<X, Y> dataPointInfo = aggregateData.get(i);
                if (!PartOf.PREVIOUS.equals((Object)dataPointInfo.partOf)) continue;
                fillPath.getElements().add(new LineTo(dataPointInfo.displayX, dataPointInfo.displayY));
            }
            if (fillPath.getElements().isEmpty()) continue;
            fillPath.getElements().add(new ClosePath());
        }
    }

    private void addDropDown(ArrayList<DataPointInfo<X, Y>> currentSeriesData, XYChart.Data<X, Y> item, X xValue, Y yValue, double x, double y) {
        DataPointInfo<X, Y> dropDownDataPoint = new DataPointInfo<X, Y>(true);
        dropDownDataPoint.setValues(item, xValue, yValue, x, y, PartOf.CURRENT, true, false);
        currentSeriesData.add(dropDownDataPoint);
    }

    private void addPoint(ArrayList<DataPointInfo<X, Y>> currentSeriesData, XYChart.Data<X, Y> item, X xValue, Y yValue, double x, double y, PartOf partof, boolean symbol, boolean lineTo) {
        DataPointInfo<X, Y> currentDataPoint = new DataPointInfo<X, Y>();
        currentDataPoint.setValues(item, xValue, yValue, x, y, partof, symbol, lineTo);
        currentSeriesData.add(currentDataPoint);
    }

    private int findNextCurrent(ArrayList<DataPointInfo<X, Y>> points, int index) {
        for (int i = index + 1; i < points.size(); ++i) {
            if (!points.get((int)i).partOf.equals((Object)PartOf.CURRENT)) continue;
            return i;
        }
        return -1;
    }

    private int findPreviousCurrent(ArrayList<DataPointInfo<X, Y>> points, int index) {
        for (int i = index - 1; i >= 0; --i) {
            if (!points.get((int)i).partOf.equals((Object)PartOf.CURRENT)) continue;
            return i;
        }
        return -1;
    }

    private int findPreviousPrevious(ArrayList<DataPointInfo<X, Y>> points, int index) {
        for (int i = index - 1; i >= 0; --i) {
            if (!points.get((int)i).partOf.equals((Object)PartOf.PREVIOUS)) continue;
            return i;
        }
        return -1;
    }

    private int findNextPrevious(ArrayList<DataPointInfo<X, Y>> points, int index) {
        for (int i = index + 1; i < points.size(); ++i) {
            if (!points.get((int)i).partOf.equals((Object)PartOf.PREVIOUS)) continue;
            return i;
        }
        return -1;
    }

    private void sortAggregateList(ArrayList<DataPointInfo<X, Y>> aggregateList) {
        Collections.sort(aggregateList, StackedAreaChart$$Lambda$4.lambdaFactory$(this));
    }

    private double interpolate(double lowX, double lowY, double highX, double highY, double x) {
        return (highY - lowY) / (highX - lowX) * (x - lowX) + lowY;
    }

    private Node createSymbol(XYChart.Series<X, Y> series, int seriesIndex, XYChart.Data<X, Y> item, int itemIndex) {
        Node symbol = item.getNode();
        if (symbol == null && this.getCreateSymbols()) {
            symbol = new StackPane();
            symbol.setAccessibleRole(AccessibleRole.TEXT);
            symbol.setAccessibleRoleDescription("Point");
            symbol.focusTraversableProperty().bind(Platform.accessibilityActiveProperty());
            item.setNode(symbol);
        }
        if (symbol != null) {
            symbol.getStyleClass().setAll((String[])new String[]{"chart-area-symbol", "series" + seriesIndex, "data" + itemIndex, series.defaultColorStyleClass});
        }
        return symbol;
    }

    @Override
    protected void updateLegend() {
        this.legend.getItems().clear();
        if (this.getData() != null) {
            for (int seriesIndex = 0; seriesIndex < this.getData().size(); ++seriesIndex) {
                XYChart.Series series = (XYChart.Series)this.getData().get(seriesIndex);
                Legend.LegendItem legenditem = new Legend.LegendItem(series.getName());
                legenditem.getSymbol().getStyleClass().addAll((String[])new String[]{"chart-area-symbol", "series" + seriesIndex, "area-legend-symbol", series.defaultColorStyleClass});
                this.legend.getItems().add(legenditem);
            }
        }
        if (this.legend.getItems().size() > 0) {
            if (this.getLegend() == null) {
                this.setLegend(this.legend);
            }
        } else {
            this.setLegend(null);
        }
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return StackedAreaChart.getClassCssMetaData();
    }

    private /* synthetic */ int lambda$sortAggregateList$583(DataPointInfo o1, DataPointInfo o2) {
        double val2;
        XYChart.Data d1 = o1.dataItem;
        XYChart.Data d2 = o2.dataItem;
        double val1 = this.getXAxis().toNumericValue(d1.getXValue());
        return val1 < (val2 = this.getXAxis().toNumericValue(d2.getXValue())) ? -1 : (val1 == val2 ? 0 : 1);
    }

    private /* synthetic */ void lambda$dataItemRemoved$582(Node symbol, XYChart.Series series, XYChart.Data item, ActionEvent actionEvent) {
        this.getPlotChildren().remove(symbol);
        this.removeDataItemFromDisplay(series, item);
    }

    private /* synthetic */ void lambda$dataItemRemoved$581(Node symbol, XYChart.Series series, XYChart.Data item, ActionEvent actionEvent) {
        this.getPlotChildren().remove(symbol);
        this.removeDataItemFromDisplay(series, item);
        symbol.setOpacity(1.0);
    }

    private /* synthetic */ void lambda$dataItemAdded$580(Node symbol, ActionEvent e) {
        if (symbol != null && !this.getPlotChildren().contains(symbol)) {
            this.getPlotChildren().add(symbol);
        }
    }

    static /* synthetic */ void access$lambda$0(StackedAreaChart stackedAreaChart, Node node, ActionEvent actionEvent) {
        stackedAreaChart.lambda$dataItemAdded$580(node, actionEvent);
    }

    static /* synthetic */ void access$lambda$1(StackedAreaChart stackedAreaChart, Node node, XYChart.Series series, XYChart.Data data, ActionEvent actionEvent) {
        stackedAreaChart.lambda$dataItemRemoved$581(node, series, data, actionEvent);
    }

    static /* synthetic */ void access$lambda$2(StackedAreaChart stackedAreaChart, Node node, XYChart.Series series, XYChart.Data data, ActionEvent actionEvent) {
        stackedAreaChart.lambda$dataItemRemoved$582(node, series, data, actionEvent);
    }

    static /* synthetic */ int access$lambda$3(StackedAreaChart stackedAreaChart, DataPointInfo dataPointInfo, DataPointInfo dataPointInfo2) {
        return stackedAreaChart.lambda$sortAggregateList$583(dataPointInfo, dataPointInfo2);
    }

    private static class StyleableProperties {
        private static final CssMetaData<StackedAreaChart<?, ?>, Boolean> CREATE_SYMBOLS = new CssMetaData<StackedAreaChart<?, ?>, Boolean>("-fx-create-symbols", BooleanConverter.getInstance(), Boolean.TRUE){

            @Override
            public boolean isSettable(StackedAreaChart<?, ?> node) {
                return ((StackedAreaChart)node).createSymbols == null || !((StackedAreaChart)node).createSymbols.isBound();
            }

            @Override
            public StyleableProperty<Boolean> getStyleableProperty(StackedAreaChart<?, ?> node) {
                return (StyleableProperty)((Object)node.createSymbolsProperty());
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList styleables = new ArrayList(XYChart.getClassCssMetaData());
            styleables.add(CREATE_SYMBOLS);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }

    private static enum PartOf {
        CURRENT,
        PREVIOUS;

    }

    static final class DataPointInfo<X, Y> {
        X x;
        Y y;
        double displayX;
        double displayY;
        XYChart.Data<X, Y> dataItem;
        PartOf partOf;
        boolean skipSymbol = false;
        boolean lineTo = false;
        boolean dropDown = false;

        DataPointInfo() {
        }

        DataPointInfo(XYChart.Data<X, Y> item, X x, Y y, PartOf partOf) {
            this.dataItem = item;
            this.x = x;
            this.y = y;
            this.partOf = partOf;
        }

        DataPointInfo(boolean dropDown) {
            this.dropDown = dropDown;
        }

        void setValues(XYChart.Data<X, Y> item, X x, Y y, double dx, double dy, PartOf partOf, boolean skipSymbol, boolean lineTo) {
            this.dataItem = item;
            this.x = x;
            this.y = y;
            this.displayX = dx;
            this.displayY = dy;
            this.partOf = partOf;
            this.skipSymbol = skipSymbol;
            this.lineTo = lineTo;
        }

        public final X getX() {
            return this.x;
        }

        public final Y getY() {
            return this.y;
        }
    }
}

