/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import javafx.beans.Observable;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.ReadOnlyIntegerWrapper;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.scene.control.FocusModel$$Lambda$1;

public abstract class FocusModel<T> {
    private ReadOnlyIntegerWrapper focusedIndex = new ReadOnlyIntegerWrapper(this, "focusedIndex", -1);
    private ReadOnlyObjectWrapper<T> focusedItem = new ReadOnlyObjectWrapper(this, "focusedItem");

    public FocusModel() {
        this.focusedIndexProperty().addListener(FocusModel$$Lambda$1.lambdaFactory$(this));
    }

    public final ReadOnlyIntegerProperty focusedIndexProperty() {
        return this.focusedIndex.getReadOnlyProperty();
    }

    public final int getFocusedIndex() {
        return this.focusedIndex.get();
    }

    final void setFocusedIndex(int value) {
        this.focusedIndex.set(value);
    }

    public final ReadOnlyObjectProperty<T> focusedItemProperty() {
        return this.focusedItem.getReadOnlyProperty();
    }

    public final T getFocusedItem() {
        return this.focusedItemProperty().get();
    }

    final void setFocusedItem(T value) {
        this.focusedItem.set(value);
    }

    protected abstract int getItemCount();

    protected abstract T getModelItem(int var1);

    public boolean isFocused(int index) {
        if (index < 0 || index >= this.getItemCount()) {
            return false;
        }
        return this.getFocusedIndex() == index;
    }

    public void focus(int index) {
        if (index < 0 || index >= this.getItemCount()) {
            this.setFocusedIndex(-1);
        } else {
            int oldFocusIndex = this.getFocusedIndex();
            this.setFocusedIndex(index);
            if (oldFocusIndex == index) {
                this.setFocusedItem(this.getModelItem(index));
            }
        }
    }

    public void focusPrevious() {
        if (this.getFocusedIndex() == -1) {
            this.focus(0);
        } else if (this.getFocusedIndex() > 0) {
            this.focus(this.getFocusedIndex() - 1);
        }
    }

    public void focusNext() {
        if (this.getFocusedIndex() == -1) {
            this.focus(0);
        } else if (this.getFocusedIndex() != this.getItemCount() - 1) {
            this.focus(this.getFocusedIndex() + 1);
        }
    }

    private /* synthetic */ void lambda$new$36(Observable valueModel) {
        this.setFocusedItem(this.getModelItem(this.getFocusedIndex()));
    }

    static /* synthetic */ void access$lambda$0(FocusModel focusModel, Observable observable) {
        focusModel.lambda$new$36(observable);
    }
}

