/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogPane;
import javafx.scene.control.FXDialog;
import javafx.scene.control.HeavyweightDialog$$Lambda$1;
import javafx.scene.control.HeavyweightDialog$$Lambda$2;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.Region;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import javafx.stage.WindowEvent;

class HeavyweightDialog
extends FXDialog {
    final Stage stage = new Stage(){

        @Override
        public void centerOnScreen() {
            Window owner = this.getOwner();
            if (owner != null) {
                HeavyweightDialog.this.positionStage();
            } else if (this.getWidth() > 0.0 && this.getHeight() > 0.0) {
                super.centerOnScreen();
            }
        }
    };
    private Scene scene;
    private final Parent DUMMY_ROOT = new Region();
    private final Dialog<?> dialog;
    private DialogPane dialogPane;
    private double prefX = Double.NaN;
    private double prefY = Double.NaN;

    HeavyweightDialog(Dialog<?> dialog) {
        this.dialog = dialog;
        this.stage.setResizable(false);
        this.stage.setOnCloseRequest(HeavyweightDialog$$Lambda$1.lambdaFactory$(this, dialog));
        this.stage.addEventHandler(KeyEvent.KEY_RELEASED, HeavyweightDialog$$Lambda$2.lambdaFactory$(this, dialog));
    }

    @Override
    void initStyle(StageStyle style) {
        this.stage.initStyle(style);
    }

    @Override
    StageStyle getStyle() {
        return this.stage.getStyle();
    }

    @Override
    public void initOwner(Window newOwner) {
        this.updateStageBindings(this.stage.getOwner(), newOwner);
        this.stage.initOwner(newOwner);
    }

    @Override
    public Window getOwner() {
        return this.stage.getOwner();
    }

    @Override
    public void initModality(Modality modality) {
        this.stage.initModality(modality == null ? Modality.APPLICATION_MODAL : modality);
    }

    @Override
    public Modality getModality() {
        return this.stage.getModality();
    }

    @Override
    public void setDialogPane(DialogPane dialogPane) {
        this.dialogPane = dialogPane;
        if (this.scene == null) {
            this.scene = new Scene(dialogPane);
            this.stage.setScene(this.scene);
        } else {
            this.scene.setRoot(dialogPane);
        }
        dialogPane.autosize();
        this.stage.sizeToScene();
    }

    @Override
    public void show() {
        this.scene.setRoot(this.dialogPane);
        this.stage.centerOnScreen();
        this.stage.show();
    }

    @Override
    public void showAndWait() {
        this.scene.setRoot(this.dialogPane);
        this.stage.centerOnScreen();
        this.stage.showAndWait();
    }

    @Override
    public void close() {
        if (this.stage.isShowing()) {
            this.stage.hide();
        }
        if (this.scene != null) {
            this.scene.setRoot(this.DUMMY_ROOT);
        }
    }

    @Override
    public ReadOnlyBooleanProperty showingProperty() {
        return this.stage.showingProperty();
    }

    @Override
    public Window getWindow() {
        return this.stage;
    }

    @Override
    public Node getRoot() {
        return this.stage.getScene().getRoot();
    }

    @Override
    public double getX() {
        return this.stage.getX();
    }

    @Override
    public void setX(double x) {
        this.stage.setX(x);
    }

    @Override
    public ReadOnlyDoubleProperty xProperty() {
        return this.stage.xProperty();
    }

    @Override
    public double getY() {
        return this.stage.getY();
    }

    @Override
    public void setY(double y) {
        this.stage.setY(y);
    }

    @Override
    public ReadOnlyDoubleProperty yProperty() {
        return this.stage.yProperty();
    }

    @Override
    ReadOnlyDoubleProperty heightProperty() {
        return this.stage.heightProperty();
    }

    @Override
    void setHeight(double height) {
        this.stage.setHeight(height);
    }

    @Override
    double getSceneHeight() {
        return this.scene == null ? 0.0 : this.scene.getHeight();
    }

    @Override
    ReadOnlyDoubleProperty widthProperty() {
        return this.stage.widthProperty();
    }

    @Override
    void setWidth(double width) {
        this.stage.setWidth(width);
    }

    @Override
    BooleanProperty resizableProperty() {
        return this.stage.resizableProperty();
    }

    @Override
    StringProperty titleProperty() {
        return this.stage.titleProperty();
    }

    @Override
    ReadOnlyBooleanProperty focusedProperty() {
        return this.stage.focusedProperty();
    }

    @Override
    public void sizeToScene() {
        this.stage.sizeToScene();
    }

    private void positionStage() {
        double x = this.getX();
        double y = this.getY();
        if (!Double.isNaN(x) && !Double.isNaN(y) && Double.compare(x, this.prefX) != 0 && Double.compare(y, this.prefY) != 0) {
            this.setX(x);
            this.setY(y);
            return;
        }
        this.dialogPane.applyCss();
        this.dialogPane.layout();
        Window owner = this.getOwner();
        Scene ownerScene = owner.getScene();
        double titleBarHeight = ownerScene.getY();
        double dialogWidth = this.dialogPane.prefWidth(-1.0);
        double dialogHeight = this.dialogPane.prefHeight(dialogWidth);
        x = owner.getX() + ownerScene.getWidth() / 2.0 - dialogWidth / 2.0;
        y = owner.getY() + titleBarHeight / 2.0 + ownerScene.getHeight() / 2.0 - dialogHeight / 2.0;
        this.prefX = x;
        this.prefY = y;
        this.setX(x);
        this.setY(y);
    }

    private void updateStageBindings(Window oldOwner, Window newOwner) {
        Scene dialogScene = this.stage.getScene();
        if (oldOwner != null && oldOwner instanceof Stage) {
            Stage oldStage = (Stage)oldOwner;
            Bindings.unbindContent(this.stage.getIcons(), oldStage.getIcons());
            Scene oldScene = oldStage.getScene();
            if (this.scene != null && dialogScene != null) {
                Bindings.unbindContent(dialogScene.getStylesheets(), oldScene.getStylesheets());
            }
        }
        if (newOwner instanceof Stage) {
            Stage newStage = (Stage)newOwner;
            Bindings.bindContent(this.stage.getIcons(), newStage.getIcons());
            Scene newScene = newStage.getScene();
            if (this.scene != null && dialogScene != null) {
                Bindings.bindContent(dialogScene.getStylesheets(), newScene.getStylesheets());
            }
        }
    }

    private /* synthetic */ void lambda$new$609(Dialog dialog, KeyEvent keyEvent) {
        if (keyEvent.getCode() == KeyCode.ESCAPE && this.requestPermissionToClose(dialog)) {
            dialog.close();
            keyEvent.consume();
        }
    }

    private /* synthetic */ void lambda$new$608(Dialog dialog, WindowEvent windowEvent) {
        if (this.requestPermissionToClose(dialog)) {
            dialog.close();
        } else {
            windowEvent.consume();
        }
    }

    static /* synthetic */ void access$lambda$0(HeavyweightDialog heavyweightDialog, Dialog dialog, WindowEvent windowEvent) {
        heavyweightDialog.lambda$new$608(dialog, windowEvent);
    }

    static /* synthetic */ void access$lambda$1(HeavyweightDialog heavyweightDialog, Dialog dialog, KeyEvent keyEvent) {
        heavyweightDialog.lambda$new$609(dialog, keyEvent);
    }
}

