/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import com.sun.javafx.scene.control.skin.TableCellSkin;
import java.lang.ref.WeakReference;
import java.util.Collection;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.WeakListChangeListener;
import javafx.css.PseudoClass;
import javafx.event.Event;
import javafx.scene.AccessibleAction;
import javafx.scene.AccessibleAttribute;
import javafx.scene.AccessibleRole;
import javafx.scene.control.ControlUtils;
import javafx.scene.control.IndexedCell;
import javafx.scene.control.Skin;
import javafx.scene.control.TableCell$$Lambda$1;
import javafx.scene.control.TableCell$$Lambda$2;
import javafx.scene.control.TableCell$$Lambda$3;
import javafx.scene.control.TableCell$$Lambda$4;
import javafx.scene.control.TableCell$$Lambda$5;
import javafx.scene.control.TableCell$$Lambda$6;
import javafx.scene.control.TableCell$$Lambda$7;
import javafx.scene.control.TableCell$$Lambda$8;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableSelectionModel;
import javafx.scene.control.TableView;

public class TableCell<S, T>
extends IndexedCell<T> {
    boolean lockItemOnEdit = false;
    private boolean itemDirty = false;
    private ListChangeListener<TablePosition> selectedListener = TableCell$$Lambda$1.lambdaFactory$(this);
    private final InvalidationListener focusedListener = TableCell$$Lambda$2.lambdaFactory$(this);
    private final InvalidationListener tableRowUpdateObserver = TableCell$$Lambda$3.lambdaFactory$(this);
    private final InvalidationListener editingListener = TableCell$$Lambda$4.lambdaFactory$(this);
    private ListChangeListener<TableColumn<S, ?>> visibleLeafColumnsListener = TableCell$$Lambda$5.lambdaFactory$(this);
    private ListChangeListener<String> columnStyleClassListener = TableCell$$Lambda$6.lambdaFactory$(this);
    private final InvalidationListener columnStyleListener = TableCell$$Lambda$7.lambdaFactory$(this);
    private final InvalidationListener columnIdListener = TableCell$$Lambda$8.lambdaFactory$(this);
    private final WeakListChangeListener<TablePosition> weakSelectedListener = new WeakListChangeListener<TablePosition>(this.selectedListener);
    private final WeakInvalidationListener weakFocusedListener = new WeakInvalidationListener(this.focusedListener);
    private final WeakInvalidationListener weaktableRowUpdateObserver = new WeakInvalidationListener(this.tableRowUpdateObserver);
    private final WeakInvalidationListener weakEditingListener = new WeakInvalidationListener(this.editingListener);
    private final WeakInvalidationListener weakColumnStyleListener = new WeakInvalidationListener(this.columnStyleListener);
    private final WeakInvalidationListener weakColumnIdListener = new WeakInvalidationListener(this.columnIdListener);
    private final WeakListChangeListener<TableColumn<S, ?>> weakVisibleLeafColumnsListener = new WeakListChangeListener(this.visibleLeafColumnsListener);
    private final WeakListChangeListener<String> weakColumnStyleClassListener = new WeakListChangeListener<String>(this.columnStyleClassListener);
    private ReadOnlyObjectWrapper<TableColumn<S, T>> tableColumn = new ReadOnlyObjectWrapper<TableColumn<S, T>>(){

        @Override
        protected void invalidated() {
            TableCell.this.updateColumnIndex();
        }

        @Override
        public Object getBean() {
            return TableCell.this;
        }

        @Override
        public String getName() {
            return "tableColumn";
        }
    };
    private ReadOnlyObjectWrapper<TableView<S>> tableView;
    private ReadOnlyObjectWrapper<TableRow> tableRow = new ReadOnlyObjectWrapper(this, "tableRow");
    private boolean isLastVisibleColumn = false;
    private int columnIndex = -1;
    private boolean updateEditingIndex = true;
    private ObservableValue<T> currentObservableValue = null;
    private boolean isFirstRun = true;
    private WeakReference<S> oldRowItemRef;
    private static final String DEFAULT_STYLE_CLASS = "table-cell";
    private static final PseudoClass PSEUDO_CLASS_LAST_VISIBLE = PseudoClass.getPseudoClass("last-visible");

    public TableCell() {
        this.getStyleClass().addAll((String[])new String[]{DEFAULT_STYLE_CLASS});
        this.setAccessibleRole(AccessibleRole.TABLE_CELL);
        this.updateColumnIndex();
    }

    public final ReadOnlyObjectProperty<TableColumn<S, T>> tableColumnProperty() {
        return this.tableColumn.getReadOnlyProperty();
    }

    private void setTableColumn(TableColumn<S, T> value) {
        this.tableColumn.set(value);
    }

    public final TableColumn<S, T> getTableColumn() {
        return (TableColumn)this.tableColumn.get();
    }

    private void setTableView(TableView<S> value) {
        this.tableViewPropertyImpl().set(value);
    }

    public final TableView<S> getTableView() {
        return this.tableView == null ? null : (TableView)this.tableView.get();
    }

    public final ReadOnlyObjectProperty<TableView<S>> tableViewProperty() {
        return this.tableViewPropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyObjectWrapper<TableView<S>> tableViewPropertyImpl() {
        if (this.tableView == null) {
            this.tableView = new ReadOnlyObjectWrapper<TableView<S>>(){
                private WeakReference<TableView<S>> weakTableViewRef;

                @Override
                protected void invalidated() {
                    if (this.weakTableViewRef != null) {
                        TableCell.this.cleanUpTableViewListeners((TableView)this.weakTableViewRef.get());
                    }
                    if (this.get() != null) {
                        TableView.TableViewFocusModel fm;
                        TableView.TableViewSelectionModel sm = ((TableView)this.get()).getSelectionModel();
                        if (sm != null) {
                            sm.getSelectedCells().addListener(TableCell.this.weakSelectedListener);
                        }
                        if ((fm = ((TableView)this.get()).getFocusModel()) != null) {
                            fm.focusedCellProperty().addListener(TableCell.this.weakFocusedListener);
                        }
                        ((TableView)this.get()).editingCellProperty().addListener(TableCell.this.weakEditingListener);
                        ((TableView)this.get()).getVisibleLeafColumns().addListener(TableCell.this.weakVisibleLeafColumnsListener);
                        this.weakTableViewRef = new WeakReference(this.get());
                    }
                    TableCell.this.updateColumnIndex();
                }

                @Override
                public Object getBean() {
                    return TableCell.this;
                }

                @Override
                public String getName() {
                    return "tableView";
                }
            };
        }
        return this.tableView;
    }

    private void setTableRow(TableRow value) {
        this.tableRow.set(value);
    }

    public final TableRow getTableRow() {
        return (TableRow)this.tableRow.get();
    }

    public final ReadOnlyObjectProperty<TableRow> tableRowProperty() {
        return this.tableRow;
    }

    @Override
    public void startEdit() {
        TableView<S> table = this.getTableView();
        TableColumn<S, T> column = this.getTableColumn();
        if (!this.isEditable() || table != null && !table.isEditable() || column != null && !this.getTableColumn().isEditable()) {
            return;
        }
        if (!this.lockItemOnEdit) {
            this.updateItem(-1);
        }
        super.startEdit();
        if (column != null) {
            TableColumn.CellEditEvent<S, Object> editEvent = new TableColumn.CellEditEvent<S, Object>(table, table.getEditingCell(), TableColumn.editStartEvent(), null);
            Event.fireEvent(column, editEvent);
        }
    }

    @Override
    public void commitEdit(T newValue) {
        if (!this.isEditing()) {
            return;
        }
        TableView table = this.getTableView();
        if (table != null) {
            TableColumn.CellEditEvent editEvent = new TableColumn.CellEditEvent(table, table.getEditingCell(), TableColumn.editCommitEvent(), newValue);
            Event.fireEvent(this.getTableColumn(), editEvent);
        }
        super.commitEdit(newValue);
        this.updateItem(newValue, false);
        if (table != null) {
            table.edit(-1, null);
            ControlUtils.requestFocusOnControlOnlyIfCurrentFocusOwnerIsChild(table);
        }
    }

    @Override
    public void cancelEdit() {
        if (!this.isEditing()) {
            return;
        }
        TableView table = this.getTableView();
        super.cancelEdit();
        if (table != null) {
            TablePosition<S, ?> editingCell = table.getEditingCell();
            if (this.updateEditingIndex) {
                table.edit(-1, null);
            }
            ControlUtils.requestFocusOnControlOnlyIfCurrentFocusOwnerIsChild(table);
            TableColumn.CellEditEvent<S, Object> editEvent = new TableColumn.CellEditEvent<S, Object>(table, editingCell, TableColumn.editCancelEvent(), null);
            Event.fireEvent(this.getTableColumn(), editEvent);
        }
    }

    @Override
    public void updateSelected(boolean selected) {
        if (this.getTableRow() == null || this.getTableRow().isEmpty()) {
            return;
        }
        this.setSelected(selected);
    }

    @Override
    protected Skin<?> createDefaultSkin() {
        return new TableCellSkin(this);
    }

    private void cleanUpTableViewListeners(TableView<S> tableView) {
        if (tableView != null) {
            TableView.TableViewFocusModel<S> fm;
            TableView.TableViewSelectionModel<S> sm = tableView.getSelectionModel();
            if (sm != null) {
                sm.getSelectedCells().removeListener(this.weakSelectedListener);
            }
            if ((fm = tableView.getFocusModel()) != null) {
                fm.focusedCellProperty().removeListener(this.weakFocusedListener);
            }
            tableView.editingCellProperty().removeListener(this.weakEditingListener);
            tableView.getVisibleLeafColumns().removeListener(this.weakVisibleLeafColumnsListener);
        }
    }

    @Override
    void indexChanged(int oldIndex, int newIndex) {
        super.indexChanged(oldIndex, newIndex);
        this.updateItem(oldIndex);
        this.updateSelection();
        this.updateFocus();
    }

    private void updateColumnIndex() {
        TableView<S> tv = this.getTableView();
        TableColumn<S, T> tc = this.getTableColumn();
        this.columnIndex = tv == null || tc == null ? -1 : tv.getVisibleLeafIndex(tc);
        this.isLastVisibleColumn = this.getTableColumn() != null && this.columnIndex != -1 && this.columnIndex == this.getTableView().getVisibleLeafColumns().size() - 1;
        this.pseudoClassStateChanged(PSEUDO_CLASS_LAST_VISIBLE, this.isLastVisibleColumn);
    }

    private void updateSelection() {
        if (this.isEmpty()) {
            return;
        }
        boolean isSelected = this.isSelected();
        if (!this.isInCellSelectionMode()) {
            if (isSelected) {
                this.updateSelected(false);
            }
            return;
        }
        TableView<S> tableView = this.getTableView();
        if (this.getIndex() == -1 || tableView == null) {
            return;
        }
        TableView.TableViewSelectionModel<S> sm = tableView.getSelectionModel();
        if (sm == null) {
            this.updateSelected(false);
            return;
        }
        boolean isSelectedNow = ((TableSelectionModel)sm).isSelected(this.getIndex(), this.getTableColumn());
        if (isSelected == isSelectedNow) {
            return;
        }
        this.updateSelected(isSelectedNow);
    }

    private void updateFocus() {
        boolean isFocused = this.isFocused();
        if (!this.isInCellSelectionMode()) {
            if (isFocused) {
                this.setFocused(false);
            }
            return;
        }
        TableView<S> tableView = this.getTableView();
        TableRow tableRow = this.getTableRow();
        int index = this.getIndex();
        if (index == -1 || tableView == null || tableRow == null) {
            return;
        }
        TableView.TableViewFocusModel<S> fm = tableView.getFocusModel();
        if (fm == null) {
            this.setFocused(false);
            return;
        }
        boolean isFocusedNow = fm != null && fm.isFocused(index, this.getTableColumn());
        this.setFocused(isFocusedNow);
    }

    private void updateEditing() {
        if (this.getIndex() == -1 || this.getTableView() == null) {
            return;
        }
        TablePosition<S, ?> editCell = this.getTableView().getEditingCell();
        boolean match = this.match(editCell);
        if (match && !this.isEditing()) {
            this.startEdit();
        } else if (!match && this.isEditing()) {
            this.updateEditingIndex = false;
            this.cancelEdit();
            this.updateEditingIndex = true;
        }
    }

    private boolean match(TablePosition<S, ?> pos) {
        return pos != null && pos.getRow() == this.getIndex() && pos.getTableColumn() == this.getTableColumn();
    }

    private boolean isInCellSelectionMode() {
        TableView<S> tableView = this.getTableView();
        if (tableView == null) {
            return false;
        }
        TableView.TableViewSelectionModel<S> sm = tableView.getSelectionModel();
        return sm != null && sm.isCellSelectionEnabled();
    }

    private void updateItem(int oldIndex) {
        Object rowItem;
        block8: {
            Object newValue;
            block7: {
                Object oldRowItem;
                boolean indexExceedsItemCount;
                TableView<S> tableView;
                if (this.currentObservableValue != null) {
                    this.currentObservableValue.removeListener(this.weaktableRowUpdateObserver);
                }
                ObservableList<Object> items = (tableView = this.getTableView()) == null ? FXCollections.emptyObservableList() : tableView.getItems();
                TableColumn<int, T> tableColumn = this.getTableColumn();
                int itemCount = items == null ? -1 : items.size();
                int index = this.getIndex();
                boolean isEmpty = this.isEmpty();
                Object oldValue = this.getItem();
                TableRow tableRow = this.getTableRow();
                rowItem = tableRow == null ? null : (Object)tableRow.getItem();
                boolean bl = indexExceedsItemCount = index >= itemCount;
                if (indexExceedsItemCount || index < 0 || this.columnIndex < 0 || !this.isVisible() || tableColumn == null || !tableColumn.isVisible()) {
                    if (!isEmpty && oldValue != null || this.isFirstRun || indexExceedsItemCount) {
                        this.updateItem(null, true);
                        this.isFirstRun = false;
                    }
                    return;
                }
                this.currentObservableValue = tableColumn.getCellObservableValue(index);
                Object t = newValue = this.currentObservableValue == null ? null : (Object)this.currentObservableValue.getValue();
                if (oldIndex != index || this.isItemChanged(oldValue, newValue)) break block7;
                Object object = oldRowItem = this.oldRowItemRef != null ? (Object)this.oldRowItemRef.get() : null;
                if (oldRowItem != null && oldRowItem.equals(rowItem)) break block8;
            }
            this.updateItem(newValue, false);
        }
        this.oldRowItemRef = new WeakReference<Object>(rowItem);
        if (this.currentObservableValue == null) {
            return;
        }
        this.currentObservableValue.addListener(this.weaktableRowUpdateObserver);
    }

    @Override
    protected void layoutChildren() {
        if (this.itemDirty) {
            this.updateItem(-1);
            this.itemDirty = false;
        }
        super.layoutChildren();
    }

    public final void updateTableView(TableView tv) {
        this.setTableView(tv);
    }

    public final void updateTableRow(TableRow tableRow) {
        this.setTableRow(tableRow);
    }

    public final void updateTableColumn(TableColumn col) {
        TableColumn<S, T> oldCol = this.getTableColumn();
        if (oldCol != null) {
            oldCol.getStyleClass().removeListener(this.weakColumnStyleClassListener);
            this.getStyleClass().removeAll((Collection<?>)oldCol.getStyleClass());
            oldCol.idProperty().removeListener(this.weakColumnIdListener);
            oldCol.styleProperty().removeListener(this.weakColumnStyleListener);
            String id = this.getId();
            String style = this.getStyle();
            if (id != null && id.equals(oldCol.getId())) {
                this.setId(null);
            }
            if (style != null && style.equals(oldCol.getStyle())) {
                this.setStyle("");
            }
        }
        this.setTableColumn(col);
        if (col != null) {
            this.getStyleClass().addAll((Collection<String>)col.getStyleClass());
            col.getStyleClass().addListener(this.weakColumnStyleClassListener);
            col.idProperty().addListener(this.weakColumnIdListener);
            col.styleProperty().addListener(this.weakColumnStyleListener);
            this.possiblySetId(col.getId());
            this.possiblySetStyle(col.getStyle());
        }
    }

    private void possiblySetId(String idCandidate) {
        if (this.getId() == null || this.getId().isEmpty()) {
            this.setId(idCandidate);
        }
    }

    private void possiblySetStyle(String styleCandidate) {
        if (this.getStyle() == null || this.getStyle().isEmpty()) {
            this.setStyle(styleCandidate);
        }
    }

    @Override
    public Object queryAccessibleAttribute(AccessibleAttribute attribute, Object ... parameters) {
        switch (attribute) {
            case ROW_INDEX: {
                return this.getIndex();
            }
            case COLUMN_INDEX: {
                return this.columnIndex;
            }
            case SELECTED: {
                return this.isInCellSelectionMode() ? this.isSelected() : this.getTableRow().isSelected();
            }
        }
        return super.queryAccessibleAttribute(attribute, parameters);
    }

    @Override
    public void executeAccessibleAction(AccessibleAction action, Object ... parameters) {
        switch (action) {
            case REQUEST_FOCUS: {
                TableView.TableViewFocusModel<S> fm;
                TableView<S> tableView = this.getTableView();
                if (tableView == null || (fm = tableView.getFocusModel()) == null) break;
                fm.focus(this.getIndex(), this.getTableColumn());
                break;
            }
            default: {
                super.executeAccessibleAction(action, parameters);
            }
        }
    }

    private /* synthetic */ void lambda$new$30(Observable value) {
        if (this.getTableColumn() != null) {
            this.possiblySetId(this.getTableColumn().getId());
        }
    }

    private /* synthetic */ void lambda$new$29(Observable value) {
        if (this.getTableColumn() != null) {
            this.possiblySetStyle(this.getTableColumn().getStyle());
        }
    }

    private /* synthetic */ void lambda$new$28(ListChangeListener.Change c) {
        while (c.next()) {
            if (c.wasRemoved()) {
                this.getStyleClass().removeAll(c.getRemoved());
            }
            if (!c.wasAdded()) continue;
            this.getStyleClass().addAll(c.getAddedSubList());
        }
    }

    private /* synthetic */ void lambda$new$27(ListChangeListener.Change c) {
        this.updateColumnIndex();
    }

    private /* synthetic */ void lambda$new$26(Observable value) {
        this.updateEditing();
    }

    private /* synthetic */ void lambda$new$25(Observable value) {
        this.itemDirty = true;
        this.requestLayout();
    }

    private /* synthetic */ void lambda$new$24(Observable value) {
        this.updateFocus();
    }

    private /* synthetic */ void lambda$new$23(ListChangeListener.Change c) {
        while (c.next()) {
            if (!c.wasAdded() && !c.wasRemoved()) continue;
            this.updateSelection();
        }
    }

    static /* synthetic */ void access$lambda$0(TableCell tableCell, ListChangeListener.Change change) {
        tableCell.lambda$new$23(change);
    }

    static /* synthetic */ void access$lambda$1(TableCell tableCell, Observable observable) {
        tableCell.lambda$new$24(observable);
    }

    static /* synthetic */ void access$lambda$2(TableCell tableCell, Observable observable) {
        tableCell.lambda$new$25(observable);
    }

    static /* synthetic */ void access$lambda$3(TableCell tableCell, Observable observable) {
        tableCell.lambda$new$26(observable);
    }

    static /* synthetic */ void access$lambda$4(TableCell tableCell, ListChangeListener.Change change) {
        tableCell.lambda$new$27(change);
    }

    static /* synthetic */ void access$lambda$5(TableCell tableCell, ListChangeListener.Change change) {
        tableCell.lambda$new$28(change);
    }

    static /* synthetic */ void access$lambda$6(TableCell tableCell, Observable observable) {
        tableCell.lambda$new$29(observable);
    }

    static /* synthetic */ void access$lambda$7(TableCell tableCell, Observable observable) {
        tableCell.lambda$new$30(observable);
    }
}

