/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import com.sun.javafx.scene.control.skin.TableRowSkin;
import java.lang.ref.WeakReference;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.WeakListChangeListener;
import javafx.scene.AccessibleAttribute;
import javafx.scene.AccessibleRole;
import javafx.scene.control.IndexedCell;
import javafx.scene.control.Skin;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TableRow$$Lambda$1;
import javafx.scene.control.TableRow$$Lambda$2;
import javafx.scene.control.TableRow$$Lambda$3;
import javafx.scene.control.TableView;

public class TableRow<T>
extends IndexedCell<T> {
    private ListChangeListener<TablePosition> selectedListener = TableRow$$Lambda$1.lambdaFactory$(this);
    private final InvalidationListener focusedListener = TableRow$$Lambda$2.lambdaFactory$(this);
    private final InvalidationListener editingListener = TableRow$$Lambda$3.lambdaFactory$(this);
    private final WeakListChangeListener<TablePosition> weakSelectedListener = new WeakListChangeListener<TablePosition>(this.selectedListener);
    private final WeakInvalidationListener weakFocusedListener = new WeakInvalidationListener(this.focusedListener);
    private final WeakInvalidationListener weakEditingListener = new WeakInvalidationListener(this.editingListener);
    private ReadOnlyObjectWrapper<TableView<T>> tableView;
    private boolean isFirstRun = true;
    private static final String DEFAULT_STYLE_CLASS = "table-row-cell";

    public TableRow() {
        this.getStyleClass().addAll((String[])new String[]{DEFAULT_STYLE_CLASS});
        this.setAccessibleRole(AccessibleRole.TABLE_ROW);
    }

    private void setTableView(TableView<T> value) {
        this.tableViewPropertyImpl().set(value);
    }

    public final TableView<T> getTableView() {
        return this.tableView == null ? null : (TableView)this.tableView.get();
    }

    public final ReadOnlyObjectProperty<TableView<T>> tableViewProperty() {
        return this.tableViewPropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyObjectWrapper<TableView<T>> tableViewPropertyImpl() {
        if (this.tableView == null) {
            this.tableView = new ReadOnlyObjectWrapper<TableView<T>>(){
                private WeakReference<TableView<T>> weakTableViewRef;

                @Override
                protected void invalidated() {
                    TableView tableView;
                    TableView.TableViewFocusModel<Object> fm;
                    TableView.TableViewSelectionModel<Object> sm;
                    if (this.weakTableViewRef != null) {
                        TableView oldTableView = (TableView)this.weakTableViewRef.get();
                        if (oldTableView != null) {
                            sm = oldTableView.getSelectionModel();
                            if (sm != null) {
                                sm.getSelectedCells().removeListener(TableRow.this.weakSelectedListener);
                            }
                            if ((fm = oldTableView.getFocusModel()) != null) {
                                fm.focusedCellProperty().removeListener(TableRow.this.weakFocusedListener);
                            }
                            oldTableView.editingCellProperty().removeListener(TableRow.this.weakEditingListener);
                        }
                        this.weakTableViewRef = null;
                    }
                    if ((tableView = TableRow.this.getTableView()) != null) {
                        sm = tableView.getSelectionModel();
                        if (sm != null) {
                            sm.getSelectedCells().addListener(TableRow.this.weakSelectedListener);
                        }
                        if ((fm = tableView.getFocusModel()) != null) {
                            fm.focusedCellProperty().addListener(TableRow.this.weakFocusedListener);
                        }
                        tableView.editingCellProperty().addListener(TableRow.this.weakEditingListener);
                        this.weakTableViewRef = new WeakReference(this.get());
                    }
                }

                @Override
                public Object getBean() {
                    return TableRow.this;
                }

                @Override
                public String getName() {
                    return "tableView";
                }
            };
        }
        return this.tableView;
    }

    @Override
    protected Skin<?> createDefaultSkin() {
        return new TableRowSkin(this);
    }

    @Override
    void indexChanged(int oldIndex, int newIndex) {
        super.indexChanged(oldIndex, newIndex);
        this.updateItem(oldIndex);
        this.updateSelection();
        this.updateFocus();
    }

    private void updateItem(int oldIndex) {
        TableView<T> tv = this.getTableView();
        if (tv == null || tv.getItems() == null) {
            return;
        }
        ObservableList<T> items = tv.getItems();
        int itemCount = items == null ? -1 : items.size();
        int newIndex = this.getIndex();
        boolean valid = newIndex >= 0 && newIndex < itemCount;
        Object oldValue = this.getItem();
        boolean isEmpty = this.isEmpty();
        if (valid) {
            Object newValue = items.get(newIndex);
            if (oldIndex != newIndex || this.isItemChanged(oldValue, newValue)) {
                this.updateItem(newValue, false);
            }
        } else if (!isEmpty && oldValue != null || this.isFirstRun) {
            this.updateItem(null, true);
            this.isFirstRun = false;
        }
    }

    private void updateSelection() {
        if (this.getIndex() == -1) {
            return;
        }
        TableView<T> table = this.getTableView();
        boolean isSelected = table != null && table.getSelectionModel() != null && !table.getSelectionModel().isCellSelectionEnabled() && table.getSelectionModel().isSelected(this.getIndex());
        this.updateSelected(isSelected);
    }

    private void updateFocus() {
        if (this.getIndex() == -1) {
            return;
        }
        TableView<T> table = this.getTableView();
        if (table == null) {
            return;
        }
        TableView.TableViewSelectionModel<T> sm = table.getSelectionModel();
        TableView.TableViewFocusModel<T> fm = table.getFocusModel();
        if (sm == null || fm == null) {
            return;
        }
        boolean isFocused = !sm.isCellSelectionEnabled() && fm.isFocused(this.getIndex());
        this.setFocused(isFocused);
    }

    private void updateEditing() {
        boolean rowMatch;
        if (this.getIndex() == -1) {
            return;
        }
        TableView<T> table = this.getTableView();
        if (table == null) {
            return;
        }
        TableView.TableViewSelectionModel<T> sm = table.getSelectionModel();
        if (sm == null || sm.isCellSelectionEnabled()) {
            return;
        }
        TablePosition<T, ?> editCell = table.getEditingCell();
        if (editCell != null && editCell.getTableColumn() != null) {
            return;
        }
        boolean bl = editCell == null ? false : (rowMatch = editCell.getRow() == this.getIndex());
        if (!this.isEditing() && rowMatch) {
            this.startEdit();
        } else if (this.isEditing() && !rowMatch) {
            this.cancelEdit();
        }
    }

    public final void updateTableView(TableView<T> tv) {
        this.setTableView(tv);
    }

    @Override
    public Object queryAccessibleAttribute(AccessibleAttribute attribute, Object ... parameters) {
        switch (attribute) {
            case INDEX: {
                return this.getIndex();
            }
        }
        return super.queryAccessibleAttribute(attribute, parameters);
    }

    private /* synthetic */ void lambda$new$60(Observable valueModel) {
        this.updateEditing();
    }

    private /* synthetic */ void lambda$new$59(Observable valueModel) {
        this.updateFocus();
    }

    private /* synthetic */ void lambda$new$58(ListChangeListener.Change c) {
        this.updateSelection();
    }

    static /* synthetic */ void access$lambda$0(TableRow tableRow, ListChangeListener.Change change) {
        tableRow.lambda$new$58(change);
    }

    static /* synthetic */ void access$lambda$1(TableRow tableRow, Observable observable) {
        tableRow.lambda$new$59(observable);
    }

    static /* synthetic */ void access$lambda$2(TableRow tableRow, Observable observable) {
        tableRow.lambda$new$60(observable);
    }
}

