/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import com.sun.javafx.scene.control.skin.resources.ControlResources;
import javafx.application.Platform;
import javafx.beans.NamedArg;
import javafx.beans.Observable;
import javafx.geometry.Pos;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogPane;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.control.TextInputDialog$$Lambda$1;
import javafx.scene.control.TextInputDialog$$Lambda$2;
import javafx.scene.control.TextInputDialog$$Lambda$3;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;

public class TextInputDialog
extends Dialog<String> {
    private final GridPane grid;
    private final Label label;
    private final TextField textField;
    private final String defaultValue;

    public TextInputDialog() {
        this("");
    }

    public TextInputDialog(@NamedArg(value="defaultValue") String defaultValue) {
        DialogPane dialogPane = this.getDialogPane();
        this.textField = new TextField(defaultValue);
        this.textField.setMaxWidth(Double.MAX_VALUE);
        GridPane.setHgrow(this.textField, Priority.ALWAYS);
        GridPane.setFillWidth(this.textField, true);
        this.label = DialogPane.createContentLabel(dialogPane.getContentText());
        this.label.setPrefWidth(-1.0);
        this.label.textProperty().bind(dialogPane.contentTextProperty());
        this.defaultValue = defaultValue;
        this.grid = new GridPane();
        this.grid.setHgap(10.0);
        this.grid.setMaxWidth(Double.MAX_VALUE);
        this.grid.setAlignment(Pos.CENTER_LEFT);
        dialogPane.contentTextProperty().addListener(TextInputDialog$$Lambda$1.lambdaFactory$(this));
        this.setTitle(ControlResources.getString("Dialog.confirm.title"));
        dialogPane.setHeaderText(ControlResources.getString("Dialog.confirm.header"));
        dialogPane.getStyleClass().add("text-input-dialog");
        dialogPane.getButtonTypes().addAll((ButtonType[])new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
        this.updateGrid();
        this.setResultConverter(TextInputDialog$$Lambda$2.lambdaFactory$(this));
    }

    public final TextField getEditor() {
        return this.textField;
    }

    public final String getDefaultValue() {
        return this.defaultValue;
    }

    private void updateGrid() {
        this.grid.getChildren().clear();
        this.grid.add(this.label, 0, 0);
        this.grid.add(this.textField, 1, 0);
        this.getDialogPane().setContent(this.grid);
        Platform.runLater(TextInputDialog$$Lambda$3.lambdaFactory$(this));
    }

    private /* synthetic */ void lambda$updateGrid$612() {
        this.textField.requestFocus();
    }

    private /* synthetic */ String lambda$new$611(ButtonType dialogButton) {
        ButtonBar.ButtonData data = dialogButton == null ? null : dialogButton.getButtonData();
        return data == ButtonBar.ButtonData.OK_DONE ? this.textField.getText() : null;
    }

    private /* synthetic */ void lambda$new$610(Observable o) {
        this.updateGrid();
    }

    static /* synthetic */ void access$lambda$0(TextInputDialog textInputDialog, Observable observable) {
        textInputDialog.lambda$new$610(observable);
    }

    static /* synthetic */ String access$lambda$1(TextInputDialog textInputDialog, ButtonType buttonType) {
        return textInputDialog.lambda$new$611(buttonType);
    }

    static /* synthetic */ void access$lambda$2(TextInputDialog textInputDialog) {
        textInputDialog.lambda$updateGrid$612();
    }
}

