/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import com.sun.javafx.scene.control.skin.ToggleButtonSkin;
import com.sun.javafx.scene.traversal.ParentTraversalEngine;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.css.PseudoClass;
import javafx.css.StyleableProperty;
import javafx.event.ActionEvent;
import javafx.geometry.Pos;
import javafx.scene.AccessibleAttribute;
import javafx.scene.AccessibleRole;
import javafx.scene.Node;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.Skin;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleButton$2$$Lambda$1;
import javafx.scene.control.ToggleGroup;

public class ToggleButton
extends ButtonBase
implements Toggle {
    private BooleanProperty selected;
    private ObjectProperty<ToggleGroup> toggleGroup;
    private static final String DEFAULT_STYLE_CLASS = "toggle-button";
    private static final PseudoClass PSEUDO_CLASS_SELECTED = PseudoClass.getPseudoClass("selected");

    public ToggleButton() {
        this.initialize();
    }

    public ToggleButton(String text) {
        this.setText(text);
        this.initialize();
    }

    public ToggleButton(String text, Node graphic) {
        this.setText(text);
        this.setGraphic(graphic);
        this.initialize();
    }

    private void initialize() {
        this.getStyleClass().setAll((String[])new String[]{DEFAULT_STYLE_CLASS});
        this.setAccessibleRole(AccessibleRole.TOGGLE_BUTTON);
        ((StyleableProperty)((Object)this.alignmentProperty())).applyStyle(null, Pos.CENTER);
        this.setMnemonicParsing(true);
    }

    @Override
    public final void setSelected(boolean value) {
        this.selectedProperty().set(value);
    }

    @Override
    public final boolean isSelected() {
        return this.selected == null ? false : this.selected.get();
    }

    @Override
    public final BooleanProperty selectedProperty() {
        if (this.selected == null) {
            this.selected = new BooleanPropertyBase(){

                @Override
                protected void invalidated() {
                    boolean selected = this.get();
                    ToggleGroup tg = ToggleButton.this.getToggleGroup();
                    ToggleButton.this.pseudoClassStateChanged(PSEUDO_CLASS_SELECTED, selected);
                    ToggleButton.this.notifyAccessibleAttributeChanged(AccessibleAttribute.SELECTED);
                    if (tg != null) {
                        if (selected) {
                            tg.selectToggle(ToggleButton.this);
                        } else if (tg.getSelectedToggle() == ToggleButton.this) {
                            tg.clearSelectedToggle();
                        }
                    }
                }

                @Override
                public Object getBean() {
                    return ToggleButton.this;
                }

                @Override
                public String getName() {
                    return "selected";
                }
            };
        }
        return this.selected;
    }

    @Override
    public final void setToggleGroup(ToggleGroup value) {
        this.toggleGroupProperty().set(value);
    }

    @Override
    public final ToggleGroup getToggleGroup() {
        return this.toggleGroup == null ? null : (ToggleGroup)this.toggleGroup.get();
    }

    @Override
    public final ObjectProperty<ToggleGroup> toggleGroupProperty() {
        if (this.toggleGroup == null) {
            this.toggleGroup = new ObjectPropertyBase<ToggleGroup>(){
                private ToggleGroup old;
                private ChangeListener<Toggle> listener = ToggleButton$2$$Lambda$1.lambdaFactory$(this);

                @Override
                protected void invalidated() {
                    ToggleGroup tg = (ToggleGroup)this.get();
                    if (tg != null && !tg.getToggles().contains(ToggleButton.this)) {
                        if (this.old != null) {
                            this.old.getToggles().remove(ToggleButton.this);
                        }
                        tg.getToggles().add(ToggleButton.this);
                        ParentTraversalEngine parentTraversalEngine = new ParentTraversalEngine(ToggleButton.this);
                        ToggleButton.this.setImpl_traversalEngine(parentTraversalEngine);
                        parentTraversalEngine.setOverriddenFocusTraversability(tg.getSelectedToggle() != null ? Boolean.valueOf(ToggleButton.this.isSelected()) : null);
                        tg.selectedToggleProperty().addListener(this.listener);
                    } else if (tg == null) {
                        this.old.selectedToggleProperty().removeListener(this.listener);
                        this.old.getToggles().remove(ToggleButton.this);
                        ToggleButton.this.setImpl_traversalEngine(null);
                    }
                    this.old = tg;
                }

                @Override
                public Object getBean() {
                    return ToggleButton.this;
                }

                @Override
                public String getName() {
                    return "toggleGroup";
                }

                private /* synthetic */ void lambda$$252(ObservableValue o, Toggle oV, Toggle nV) {
                    ToggleButton.this.getImpl_traversalEngine().setOverriddenFocusTraversability(nV != null ? Boolean.valueOf(ToggleButton.this.isSelected()) : null);
                }

                static /* synthetic */ void access$lambda$0(2 var0, ObservableValue observableValue, Toggle toggle, Toggle toggle2) {
                    var0.lambda$$252(observableValue, toggle, toggle2);
                }
            };
        }
        return this.toggleGroup;
    }

    @Override
    public void fire() {
        if (!this.isDisabled()) {
            this.setSelected(!this.isSelected());
            this.fireEvent(new ActionEvent());
        }
    }

    @Override
    protected Skin<?> createDefaultSkin() {
        return new ToggleButtonSkin(this);
    }

    @Override
    @Deprecated
    protected Pos impl_cssGetAlignmentInitialValue() {
        return Pos.CENTER;
    }

    @Override
    public Object queryAccessibleAttribute(AccessibleAttribute attribute, Object ... parameters) {
        switch (attribute) {
            case SELECTED: {
                return this.isSelected();
            }
        }
        return super.queryAccessibleAttribute(attribute, parameters);
    }
}

