/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control.cell;

import javafx.beans.value.ObservableValue;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.TreeTableCell;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.cell.ProgressBarTreeTableCell$$Lambda$1;
import javafx.util.Callback;

public class ProgressBarTreeTableCell<S>
extends TreeTableCell<S, Double> {
    private final ProgressBar progressBar;
    private ObservableValue<Double> observable;

    public static <S> Callback<TreeTableColumn<S, Double>, TreeTableCell<S, Double>> forTreeTableColumn() {
        return ProgressBarTreeTableCell$$Lambda$1.lambdaFactory$();
    }

    public ProgressBarTreeTableCell() {
        this.getStyleClass().add("progress-bar-tree-table-cell");
        this.progressBar = new ProgressBar();
        this.progressBar.setMaxWidth(Double.MAX_VALUE);
    }

    @Override
    public void updateItem(Double item, boolean empty) {
        super.updateItem(item, empty);
        if (empty) {
            this.setGraphic(null);
        } else {
            this.progressBar.progressProperty().unbind();
            TreeTableColumn column = this.getTableColumn();
            ObservableValue<Object> observableValue = this.observable = column == null ? null : column.getCellObservableValue(this.getIndex());
            if (this.observable != null) {
                this.progressBar.progressProperty().bind(this.observable);
            } else if (item != null) {
                this.progressBar.setProgress(item);
            }
            this.setGraphic(this.progressBar);
        }
    }

    private static /* synthetic */ TreeTableCell lambda$forTreeTableColumn$633(TreeTableColumn param) {
        return new ProgressBarTreeTableCell();
    }

    static /* synthetic */ TreeTableCell access$lambda$0(TreeTableColumn treeTableColumn) {
        return ProgressBarTreeTableCell.lambda$forTreeTableColumn$633(treeTableColumn);
    }
}

