/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.layout;

import javafx.beans.NamedArg;

public final class BackgroundSize {
    public static final double AUTO = -1.0;
    public static final BackgroundSize DEFAULT = new BackgroundSize(-1.0, -1.0, true, true, false, false);
    final double width;
    final double height;
    final boolean widthAsPercentage;
    final boolean heightAsPercentage;
    final boolean contain;
    final boolean cover;
    private final int hash;

    public final double getWidth() {
        return this.width;
    }

    public final double getHeight() {
        return this.height;
    }

    public final boolean isWidthAsPercentage() {
        return this.widthAsPercentage;
    }

    public final boolean isHeightAsPercentage() {
        return this.heightAsPercentage;
    }

    public final boolean isContain() {
        return this.contain;
    }

    public final boolean isCover() {
        return this.cover;
    }

    public BackgroundSize(@NamedArg(value="width") double width, @NamedArg(value="height") double height, @NamedArg(value="widthAsPercentage") boolean widthAsPercentage, @NamedArg(value="heightAsPercentage") boolean heightAsPercentage, @NamedArg(value="contain") boolean contain, @NamedArg(value="cover") boolean cover) {
        if (width < 0.0 && width != -1.0) {
            throw new IllegalArgumentException("Width cannot be < 0, except when AUTO");
        }
        if (height < 0.0 && height != -1.0) {
            throw new IllegalArgumentException("Height cannot be < 0, except when AUTO");
        }
        this.width = width;
        this.height = height;
        this.widthAsPercentage = widthAsPercentage;
        this.heightAsPercentage = heightAsPercentage;
        this.contain = contain;
        this.cover = cover;
        int result = this.widthAsPercentage ? 1 : 0;
        result = 31 * result + (this.heightAsPercentage ? 1 : 0);
        long temp = this.width != 0.0 ? Double.doubleToLongBits(this.width) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = this.height != 0.0 ? Double.doubleToLongBits(this.height) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.cover ? 1 : 0);
        this.hash = result = 31 * result + (this.contain ? 1 : 0);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BackgroundSize that = (BackgroundSize)o;
        if (this.hash != that.hash) {
            return false;
        }
        if (this.contain != that.contain) {
            return false;
        }
        if (this.cover != that.cover) {
            return false;
        }
        if (Double.compare(that.height, this.height) != 0) {
            return false;
        }
        if (this.heightAsPercentage != that.heightAsPercentage) {
            return false;
        }
        if (this.widthAsPercentage != that.widthAsPercentage) {
            return false;
        }
        return Double.compare(that.width, this.width) == 0;
    }

    public int hashCode() {
        return this.hash;
    }
}

