/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.text;

import com.sun.javafx.css.converters.BooleanConverter;
import com.sun.javafx.css.converters.EnumConverter;
import com.sun.javafx.css.converters.SizeConverter;
import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.Path2D;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.Shape;
import com.sun.javafx.geom.TransformedShape;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.scene.DirtyBits;
import com.sun.javafx.scene.text.GlyphList;
import com.sun.javafx.scene.text.HitInfo;
import com.sun.javafx.scene.text.TextLayout;
import com.sun.javafx.scene.text.TextLayoutFactory;
import com.sun.javafx.scene.text.TextLine;
import com.sun.javafx.scene.text.TextSpan;
import com.sun.javafx.sg.prism.NGNode;
import com.sun.javafx.sg.prism.NGShape;
import com.sun.javafx.sg.prism.NGText;
import com.sun.javafx.tk.Toolkit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.DefaultProperty;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.IntegerPropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyDoubleWrapper;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.property.StringPropertyBase;
import javafx.css.CssMetaData;
import javafx.css.FontCssMetaData;
import javafx.css.Styleable;
import javafx.css.StyleableBooleanProperty;
import javafx.css.StyleableDoubleProperty;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.geometry.NodeOrientation;
import javafx.geometry.Point2D;
import javafx.geometry.VPos;
import javafx.scene.AccessibleAttribute;
import javafx.scene.AccessibleRole;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.PathElement;
import javafx.scene.shape.StrokeType;
import javafx.scene.text.Font;
import javafx.scene.text.FontSmoothingType;
import javafx.scene.text.Text$$Lambda$1;
import javafx.scene.text.Text$$Lambda$2;
import javafx.scene.text.TextAlignment;
import javafx.scene.text.TextBoundsType;
import javafx.scene.text.TextFlow;

@DefaultProperty(value="text")
public class Text
extends javafx.scene.shape.Shape {
    private TextLayout layout;
    private static final PathElement[] EMPTY_PATH_ELEMENT_ARRAY = new PathElement[0];
    private boolean isSpan;
    private TextSpan textSpan;
    private GlyphList[] textRuns = null;
    private BaseBounds spanBounds = new RectBounds();
    private boolean spanBoundsInvalid = true;
    private StringProperty text;
    private DoubleProperty x;
    private DoubleProperty y;
    private ObjectProperty<Font> font;
    private ObjectProperty<TextBoundsType> boundsType;
    private DoubleProperty wrappingWidth;
    private ObjectProperty<FontSmoothingType> fontSmoothingType;
    private TextAttribute attributes;
    private static final VPos DEFAULT_TEXT_ORIGIN = VPos.BASELINE;
    private static final TextBoundsType DEFAULT_BOUNDS_TYPE = TextBoundsType.LOGICAL;
    private static final boolean DEFAULT_UNDERLINE = false;
    private static final boolean DEFAULT_STRIKETHROUGH = false;
    private static final TextAlignment DEFAULT_TEXT_ALIGNMENT = TextAlignment.LEFT;
    private static final double DEFAULT_LINE_SPACING = 0.0;
    private static final int DEFAULT_CARET_POSITION = -1;
    private static final int DEFAULT_SELECTION_START = -1;
    private static final int DEFAULT_SELECTION_END = -1;
    private static final Color DEFAULT_SELECTION_FILL = Color.WHITE;
    private static final boolean DEFAULT_CARET_BIAS = true;

    @Override
    @Deprecated
    protected final NGNode impl_createPeer() {
        return new NGText();
    }

    public Text() {
        this.setAccessibleRole(AccessibleRole.TEXT);
        InvalidationListener listener = Text$$Lambda$1.lambdaFactory$(this);
        this.parentProperty().addListener(listener);
        this.managedProperty().addListener(listener);
        this.effectiveNodeOrientationProperty().addListener(Text$$Lambda$2.lambdaFactory$(this));
        this.setPickOnBounds(true);
    }

    public Text(String text) {
        this();
        this.setText(text);
    }

    public Text(double x, double y, String text) {
        this(text);
        this.setX(x);
        this.setY(y);
    }

    private boolean isSpan() {
        return this.isSpan;
    }

    private void checkSpan() {
        boolean bl = this.isSpan = this.isManaged() && this.getParent() instanceof TextFlow;
        if (this.isSpan() && !this.pickOnBoundsProperty().isBound()) {
            this.setPickOnBounds(false);
        }
    }

    private void checkOrientation() {
        if (!this.isSpan()) {
            NodeOrientation orientation = this.getEffectiveNodeOrientation();
            boolean rtl = orientation == NodeOrientation.RIGHT_TO_LEFT;
            int dir = rtl ? 2048 : 1024;
            TextLayout layout = this.getTextLayout();
            if (layout.setDirection(dir)) {
                this.needsTextLayout();
            }
        }
    }

    @Override
    public boolean usesMirroring() {
        return false;
    }

    private void needsFullTextLayout() {
        if (this.isSpan()) {
            this.textSpan = null;
        } else {
            TextLayout layout = this.getTextLayout();
            String string = this.getTextInternal();
            Object font = this.getFontInternal();
            layout.setContent(string, font);
        }
        this.needsTextLayout();
    }

    private void needsTextLayout() {
        this.textRuns = null;
        this.impl_geomChanged();
        this.impl_markDirty(DirtyBits.NODE_CONTENTS);
    }

    TextSpan getTextSpan() {
        if (this.textSpan == null) {
            this.textSpan = new TextSpan(){

                @Override
                public String getText() {
                    return Text.this.getTextInternal();
                }

                @Override
                public Object getFont() {
                    return Text.this.getFontInternal();
                }

                @Override
                public RectBounds getBounds() {
                    return null;
                }
            };
        }
        return this.textSpan;
    }

    private TextLayout getTextLayout() {
        if (this.isSpan()) {
            this.layout = null;
            TextFlow parent = (TextFlow)this.getParent();
            return parent.getTextLayout();
        }
        if (this.layout == null) {
            TextLayoutFactory factory = Toolkit.getToolkit().getTextLayoutFactory();
            this.layout = factory.createLayout();
            String string = this.getTextInternal();
            Object font = this.getFontInternal();
            TextAlignment alignment = this.getTextAlignment();
            if (alignment == null) {
                alignment = DEFAULT_TEXT_ALIGNMENT;
            }
            this.layout.setContent(string, font);
            this.layout.setAlignment(alignment.ordinal());
            this.layout.setLineSpacing((float)this.getLineSpacing());
            this.layout.setWrapWidth((float)this.getWrappingWidth());
            if (this.getEffectiveNodeOrientation() == NodeOrientation.RIGHT_TO_LEFT) {
                this.layout.setDirection(2048);
            } else {
                this.layout.setDirection(1024);
            }
        }
        return this.layout;
    }

    void layoutSpan(GlyphList[] runs) {
        GlyphList run;
        int i;
        TextSpan span = this.getTextSpan();
        int count = 0;
        for (i = 0; i < runs.length; ++i) {
            run = runs[i];
            if (run.getTextSpan() != span) continue;
            ++count;
        }
        this.textRuns = new GlyphList[count];
        count = 0;
        for (i = 0; i < runs.length; ++i) {
            run = runs[i];
            if (run.getTextSpan() != span) continue;
            this.textRuns[count++] = run;
        }
        this.spanBoundsInvalid = true;
        this.impl_geomChanged();
        this.impl_markDirty(DirtyBits.NODE_CONTENTS);
    }

    BaseBounds getSpanBounds() {
        if (this.spanBoundsInvalid) {
            GlyphList[] runs = this.getRuns();
            if (runs.length != 0) {
                float left = Float.POSITIVE_INFINITY;
                float top = Float.POSITIVE_INFINITY;
                float right = 0.0f;
                float bottom = 0.0f;
                for (int i = 0; i < runs.length; ++i) {
                    GlyphList run = runs[i];
                    com.sun.javafx.geom.Point2D location = run.getLocation();
                    float width = run.getWidth();
                    float height = run.getLineBounds().getHeight();
                    left = Math.min(location.x, left);
                    top = Math.min(location.y, top);
                    right = Math.max(location.x + width, right);
                    bottom = Math.max(location.y + height, bottom);
                }
                this.spanBounds = this.spanBounds.deriveWithNewBounds(left, top, 0.0f, right, bottom, 0.0f);
            } else {
                this.spanBounds = this.spanBounds.makeEmpty();
            }
            this.spanBoundsInvalid = false;
        }
        return this.spanBounds;
    }

    private GlyphList[] getRuns() {
        if (this.textRuns != null) {
            return this.textRuns;
        }
        if (this.isSpan()) {
            this.getParent().layout();
        } else {
            TextLayout layout = this.getTextLayout();
            this.textRuns = layout.getRuns();
        }
        return this.textRuns;
    }

    private Shape getShape() {
        TextLayout layout = this.getTextLayout();
        int type = 1;
        if (this.isStrikethrough()) {
            type |= 4;
        }
        if (this.isUnderline()) {
            type |= 2;
        }
        TextSpan filter = null;
        if (this.isSpan()) {
            type |= 0x10;
            filter = this.getTextSpan();
        } else {
            type |= 8;
        }
        return layout.getShape(type, filter);
    }

    private BaseBounds getVisualBounds() {
        if (this.impl_mode == NGShape.Mode.FILL || this.getStrokeType() == StrokeType.INSIDE) {
            int type = 1;
            if (this.isStrikethrough()) {
                type |= 4;
            }
            if (this.isUnderline()) {
                type |= 2;
            }
            return this.getTextLayout().getVisualBounds(type);
        }
        return this.getShape().getBounds();
    }

    private BaseBounds getLogicalBounds() {
        TextLayout layout = this.getTextLayout();
        return layout.getBounds();
    }

    public final void setText(String value) {
        if (value == null) {
            value = "";
        }
        this.textProperty().set(value);
    }

    public final String getText() {
        return this.text == null ? "" : (String)this.text.get();
    }

    private String getTextInternal() {
        String localText = this.getText();
        return localText == null ? "" : localText;
    }

    public final StringProperty textProperty() {
        if (this.text == null) {
            this.text = new StringPropertyBase(""){

                @Override
                public Object getBean() {
                    return Text.this;
                }

                @Override
                public String getName() {
                    return "text";
                }

                @Override
                public void invalidated() {
                    Text.this.needsFullTextLayout();
                    Text.this.setImpl_selectionStart(-1);
                    Text.this.setImpl_selectionEnd(-1);
                    Text.this.setImpl_caretPosition(-1);
                    Text.this.setImpl_caretBias(true);
                    String value = this.get();
                    if (value == null && !this.isBound()) {
                        this.set("");
                    }
                    Text.this.notifyAccessibleAttributeChanged(AccessibleAttribute.TEXT);
                }
            };
        }
        return this.text;
    }

    public final void setX(double value) {
        this.xProperty().set(value);
    }

    public final double getX() {
        return this.x == null ? 0.0 : this.x.get();
    }

    public final DoubleProperty xProperty() {
        if (this.x == null) {
            this.x = new DoublePropertyBase(){

                @Override
                public Object getBean() {
                    return Text.this;
                }

                @Override
                public String getName() {
                    return "x";
                }

                @Override
                public void invalidated() {
                    Text.this.impl_geomChanged();
                }
            };
        }
        return this.x;
    }

    public final void setY(double value) {
        this.yProperty().set(value);
    }

    public final double getY() {
        return this.y == null ? 0.0 : this.y.get();
    }

    public final DoubleProperty yProperty() {
        if (this.y == null) {
            this.y = new DoublePropertyBase(){

                @Override
                public Object getBean() {
                    return Text.this;
                }

                @Override
                public String getName() {
                    return "y";
                }

                @Override
                public void invalidated() {
                    Text.this.impl_geomChanged();
                }
            };
        }
        return this.y;
    }

    public final void setFont(Font value) {
        this.fontProperty().set(value);
    }

    public final Font getFont() {
        return this.font == null ? Font.getDefault() : (Font)this.font.get();
    }

    private Object getFontInternal() {
        Font font = this.getFont();
        if (font == null) {
            font = Font.getDefault();
        }
        return font.impl_getNativeFont();
    }

    public final ObjectProperty<Font> fontProperty() {
        if (this.font == null) {
            this.font = new StyleableObjectProperty<Font>(Font.getDefault()){

                @Override
                public Object getBean() {
                    return Text.this;
                }

                @Override
                public String getName() {
                    return "font";
                }

                @Override
                public CssMetaData<Text, Font> getCssMetaData() {
                    return StyleableProperties.FONT;
                }

                @Override
                public void invalidated() {
                    Text.this.needsFullTextLayout();
                    Text.this.impl_markDirty(DirtyBits.TEXT_FONT);
                }
            };
        }
        return this.font;
    }

    public final void setTextOrigin(VPos value) {
        this.textOriginProperty().set(value);
    }

    public final VPos getTextOrigin() {
        if (this.attributes == null || this.attributes.textOrigin == null) {
            return DEFAULT_TEXT_ORIGIN;
        }
        return this.attributes.getTextOrigin();
    }

    public final ObjectProperty<VPos> textOriginProperty() {
        return this.getTextAttribute().textOriginProperty();
    }

    public final void setBoundsType(TextBoundsType value) {
        this.boundsTypeProperty().set(value);
    }

    public final TextBoundsType getBoundsType() {
        return this.boundsType == null ? DEFAULT_BOUNDS_TYPE : (TextBoundsType)((Object)this.boundsTypeProperty().get());
    }

    public final ObjectProperty<TextBoundsType> boundsTypeProperty() {
        if (this.boundsType == null) {
            this.boundsType = new StyleableObjectProperty<TextBoundsType>(DEFAULT_BOUNDS_TYPE){

                @Override
                public Object getBean() {
                    return Text.this;
                }

                @Override
                public String getName() {
                    return "boundsType";
                }

                @Override
                public CssMetaData<Text, TextBoundsType> getCssMetaData() {
                    return StyleableProperties.BOUNDS_TYPE;
                }

                @Override
                public void invalidated() {
                    TextLayout layout = Text.this.getTextLayout();
                    int type = 0;
                    if (Text.this.boundsType.get() == TextBoundsType.LOGICAL_VERTICAL_CENTER) {
                        type |= 0x4000;
                    }
                    if (layout.setBoundsType(type)) {
                        Text.this.needsTextLayout();
                    } else {
                        Text.this.impl_geomChanged();
                    }
                }
            };
        }
        return this.boundsType;
    }

    public final void setWrappingWidth(double value) {
        this.wrappingWidthProperty().set(value);
    }

    public final double getWrappingWidth() {
        return this.wrappingWidth == null ? 0.0 : this.wrappingWidth.get();
    }

    public final DoubleProperty wrappingWidthProperty() {
        if (this.wrappingWidth == null) {
            this.wrappingWidth = new DoublePropertyBase(){

                @Override
                public Object getBean() {
                    return Text.this;
                }

                @Override
                public String getName() {
                    return "wrappingWidth";
                }

                @Override
                public void invalidated() {
                    if (!Text.this.isSpan()) {
                        TextLayout layout = Text.this.getTextLayout();
                        if (layout.setWrapWidth((float)this.get())) {
                            Text.this.needsTextLayout();
                        } else {
                            Text.this.impl_geomChanged();
                        }
                    }
                }
            };
        }
        return this.wrappingWidth;
    }

    public final void setUnderline(boolean value) {
        this.underlineProperty().set(value);
    }

    public final boolean isUnderline() {
        if (this.attributes == null || this.attributes.underline == null) {
            return false;
        }
        return this.attributes.isUnderline();
    }

    public final BooleanProperty underlineProperty() {
        return this.getTextAttribute().underlineProperty();
    }

    public final void setStrikethrough(boolean value) {
        this.strikethroughProperty().set(value);
    }

    public final boolean isStrikethrough() {
        if (this.attributes == null || this.attributes.strikethrough == null) {
            return false;
        }
        return this.attributes.isStrikethrough();
    }

    public final BooleanProperty strikethroughProperty() {
        return this.getTextAttribute().strikethroughProperty();
    }

    public final void setTextAlignment(TextAlignment value) {
        this.textAlignmentProperty().set(value);
    }

    public final TextAlignment getTextAlignment() {
        if (this.attributes == null || this.attributes.textAlignment == null) {
            return DEFAULT_TEXT_ALIGNMENT;
        }
        return this.attributes.getTextAlignment();
    }

    public final ObjectProperty<TextAlignment> textAlignmentProperty() {
        return this.getTextAttribute().textAlignmentProperty();
    }

    public final void setLineSpacing(double spacing) {
        this.lineSpacingProperty().set(spacing);
    }

    public final double getLineSpacing() {
        if (this.attributes == null || this.attributes.lineSpacing == null) {
            return 0.0;
        }
        return this.attributes.getLineSpacing();
    }

    public final DoubleProperty lineSpacingProperty() {
        return this.getTextAttribute().lineSpacingProperty();
    }

    @Override
    public final double getBaselineOffset() {
        return this.baselineOffsetProperty().get();
    }

    public final ReadOnlyDoubleProperty baselineOffsetProperty() {
        return this.getTextAttribute().baselineOffsetProperty();
    }

    public final void setFontSmoothingType(FontSmoothingType value) {
        this.fontSmoothingTypeProperty().set(value);
    }

    public final FontSmoothingType getFontSmoothingType() {
        return this.fontSmoothingType == null ? FontSmoothingType.GRAY : (FontSmoothingType)((Object)this.fontSmoothingType.get());
    }

    public final ObjectProperty<FontSmoothingType> fontSmoothingTypeProperty() {
        if (this.fontSmoothingType == null) {
            this.fontSmoothingType = new StyleableObjectProperty<FontSmoothingType>(FontSmoothingType.GRAY){

                @Override
                public Object getBean() {
                    return Text.this;
                }

                @Override
                public String getName() {
                    return "fontSmoothingType";
                }

                @Override
                public CssMetaData<Text, FontSmoothingType> getCssMetaData() {
                    return StyleableProperties.FONT_SMOOTHING_TYPE;
                }

                @Override
                public void invalidated() {
                    Text.this.impl_markDirty(DirtyBits.TEXT_ATTRS);
                    Text.this.impl_geomChanged();
                }
            };
        }
        return this.fontSmoothingType;
    }

    @Override
    @Deprecated
    protected final void impl_geomChanged() {
        super.impl_geomChanged();
        if (this.attributes != null) {
            if (this.attributes.impl_caretBinding != null) {
                this.attributes.impl_caretBinding.invalidate();
            }
            if (this.attributes.impl_selectionBinding != null) {
                this.attributes.impl_selectionBinding.invalidate();
            }
        }
        this.impl_markDirty(DirtyBits.NODE_GEOMETRY);
    }

    @Deprecated
    public final PathElement[] getImpl_selectionShape() {
        return (PathElement[])this.impl_selectionShapeProperty().get();
    }

    @Deprecated
    public final ReadOnlyObjectProperty<PathElement[]> impl_selectionShapeProperty() {
        return this.getTextAttribute().impl_selectionShapeProperty();
    }

    @Deprecated
    public final void setImpl_selectionStart(int value) {
        if (value == -1 && (this.attributes == null || this.attributes.impl_selectionStart == null)) {
            return;
        }
        this.impl_selectionStartProperty().set(value);
    }

    @Deprecated
    public final int getImpl_selectionStart() {
        if (this.attributes == null || this.attributes.impl_selectionStart == null) {
            return -1;
        }
        return this.attributes.getImpl_selectionStart();
    }

    @Deprecated
    public final IntegerProperty impl_selectionStartProperty() {
        return this.getTextAttribute().impl_selectionStartProperty();
    }

    @Deprecated
    public final void setImpl_selectionEnd(int value) {
        if (value == -1 && (this.attributes == null || this.attributes.impl_selectionEnd == null)) {
            return;
        }
        this.impl_selectionEndProperty().set(value);
    }

    @Deprecated
    public final int getImpl_selectionEnd() {
        if (this.attributes == null || this.attributes.impl_selectionEnd == null) {
            return -1;
        }
        return this.attributes.getImpl_selectionEnd();
    }

    @Deprecated
    public final IntegerProperty impl_selectionEndProperty() {
        return this.getTextAttribute().impl_selectionEndProperty();
    }

    @Deprecated
    public final ObjectProperty<Paint> impl_selectionFillProperty() {
        return this.getTextAttribute().impl_selectionFillProperty();
    }

    @Deprecated
    public final PathElement[] getImpl_caretShape() {
        return (PathElement[])this.impl_caretShapeProperty().get();
    }

    @Deprecated
    public final ReadOnlyObjectProperty<PathElement[]> impl_caretShapeProperty() {
        return this.getTextAttribute().impl_caretShapeProperty();
    }

    @Deprecated
    public final void setImpl_caretPosition(int value) {
        if (value == -1 && (this.attributes == null || this.attributes.impl_caretPosition == null)) {
            return;
        }
        this.impl_caretPositionProperty().set(value);
    }

    @Deprecated
    public final int getImpl_caretPosition() {
        if (this.attributes == null || this.attributes.impl_caretPosition == null) {
            return -1;
        }
        return this.attributes.getImpl_caretPosition();
    }

    @Deprecated
    public final IntegerProperty impl_caretPositionProperty() {
        return this.getTextAttribute().impl_caretPositionProperty();
    }

    @Deprecated
    public final void setImpl_caretBias(boolean value) {
        if (value && (this.attributes == null || this.attributes.impl_caretBias == null)) {
            return;
        }
        this.impl_caretBiasProperty().set(value);
    }

    @Deprecated
    public final boolean isImpl_caretBias() {
        if (this.attributes == null || this.attributes.impl_caretBias == null) {
            return true;
        }
        return this.getTextAttribute().isImpl_caretBias();
    }

    @Deprecated
    public final BooleanProperty impl_caretBiasProperty() {
        return this.getTextAttribute().impl_caretBiasProperty();
    }

    @Deprecated
    public final HitInfo impl_hitTestChar(Point2D point) {
        if (point == null) {
            return null;
        }
        TextLayout layout = this.getTextLayout();
        double x = point.getX() - this.getX();
        double y = point.getY() - this.getY() + (double)this.getYRendering();
        return layout.getHitInfo((float)x, (float)y);
    }

    private PathElement[] getRange(int start, int end, int type) {
        int length = this.getTextInternal().length();
        if (0 <= start && start < end && end <= length) {
            TextLayout layout = this.getTextLayout();
            float x = (float)this.getX();
            float y = (float)this.getY() - this.getYRendering();
            return layout.getRange(start, end, type, x, y);
        }
        return EMPTY_PATH_ELEMENT_ARRAY;
    }

    @Deprecated
    public final PathElement[] impl_getRangeShape(int start, int end) {
        return this.getRange(start, end, 1);
    }

    @Deprecated
    public final PathElement[] impl_getUnderlineShape(int start, int end) {
        return this.getRange(start, end, 2);
    }

    @Deprecated
    public final void impl_displaySoftwareKeyboard(boolean display) {
    }

    private float getYAdjustment(BaseBounds bounds) {
        VPos origin = this.getTextOrigin();
        if (origin == null) {
            origin = DEFAULT_TEXT_ORIGIN;
        }
        switch (origin) {
            case TOP: {
                return -bounds.getMinY();
            }
            case BASELINE: {
                return 0.0f;
            }
            case CENTER: {
                return -bounds.getMinY() - bounds.getHeight() / 2.0f;
            }
            case BOTTOM: {
                return -bounds.getMinY() - bounds.getHeight();
            }
        }
        return 0.0f;
    }

    private float getYRendering() {
        if (this.isSpan()) {
            return 0.0f;
        }
        BaseBounds bounds = this.getLogicalBounds();
        VPos origin = this.getTextOrigin();
        if (origin == null) {
            origin = DEFAULT_TEXT_ORIGIN;
        }
        if (this.getBoundsType() == TextBoundsType.VISUAL) {
            BaseBounds vBounds = this.getVisualBounds();
            float delta = vBounds.getMinY() - bounds.getMinY();
            switch (origin) {
                case TOP: {
                    return delta;
                }
                case BASELINE: {
                    return -vBounds.getMinY() + delta;
                }
                case CENTER: {
                    return vBounds.getHeight() / 2.0f + delta;
                }
                case BOTTOM: {
                    return vBounds.getHeight() + delta;
                }
            }
            return 0.0f;
        }
        switch (origin) {
            case TOP: {
                return 0.0f;
            }
            case BASELINE: {
                return -bounds.getMinY();
            }
            case CENTER: {
                return bounds.getHeight() / 2.0f;
            }
            case BOTTOM: {
                return bounds.getHeight();
            }
        }
        return 0.0f;
    }

    @Override
    @Deprecated
    protected final Bounds impl_computeLayoutBounds() {
        if (this.isSpan()) {
            BaseBounds bounds = this.getSpanBounds();
            double width = bounds.getWidth();
            double height = bounds.getHeight();
            return new BoundingBox(0.0, 0.0, width, height);
        }
        if (this.getBoundsType() == TextBoundsType.VISUAL) {
            return super.impl_computeLayoutBounds();
        }
        BaseBounds bounds = this.getLogicalBounds();
        double x = (double)bounds.getMinX() + this.getX();
        double y = (double)bounds.getMinY() + this.getY() + (double)this.getYAdjustment(bounds);
        double width = bounds.getWidth();
        double height = bounds.getHeight();
        double wrappingWidth = this.getWrappingWidth();
        if (wrappingWidth != 0.0) {
            width = wrappingWidth;
        }
        return new BoundingBox(x, y, width, height);
    }

    @Override
    @Deprecated
    public final BaseBounds impl_computeGeomBounds(BaseBounds bounds, BaseTransform tx) {
        NodeOrientation orientation;
        if (this.isSpan()) {
            if (this.impl_mode != NGShape.Mode.FILL && this.getStrokeType() != StrokeType.INSIDE) {
                return super.impl_computeGeomBounds(bounds, tx);
            }
            TextLayout layout = this.getTextLayout();
            bounds = layout.getBounds(this.getTextSpan(), bounds);
            BaseBounds spanBounds = this.getSpanBounds();
            float minX = bounds.getMinX() - spanBounds.getMinX();
            float minY = bounds.getMinY() - spanBounds.getMinY();
            float maxX = minX + bounds.getWidth();
            float maxY = minY + bounds.getHeight();
            bounds = bounds.deriveWithNewBounds(minX, minY, 0.0f, maxX, maxY, 0.0f);
            return tx.transform(bounds, bounds);
        }
        if (this.getBoundsType() == TextBoundsType.VISUAL) {
            if (this.getTextInternal().length() == 0 || this.impl_mode == NGShape.Mode.EMPTY) {
                return bounds.makeEmpty();
            }
            if (this.impl_mode == NGShape.Mode.FILL || this.getStrokeType() == StrokeType.INSIDE) {
                BaseBounds visualBounds = this.getVisualBounds();
                float x = visualBounds.getMinX() + (float)this.getX();
                float yadj = this.getYAdjustment(visualBounds);
                float y = visualBounds.getMinY() + yadj + (float)this.getY();
                bounds.deriveWithNewBounds(x, y, 0.0f, x + visualBounds.getWidth(), y + visualBounds.getHeight(), 0.0f);
                return tx.transform(bounds, bounds);
            }
            return super.impl_computeGeomBounds(bounds, tx);
        }
        BaseBounds textBounds = this.getLogicalBounds();
        float x = textBounds.getMinX() + (float)this.getX();
        float yadj = this.getYAdjustment(textBounds);
        float y = textBounds.getMinY() + yadj + (float)this.getY();
        float width = textBounds.getWidth();
        float height = textBounds.getHeight();
        float wrappingWidth = (float)this.getWrappingWidth();
        if (wrappingWidth > width) {
            width = wrappingWidth;
        } else if (wrappingWidth > 0.0f && (orientation = this.getEffectiveNodeOrientation()) == NodeOrientation.RIGHT_TO_LEFT) {
            x -= width - wrappingWidth;
        }
        textBounds = new RectBounds(x, y, x + width, y + height);
        if (this.impl_mode != NGShape.Mode.FILL && this.getStrokeType() != StrokeType.INSIDE) {
            bounds = super.impl_computeGeomBounds(bounds, BaseTransform.IDENTITY_TRANSFORM);
        } else {
            TextLayout layout = this.getTextLayout();
            bounds = layout.getBounds(null, bounds);
            x = bounds.getMinX() + (float)this.getX();
            width = bounds.getWidth();
            bounds = bounds.deriveWithNewBounds(x, y, 0.0f, x + width, y + height, 0.0f);
        }
        bounds = bounds.deriveWithUnion(textBounds);
        return tx.transform(bounds, bounds);
    }

    @Override
    @Deprecated
    protected final boolean impl_computeContains(double localX, double localY) {
        double x = localX + (double)this.getSpanBounds().getMinX();
        double y = localY + (double)this.getSpanBounds().getMinY();
        GlyphList[] runs = this.getRuns();
        if (runs.length != 0) {
            for (int i = 0; i < runs.length; ++i) {
                GlyphList run = runs[i];
                com.sun.javafx.geom.Point2D location = run.getLocation();
                float width = run.getWidth();
                RectBounds lineBounds = run.getLineBounds();
                float height = lineBounds.getHeight();
                if (!((double)location.x <= x) || !(x < (double)(location.x + width)) || !((double)location.y <= y) || !(y < (double)(location.y + height))) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    @Deprecated
    public final Shape impl_configShape() {
        float y;
        float x;
        if (this.impl_mode == NGShape.Mode.EMPTY || this.getTextInternal().length() == 0) {
            return new Path2D();
        }
        Shape shape = this.getShape();
        if (this.isSpan()) {
            BaseBounds bounds = this.getSpanBounds();
            x = -bounds.getMinX();
            y = -bounds.getMinY();
        } else {
            x = (float)this.getX();
            y = this.getYAdjustment(this.getVisualBounds()) + (float)this.getY();
        }
        return TransformedShape.translatedShape(shape, x, y);
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return Text.getClassCssMetaData();
    }

    private void updatePGText() {
        NGText peer = (NGText)this.impl_getPeer();
        if (this.impl_isDirty(DirtyBits.TEXT_ATTRS)) {
            peer.setUnderline(this.isUnderline());
            peer.setStrikethrough(this.isStrikethrough());
            FontSmoothingType smoothing = this.getFontSmoothingType();
            if (smoothing == null) {
                smoothing = FontSmoothingType.GRAY;
            }
            peer.setFontSmoothingType(smoothing.ordinal());
        }
        if (this.impl_isDirty(DirtyBits.TEXT_FONT)) {
            peer.setFont(this.getFontInternal());
        }
        if (this.impl_isDirty(DirtyBits.NODE_CONTENTS)) {
            peer.setGlyphs(this.getRuns());
        }
        if (this.impl_isDirty(DirtyBits.NODE_GEOMETRY)) {
            if (this.isSpan()) {
                BaseBounds spanBounds = this.getSpanBounds();
                peer.setLayoutLocation(spanBounds.getMinX(), spanBounds.getMinY());
            } else {
                float x = (float)this.getX();
                float y = (float)this.getY();
                float yadj = this.getYRendering();
                peer.setLayoutLocation(-x, yadj - y);
            }
        }
        if (this.impl_isDirty(DirtyBits.TEXT_SELECTION)) {
            Object fillObj = null;
            int start = this.getImpl_selectionStart();
            int end = this.getImpl_selectionEnd();
            int length = this.getTextInternal().length();
            if (0 <= start && start < end && end <= length) {
                Paint fill = (Paint)this.impl_selectionFillProperty().get();
                fillObj = fill != null ? Toolkit.getPaintAccessor().getPlatformPaint(fill) : null;
            }
            peer.setSelection(start, end, fillObj);
        }
    }

    @Override
    @Deprecated
    public final void impl_updatePeer() {
        super.impl_updatePeer();
        this.updatePGText();
    }

    private TextAttribute getTextAttribute() {
        if (this.attributes == null) {
            this.attributes = new TextAttribute();
        }
        return this.attributes;
    }

    @Override
    public String toString() {
        double wrap;
        StringBuilder sb = new StringBuilder("Text[");
        String id = this.getId();
        if (id != null) {
            sb.append("id=").append(id).append(", ");
        }
        sb.append("text=\"").append(this.getText()).append("\"");
        sb.append(", x=").append(this.getX());
        sb.append(", y=").append(this.getY());
        sb.append(", alignment=").append((Object)this.getTextAlignment());
        sb.append(", origin=").append((Object)this.getTextOrigin());
        sb.append(", boundsType=").append((Object)this.getBoundsType());
        double spacing = this.getLineSpacing();
        if (spacing != 0.0) {
            sb.append(", lineSpacing=").append(spacing);
        }
        if ((wrap = this.getWrappingWidth()) != 0.0) {
            sb.append(", wrappingWidth=").append(wrap);
        }
        sb.append(", font=").append(this.getFont());
        sb.append(", fontSmoothingType=").append((Object)this.getFontSmoothingType());
        if (this.isStrikethrough()) {
            sb.append(", strikethrough");
        }
        if (this.isUnderline()) {
            sb.append(", underline");
        }
        sb.append(", fill=").append(this.getFill());
        Paint stroke = this.getStroke();
        if (stroke != null) {
            sb.append(", stroke=").append(stroke);
            sb.append(", strokeWidth=").append(this.getStrokeWidth());
        }
        return sb.append("]").toString();
    }

    @Override
    public Object queryAccessibleAttribute(AccessibleAttribute attribute, Object ... parameters) {
        switch (attribute) {
            case TEXT: {
                String accText = this.getAccessibleText();
                if (accText != null && !accText.isEmpty()) {
                    return accText;
                }
                return this.getText();
            }
            case FONT: {
                return this.getFont();
            }
            case CARET_OFFSET: {
                int sel = this.getImpl_caretPosition();
                if (sel >= 0) {
                    return sel;
                }
                return this.getText().length();
            }
            case SELECTION_START: {
                int sel = this.getImpl_selectionStart();
                if (sel >= 0) {
                    return sel;
                }
                sel = this.getImpl_caretPosition();
                if (sel >= 0) {
                    return sel;
                }
                return this.getText().length();
            }
            case SELECTION_END: {
                int sel = this.getImpl_selectionEnd();
                if (sel >= 0) {
                    return sel;
                }
                sel = this.getImpl_caretPosition();
                if (sel >= 0) {
                    return sel;
                }
                return this.getText().length();
            }
            case LINE_FOR_OFFSET: {
                TextLine line;
                int offset = (Integer)parameters[0];
                if (offset > this.getTextInternal().length()) {
                    return null;
                }
                TextLine[] lines = this.getTextLayout().getLines();
                int lineIndex = 0;
                for (int i = 1; i < lines.length && (line = lines[i]).getStart() <= offset; ++i) {
                    ++lineIndex;
                }
                return lineIndex;
            }
            case LINE_START: {
                int lineIndex = (Integer)parameters[0];
                TextLine[] lines = this.getTextLayout().getLines();
                if (0 <= lineIndex && lineIndex < lines.length) {
                    TextLine line = lines[lineIndex];
                    return line.getStart();
                }
                return null;
            }
            case LINE_END: {
                int lineIndex = (Integer)parameters[0];
                TextLine[] lines = this.getTextLayout().getLines();
                if (0 <= lineIndex && lineIndex < lines.length) {
                    TextLine line = lines[lineIndex];
                    return line.getStart() + line.getLength();
                }
                return null;
            }
            case OFFSET_AT_POINT: {
                Point2D point = (Point2D)parameters[0];
                point = this.screenToLocal(point);
                return this.impl_hitTestChar(point).getCharIndex();
            }
            case BOUNDS_FOR_RANGE: {
                int start = (Integer)parameters[0];
                int end = (Integer)parameters[1];
                PathElement[] elements = this.impl_getRangeShape(start, end + 1);
                Bounds[] bounds = new Bounds[elements.length / 5];
                int index = 0;
                for (int i = 0; i < bounds.length; ++i) {
                    MoveTo topLeft = (MoveTo)elements[index];
                    LineTo topRight = (LineTo)elements[index + 1];
                    LineTo bottomRight = (LineTo)elements[index + 2];
                    BoundingBox b = new BoundingBox(topLeft.getX(), topLeft.getY(), topRight.getX() - topLeft.getX(), bottomRight.getY() - topRight.getY());
                    bounds[i] = this.localToScreen(b);
                    index += 5;
                }
                return bounds;
            }
        }
        return super.queryAccessibleAttribute(attribute, parameters);
    }

    private /* synthetic */ void lambda$new$402(Observable observable) {
        this.checkOrientation();
    }

    private /* synthetic */ void lambda$new$401(Observable observable) {
        this.checkSpan();
    }

    static /* synthetic */ TextBoundsType access$2600() {
        return DEFAULT_BOUNDS_TYPE;
    }

    static /* synthetic */ void access$lambda$0(Text text, Observable observable) {
        text.lambda$new$401(observable);
    }

    static /* synthetic */ void access$lambda$1(Text text, Observable observable) {
        text.lambda$new$402(observable);
    }

    private final class TextAttribute {
        private ObjectProperty<VPos> textOrigin;
        private BooleanProperty underline;
        private BooleanProperty strikethrough;
        private ObjectProperty<TextAlignment> textAlignment;
        private DoubleProperty lineSpacing;
        private ReadOnlyDoubleWrapper baselineOffset;
        @Deprecated
        private ObjectProperty<PathElement[]> impl_selectionShape;
        private ObjectBinding<PathElement[]> impl_selectionBinding;
        private ObjectProperty<Paint> selectionFill;
        @Deprecated
        private IntegerProperty impl_selectionStart;
        @Deprecated
        private IntegerProperty impl_selectionEnd;
        @Deprecated
        private ObjectProperty<PathElement[]> impl_caretShape;
        private ObjectBinding<PathElement[]> impl_caretBinding;
        @Deprecated
        private IntegerProperty impl_caretPosition;
        @Deprecated
        private BooleanProperty impl_caretBias;

        private TextAttribute() {
        }

        public final VPos getTextOrigin() {
            return this.textOrigin == null ? DEFAULT_TEXT_ORIGIN : (VPos)((Object)this.textOrigin.get());
        }

        public final ObjectProperty<VPos> textOriginProperty() {
            if (this.textOrigin == null) {
                this.textOrigin = new StyleableObjectProperty<VPos>(DEFAULT_TEXT_ORIGIN){

                    @Override
                    public Object getBean() {
                        return Text.this;
                    }

                    @Override
                    public String getName() {
                        return "textOrigin";
                    }

                    @Override
                    public CssMetaData getCssMetaData() {
                        return StyleableProperties.TEXT_ORIGIN;
                    }

                    @Override
                    public void invalidated() {
                        Text.this.impl_geomChanged();
                    }
                };
            }
            return this.textOrigin;
        }

        public final boolean isUnderline() {
            return this.underline == null ? false : this.underline.get();
        }

        public final BooleanProperty underlineProperty() {
            if (this.underline == null) {
                this.underline = new StyleableBooleanProperty(){

                    @Override
                    public Object getBean() {
                        return Text.this;
                    }

                    @Override
                    public String getName() {
                        return "underline";
                    }

                    @Override
                    public CssMetaData getCssMetaData() {
                        return StyleableProperties.UNDERLINE;
                    }

                    @Override
                    public void invalidated() {
                        Text.this.impl_markDirty(DirtyBits.TEXT_ATTRS);
                        if (Text.this.getBoundsType() == TextBoundsType.VISUAL) {
                            Text.this.impl_geomChanged();
                        }
                    }
                };
            }
            return this.underline;
        }

        public final boolean isStrikethrough() {
            return this.strikethrough == null ? false : this.strikethrough.get();
        }

        public final BooleanProperty strikethroughProperty() {
            if (this.strikethrough == null) {
                this.strikethrough = new StyleableBooleanProperty(){

                    @Override
                    public Object getBean() {
                        return Text.this;
                    }

                    @Override
                    public String getName() {
                        return "strikethrough";
                    }

                    @Override
                    public CssMetaData getCssMetaData() {
                        return StyleableProperties.STRIKETHROUGH;
                    }

                    @Override
                    public void invalidated() {
                        Text.this.impl_markDirty(DirtyBits.TEXT_ATTRS);
                        if (Text.this.getBoundsType() == TextBoundsType.VISUAL) {
                            Text.this.impl_geomChanged();
                        }
                    }
                };
            }
            return this.strikethrough;
        }

        public final TextAlignment getTextAlignment() {
            return this.textAlignment == null ? DEFAULT_TEXT_ALIGNMENT : (TextAlignment)((Object)this.textAlignment.get());
        }

        public final ObjectProperty<TextAlignment> textAlignmentProperty() {
            if (this.textAlignment == null) {
                this.textAlignment = new StyleableObjectProperty<TextAlignment>(DEFAULT_TEXT_ALIGNMENT){

                    @Override
                    public Object getBean() {
                        return Text.this;
                    }

                    @Override
                    public String getName() {
                        return "textAlignment";
                    }

                    @Override
                    public CssMetaData getCssMetaData() {
                        return StyleableProperties.TEXT_ALIGNMENT;
                    }

                    @Override
                    public void invalidated() {
                        if (!Text.this.isSpan()) {
                            TextLayout layout;
                            TextAlignment alignment = (TextAlignment)((Object)this.get());
                            if (alignment == null) {
                                alignment = DEFAULT_TEXT_ALIGNMENT;
                            }
                            if ((layout = Text.this.getTextLayout()).setAlignment(alignment.ordinal())) {
                                Text.this.needsTextLayout();
                            }
                        }
                    }
                };
            }
            return this.textAlignment;
        }

        public final double getLineSpacing() {
            return this.lineSpacing == null ? 0.0 : this.lineSpacing.get();
        }

        public final DoubleProperty lineSpacingProperty() {
            if (this.lineSpacing == null) {
                this.lineSpacing = new StyleableDoubleProperty(0.0){

                    @Override
                    public Object getBean() {
                        return Text.this;
                    }

                    @Override
                    public String getName() {
                        return "lineSpacing";
                    }

                    @Override
                    public CssMetaData getCssMetaData() {
                        return StyleableProperties.LINE_SPACING;
                    }

                    @Override
                    public void invalidated() {
                        TextLayout layout;
                        if (!Text.this.isSpan() && (layout = Text.this.getTextLayout()).setLineSpacing((float)this.get())) {
                            Text.this.needsTextLayout();
                        }
                    }
                };
            }
            return this.lineSpacing;
        }

        public final ReadOnlyDoubleProperty baselineOffsetProperty() {
            if (this.baselineOffset == null) {
                this.baselineOffset = new ReadOnlyDoubleWrapper(Text.this, "baselineOffset"){
                    {
                        this.bind(new DoubleBinding(){
                            {
                                this.bind(Text.this.fontProperty());
                            }

                            @Override
                            protected double computeValue() {
                                BaseBounds bounds = Text.this.getLogicalBounds();
                                return -bounds.getMinY();
                            }
                        });
                    }
                };
            }
            return this.baselineOffset.getReadOnlyProperty();
        }

        @Deprecated
        public final ReadOnlyObjectProperty<PathElement[]> impl_selectionShapeProperty() {
            if (this.impl_selectionShape == null) {
                this.impl_selectionBinding = new ObjectBinding<PathElement[]>(){
                    {
                        this.bind(TextAttribute.this.impl_selectionStartProperty(), TextAttribute.this.impl_selectionEndProperty());
                    }

                    @Override
                    protected PathElement[] computeValue() {
                        int start = TextAttribute.this.getImpl_selectionStart();
                        int end = TextAttribute.this.getImpl_selectionEnd();
                        return Text.this.getRange(start, end, 1);
                    }
                };
                this.impl_selectionShape = new SimpleObjectProperty<PathElement[]>(Text.this, "impl_selectionShape");
                this.impl_selectionShape.bind(this.impl_selectionBinding);
            }
            return this.impl_selectionShape;
        }

        @Deprecated
        public final ObjectProperty<Paint> impl_selectionFillProperty() {
            if (this.selectionFill == null) {
                this.selectionFill = new ObjectPropertyBase<Paint>((Paint)DEFAULT_SELECTION_FILL){

                    @Override
                    public Object getBean() {
                        return Text.this;
                    }

                    @Override
                    public String getName() {
                        return "impl_selectionFill";
                    }

                    @Override
                    protected void invalidated() {
                        Text.this.impl_markDirty(DirtyBits.TEXT_SELECTION);
                    }
                };
            }
            return this.selectionFill;
        }

        @Deprecated
        public final int getImpl_selectionStart() {
            return this.impl_selectionStart == null ? -1 : this.impl_selectionStart.get();
        }

        @Deprecated
        public final IntegerProperty impl_selectionStartProperty() {
            if (this.impl_selectionStart == null) {
                this.impl_selectionStart = new IntegerPropertyBase(-1){

                    @Override
                    public Object getBean() {
                        return Text.this;
                    }

                    @Override
                    public String getName() {
                        return "impl_selectionStart";
                    }

                    @Override
                    protected void invalidated() {
                        Text.this.impl_markDirty(DirtyBits.TEXT_SELECTION);
                        Text.this.notifyAccessibleAttributeChanged(AccessibleAttribute.SELECTION_START);
                    }
                };
            }
            return this.impl_selectionStart;
        }

        @Deprecated
        public final int getImpl_selectionEnd() {
            return this.impl_selectionEnd == null ? -1 : this.impl_selectionEnd.get();
        }

        @Deprecated
        public final IntegerProperty impl_selectionEndProperty() {
            if (this.impl_selectionEnd == null) {
                this.impl_selectionEnd = new IntegerPropertyBase(-1){

                    @Override
                    public Object getBean() {
                        return Text.this;
                    }

                    @Override
                    public String getName() {
                        return "impl_selectionEnd";
                    }

                    @Override
                    protected void invalidated() {
                        Text.this.impl_markDirty(DirtyBits.TEXT_SELECTION);
                        Text.this.notifyAccessibleAttributeChanged(AccessibleAttribute.SELECTION_END);
                    }
                };
            }
            return this.impl_selectionEnd;
        }

        @Deprecated
        public final ReadOnlyObjectProperty<PathElement[]> impl_caretShapeProperty() {
            if (this.impl_caretShape == null) {
                this.impl_caretBinding = new ObjectBinding<PathElement[]>(){
                    {
                        this.bind(TextAttribute.this.impl_caretPositionProperty(), TextAttribute.this.impl_caretBiasProperty());
                    }

                    @Override
                    protected PathElement[] computeValue() {
                        int pos = TextAttribute.this.getImpl_caretPosition();
                        int length = Text.this.getTextInternal().length();
                        if (0 <= pos && pos <= length) {
                            boolean bias = TextAttribute.this.isImpl_caretBias();
                            float x = (float)Text.this.getX();
                            float y = (float)Text.this.getY() - Text.this.getYRendering();
                            TextLayout layout = Text.this.getTextLayout();
                            return layout.getCaretShape(pos, bias, x, y);
                        }
                        return EMPTY_PATH_ELEMENT_ARRAY;
                    }
                };
                this.impl_caretShape = new SimpleObjectProperty<PathElement[]>(Text.this, "impl_caretShape");
                this.impl_caretShape.bind(this.impl_caretBinding);
            }
            return this.impl_caretShape;
        }

        @Deprecated
        public final int getImpl_caretPosition() {
            return this.impl_caretPosition == null ? -1 : this.impl_caretPosition.get();
        }

        @Deprecated
        public final IntegerProperty impl_caretPositionProperty() {
            if (this.impl_caretPosition == null) {
                this.impl_caretPosition = new IntegerPropertyBase(-1){

                    @Override
                    public Object getBean() {
                        return Text.this;
                    }

                    @Override
                    public String getName() {
                        return "impl_caretPosition";
                    }

                    @Override
                    protected void invalidated() {
                        Text.this.notifyAccessibleAttributeChanged(AccessibleAttribute.SELECTION_END);
                    }
                };
            }
            return this.impl_caretPosition;
        }

        @Deprecated
        public final boolean isImpl_caretBias() {
            return this.impl_caretBias == null ? true : this.impl_caretBias.get();
        }

        @Deprecated
        public final BooleanProperty impl_caretBiasProperty() {
            if (this.impl_caretBias == null) {
                this.impl_caretBias = new SimpleBooleanProperty(Text.this, "impl_caretBias", true);
            }
            return this.impl_caretBias;
        }
    }

    private static class StyleableProperties {
        private static final CssMetaData<Text, Font> FONT = new FontCssMetaData<Text>("-fx-font", Font.getDefault()){

            @Override
            public boolean isSettable(Text node) {
                return node.font == null || !node.font.isBound();
            }

            @Override
            public StyleableProperty<Font> getStyleableProperty(Text node) {
                return (StyleableProperty)((Object)node.fontProperty());
            }
        };
        private static final CssMetaData<Text, Boolean> UNDERLINE = new CssMetaData<Text, Boolean>("-fx-underline", BooleanConverter.getInstance(), Boolean.FALSE){

            @Override
            public boolean isSettable(Text node) {
                return node.attributes == null || node.attributes.underline == null || !node.attributes.underline.isBound();
            }

            @Override
            public StyleableProperty<Boolean> getStyleableProperty(Text node) {
                return (StyleableProperty)((Object)node.underlineProperty());
            }
        };
        private static final CssMetaData<Text, Boolean> STRIKETHROUGH = new CssMetaData<Text, Boolean>("-fx-strikethrough", BooleanConverter.getInstance(), Boolean.FALSE){

            @Override
            public boolean isSettable(Text node) {
                return node.attributes == null || node.attributes.strikethrough == null || !node.attributes.strikethrough.isBound();
            }

            @Override
            public StyleableProperty<Boolean> getStyleableProperty(Text node) {
                return (StyleableProperty)((Object)node.strikethroughProperty());
            }
        };
        private static final CssMetaData<Text, TextAlignment> TEXT_ALIGNMENT = new CssMetaData<Text, TextAlignment>("-fx-text-alignment", new EnumConverter<TextAlignment>(TextAlignment.class), TextAlignment.LEFT){

            @Override
            public boolean isSettable(Text node) {
                return node.attributes == null || node.attributes.textAlignment == null || !node.attributes.textAlignment.isBound();
            }

            @Override
            public StyleableProperty<TextAlignment> getStyleableProperty(Text node) {
                return (StyleableProperty)((Object)node.textAlignmentProperty());
            }
        };
        private static final CssMetaData<Text, VPos> TEXT_ORIGIN = new CssMetaData<Text, VPos>("-fx-text-origin", new EnumConverter<VPos>(VPos.class), VPos.BASELINE){

            @Override
            public boolean isSettable(Text node) {
                return node.attributes == null || node.attributes.textOrigin == null || !node.attributes.textOrigin.isBound();
            }

            @Override
            public StyleableProperty<VPos> getStyleableProperty(Text node) {
                return (StyleableProperty)((Object)node.textOriginProperty());
            }
        };
        private static final CssMetaData<Text, FontSmoothingType> FONT_SMOOTHING_TYPE = new CssMetaData<Text, FontSmoothingType>("-fx-font-smoothing-type", new EnumConverter<FontSmoothingType>(FontSmoothingType.class), FontSmoothingType.GRAY){

            @Override
            public boolean isSettable(Text node) {
                return node.fontSmoothingType == null || !node.fontSmoothingType.isBound();
            }

            @Override
            public StyleableProperty<FontSmoothingType> getStyleableProperty(Text node) {
                return (StyleableProperty)((Object)node.fontSmoothingTypeProperty());
            }
        };
        private static final CssMetaData<Text, Number> LINE_SPACING = new CssMetaData<Text, Number>("-fx-line-spacing", SizeConverter.getInstance(), (Number)0){

            @Override
            public boolean isSettable(Text node) {
                return node.attributes == null || node.attributes.lineSpacing == null || !node.attributes.lineSpacing.isBound();
            }

            @Override
            public StyleableProperty<Number> getStyleableProperty(Text node) {
                return (StyleableProperty)((Object)node.lineSpacingProperty());
            }
        };
        private static final CssMetaData<Text, TextBoundsType> BOUNDS_TYPE = new CssMetaData<Text, TextBoundsType>("-fx-bounds-type", new EnumConverter<TextBoundsType>(TextBoundsType.class), Text.access$2600()){

            @Override
            public boolean isSettable(Text node) {
                return node.boundsType == null || !node.boundsType.isBound();
            }

            @Override
            public StyleableProperty<TextBoundsType> getStyleableProperty(Text node) {
                return (StyleableProperty)((Object)node.boundsTypeProperty());
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList styleables = new ArrayList(javafx.scene.shape.Shape.getClassCssMetaData());
            styleables.add(FONT);
            styleables.add(UNDERLINE);
            styleables.add(STRIKETHROUGH);
            styleables.add(TEXT_ALIGNMENT);
            styleables.add(TEXT_ORIGIN);
            styleables.add(FONT_SMOOTHING_TYPE);
            styleables.add(LINE_SPACING);
            styleables.add(BOUNDS_TYPE);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

