/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.web;

import com.sun.javafx.scene.web.Debugger;
import com.sun.javafx.tk.TKPulseListener;
import com.sun.javafx.tk.Toolkit;
import com.sun.javafx.webkit.Accessor;
import com.sun.javafx.webkit.prism.PrismInvoker;
import com.sun.webkit.Disposer;
import com.sun.webkit.DisposerRecord;
import com.sun.webkit.InspectorClient;
import com.sun.webkit.Invoker;
import com.sun.webkit.LoadListenerClient;
import com.sun.webkit.Timer;
import com.sun.webkit.WebPage;
import com.sun.webkit.network.URLs;
import com.sun.webkit.network.Util;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javafx.animation.AnimationTimer;
import javafx.beans.InvalidationListener;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyDoubleWrapper;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectPropertyBase;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.property.StringPropertyBase;
import javafx.concurrent.Worker;
import javafx.event.EventHandler;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.web.PopupFeatures;
import javafx.scene.web.PromptData;
import javafx.scene.web.WebEvent;
import javafx.scene.web.WebHistory;
import javafx.scene.web.WebView;
import javafx.util.Callback;
import org.w3c.dom.Document;
import sun.misc.BASE64Encoder;

public final class WebEngine {
    private static int instanceCount;
    private final ObjectProperty<WebView> view = new SimpleObjectProperty<WebView>(this, "view");
    private final LoadWorker loadWorker = new LoadWorker();
    private final WebPage page;
    private final DebuggerImpl debugger = new DebuggerImpl();
    private final DocumentProperty document = new DocumentProperty();
    private final ReadOnlyStringWrapper location = new ReadOnlyStringWrapper(this, "location");
    private final ReadOnlyStringWrapper title = new ReadOnlyStringWrapper(this, "title");
    private BooleanProperty javaScriptEnabled;
    private StringProperty userStyleSheetLocation;
    private StringProperty userAgent;
    private final ObjectProperty<EventHandler<WebEvent<String>>> onAlert = new SimpleObjectProperty<EventHandler<WebEvent<String>>>(this, "onAlert");
    private final ObjectProperty<EventHandler<WebEvent<String>>> onStatusChanged = new SimpleObjectProperty<EventHandler<WebEvent<String>>>(this, "onStatusChanged");
    private final ObjectProperty<EventHandler<WebEvent<Rectangle2D>>> onResized = new SimpleObjectProperty<EventHandler<WebEvent<Rectangle2D>>>(this, "onResized");
    private final ObjectProperty<EventHandler<WebEvent<Boolean>>> onVisibilityChanged = new SimpleObjectProperty<EventHandler<WebEvent<Boolean>>>(this, "onVisibilityChanged");
    private final ObjectProperty<Callback<PopupFeatures, WebEngine>> createPopupHandler = new SimpleObjectProperty<5>(this, "createPopupHandler", new Callback<PopupFeatures, WebEngine>(){

        @Override
        public WebEngine call(PopupFeatures p) {
            return WebEngine.this;
        }
    });
    private final ObjectProperty<Callback<String, Boolean>> confirmHandler = new SimpleObjectProperty<Callback<String, Boolean>>(this, "confirmHandler");
    private final ObjectProperty<Callback<PromptData, String>> promptHandler = new SimpleObjectProperty<Callback<PromptData, String>>(this, "promptHandler");
    private final WebHistory history;

    public final Worker<Void> getLoadWorker() {
        return this.loadWorker;
    }

    public final Document getDocument() {
        return (Document)this.document.getValue();
    }

    public final ReadOnlyObjectProperty<Document> documentProperty() {
        return this.document;
    }

    public final String getLocation() {
        return this.location.getValue();
    }

    public final ReadOnlyStringProperty locationProperty() {
        return this.location.getReadOnlyProperty();
    }

    private void updateLocation(String value) {
        this.location.set(value);
        this.document.invalidate(false);
        this.title.set(null);
    }

    public final String getTitle() {
        return this.title.getValue();
    }

    public final ReadOnlyStringProperty titleProperty() {
        return this.title.getReadOnlyProperty();
    }

    private void updateTitle() {
        this.title.set(this.page.getTitle(this.page.getMainFrame()));
    }

    public final void setJavaScriptEnabled(boolean value) {
        this.javaScriptEnabledProperty().set(value);
    }

    public final boolean isJavaScriptEnabled() {
        return this.javaScriptEnabled == null ? true : this.javaScriptEnabled.get();
    }

    public final BooleanProperty javaScriptEnabledProperty() {
        if (this.javaScriptEnabled == null) {
            this.javaScriptEnabled = new BooleanPropertyBase(true){

                @Override
                public void invalidated() {
                    WebEngine.checkThread();
                    WebEngine.this.page.setJavaScriptEnabled(this.get());
                }

                @Override
                public Object getBean() {
                    return WebEngine.this;
                }

                @Override
                public String getName() {
                    return "javaScriptEnabled";
                }
            };
        }
        return this.javaScriptEnabled;
    }

    public final void setUserStyleSheetLocation(String value) {
        this.userStyleSheetLocationProperty().set(value);
    }

    public final String getUserStyleSheetLocation() {
        return this.userStyleSheetLocation == null ? null : (String)this.userStyleSheetLocation.get();
    }

    public final StringProperty userStyleSheetLocationProperty() {
        if (this.userStyleSheetLocation == null) {
            this.userStyleSheetLocation = new StringPropertyBase(null){
                private static final String DATA_PREFIX = "data:text/css;charset=utf-8;base64,";

                @Override
                public void invalidated() {
                    String dataUrl;
                    WebEngine.checkThread();
                    String url = this.get();
                    if (url == null || url.length() <= 0) {
                        dataUrl = null;
                    } else if (url.startsWith(DATA_PREFIX)) {
                        dataUrl = url;
                    } else if (url.startsWith("file:") || url.startsWith("jar:") || url.startsWith("data:")) {
                        try {
                            URLConnection conn = URLs.newURL(url).openConnection();
                            conn.connect();
                            BufferedInputStream in = new BufferedInputStream(conn.getInputStream());
                            ByteArrayOutputStream out = new ByteArrayOutputStream();
                            new BASE64Encoder().encodeBuffer((InputStream)in, (OutputStream)out);
                            dataUrl = DATA_PREFIX + out.toString();
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    } else {
                        throw new IllegalArgumentException("Invalid stylesheet URL");
                    }
                    WebEngine.this.page.setUserStyleSheetLocation(dataUrl);
                }

                @Override
                public Object getBean() {
                    return WebEngine.this;
                }

                @Override
                public String getName() {
                    return "userStyleSheetLocation";
                }
            };
        }
        return this.userStyleSheetLocation;
    }

    public final void setUserAgent(String value) {
        this.userAgentProperty().set(value);
    }

    public final String getUserAgent() {
        return this.userAgent == null ? this.page.getUserAgent() : (String)this.userAgent.get();
    }

    public final StringProperty userAgentProperty() {
        if (this.userAgent == null) {
            this.userAgent = new StringPropertyBase(this.page.getUserAgent()){

                @Override
                public void invalidated() {
                    WebEngine.checkThread();
                    WebEngine.this.page.setUserAgent(this.get());
                }

                @Override
                public Object getBean() {
                    return WebEngine.this;
                }

                @Override
                public String getName() {
                    return "userAgent";
                }
            };
        }
        return this.userAgent;
    }

    public final EventHandler<WebEvent<String>> getOnAlert() {
        return (EventHandler)this.onAlert.get();
    }

    public final void setOnAlert(EventHandler<WebEvent<String>> handler) {
        this.onAlert.set(handler);
    }

    public final ObjectProperty<EventHandler<WebEvent<String>>> onAlertProperty() {
        return this.onAlert;
    }

    public final EventHandler<WebEvent<String>> getOnStatusChanged() {
        return (EventHandler)this.onStatusChanged.get();
    }

    public final void setOnStatusChanged(EventHandler<WebEvent<String>> handler) {
        this.onStatusChanged.set(handler);
    }

    public final ObjectProperty<EventHandler<WebEvent<String>>> onStatusChangedProperty() {
        return this.onStatusChanged;
    }

    public final EventHandler<WebEvent<Rectangle2D>> getOnResized() {
        return (EventHandler)this.onResized.get();
    }

    public final void setOnResized(EventHandler<WebEvent<Rectangle2D>> handler) {
        this.onResized.set(handler);
    }

    public final ObjectProperty<EventHandler<WebEvent<Rectangle2D>>> onResizedProperty() {
        return this.onResized;
    }

    public final EventHandler<WebEvent<Boolean>> getOnVisibilityChanged() {
        return (EventHandler)this.onVisibilityChanged.get();
    }

    public final void setOnVisibilityChanged(EventHandler<WebEvent<Boolean>> handler) {
        this.onVisibilityChanged.set(handler);
    }

    public final ObjectProperty<EventHandler<WebEvent<Boolean>>> onVisibilityChangedProperty() {
        return this.onVisibilityChanged;
    }

    public final Callback<PopupFeatures, WebEngine> getCreatePopupHandler() {
        return (Callback)this.createPopupHandler.get();
    }

    public final void setCreatePopupHandler(Callback<PopupFeatures, WebEngine> handler) {
        this.createPopupHandler.set(handler);
    }

    public final ObjectProperty<Callback<PopupFeatures, WebEngine>> createPopupHandlerProperty() {
        return this.createPopupHandler;
    }

    public final Callback<String, Boolean> getConfirmHandler() {
        return (Callback)this.confirmHandler.get();
    }

    public final void setConfirmHandler(Callback<String, Boolean> handler) {
        this.confirmHandler.set(handler);
    }

    public final ObjectProperty<Callback<String, Boolean>> confirmHandlerProperty() {
        return this.confirmHandler;
    }

    public final Callback<PromptData, String> getPromptHandler() {
        return (Callback)this.promptHandler.get();
    }

    public final void setPromptHandler(Callback<PromptData, String> handler) {
        this.promptHandler.set(handler);
    }

    public final ObjectProperty<Callback<PromptData, String>> promptHandlerProperty() {
        return this.promptHandler;
    }

    public WebEngine() {
        this(null);
    }

    public WebEngine(String url) {
        if (instanceCount == 0 && Timer.getMode() == Timer.Mode.PLATFORM_TICKS) {
            PulseTimer.start();
        }
        AccessorImpl accessor = new AccessorImpl(this);
        this.page = new WebPage(this);
        this.page.addLoadListenerClient(new PageLoadListener(this));
        this.history = new WebHistory(this.page);
        Disposer.addRecord(this, new SelfDisposer(this.page));
        this.load(url);
        ++instanceCount;
    }

    public void load(String url) {
        WebEngine.checkThread();
        this.loadWorker.cancelAndReset();
        if (url == null) {
            url = "";
        } else {
            try {
                url = Util.adjustUrlForWebKit(url);
            }
            catch (MalformedURLException e) {
                this.loadWorker.dispatchLoadEvent(this.getMainFrame(), 0, url, null, 0.0, 0);
                this.loadWorker.dispatchLoadEvent(this.getMainFrame(), 5, url, null, 0.0, 2);
            }
        }
        this.page.open(this.page.getMainFrame(), url);
    }

    public void loadContent(String content) {
        this.loadContent(content, "text/html");
    }

    public void loadContent(String content, String contentType) {
        WebEngine.checkThread();
        this.loadWorker.cancelAndReset();
        this.page.load(this.page.getMainFrame(), content, contentType);
    }

    public void reload() {
        WebEngine.checkThread();
        this.page.refresh(this.page.getMainFrame());
    }

    public WebHistory getHistory() {
        return this.history;
    }

    public Object executeScript(String script) {
        WebEngine.checkThread();
        return this.page.executeScript(this.page.getMainFrame(), script);
    }

    private long getMainFrame() {
        return this.page.getMainFrame();
    }

    WebPage getPage() {
        return this.page;
    }

    void setView(WebView view) {
        this.view.setValue(view);
    }

    public WebView getView() {
        return (WebView)this.view.getValue();
    }

    private void stop() {
        WebEngine.checkThread();
        this.page.stop(this.page.getMainFrame());
    }

    static void checkThread() {
        Toolkit.getToolkit().checkFxUserThread();
    }

    @Deprecated
    public Debugger impl_getDebugger() {
        return this.debugger;
    }

    static {
        Accessor.setPageAccessor(new Accessor.PageAccessor(){

            @Override
            public WebPage getPage(WebEngine w) {
                return w == null ? null : w.getPage();
            }
        });
        Invoker.setInvoker(new PrismInvoker());
        instanceCount = 0;
    }

    private static final class InspectorClientImpl
    implements InspectorClient {
        private final WeakReference<WebEngine> engine;

        private InspectorClientImpl(WebEngine engine) {
            this.engine = new WeakReference<WebEngine>(engine);
        }

        @Override
        public boolean sendMessageToFrontend(final String message) {
            Callback messageCallback;
            boolean result = false;
            WebEngine webEngine = (WebEngine)this.engine.get();
            if (webEngine != null && (messageCallback = webEngine.debugger.messageCallback) != null) {
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        messageCallback.call(message);
                        return null;
                    }
                }, webEngine.page.getAccessControlContext());
                result = true;
            }
            return result;
        }
    }

    private final class DebuggerImpl
    implements Debugger {
        private boolean enabled;
        private Callback<String, Void> messageCallback;

        private DebuggerImpl() {
        }

        @Override
        public boolean isEnabled() {
            WebEngine.checkThread();
            return this.enabled;
        }

        @Override
        public void setEnabled(boolean enabled) {
            WebEngine.checkThread();
            if (enabled != this.enabled) {
                if (enabled) {
                    WebEngine.this.page.setDeveloperExtrasEnabled(true);
                    WebEngine.this.page.connectInspectorFrontend();
                } else {
                    WebEngine.this.page.disconnectInspectorFrontend();
                    WebEngine.this.page.setDeveloperExtrasEnabled(false);
                }
                this.enabled = enabled;
            }
        }

        @Override
        public void sendMessage(String message) {
            WebEngine.checkThread();
            if (!this.enabled) {
                throw new IllegalStateException("Debugger is not enabled");
            }
            if (message == null) {
                throw new NullPointerException("message is null");
            }
            WebEngine.this.page.dispatchInspectorMessageFromFrontend(message);
        }

        @Override
        public Callback<String, Void> getMessageCallback() {
            WebEngine.checkThread();
            return this.messageCallback;
        }

        @Override
        public void setMessageCallback(Callback<String, Void> callback) {
            WebEngine.checkThread();
            this.messageCallback = callback;
        }
    }

    private final class DocumentProperty
    extends ReadOnlyObjectPropertyBase<Document> {
        private boolean available;
        private Document document;

        private DocumentProperty() {
        }

        private void invalidate(boolean available) {
            if (this.available || available) {
                this.available = available;
                this.document = null;
                this.fireValueChangedEvent();
            }
        }

        @Override
        public Document get() {
            if (!this.available) {
                return null;
            }
            if (this.document == null) {
                this.document = WebEngine.this.page.getDocument(WebEngine.this.page.getMainFrame());
                if (this.document == null) {
                    this.available = false;
                }
            }
            return this.document;
        }

        @Override
        public Object getBean() {
            return WebEngine.this;
        }

        @Override
        public String getName() {
            return "document";
        }
    }

    private final class LoadWorker
    implements Worker<Void> {
        private final ReadOnlyObjectWrapper<Worker.State> state = new ReadOnlyObjectWrapper<Worker.State>(this, "state", Worker.State.READY);
        private final ReadOnlyObjectWrapper<Void> value = new ReadOnlyObjectWrapper<Object>(this, "value", null);
        private final ReadOnlyObjectWrapper<Throwable> exception = new ReadOnlyObjectWrapper(this, "exception");
        private final ReadOnlyDoubleWrapper workDone = new ReadOnlyDoubleWrapper(this, "workDone", -1.0);
        private final ReadOnlyDoubleWrapper totalWorkToBeDone = new ReadOnlyDoubleWrapper(this, "totalWork", -1.0);
        private final ReadOnlyDoubleWrapper progress = new ReadOnlyDoubleWrapper(this, "progress", -1.0);
        private final ReadOnlyBooleanWrapper running = new ReadOnlyBooleanWrapper(this, "running", false);
        private final ReadOnlyStringWrapper message = new ReadOnlyStringWrapper(this, "message", "");
        private final ReadOnlyStringWrapper title = new ReadOnlyStringWrapper(this, "title", "WebEngine Loader");

        private LoadWorker() {
        }

        @Override
        public final Worker.State getState() {
            WebEngine.checkThread();
            return (Worker.State)((Object)this.state.get());
        }

        @Override
        public final ReadOnlyObjectProperty<Worker.State> stateProperty() {
            WebEngine.checkThread();
            return this.state.getReadOnlyProperty();
        }

        private void updateState(Worker.State value) {
            WebEngine.checkThread();
            this.state.set(value);
            this.running.set(value == Worker.State.SCHEDULED || value == Worker.State.RUNNING);
        }

        @Override
        public final Void getValue() {
            WebEngine.checkThread();
            return (Void)this.value.get();
        }

        @Override
        public final ReadOnlyObjectProperty<Void> valueProperty() {
            WebEngine.checkThread();
            return this.value.getReadOnlyProperty();
        }

        @Override
        public final Throwable getException() {
            WebEngine.checkThread();
            return (Throwable)this.exception.get();
        }

        @Override
        public final ReadOnlyObjectProperty<Throwable> exceptionProperty() {
            WebEngine.checkThread();
            return this.exception.getReadOnlyProperty();
        }

        @Override
        public final double getWorkDone() {
            WebEngine.checkThread();
            return this.workDone.get();
        }

        @Override
        public final ReadOnlyDoubleProperty workDoneProperty() {
            WebEngine.checkThread();
            return this.workDone.getReadOnlyProperty();
        }

        @Override
        public final double getTotalWork() {
            WebEngine.checkThread();
            return this.totalWorkToBeDone.get();
        }

        @Override
        public final ReadOnlyDoubleProperty totalWorkProperty() {
            WebEngine.checkThread();
            return this.totalWorkToBeDone.getReadOnlyProperty();
        }

        @Override
        public final double getProgress() {
            WebEngine.checkThread();
            return this.progress.get();
        }

        @Override
        public final ReadOnlyDoubleProperty progressProperty() {
            WebEngine.checkThread();
            return this.progress.getReadOnlyProperty();
        }

        private void updateProgress(double p) {
            this.totalWorkToBeDone.set(100.0);
            this.workDone.set(p * 100.0);
            this.progress.set(p);
        }

        @Override
        public final boolean isRunning() {
            WebEngine.checkThread();
            return this.running.get();
        }

        @Override
        public final ReadOnlyBooleanProperty runningProperty() {
            WebEngine.checkThread();
            return this.running.getReadOnlyProperty();
        }

        @Override
        public final String getMessage() {
            return this.message.get();
        }

        @Override
        public final ReadOnlyStringProperty messageProperty() {
            return this.message.getReadOnlyProperty();
        }

        @Override
        public final String getTitle() {
            return this.title.get();
        }

        @Override
        public final ReadOnlyStringProperty titleProperty() {
            return this.title.getReadOnlyProperty();
        }

        @Override
        public boolean cancel() {
            if (this.isRunning()) {
                WebEngine.this.stop();
                return true;
            }
            return false;
        }

        private void cancelAndReset() {
            this.cancel();
            this.exception.set(null);
            this.message.set("");
            this.totalWorkToBeDone.set(-1.0);
            this.workDone.set(-1.0);
            this.progress.set(-1.0);
            this.updateState(Worker.State.READY);
            this.running.set(false);
        }

        private void dispatchLoadEvent(long frame, int state, String url, String contentType, double workDone, int errorCode) {
            if (frame != WebEngine.this.getMainFrame()) {
                return;
            }
            switch (state) {
                case 0: {
                    this.message.set("Loading " + url);
                    WebEngine.this.updateLocation(url);
                    this.updateProgress(0.0);
                    this.updateState(Worker.State.SCHEDULED);
                    this.updateState(Worker.State.RUNNING);
                    break;
                }
                case 2: {
                    this.message.set("Loading " + url);
                    WebEngine.this.updateLocation(url);
                    break;
                }
                case 1: {
                    this.message.set("Loading complete");
                    this.updateProgress(1.0);
                    this.updateState(Worker.State.SUCCEEDED);
                    break;
                }
                case 5: {
                    this.message.set("Loading failed");
                    this.exception.set(this.describeError(errorCode));
                    this.updateState(Worker.State.FAILED);
                    break;
                }
                case 6: {
                    this.message.set("Loading stopped");
                    this.updateState(Worker.State.CANCELLED);
                    break;
                }
                case 30: {
                    this.updateProgress(workDone);
                    break;
                }
                case 11: {
                    WebEngine.this.updateTitle();
                    break;
                }
                case 14: {
                    WebEngine.this.document.invalidate(true);
                }
            }
        }

        private Throwable describeError(int errorCode) {
            String reason = "Unknown error";
            switch (errorCode) {
                case 1: {
                    reason = "Unknown host";
                    break;
                }
                case 2: {
                    reason = "Malformed URL";
                    break;
                }
                case 3: {
                    reason = "SSL handshake failed";
                    break;
                }
                case 4: {
                    reason = "Connection refused by server";
                    break;
                }
                case 5: {
                    reason = "Connection reset by server";
                    break;
                }
                case 6: {
                    reason = "No route to host";
                    break;
                }
                case 7: {
                    reason = "Connection timed out";
                    break;
                }
                case 8: {
                    reason = "Permission denied";
                    break;
                }
                case 9: {
                    reason = "Invalid response from server";
                    break;
                }
                case 10: {
                    reason = "Too many redirects";
                    break;
                }
                case 11: {
                    reason = "File not found";
                }
            }
            return new Throwable(reason);
        }
    }

    private static final class PageLoadListener
    implements LoadListenerClient {
        private final WeakReference<WebEngine> engine;

        private PageLoadListener(WebEngine engine) {
            this.engine = new WeakReference<WebEngine>(engine);
        }

        @Override
        public void dispatchLoadEvent(long frame, int state, String url, String contentType, double progress, int errorCode) {
            WebEngine w = (WebEngine)this.engine.get();
            if (w != null) {
                w.loadWorker.dispatchLoadEvent(frame, state, url, contentType, progress, errorCode);
            }
        }

        @Override
        public void dispatchResourceLoadEvent(long frame, int state, String url, String contentType, double progress, int errorCode) {
        }
    }

    private static final class PulseTimer {
        private static final AnimationTimer animation = new AnimationTimer(){

            @Override
            public void handle(long l) {
            }
        };
        private static final TKPulseListener listener = new TKPulseListener(){

            @Override
            public void pulse() {
            }
        };

        private PulseTimer() {
        }

        private static void start() {
            Toolkit.getToolkit().addSceneTkPulseListener(listener);
        }

        private static void stop() {
            Toolkit.getToolkit().removeSceneTkPulseListener(listener);
        }
    }

    private static final class AccessorImpl
    extends Accessor {
        private final WeakReference<WebEngine> engine;

        private AccessorImpl(WebEngine w) {
            this.engine = new WeakReference<WebEngine>(w);
        }

        @Override
        public WebEngine getEngine() {
            return (WebEngine)this.engine.get();
        }

        @Override
        public WebPage getPage() {
            WebEngine w = this.getEngine();
            return w == null ? null : w.page;
        }

        @Override
        public WebView getView() {
            WebEngine w = this.getEngine();
            return w == null ? null : (WebView)w.view.get();
        }

        @Override
        public void addChild(Node child) {
            WebView view = this.getView();
            if (view != null) {
                view.getChildren().add(child);
            }
        }

        @Override
        public void removeChild(Node child) {
            WebView view = this.getView();
            if (view != null) {
                view.getChildren().remove(child);
            }
        }

        @Override
        public void addViewListener(InvalidationListener l) {
            WebEngine w = this.getEngine();
            if (w != null) {
                w.view.addListener(l);
            }
        }
    }

    private static final class SelfDisposer
    implements DisposerRecord {
        private final WebPage page;

        private SelfDisposer(WebPage page) {
            this.page = page;
        }

        @Override
        public void dispose() {
            this.page.dispose();
            instanceCount--;
            if (instanceCount == 0 && Timer.getMode() == Timer.Mode.PLATFORM_TICKS) {
                PulseTimer.stop();
            }
        }
    }
}

