/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.util;

import java.util.Hashtable;
import java.util.Vector;
import org.apache.xerces.xni.parser.XMLComponentManager;
import org.apache.xerces.xni.parser.XMLConfigurationException;

public class ParserConfigurationSettings
implements XMLComponentManager {
    protected Vector fRecognizedProperties;
    protected Hashtable fProperties;
    protected Vector fRecognizedFeatures = new Vector();
    protected Hashtable fFeatures;
    protected XMLComponentManager fParentSettings;
    static int counter = 1;

    public ParserConfigurationSettings() {
        this(null);
    }

    public ParserConfigurationSettings(XMLComponentManager parent) {
        this.fRecognizedProperties = new Vector();
        this.fFeatures = new Hashtable();
        this.fProperties = new Hashtable();
        this.fParentSettings = parent;
    }

    public void addRecognizedFeatures(String[] featureIds) {
        int featureIdsCount = featureIds != null ? featureIds.length : 0;
        for (int i = 0; i < featureIdsCount; ++i) {
            String featureId = featureIds[i];
            if (this.fRecognizedFeatures.contains(featureId)) continue;
            this.fRecognizedFeatures.addElement(featureId);
        }
    }

    public void setFeature(String featureId, boolean state) throws XMLConfigurationException {
        this.checkFeature(featureId);
        this.fFeatures.put(featureId, state ? Boolean.TRUE : Boolean.FALSE);
    }

    public void addRecognizedProperties(String[] propertyIds) {
        int propertyIdsCount = propertyIds != null ? propertyIds.length : 0;
        for (int i = 0; i < propertyIdsCount; ++i) {
            String propertyId = propertyIds[i];
            if (this.fRecognizedProperties.contains(propertyId)) continue;
            this.fRecognizedProperties.addElement(propertyId);
        }
    }

    public void setProperty(String propertyId, Object value) throws XMLConfigurationException {
        this.checkProperty(propertyId);
        this.fProperties.put(propertyId, value);
    }

    @Override
    public boolean getFeature(String featureId) throws XMLConfigurationException {
        Boolean state = (Boolean)this.fFeatures.get(featureId);
        if (state == null) {
            this.checkFeature(featureId);
            return false;
        }
        return state;
    }

    @Override
    public Object getProperty(String propertyId) throws XMLConfigurationException {
        Object propertyValue = this.fProperties.get(propertyId);
        if (propertyValue == null) {
            this.checkProperty(propertyId);
        }
        return propertyValue;
    }

    protected void checkFeature(String featureId) throws XMLConfigurationException {
        if (!this.fRecognizedFeatures.contains(featureId)) {
            if (this.fParentSettings != null) {
                this.fParentSettings.getFeature(featureId);
            } else {
                short type = 0;
                throw new XMLConfigurationException(type, featureId);
            }
        }
    }

    protected void checkProperty(String propertyId) throws XMLConfigurationException {
        if (!this.fRecognizedProperties.contains(propertyId)) {
            if (this.fParentSettings != null) {
                this.fParentSettings.getProperty(propertyId);
            } else {
                short type = 0;
                throw new XMLConfigurationException(type, propertyId);
            }
        }
    }
}

