/*
 * Decompiled with CFR 0.152.
 */
package sun.util.logging;

import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Date;
import java.util.List;
import sun.util.logging.LoggingProxy;

public class LoggingSupport {
    private static final LoggingProxy proxy = AccessController.doPrivileged(new PrivilegedAction<LoggingProxy>(){

        @Override
        public LoggingProxy run() {
            try {
                Class<?> c = Class.forName("java.util.logging.LoggingProxyImpl", true, LoggingSupport.class.getClassLoader());
                Field f = c.getDeclaredField("INSTANCE");
                f.setAccessible(true);
                return (LoggingProxy)f.get(null);
            }
            catch (ClassNotFoundException cnf) {
                return null;
            }
            catch (NoSuchFieldException e) {
                throw new AssertionError((Object)e);
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
        }
    });
    private static final String DEFAULT_FORMAT = "%1$tb %1$td, %1$tY %1$tl:%1$tM:%1$tS %1$Tp %2$s%n%4$s: %5$s%6$s%n";
    private static final String FORMAT_PROP_KEY = "java.util.logging.SimpleFormatter.format";

    private LoggingSupport() {
    }

    public static boolean isAvailable() {
        return proxy != null;
    }

    private static void ensureAvailable() {
        if (proxy == null) {
            throw new AssertionError((Object)"Should not here");
        }
    }

    public static List<String> getLoggerNames() {
        LoggingSupport.ensureAvailable();
        return proxy.getLoggerNames();
    }

    public static String getLoggerLevel(String loggerName) {
        LoggingSupport.ensureAvailable();
        return proxy.getLoggerLevel(loggerName);
    }

    public static void setLoggerLevel(String loggerName, String levelName) {
        LoggingSupport.ensureAvailable();
        proxy.setLoggerLevel(loggerName, levelName);
    }

    public static String getParentLoggerName(String loggerName) {
        LoggingSupport.ensureAvailable();
        return proxy.getParentLoggerName(loggerName);
    }

    public static Object getLogger(String name) {
        LoggingSupport.ensureAvailable();
        return proxy.getLogger(name);
    }

    public static Object getLevel(Object logger) {
        LoggingSupport.ensureAvailable();
        return proxy.getLevel(logger);
    }

    public static void setLevel(Object logger, Object newLevel) {
        LoggingSupport.ensureAvailable();
        proxy.setLevel(logger, newLevel);
    }

    public static boolean isLoggable(Object logger, Object level) {
        LoggingSupport.ensureAvailable();
        return proxy.isLoggable(logger, level);
    }

    public static void log(Object logger, Object level, String msg) {
        LoggingSupport.ensureAvailable();
        proxy.log(logger, level, msg);
    }

    public static void log(Object logger, Object level, String msg, Throwable t) {
        LoggingSupport.ensureAvailable();
        proxy.log(logger, level, msg, t);
    }

    public static void log(Object logger, Object level, String msg, Object ... params) {
        LoggingSupport.ensureAvailable();
        proxy.log(logger, level, msg, params);
    }

    public static Object parseLevel(String levelName) {
        LoggingSupport.ensureAvailable();
        return proxy.parseLevel(levelName);
    }

    public static String getLevelName(Object level) {
        LoggingSupport.ensureAvailable();
        return proxy.getLevelName(level);
    }

    public static int getLevelValue(Object level) {
        LoggingSupport.ensureAvailable();
        return proxy.getLevelValue(level);
    }

    public static String getSimpleFormat() {
        return LoggingSupport.getSimpleFormat(true);
    }

    static String getSimpleFormat(boolean useProxy) {
        String format = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(LoggingSupport.FORMAT_PROP_KEY);
            }
        });
        if (useProxy && proxy != null && format == null) {
            format = proxy.getProperty(FORMAT_PROP_KEY);
        }
        if (format != null) {
            try {
                String.format(format, new Date(), "", "", "", "", "");
            }
            catch (IllegalArgumentException e) {
                format = DEFAULT_FORMAT;
            }
        } else {
            format = DEFAULT_FORMAT;
        }
        return format;
    }
}

