/*
 * Decompiled with CFR 0.152.
 */
package java.time.chrono;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.Clock;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.chrono.AbstractChronoLocalDate;
import java.time.chrono.ChronoLocalDateTime;
import java.time.chrono.ChronoLocalDateTimeImpl;
import java.time.chrono.ChronoPeriod;
import java.time.chrono.ChronoPeriodImpl;
import java.time.chrono.ChronoZonedDateTime;
import java.time.chrono.ChronoZonedDateTimeImpl;
import java.time.chrono.Chronology;
import java.time.chrono.Era;
import java.time.chrono.HijrahChronology;
import java.time.chrono.IsoChronology;
import java.time.chrono.JapaneseChronology;
import java.time.chrono.MinguoChronology;
import java.time.chrono.Ser;
import java.time.chrono.ThaiBuddhistChronology;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.ResolverStyle;
import java.time.format.TextStyle;
import java.time.jdk8.DefaultInterfaceTemporalAccessor;
import java.time.jdk8.Jdk8Methods;
import java.time.temporal.ChronoField;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalQueries;
import java.time.temporal.TemporalQuery;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.time.temporal.ValueRange;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public abstract class AbstractChronology
implements Chronology,
Comparable<Chronology> {
    public static final TemporalQuery<AbstractChronology> FROM = new TemporalQuery<AbstractChronology>(){

        @Override
        public AbstractChronology queryFrom(TemporalAccessor temporal) {
            return AbstractChronology.from(temporal);
        }
    };
    private static final ConcurrentHashMap<String, AbstractChronology> CHRONOS_BY_ID = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, AbstractChronology> CHRONOS_BY_TYPE = new ConcurrentHashMap();
    private static final Method LOCALE_METHOD;

    public static AbstractChronology from(TemporalAccessor temporal) {
        Jdk8Methods.requireNonNull(temporal, "temporal");
        AbstractChronology obj = temporal.query(TemporalQueries.chronology());
        return obj != null ? obj : IsoChronology.INSTANCE;
    }

    public static AbstractChronology ofLocale_static(Locale locale) {
        AbstractChronology.init();
        Jdk8Methods.requireNonNull(locale, "locale");
        String type = "iso";
        if (LOCALE_METHOD != null) {
            try {
                type = (String)LOCALE_METHOD.invoke((Object)locale, "ca");
            }
            catch (IllegalArgumentException ex) {
            }
            catch (IllegalAccessException ex) {
            }
            catch (InvocationTargetException ex) {}
        } else if (locale.equals(JapaneseChronology.LOCALE)) {
            type = "japanese";
        }
        if (type == null || "iso".equals(type) || "iso8601".equals(type)) {
            return IsoChronology.INSTANCE;
        }
        AbstractChronology chrono = CHRONOS_BY_TYPE.get(type);
        if (chrono == null) {
            throw new DateTimeException("Unknown calendar system: " + type);
        }
        return chrono;
    }

    @Override
    public Chronology ofLocale(Locale l) {
        return AbstractChronology.ofLocale_static(l);
    }

    public static AbstractChronology of(String id) {
        AbstractChronology.init();
        AbstractChronology chrono = CHRONOS_BY_ID.get(id);
        if (chrono != null) {
            return chrono;
        }
        chrono = CHRONOS_BY_TYPE.get(id);
        if (chrono != null) {
            return chrono;
        }
        throw new DateTimeException("Unknown chronology: " + id);
    }

    public static Set<AbstractChronology> getAvailableChronologies() {
        AbstractChronology.init();
        return new HashSet<AbstractChronology>(CHRONOS_BY_ID.values());
    }

    private static void init() {
        if (CHRONOS_BY_ID.isEmpty()) {
            AbstractChronology.register(IsoChronology.INSTANCE);
            AbstractChronology.register(ThaiBuddhistChronology.INSTANCE);
            AbstractChronology.register(MinguoChronology.INSTANCE);
            AbstractChronology.register(JapaneseChronology.INSTANCE);
            AbstractChronology.register(HijrahChronology.INSTANCE);
            CHRONOS_BY_ID.putIfAbsent("Hijrah", HijrahChronology.INSTANCE);
            CHRONOS_BY_TYPE.putIfAbsent("islamic", HijrahChronology.INSTANCE);
            ServiceLoader<AbstractChronology> loader = ServiceLoader.load(AbstractChronology.class, AbstractChronology.class.getClassLoader());
            for (AbstractChronology chrono : loader) {
                CHRONOS_BY_ID.putIfAbsent(chrono.getId(), chrono);
                String type = chrono.getCalendarType();
                if (type == null) continue;
                CHRONOS_BY_TYPE.putIfAbsent(type, chrono);
            }
        }
    }

    private static void register(AbstractChronology chrono) {
        CHRONOS_BY_ID.putIfAbsent(chrono.getId(), chrono);
        String type = chrono.getCalendarType();
        if (type != null) {
            CHRONOS_BY_TYPE.putIfAbsent(type, chrono);
        }
    }

    protected AbstractChronology() {
    }

    public <D extends AbstractChronoLocalDate> D ensureChronoLocalDate(Temporal temporal) {
        AbstractChronoLocalDate other = (AbstractChronoLocalDate)temporal;
        if (!this.equals(other.getChronology())) {
            throw new ClassCastException("Chrono mismatch, expected: " + this.getId() + ", actual: " + other.getChronology().getId());
        }
        return (D)other;
    }

    public <D extends AbstractChronoLocalDate> ChronoLocalDateTimeImpl<D> ensureChronoLocalDateTime(Temporal temporal) {
        ChronoLocalDateTimeImpl other = (ChronoLocalDateTimeImpl)temporal;
        if (!this.equals(((AbstractChronoLocalDate)other.toLocalDate()).getChronology())) {
            throw new ClassCastException("Chrono mismatch, required: " + this.getId() + ", supplied: " + ((AbstractChronoLocalDate)other.toLocalDate()).getChronology().getId());
        }
        return other;
    }

    public <D extends AbstractChronoLocalDate> ChronoZonedDateTimeImpl<D> ensureChronoZonedDateTime(Temporal temporal) {
        ChronoZonedDateTimeImpl other = (ChronoZonedDateTimeImpl)temporal;
        if (!this.equals(((AbstractChronoLocalDate)other.toLocalDate()).getChronology())) {
            throw new ClassCastException("Chrono mismatch, required: " + this.getId() + ", supplied: " + ((AbstractChronoLocalDate)other.toLocalDate()).getChronology().getId());
        }
        return other;
    }

    @Override
    public abstract String getId();

    public abstract String getCalendarType();

    public AbstractChronoLocalDate date(Era era, int yearOfEra, int month, int dayOfMonth) {
        return this.date(this.prolepticYear(era, yearOfEra), month, dayOfMonth);
    }

    public abstract AbstractChronoLocalDate date(int var1, int var2, int var3);

    public AbstractChronoLocalDate dateYearDay(Era era, int yearOfEra, int dayOfYear) {
        return this.dateYearDay(this.prolepticYear(era, yearOfEra), dayOfYear);
    }

    public abstract AbstractChronoLocalDate dateYearDay(int var1, int var2);

    public abstract AbstractChronoLocalDate dateEpochDay(long var1);

    @Override
    public abstract AbstractChronoLocalDate date(TemporalAccessor var1);

    public AbstractChronoLocalDate dateNow() {
        return this.dateNow(Clock.systemDefaultZone());
    }

    public AbstractChronoLocalDate dateNow(ZoneId zone) {
        return this.dateNow(Clock.system(zone));
    }

    public AbstractChronoLocalDate dateNow(Clock clock) {
        Jdk8Methods.requireNonNull(clock, "clock");
        return this.date(LocalDate.now(clock));
    }

    public ChronoLocalDateTime<?> localDateTime(TemporalAccessor temporal) {
        try {
            AbstractChronoLocalDate date = this.date(temporal);
            return date.atTime(LocalTime.from(temporal));
        }
        catch (DateTimeException ex) {
            throw new DateTimeException("Unable to obtain ChronoLocalDateTime from TemporalAccessor: " + temporal.getClass(), ex);
        }
    }

    public ChronoZonedDateTime<?> zonedDateTime(TemporalAccessor temporal) {
        try {
            ZoneId zone = ZoneId.from(temporal);
            try {
                Instant instant = Instant.from(temporal);
                return this.zonedDateTime(instant, zone);
            }
            catch (DateTimeException ex1) {
                ChronoLocalDateTime<?> cldt = this.localDateTime(temporal);
                ChronoLocalDateTimeImpl cldtImpl = this.ensureChronoLocalDateTime(cldt);
                return ChronoZonedDateTimeImpl.ofBest(cldtImpl, zone, null);
            }
        }
        catch (DateTimeException ex) {
            throw new DateTimeException("Unable to obtain ChronoZonedDateTime from TemporalAccessor: " + temporal.getClass(), ex);
        }
    }

    public ChronoZonedDateTime<?> zonedDateTime(Instant instant, ZoneId zone) {
        ChronoZonedDateTimeImpl result = ChronoZonedDateTimeImpl.ofInstant(this, instant, zone);
        return result;
    }

    public ChronoPeriod period(int years, int months, int days) {
        return new ChronoPeriodImpl(this, years, months, days);
    }

    @Override
    public abstract boolean isLeapYear(long var1);

    public abstract int prolepticYear(Era var1, int var2);

    @Override
    public abstract Era eraOf(int var1);

    @Override
    public abstract List<Era> eras();

    @Override
    public abstract ValueRange range(ChronoField var1);

    public String getDisplayName(TextStyle style, Locale locale) {
        return new DateTimeFormatterBuilder().appendChronologyText(style).toFormatter(locale).format(new DefaultInterfaceTemporalAccessor(){

            @Override
            public boolean isSupported(TemporalField field) {
                return false;
            }

            @Override
            public long getLong(TemporalField field) {
                throw new UnsupportedTemporalTypeException("Unsupported field: " + field);
            }

            @Override
            public <R> R query(TemporalQuery<R> query) {
                if (query == TemporalQueries.chronology()) {
                    return (R)AbstractChronology.this;
                }
                return super.query(query);
            }
        });
    }

    public AbstractChronoLocalDate resolveDate(Map<TemporalField, Long> fieldValues, ResolverStyle resolverStyle) {
        throw new UnsupportedOperationException("ThreeTen Backport does not support resolveDate");
    }

    void updateResolveMap(Map<TemporalField, Long> fieldValues, ChronoField field, long value) {
        Long current = fieldValues.get(field);
        if (current != null && current != value) {
            throw new DateTimeException("Invalid state, field: " + field + " " + current + " conflicts with " + field + " " + value);
        }
        fieldValues.put(field, value);
    }

    @Override
    public int compareTo(Chronology other) {
        return this.getId().compareTo(other.getId());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof AbstractChronology) {
            return this.compareTo((AbstractChronology)obj) == 0;
        }
        return false;
    }

    public int hashCode() {
        return this.getClass().hashCode() ^ this.getId().hashCode();
    }

    public String toString() {
        return this.getId();
    }

    private Object writeReplace() {
        return new Ser(11, this);
    }

    private Object readResolve() throws ObjectStreamException {
        throw new InvalidObjectException("Deserialization via serialization delegate");
    }

    void writeExternal(DataOutput out) throws IOException {
        out.writeUTF(this.getId());
    }

    static AbstractChronology readExternal(DataInput in) throws IOException {
        String id = in.readUTF();
        return AbstractChronology.of(id);
    }

    static {
        Method method = null;
        try {
            method = Locale.class.getMethod("getUnicodeLocaleType", String.class);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        LOCALE_METHOD = method;
    }
}

