/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui;

import com.sun.glass.ui.Application;
import com.sun.glass.ui.EventLoop$$Lambda$1;
import com.sun.glass.ui.EventLoop$$Lambda$2;
import java.util.ArrayDeque;
import java.util.Deque;

public final class EventLoop {
    private static final Deque<EventLoop> stack = new ArrayDeque<EventLoop>();
    private State state = State.IDLE;
    private Object returnValue;

    EventLoop() {
        Application.checkEventThread();
    }

    public State getState() {
        Application.checkEventThread();
        return this.state;
    }

    public Object enter() {
        Object object;
        Application.checkEventThread();
        if (!this.state.equals((Object)State.IDLE)) {
            throw new IllegalStateException("The event loop object isn't idle");
        }
        this.state = State.ACTIVE;
        stack.push(this);
        try {
            Object ret = Application.enterNestedEventLoop();
            assert (ret == this) : "Internal inconsistency - wrong EventLoop";
            assert (stack.peek() == this) : "Internal inconsistency - corrupted event loops stack";
            assert (this.state.equals((Object)State.LEAVING)) : "The event loop isn't leaving";
            object = this.returnValue;
            this.returnValue = null;
            this.state = State.IDLE;
            stack.pop();
        }
        catch (Throwable throwable) {
            this.returnValue = null;
            this.state = State.IDLE;
            stack.pop();
            if (!stack.isEmpty() && EventLoop.stack.peek().state.equals((Object)State.LEAVING)) {
                Application.invokeLater(EventLoop$$Lambda$2.lambdaFactory$());
            }
            throw throwable;
        }
        if (!stack.isEmpty() && EventLoop.stack.peek().state.equals((Object)State.LEAVING)) {
            Application.invokeLater(EventLoop$$Lambda$1.lambdaFactory$());
        }
        return object;
    }

    public void leave(Object ret) {
        Application.checkEventThread();
        if (!this.state.equals((Object)State.ACTIVE)) {
            throw new IllegalStateException("The event loop object isn't active");
        }
        this.state = State.LEAVING;
        this.returnValue = ret;
        if (stack.peek() == this) {
            Application.leaveNestedEventLoop(this);
        }
    }

    static /* synthetic */ void lambda$enter$40() {
        EventLoop loop = stack.peek();
        if (loop != null && loop.state.equals((Object)State.LEAVING)) {
            Application.leaveNestedEventLoop(loop);
        }
    }

    public static enum State {
        IDLE,
        ACTIVE,
        LEAVING;

    }
}

