/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui;

import com.sun.glass.ui.Application;
import com.sun.glass.ui.Screen$$Lambda$1;
import com.sun.glass.ui.Window;
import java.security.AccessController;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class Screen {
    private static volatile List<Screen> screens = null;
    private static final int dpiOverride = (Integer)AccessController.doPrivileged(Screen$$Lambda$1.lambdaFactory$());
    private static EventHandler eventHandler;
    private volatile long ptr;
    private volatile int adapter;
    private final int depth;
    private final int x;
    private final int y;
    private final int width;
    private final int height;
    private final int visibleX;
    private final int visibleY;
    private final int visibleWidth;
    private final int visibleHeight;
    private final int resolutionX;
    private final int resolutionY;
    private final float scale;

    public static double getVideoRefreshPeriod() {
        Application.checkEventThread();
        return Application.GetApplication().staticScreen_getVideoRefreshPeriod();
    }

    public static Screen getMainScreen() {
        return Screen.getScreens().get(0);
    }

    public static List<Screen> getScreens() {
        if (screens == null) {
            throw new RuntimeException("Internal graphics not initialized yet");
        }
        return screens;
    }

    protected Screen(long nativePtr, int depth, int x, int y, int width, int height, int visibleX, int visibleY, int visibleWidth, int visibleHeight, int resolutionX, int resolutionY, float scale) {
        this.ptr = nativePtr;
        this.depth = depth;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.visibleX = visibleX;
        this.visibleY = visibleY;
        this.visibleWidth = visibleWidth;
        this.visibleHeight = visibleHeight;
        if (dpiOverride > 0) {
            this.resolutionX = this.resolutionY = dpiOverride;
        } else {
            this.resolutionX = resolutionX;
            this.resolutionY = resolutionY;
        }
        this.scale = scale;
    }

    public int getDepth() {
        return this.depth;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getVisibleX() {
        return this.visibleX;
    }

    public int getVisibleY() {
        return this.visibleY;
    }

    public int getVisibleWidth() {
        return this.visibleWidth;
    }

    public int getVisibleHeight() {
        return this.visibleHeight;
    }

    public int getResolutionX() {
        return this.resolutionX;
    }

    public int getResolutionY() {
        return this.resolutionY;
    }

    public float getScale() {
        return this.scale;
    }

    public long getNativeScreen() {
        return this.ptr;
    }

    private void dispose() {
        this.ptr = 0L;
    }

    public int getAdapterOrdinal() {
        return this.adapter;
    }

    public void setAdapterOrdinal(int adapter) {
        this.adapter = adapter;
    }

    public static void setEventHandler(EventHandler eh) {
        Application.checkEventThread();
        eventHandler = eh;
    }

    public static void notifySettingsChanged() {
        List<Screen> oldScreens = screens;
        Screen.initScreens();
        if (eventHandler != null) {
            eventHandler.handleSettingsChanged();
        }
        List<Window> windows = Window.getWindows();
        for (Window w : windows) {
            Screen oldScreen = w.getScreen();
            for (Screen newScreen : screens) {
                w.setScreen(newScreen);
            }
        }
        if (oldScreens != null) {
            for (Screen screen : oldScreens) {
                screen.dispose();
            }
        }
    }

    static void initScreens() {
        Application.checkEventThread();
        Screen[] newScreens = Application.GetApplication().staticScreen_getScreens();
        if (newScreens == null) {
            throw new RuntimeException("Internal graphics failed to initialize");
        }
        screens = Collections.unmodifiableList(Arrays.asList(newScreens));
    }

    public String toString() {
        return "Screen:\n    ptr:" + this.getNativeScreen() + "\n" + "    adapter:" + this.getAdapterOrdinal() + "\n" + "    depth:" + this.getDepth() + "\n" + "    x:" + this.getX() + "\n" + "    y:" + this.getY() + "\n" + "    width:" + this.getWidth() + "\n" + "    height:" + this.getHeight() + "\n" + "    visibleX:" + this.getVisibleX() + "\n" + "    visibleY:" + this.getVisibleY() + "\n" + "    visibleWidth:" + this.getVisibleWidth() + "\n" + "    visibleHeight:" + this.getVisibleHeight() + "\n" + "    scale:" + this.getScale() + "\n" + "    resolutionX:" + this.getResolutionX() + "\n" + "    resolutionY:" + this.getResolutionY() + "\n";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Screen screen = (Screen)o;
        return this.ptr == screen.ptr && this.adapter == screen.adapter && this.depth == screen.depth && this.x == screen.x && this.y == screen.y && this.width == screen.width && this.height == screen.height && this.visibleX == screen.visibleX && this.visibleY == screen.visibleY && this.visibleWidth == screen.visibleWidth && this.visibleHeight == screen.visibleHeight && this.resolutionX == screen.resolutionX && this.resolutionY == screen.resolutionY && Float.compare(screen.scale, this.scale) == 0;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + (int)(this.ptr ^ this.ptr >>> 32);
        result = 31 * result + this.adapter;
        result = 31 * result + this.depth;
        result = 31 * result + this.x;
        result = 31 * result + this.y;
        result = 31 * result + this.width;
        result = 31 * result + this.height;
        result = 31 * result + this.visibleX;
        result = 31 * result + this.visibleY;
        result = 31 * result + this.visibleWidth;
        result = 31 * result + this.visibleHeight;
        result = 31 * result + this.resolutionX;
        result = 31 * result + this.resolutionY;
        result = 31 * result + (this.scale != 0.0f ? Float.floatToIntBits(this.scale) : 0);
        return result;
    }

    static /* synthetic */ Integer lambda$static$3() {
        return Integer.getInteger("com.sun.javafx.screenDPI", 0);
    }

    public static class EventHandler {
        public void handleSettingsChanged() {
        }
    }
}

