/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui;

import com.sun.glass.ui.Application;
import com.sun.glass.ui.View;
import java.util.HashMap;
import java.util.Map;

public class TouchInputSupport {
    private int touchCount = 0;
    private boolean filterTouchCoordinates;
    private Map<Long, TouchCoord> touch;
    private TouchCountListener listener;
    private int curTouchCount;
    private View curView;
    private int curModifiers;
    private boolean curIsDirect;

    public TouchInputSupport(TouchCountListener listener, boolean filterTouchCoordinates) {
        Application.checkEventThread();
        this.listener = listener;
        this.filterTouchCoordinates = filterTouchCoordinates;
        if (filterTouchCoordinates) {
            this.touch = new HashMap<Long, TouchCoord>();
        }
    }

    public int getTouchCount() {
        Application.checkEventThread();
        return this.touchCount;
    }

    public void notifyBeginTouchEvent(View view, int modifiers, boolean isDirect, int touchEventCount) {
        if (this.curView != null && view != this.curView && this.touchCount != 0 && this.touch != null) {
            this.curView.notifyBeginTouchEvent(0, true, this.touchCount);
            for (Map.Entry<Long, TouchCoord> e : this.touch.entrySet()) {
                TouchCoord coord = e.getValue();
                this.curView.notifyNextTouchEvent(813, e.getKey(), coord.x, coord.y, coord.xAbs, coord.yAbs);
            }
            this.curView.notifyEndTouchEvent();
            this.touchCount = 0;
            if (this.listener != null) {
                this.listener.touchCountChanged(this, this.curView, 0, true);
            }
        }
        this.curTouchCount = this.touchCount;
        this.curView = view;
        this.curModifiers = modifiers;
        this.curIsDirect = isDirect;
        if (view != null) {
            view.notifyBeginTouchEvent(modifiers, isDirect, touchEventCount);
        }
    }

    public void notifyEndTouchEvent(View view) {
        if (view == null) {
            return;
        }
        view.notifyEndTouchEvent();
        if (this.curTouchCount != 0 && this.touchCount != 0 && this.curTouchCount != this.touchCount && this.listener != null) {
            this.listener.touchCountChanged(this, this.curView, this.curModifiers, this.curIsDirect);
        }
    }

    public void notifyNextTouchEvent(View view, int state, long id, int x, int y, int xAbs, int yAbs) {
        switch (state) {
            case 813: {
                --this.touchCount;
                break;
            }
            case 811: {
                ++this.touchCount;
                break;
            }
            case 812: 
            case 814: {
                break;
            }
            default: {
                System.err.println("Unknown touch state: " + state);
                return;
            }
        }
        if (this.filterTouchCoordinates) {
            state = this.filterTouchInputState(state, id, x, y, xAbs, yAbs);
        }
        if (view != null) {
            view.notifyNextTouchEvent(state, id, x, y, xAbs, yAbs);
        }
    }

    private int filterTouchInputState(int state, long id, int x, int y, int xAbs, int yAbs) {
        switch (state) {
            case 813: {
                this.touch.remove(id);
                break;
            }
            case 812: {
                TouchCoord c = this.touch.get(id);
                if (x == c.x && y == c.y) {
                    state = 814;
                    break;
                }
            }
            case 811: {
                this.touch.put(id, new TouchCoord(x, y, xAbs, yAbs));
                break;
            }
            case 814: {
                break;
            }
            default: {
                System.err.println("Unknown touch state: " + state);
            }
        }
        return state;
    }

    public static interface TouchCountListener {
        public void touchCountChanged(TouchInputSupport var1, View var2, int var3, boolean var4);
    }

    private static class TouchCoord {
        private final int x;
        private final int y;
        private final int xAbs;
        private final int yAbs;

        private TouchCoord(int x, int y, int xAbs, int yAbs) {
            this.x = x;
            this.y = y;
            this.xAbs = xAbs;
            this.yAbs = yAbs;
        }
    }
}

