/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.gtk;

import com.sun.glass.ui.Application;
import com.sun.glass.ui.CommonDialogs;
import com.sun.glass.ui.Cursor;
import com.sun.glass.ui.InvokeLaterDispatcher;
import com.sun.glass.ui.Pixels;
import com.sun.glass.ui.Robot;
import com.sun.glass.ui.Screen;
import com.sun.glass.ui.Size;
import com.sun.glass.ui.Timer;
import com.sun.glass.ui.View;
import com.sun.glass.ui.Window;
import com.sun.glass.ui.gtk.GtkApplication$$Lambda$1;
import com.sun.glass.ui.gtk.GtkApplication$$Lambda$2;
import com.sun.glass.ui.gtk.GtkApplication$$Lambda$3;
import com.sun.glass.ui.gtk.GtkApplication$$Lambda$4;
import com.sun.glass.ui.gtk.GtkApplication$$Lambda$5;
import com.sun.glass.ui.gtk.GtkApplication$$Lambda$6;
import com.sun.glass.ui.gtk.GtkApplication$$Lambda$7;
import com.sun.glass.ui.gtk.GtkApplication$$Lambda$8;
import com.sun.glass.ui.gtk.GtkChildWindow;
import com.sun.glass.ui.gtk.GtkCommonDialogs;
import com.sun.glass.ui.gtk.GtkCursor;
import com.sun.glass.ui.gtk.GtkPixels;
import com.sun.glass.ui.gtk.GtkRobot;
import com.sun.glass.ui.gtk.GtkTimer;
import com.sun.glass.ui.gtk.GtkView;
import com.sun.glass.ui.gtk.GtkWindow;
import java.io.File;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.security.AccessController;
import java.util.Map;
import java.util.concurrent.CountDownLatch;

final class GtkApplication
extends Application
implements InvokeLaterDispatcher.InvokeLaterSubmitter {
    public static int screen;
    public static long display;
    public static long visualID;
    private final InvokeLaterDispatcher invokeLaterDispatcher;
    private Object eventLoopExitEnterPassValue;

    GtkApplication() {
        if (!GtkApplication.isDisplayValid()) {
            throw new UnsupportedOperationException("Unable to open DISPLAY");
        }
        boolean isEventThread = (Boolean)AccessController.doPrivileged(GtkApplication$$Lambda$1.lambdaFactory$());
        if (!isEventThread) {
            this.invokeLaterDispatcher = new InvokeLaterDispatcher(this);
            this.invokeLaterDispatcher.start();
        } else {
            this.invokeLaterDispatcher = null;
        }
    }

    private static boolean isDisplayValid() {
        return GtkApplication._isDisplayValid();
    }

    private void initDisplay() {
        Map ds = GtkApplication.getDeviceDetails();
        if (ds != null) {
            Object value = ds.get("XDisplay");
            if (value != null) {
                display = (Long)value;
            }
            if ((value = ds.get("XVisualID")) != null) {
                visualID = (Long)value;
            }
            if ((value = ds.get("XScreenID")) != null) {
                screen = (Integer)value;
            }
        }
    }

    private void init() {
        this.initDisplay();
        long eventProc = 0L;
        Map map = GtkApplication.getDeviceDetails();
        if (map != null) {
            Long result = (Long)map.get("javafx.embed.eventProc");
            eventProc = result == null ? 0L : result;
        }
        boolean disableGrab = (Boolean)AccessController.doPrivileged(GtkApplication$$Lambda$2.lambdaFactory$());
        this._init(eventProc, disableGrab);
    }

    @Override
    protected void runLoop(Runnable launchable) {
        boolean isEventThread = (Boolean)AccessController.doPrivileged(GtkApplication$$Lambda$3.lambdaFactory$());
        if (isEventThread) {
            this.init();
            GtkApplication.setEventThread(Thread.currentThread());
            launchable.run();
            return;
        }
        boolean noErrorTrap = (Boolean)AccessController.doPrivileged(GtkApplication$$Lambda$4.lambdaFactory$());
        Thread toolkitThread = (Thread)AccessController.doPrivileged(GtkApplication$$Lambda$5.lambdaFactory$(this, launchable, noErrorTrap));
        GtkApplication.setEventThread(toolkitThread);
        toolkitThread.start();
    }

    @Override
    protected void finishTerminating() {
        Thread toolkitThread = GtkApplication.getEventThread();
        if (toolkitThread != null) {
            this._terminateLoop();
            GtkApplication.setEventThread(null);
        }
        super.finishTerminating();
    }

    @Override
    public boolean shouldUpdateWindow() {
        return true;
    }

    private static native boolean _isDisplayValid();

    private native void _terminateLoop();

    private native void _init(long var1, boolean var3);

    private native void _runLoop(Runnable var1, boolean var2);

    @Override
    protected void _invokeAndWait(Runnable runnable) {
        if (this.invokeLaterDispatcher != null) {
            this.invokeLaterDispatcher.invokeAndWait(runnable);
        } else {
            CountDownLatch latch = new CountDownLatch(1);
            this.submitForLaterInvocation(GtkApplication$$Lambda$6.lambdaFactory$(runnable, latch));
            try {
                latch.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private native void _submitForLaterInvocation(Runnable var1);

    @Override
    public void submitForLaterInvocation(Runnable r) {
        this._submitForLaterInvocation(r);
    }

    @Override
    protected void _invokeLater(Runnable runnable) {
        if (this.invokeLaterDispatcher != null) {
            this.invokeLaterDispatcher.invokeLater(runnable);
        } else {
            this.submitForLaterInvocation(runnable);
        }
    }

    private native void enterNestedEventLoopImpl();

    private native void leaveNestedEventLoopImpl();

    @Override
    protected Object _enterNestedEventLoop() {
        if (this.invokeLaterDispatcher != null) {
            this.invokeLaterDispatcher.notifyEnteringNestedEventLoop();
        }
        try {
            this.enterNestedEventLoopImpl();
            Object retValue = this.eventLoopExitEnterPassValue;
            this.eventLoopExitEnterPassValue = null;
            Object object = retValue;
            return object;
        }
        finally {
            if (this.invokeLaterDispatcher != null) {
                this.invokeLaterDispatcher.notifyLeftNestedEventLoop();
            }
        }
    }

    @Override
    protected void _leaveNestedEventLoop(Object retValue) {
        if (this.invokeLaterDispatcher != null) {
            this.invokeLaterDispatcher.notifyLeavingNestedEventLoop();
        }
        this.eventLoopExitEnterPassValue = retValue;
        this.leaveNestedEventLoopImpl();
    }

    @Override
    public Window createWindow(Window owner, Screen screen, int styleMask) {
        return new GtkWindow(owner, screen, styleMask);
    }

    @Override
    public Window createWindow(long parent) {
        return new GtkChildWindow(parent);
    }

    @Override
    public View createView() {
        return new GtkView();
    }

    @Override
    public Cursor createCursor(int type) {
        return new GtkCursor(type);
    }

    @Override
    public Cursor createCursor(int x, int y, Pixels pixels) {
        return new GtkCursor(x, y, pixels);
    }

    @Override
    protected void staticCursor_setVisible(boolean visible) {
    }

    @Override
    protected Size staticCursor_getBestSize(int width, int height) {
        return GtkCursor._getBestSize(width, height);
    }

    @Override
    public Pixels createPixels(int width, int height, ByteBuffer data) {
        return new GtkPixels(width, height, data);
    }

    @Override
    public Pixels createPixels(int width, int height, IntBuffer data) {
        return new GtkPixels(width, height, data);
    }

    @Override
    public Pixels createPixels(int width, int height, IntBuffer data, float scale) {
        return new GtkPixels(width, height, data, scale);
    }

    @Override
    protected int staticPixels_getNativeFormat() {
        return 1;
    }

    @Override
    public Robot createRobot() {
        return new GtkRobot();
    }

    @Override
    public Timer createTimer(Runnable runnable) {
        return new GtkTimer(runnable);
    }

    @Override
    protected native int staticTimer_getMinPeriod();

    @Override
    protected native int staticTimer_getMaxPeriod();

    @Override
    protected double staticScreen_getVideoRefreshPeriod() {
        return 0.0;
    }

    @Override
    protected native Screen[] staticScreen_getScreens();

    @Override
    protected CommonDialogs.FileChooserResult staticCommonDialogs_showFileChooser(Window owner, String folder, String filename, String title, int type, boolean multipleMode, CommonDialogs.ExtensionFilter[] extensionFilters, int defaultFilterIndex) {
        return GtkCommonDialogs.showFileChooser(owner, folder, filename, title, type, multipleMode, extensionFilters, defaultFilterIndex);
    }

    @Override
    protected File staticCommonDialogs_showFolderChooser(Window owner, String folder, String title) {
        return GtkCommonDialogs.showFolderChooser(owner, folder, title);
    }

    @Override
    protected native long staticView_getMultiClickTime();

    @Override
    protected native int staticView_getMultiClickMaxX();

    @Override
    protected native int staticView_getMultiClickMaxY();

    @Override
    protected boolean _supportsInputMethods() {
        return true;
    }

    @Override
    protected native boolean _supportsTransparentWindows();

    @Override
    protected boolean _supportsUnifiedWindows() {
        return false;
    }

    @Override
    protected native int _getKeyCodeForChar(char var1);

    static /* synthetic */ void lambda$_invokeAndWait$50(Runnable runnable, CountDownLatch countDownLatch) {
        if (runnable != null) {
            runnable.run();
        }
        countDownLatch.countDown();
    }

    /* synthetic */ Thread lambda$runLoop$49(Runnable runnable, boolean bl) {
        return new Thread(GtkApplication$$Lambda$7.lambdaFactory$(this, runnable, bl), "GtkNativeMainLoopThread");
    }

    /* synthetic */ void lambda$null$48(Runnable runnable, boolean bl) {
        this.init();
        this._runLoop(runnable, bl);
    }

    static /* synthetic */ Boolean lambda$runLoop$47() {
        return Boolean.getBoolean("glass.noErrorTrap");
    }

    static /* synthetic */ Boolean lambda$runLoop$46() {
        return Boolean.getBoolean("javafx.embed.isEventThread");
    }

    static /* synthetic */ Boolean lambda$init$45() {
        return Boolean.getBoolean("sun.awt.disablegrab") || Boolean.getBoolean("glass.disableGrab");
    }

    static /* synthetic */ Boolean lambda$new$44() {
        return Boolean.getBoolean("javafx.embed.isEventThread");
    }

    static /* synthetic */ Void lambda$static$43() {
        Application.loadNativeLibrary();
        return null;
    }

    static {
        AccessController.doPrivileged(GtkApplication$$Lambda$8.lambdaFactory$());
        screen = -1;
        display = 0L;
        visualID = 0L;
    }
}

