/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.lens;

import com.sun.glass.ui.Application;
import com.sun.glass.ui.Cursor;
import com.sun.glass.ui.Pixels;
import com.sun.glass.ui.Size;
import com.sun.glass.ui.lens.LensApplication;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;

final class LensCursor
extends Cursor {
    private long ptr = 0L;

    protected LensCursor(int type) {
        super(type);
        if (type != -1) {
            this.ptr = this._createNativeCursorByType(type);
        }
    }

    protected LensCursor(int x, int y, Pixels pixels) {
        super(x, y, pixels);
        this.ptr = this.getNativeCursor();
    }

    protected void finalize() throws Throwable {
        try {
            if (this.ptr != 0L) {
                this._releaseNativeCursor(this.ptr);
            }
        }
        finally {
            super.finalize();
        }
    }

    @Override
    protected long _createCursor(int x, int y, Pixels pixels) {
        long res = 0L;
        Buffer data = pixels.getPixels();
        int width = pixels.getWidth();
        int height = pixels.getHeight();
        if (data != null) {
            if (!data.isDirect()) {
                if (pixels.getBytesPerComponent() == 4) {
                    IntBuffer ints = (IntBuffer)data.rewind();
                    int[] intArray = ints.array();
                    res = this._createNativeCursorInts(x, y, intArray, width, height);
                } else if (pixels.getBytesPerComponent() == 1) {
                    ByteBuffer bytes = (ByteBuffer)data.rewind();
                    byte[] byteArray = bytes.array();
                    res = this._createNativeCursorBytes(x, y, byteArray, width, height);
                }
            } else {
                data.rewind();
                res = this._createNativeCursorDirect(x, y, data, data.capacity(), width, height);
            }
        }
        return res;
    }

    void set() {
        int type;
        if (this.ptr != 0L) {
            this._setNativeCursor(this.ptr);
        }
        if ((type = this.getType()) == -1) {
            ((LensApplication)Application.GetApplication()).staticCursor_setVisible(false);
        } else {
            ((LensApplication)Application.GetApplication()).staticCursor_setVisible(true);
        }
    }

    static void setVisible_impl(boolean visible) {
        LensCursor._setVisible(visible);
    }

    static Size getBestSize_impl(int width, int height) {
        return new Size(16, 16);
    }

    private native void _setNativeCursor(long var1);

    private native void _releaseNativeCursor(long var1);

    private native long _createNativeCursorByType(int var1);

    private native long _createNativeCursorInts(int var1, int var2, int[] var3, int var4, int var5);

    private native long _createNativeCursorBytes(int var1, int var2, byte[] var3, int var4, int var5);

    private native long _createNativeCursorDirect(int var1, int var2, Buffer var3, int var4, int var5, int var6);

    private static native void _setVisible(boolean var0);
}

