/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.monocle;

import com.sun.glass.ui.monocle.Framebuffer;
import com.sun.glass.ui.monocle.HeadlessScreen$$Lambda$1;
import com.sun.glass.ui.monocle.NativeScreen;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.AccessController;

class HeadlessScreen
implements NativeScreen {
    protected int depth;
    protected int width;
    protected int height;
    protected Framebuffer fb;

    HeadlessScreen() {
        this(1280, 800, 32);
    }

    protected HeadlessScreen(int defaultWidth, int defaultHeight, int defaultDepth) {
        this.width = defaultWidth;
        this.height = defaultHeight;
        this.depth = defaultDepth;
        String geometry = (String)AccessController.doPrivileged(HeadlessScreen$$Lambda$1.lambdaFactory$());
        if (geometry != null && geometry.indexOf(120) > 0) {
            try {
                int i = geometry.indexOf("x");
                this.width = Integer.parseInt(geometry.substring(0, i));
                int j = geometry.indexOf("-", i + 1);
                if (j > 0) {
                    this.depth = Integer.parseInt(geometry.substring(j + 1));
                } else {
                    j = geometry.length();
                }
                this.height = Integer.parseInt(geometry.substring(i + 1, j));
            }
            catch (NumberFormatException e) {
                System.err.println("Cannot parse geometry string: '" + geometry + "'");
            }
        }
        ByteBuffer bb = ByteBuffer.allocate(this.width * this.height * (this.depth >>> 3));
        bb.order(ByteOrder.nativeOrder());
        this.fb = new Framebuffer(bb, this.width, this.height, this.depth, true);
    }

    @Override
    public int getDepth() {
        return this.depth;
    }

    @Override
    public int getNativeFormat() {
        return 1;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public long getNativeHandle() {
        return 1L;
    }

    @Override
    public int getDPI() {
        return 96;
    }

    @Override
    public void shutdown() {
    }

    @Override
    public void uploadPixels(Buffer b, int x, int y, int width, int height, float alpha) {
        this.fb.composePixels(b, x, y, width, height, alpha);
    }

    @Override
    public void swapBuffers() {
        this.fb.reset();
    }

    @Override
    public ByteBuffer getScreenCapture() {
        return this.fb.getBuffer();
    }

    static /* synthetic */ String lambda$new$93() {
        return System.getProperty("headless.geometry");
    }
}

