/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.monocle;

import com.sun.glass.ui.monocle.IntSet;
import com.sun.glass.ui.monocle.KeyInput$$Lambda$1;
import com.sun.glass.ui.monocle.KeyInput$$Lambda$2;
import com.sun.glass.ui.monocle.KeyInput$$Lambda$3;
import com.sun.glass.ui.monocle.KeyState;
import com.sun.glass.ui.monocle.MonocleSettings;
import com.sun.glass.ui.monocle.MonocleTrace;
import com.sun.glass.ui.monocle.MonocleView;
import com.sun.glass.ui.monocle.MonocleWindow;
import com.sun.glass.ui.monocle.RunnableProcessor;
import java.security.AccessController;

class KeyInput {
    private static KeyInput instance = new KeyInput();
    private KeyState state = new KeyState();
    private IntSet keys = new IntSet();
    private boolean numLock = false;
    private boolean capsLock = false;
    private char[] NO_CHAR = new char[0];

    KeyInput() {
    }

    static KeyInput getInstance() {
        return instance;
    }

    void getState(KeyState result) {
        this.state.copyTo(result);
    }

    void setState(KeyState newState) {
        int key;
        int i;
        MonocleSettings.settings.getClass();
        MonocleTrace.traceEvent("Set %s", newState);
        newState.getWindow(true);
        this.state.getKeysPressed().difference(this.keys, newState.getKeysPressed());
        if (!this.keys.isEmpty()) {
            for (i = 0; i < this.keys.size(); ++i) {
                key = this.keys.get(i);
                this.dispatchKeyEvent(newState, 112, key);
            }
        }
        this.keys.clear();
        newState.getKeysPressed().difference(this.keys, this.state.getKeysPressed());
        if (!this.keys.isEmpty()) {
            for (i = 0; i < this.keys.size(); ++i) {
                key = this.keys.get(i);
                if (key == 20) {
                    this.capsLock = !this.capsLock;
                } else if (key == 144) {
                    this.numLock = !this.numLock;
                } else if (key == 67 && newState.isControlPressed()) {
                    AccessController.doPrivileged(KeyInput$$Lambda$1.lambdaFactory$());
                }
                this.dispatchKeyEvent(newState, 111, key);
            }
        }
        this.keys.clear();
        newState.copyTo(this.state);
    }

    private void dispatchKeyEvent(KeyState ks, int type, int key) {
        MonocleWindow window = ks.getWindow(false);
        if (window == null) {
            return;
        }
        MonocleView view = (MonocleView)window.getView();
        if (view == null) {
            return;
        }
        char[] chars = this.getKeyChars(ks, key);
        int modifiers = ks.getModifiers();
        RunnableProcessor.runLater(KeyInput$$Lambda$2.lambdaFactory$(view, type, key, chars, modifiers));
        if (type == 111 && chars.length > 0) {
            RunnableProcessor.runLater(KeyInput$$Lambda$3.lambdaFactory$(view, key, chars, modifiers));
        }
    }

    private char[] getKeyChars(KeyState state, int key) {
        char[] cArray;
        int c = 0;
        boolean shifted = state.isShiftPressed();
        if (key >= 65 && key <= 90) {
            c = (shifted ^= this.capsLock) ? (int)((char)(key - 65 + 65)) : (int)((char)(key - 65 + 97));
        } else if (key >= 96 && key <= 105) {
            if (this.numLock) {
                c = (char)(key - 96 + 48);
            }
        } else if (key >= 48 && key <= 57) {
            if (shifted) {
                switch (key) {
                    case 48: {
                        c = 41;
                        break;
                    }
                    case 49: {
                        c = 33;
                        break;
                    }
                    case 50: {
                        c = 64;
                        break;
                    }
                    case 51: {
                        c = 35;
                        break;
                    }
                    case 52: {
                        c = 36;
                        break;
                    }
                    case 53: {
                        c = 37;
                        break;
                    }
                    case 54: {
                        c = 94;
                        break;
                    }
                    case 55: {
                        c = 38;
                        break;
                    }
                    case 56: {
                        c = 42;
                        break;
                    }
                    case 57: {
                        c = 40;
                    }
                }
            } else {
                c = (char)(key - 48 + 48);
            }
        } else if (key == 32) {
            c = 32;
        } else if (key == 9) {
            c = 9;
        } else if (key == 10) {
            c = 10;
        } else if (key == 106) {
            c = 42;
        } else if (key == 111) {
            c = 47;
        } else if (shifted) {
            switch (key) {
                case 192: {
                    c = 126;
                    break;
                }
                case 44: {
                    c = 60;
                    break;
                }
                case 46: {
                    c = 62;
                    break;
                }
                case 47: {
                    c = 63;
                    break;
                }
                case 59: {
                    c = 58;
                    break;
                }
                case 222: {
                    c = 34;
                    break;
                }
                case 161: {
                    c = 123;
                    break;
                }
                case 162: {
                    c = 125;
                    break;
                }
                case 92: {
                    c = 124;
                    break;
                }
                case 45: {
                    c = 95;
                    break;
                }
                case 61: {
                    c = 43;
                }
            }
        } else {
            switch (key) {
                case 192: {
                    c = 96;
                    break;
                }
                case 44: {
                    c = 44;
                    break;
                }
                case 46: {
                    c = 46;
                    break;
                }
                case 47: {
                    c = 47;
                    break;
                }
                case 59: {
                    c = 59;
                    break;
                }
                case 222: {
                    c = 39;
                    break;
                }
                case 161: {
                    c = 91;
                    break;
                }
                case 162: {
                    c = 93;
                    break;
                }
                case 92: {
                    c = 92;
                    break;
                }
                case 45: {
                    c = 45;
                    break;
                }
                case 61: {
                    c = 61;
                }
            }
        }
        if (c == 0) {
            cArray = this.NO_CHAR;
        } else {
            char[] cArray2 = new char[1];
            cArray = cArray2;
            cArray2[0] = c;
        }
        return cArray;
    }

    int getKeyCodeForChar(char c) {
        c = Character.toUpperCase(c);
        switch (c) {
            case '!': {
                c = (char)49;
                break;
            }
            case '@': {
                c = (char)50;
                break;
            }
            case '#': {
                c = (char)51;
                break;
            }
            case '$': {
                c = (char)52;
                break;
            }
            case '%': {
                c = (char)53;
                break;
            }
            case '^': {
                c = (char)54;
                break;
            }
            case '&': {
                c = (char)55;
                break;
            }
            case '*': {
                c = (char)56;
                break;
            }
            case '(': {
                c = (char)57;
                break;
            }
            case ')': {
                c = (char)48;
                break;
            }
            case '~': {
                c = (char)96;
                break;
            }
            case '_': {
                c = (char)45;
                break;
            }
            case '+': {
                c = (char)61;
                break;
            }
            case '{': {
                c = (char)91;
                break;
            }
            case '}': {
                c = (char)93;
                break;
            }
            case '|': {
                c = (char)92;
                break;
            }
            case ':': {
                c = (char)59;
                break;
            }
            case '\"': {
                c = (char)39;
                break;
            }
            case '<': {
                c = (char)44;
                break;
            }
            case '>': {
                c = (char)46;
                break;
            }
            case '?': {
                c = (char)47;
            }
        }
        if (c >= 'A' && c <= 'Z') {
            return c - 65 + 65;
        }
        if (c >= '0' && c <= '9') {
            return c - 48 + 48;
        }
        switch (c) {
            case '`': {
                return 192;
            }
            case '-': {
                return 45;
            }
            case '=': {
                return 61;
            }
            case '[': {
                return 161;
            }
            case ']': {
                return 162;
            }
            case '\\': {
                return 92;
            }
            case ';': {
                return 59;
            }
            case '\'': {
                return 222;
            }
            case ',': {
                return 44;
            }
            case '.': {
                return 46;
            }
            case '/': {
                return 47;
            }
        }
        return 0;
    }

    static /* synthetic */ void lambda$dispatchKeyEvent$76(MonocleView monocleView, int n, char[] cArray, int n2) {
        monocleView.notifyKey(113, n, cArray, n2);
    }

    static /* synthetic */ void lambda$dispatchKeyEvent$75(MonocleView monocleView, int n, int n2, char[] cArray, int n3) {
        monocleView.notifyKey(n, n2, cArray, n3);
    }

    static /* synthetic */ Void lambda$setState$74() {
        if ("1".equals(System.getenv("JAVAFX_DEBUG"))) {
            System.exit(0);
        }
        return null;
    }
}

