/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.monocle;

import com.sun.glass.ui.monocle.LinuxInput;
import com.sun.glass.ui.monocle.MonocleSettings;
import com.sun.glass.ui.monocle.MonocleTrace;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

class LinuxEventBuffer {
    private static final int EVENT_BUFFER_SIZE = 1000;
    private final ByteBuffer bb;
    private final EventStruct eventStruct;
    private int positionOfLastSync;
    private int currentPosition;
    private int mark;

    LinuxEventBuffer(int osArchBits) {
        this.eventStruct = osArchBits == 64 ? new EventStruct64Bit() : new EventStruct32Bit();
        this.bb = ByteBuffer.allocate(this.eventStruct.getSize() * 1000);
        this.bb.order(ByteOrder.nativeOrder());
    }

    int getEventSize() {
        return this.eventStruct.getSize();
    }

    synchronized boolean put(ByteBuffer event) throws InterruptedException {
        boolean isSync;
        boolean bl = isSync = event.getInt(this.eventStruct.getTypeIndex()) == 0 && event.getInt(this.eventStruct.getValueIndex()) == 0;
        while (this.bb.limit() - this.bb.position() < event.limit()) {
            MonocleSettings.settings.getClass();
            MonocleTrace.traceEvent("Event buffer %s is full, waiting for some space to become available", this.bb);
            this.wait();
        }
        if (isSync) {
            this.positionOfLastSync = this.bb.position();
        }
        this.bb.put(event);
        MonocleSettings.settings.getClass();
        int index = this.bb.position() - this.eventStruct.getSize();
        MonocleTrace.traceEvent("Read %s [index=%d]", this.getEventDescription(index), index);
        return isSync;
    }

    synchronized void startIteration() {
        this.currentPosition = 0;
        this.mark = 0;
        MonocleSettings.settings.getClass();
        MonocleTrace.traceEvent("Processing %s [index=%d]", this.getEventDescription(), this.currentPosition);
    }

    synchronized void compact() {
        this.positionOfLastSync -= this.currentPosition;
        int newLimit = this.bb.position();
        this.bb.position(this.currentPosition);
        this.bb.limit(newLimit);
        this.bb.compact();
        MonocleSettings.settings.getClass();
        MonocleTrace.traceEvent("Compacted event buffer %s", this.bb);
        this.notifyAll();
    }

    synchronized short getEventType() {
        return this.bb.getShort(this.currentPosition + this.eventStruct.getTypeIndex());
    }

    short getEventCode() {
        return this.bb.getShort(this.currentPosition + this.eventStruct.getCodeIndex());
    }

    synchronized int getEventValue() {
        return this.bb.getInt(this.currentPosition + this.eventStruct.getValueIndex());
    }

    synchronized String getEventDescription() {
        return this.getEventDescription(this.currentPosition);
    }

    private synchronized String getEventDescription(int position) {
        short type = this.bb.getShort(position + this.eventStruct.getTypeIndex());
        short code = this.bb.getShort(position + this.eventStruct.getCodeIndex());
        int value = this.bb.getInt(position + this.eventStruct.getValueIndex());
        String typeStr = LinuxInput.typeToString(type);
        return typeStr + " " + LinuxInput.codeToString(typeStr, code) + " " + value;
    }

    synchronized void nextEvent() {
        if (this.currentPosition > this.positionOfLastSync) {
            throw new IllegalStateException("Cannot advance past the last EV_SYN EV_SYN_REPORT 0");
        }
        this.currentPosition += this.eventStruct.getSize();
        MonocleSettings.settings.getClass();
        if (this.hasNextEvent()) {
            MonocleTrace.traceEvent("Processing %s [index=%d]", this.getEventDescription(), this.currentPosition);
        }
    }

    synchronized void mark() {
        this.mark = this.currentPosition;
    }

    synchronized void reset() {
        this.currentPosition = this.mark;
    }

    synchronized boolean hasNextEvent() {
        return this.currentPosition <= this.positionOfLastSync;
    }

    synchronized boolean hasData() {
        return this.bb.position() != 0;
    }

    class EventStruct64Bit
    implements EventStruct {
        EventStruct64Bit() {
        }

        @Override
        public int getTypeIndex() {
            return 16;
        }

        @Override
        public int getCodeIndex() {
            return 18;
        }

        @Override
        public int getValueIndex() {
            return 20;
        }

        @Override
        public int getSize() {
            return 24;
        }
    }

    class EventStruct32Bit
    implements EventStruct {
        EventStruct32Bit() {
        }

        @Override
        public int getTypeIndex() {
            return 8;
        }

        @Override
        public int getCodeIndex() {
            return 10;
        }

        @Override
        public int getValueIndex() {
            return 12;
        }

        @Override
        public int getSize() {
            return 16;
        }
    }

    static interface EventStruct {
        public int getTypeIndex();

        public int getCodeIndex();

        public int getValueIndex();

        public int getSize();
    }
}

