/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.monocle;

import com.sun.glass.ui.monocle.InputDeviceRegistry;
import com.sun.glass.ui.monocle.LinuxInputDevice;
import com.sun.glass.ui.monocle.LinuxInputDeviceRegistry$$Lambda$1;
import com.sun.glass.ui.monocle.LinuxInputProcessor;
import com.sun.glass.ui.monocle.LinuxKeyProcessor;
import com.sun.glass.ui.monocle.LinuxMouseProcessor;
import com.sun.glass.ui.monocle.LinuxSimpleTouchProcessor;
import com.sun.glass.ui.monocle.LinuxStatefulMultiTouchProcessor;
import com.sun.glass.ui.monocle.LinuxStatelessMultiTouchProcessor;
import com.sun.glass.ui.monocle.SysFS;
import com.sun.glass.ui.monocle.Udev;
import com.sun.glass.ui.monocle.UdevListener;
import java.io.File;
import java.io.IOException;
import java.security.AllPermission;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;

class LinuxInputDeviceRegistry
extends InputDeviceRegistry {
    LinuxInputDeviceRegistry(boolean headless) {
        if (headless) {
            return;
        }
        HashMap deviceMap = new HashMap();
        UdevListener udevListener = LinuxInputDeviceRegistry$$Lambda$1.lambdaFactory$(this, deviceMap);
        Udev.getInstance().addListener(udevListener);
        SysFS.triggerUdevNotification("input");
    }

    private LinuxInputDevice createDevice(File devNode, File sysPath, Map<String, String> udevManifest) throws IOException {
        LinuxInputDevice device = new LinuxInputDevice(devNode, sysPath, udevManifest);
        return this.addDeviceInternal(device, "Linux input: " + devNode.toString());
    }

    LinuxInputDevice addDevice(LinuxInputDevice device, String name) {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(new AllPermission());
        }
        return this.addDeviceInternal(device, name);
    }

    private LinuxInputDevice addDeviceInternal(LinuxInputDevice device, String name) {
        LinuxInputProcessor processor = this.createInputProcessor(device);
        if (processor == null) {
            return null;
        }
        device.setInputProcessor(processor);
        Thread thread = new Thread(device);
        thread.setName(name);
        thread.setDaemon(true);
        thread.start();
        this.devices.add(device);
        return device;
    }

    void removeDevice(LinuxInputDevice device) {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(new AllPermission());
        }
        this.devices.remove(device);
    }

    private LinuxInputProcessor createInputProcessor(LinuxInputDevice device) {
        if (device.isTouch()) {
            boolean isMT;
            BitSet absCaps = device.getCapability("abs");
            boolean bl = isMT = absCaps.get(53) && absCaps.get(54);
            if (isMT) {
                if (absCaps.get(57)) {
                    return new LinuxStatefulMultiTouchProcessor(device);
                }
                return new LinuxStatelessMultiTouchProcessor(device);
            }
            return new LinuxSimpleTouchProcessor(device);
        }
        if (device.isRelative()) {
            return new LinuxMouseProcessor();
        }
        BitSet keyCaps = device.getCapability("key");
        if (keyCaps != null && !keyCaps.isEmpty()) {
            return new LinuxKeyProcessor();
        }
        return null;
    }

    /* synthetic */ void lambda$new$95(Map map, String action, Map event) {
        String subsystem = (String)event.get("SUBSYSTEM");
        String devPath = (String)event.get("DEVPATH");
        String devName = (String)event.get("DEVNAME");
        if (subsystem != null && subsystem.equals("input") && devPath != null && devName != null) {
            try {
                File sysPath = new File("/sys", devPath);
                if (action.equals("add") || action.equals("change") && !map.containsKey(sysPath)) {
                    File devNode = new File(devName);
                    LinuxInputDevice device = this.createDevice(devNode, sysPath, event);
                    if (device != null) {
                        map.put(sysPath, device);
                    }
                } else if (action.equals("remove")) {
                    LinuxInputDevice device = (LinuxInputDevice)map.get(sysPath);
                    map.remove(sysPath);
                    if (device != null) {
                        this.devices.remove(device);
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

