/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.monocle;

import com.sun.glass.ui.Pixels;
import com.sun.glass.ui.View;
import com.sun.glass.ui.Window;
import com.sun.glass.ui.monocle.MonocleWindow;
import com.sun.glass.ui.monocle.MonocleWindowManager;
import com.sun.glass.ui.monocle.NativeCursor;
import com.sun.glass.ui.monocle.NativePlatformFactory;
import com.sun.glass.ui.monocle.NativeScreen;
import java.util.Map;

final class MonocleView
extends View {
    private boolean cursorVisibility;
    private boolean resetCursorVisibility = false;
    private static long multiClickTime = 500L;
    private static int multiClickMaxX = 20;
    private static int multiClickMaxY = 20;
    private int x;
    private int y;

    MonocleView() {
    }

    static long _getMultiClickTime() {
        return multiClickTime;
    }

    static int _getMultiClickMaxX() {
        return multiClickMaxX;
    }

    static int _getMultiClickMaxY() {
        return multiClickMaxY;
    }

    @Override
    protected void _enableInputMethodEvents(long ptr, boolean enable) {
    }

    @Override
    protected long _getNativeView(long ptr) {
        return ptr;
    }

    @Override
    protected int _getX(long ptr) {
        return this.x;
    }

    @Override
    protected int _getY(long ptr) {
        return this.y;
    }

    @Override
    protected void _scheduleRepaint(long ptr) {
    }

    @Override
    protected void _uploadPixels(long nativeViewPtr, Pixels pixels) {
        if (this.getWindow() != null) {
            NativeScreen screen = NativePlatformFactory.getNativePlatform().getScreen();
            Window window = this.getWindow();
            screen.uploadPixels(pixels.getPixels(), this.x + window.getX(), this.y + window.getY(), pixels.getWidth(), pixels.getHeight(), window.getAlpha());
        }
    }

    @Override
    protected void notifyKey(int type, int keyCode, char[] keyChars, int modifiers) {
        super.notifyKey(type, keyCode, keyChars, modifiers);
    }

    @Override
    protected void notifyMouse(int type, int button, int x, int y, int xAbs, int yAbs, int modifiers, boolean isPopupTrigger, boolean isSynthesized) {
        super.notifyMouse(type, button, x, y, xAbs, yAbs, modifiers, isPopupTrigger, isSynthesized);
    }

    @Override
    protected void notifyScroll(int x, int y, int xAbs, int yAbs, double deltaX, double deltaY, int modifiers, int lines, int chars, int defaultLines, int defaultChars, double xMultiplier, double yMultiplier) {
        super.notifyScroll(x, y, xAbs, yAbs, deltaX, deltaY, modifiers, lines, chars, defaultLines, defaultChars, xMultiplier, yMultiplier);
    }

    void notifyRepaint() {
        super.notifyRepaint(this.x, this.y, this.getWidth(), this.getHeight());
    }

    @Override
    protected void notifyResize(int width, int height) {
        super.notifyResize(width, height);
    }

    @Override
    protected void notifyView(int viewEvent) {
        super.notifyView(viewEvent);
    }

    @Override
    protected int notifyDragEnter(int x, int y, int absx, int absy, int recommendedDropAction) {
        return super.notifyDragEnter(x, y, absx, absy, recommendedDropAction);
    }

    @Override
    protected void notifyDragLeave() {
        super.notifyDragLeave();
    }

    @Override
    protected int notifyDragDrop(int x, int y, int absx, int absy, int recommendedDropAction) {
        return super.notifyDragDrop(x, y, absx, absy, recommendedDropAction);
    }

    @Override
    protected int notifyDragOver(int x, int y, int absx, int absy, int recommendedDropAction) {
        return super.notifyDragOver(x, y, absx, absy, recommendedDropAction);
    }

    @Override
    protected void notifyDragEnd(int performedAction) {
        super.notifyDragEnd(performedAction);
    }

    @Override
    protected void notifyMenu(int x, int y, int xAbs, int yAbs, boolean isKeyboardTrigger) {
        super.notifyMenu(x, y, xAbs, yAbs, isKeyboardTrigger);
    }

    @Override
    protected long _create(Map caps) {
        return 1L;
    }

    @Override
    protected void _setParent(long ptr, long parentPtr) {
    }

    @Override
    protected boolean _close(long ptr) {
        return true;
    }

    @Override
    protected boolean _enterFullscreen(long ptr, boolean animate, boolean keepRatio, boolean hideCursor) {
        MonocleWindowManager wm = MonocleWindowManager.getInstance();
        MonocleWindow focusedWindow = wm.getFocusedWindow();
        focusedWindow.setFullScreen(true);
        if (hideCursor) {
            this.resetCursorVisibility = true;
            NativeCursor nativeCursor = NativePlatformFactory.getNativePlatform().getCursor();
            this.cursorVisibility = nativeCursor.getVisiblity();
            nativeCursor.setVisibility(false);
        }
        return true;
    }

    @Override
    protected void _exitFullscreen(long ptr, boolean animate) {
        MonocleWindowManager wm = MonocleWindowManager.getInstance();
        MonocleWindow focusedWindow = wm.getFocusedWindow();
        focusedWindow.setFullScreen(false);
        if (this.resetCursorVisibility) {
            this.resetCursorVisibility = false;
            NativeCursor nativeCursor = NativePlatformFactory.getNativePlatform().getCursor();
            nativeCursor.setVisibility(this.cursorVisibility);
        }
    }

    public String toString() {
        return "MonocleView[" + this.x + "," + this.y + "+" + this.getWidth() + "x" + this.getHeight() + "]";
    }

    @Override
    protected void _begin(long ptr) {
    }

    @Override
    protected void _end(long ptr) {
    }
}

