/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.monocle;

import com.sun.glass.ui.Application;
import com.sun.glass.ui.monocle.NativePlatformFactory;
import com.sun.glass.ui.monocle.RunnableProcessor$$Lambda$1;
import com.sun.glass.ui.monocle.RunnableQueue;
import java.util.LinkedList;
import java.util.concurrent.CountDownLatch;

class RunnableProcessor
implements Runnable {
    private RunnableQueue queue = new RunnableQueue();
    private LinkedList<RunLoopControl> activeRunLoops = new LinkedList();

    RunnableProcessor() {
    }

    @Override
    public void run() {
        this.runLoop();
    }

    void invokeLater(Runnable r) {
        this.queue.postRunnable(r);
    }

    void invokeAndWait(Runnable r) {
        CountDownLatch latch = new CountDownLatch(1);
        this.queue.postRunnable(RunnableProcessor$$Lambda$1.lambdaFactory$(r, latch));
        try {
            latch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private Object runLoop() {
        RunLoopControl control = new RunLoopControl();
        this.activeRunLoops.push(control);
        control.active = true;
        while (control.active) {
            try {
                this.queue.getNextRunnable().run();
            }
            catch (Throwable e) {
                Application.reportException(e);
            }
        }
        return control.release;
    }

    Object enterNestedEventLoop() {
        Object ret = this.runLoop();
        return ret;
    }

    void leaveNestedEventLoop(Object retValue) {
        RunLoopControl current = this.activeRunLoops.pop();
        assert (current != null);
        current.active = false;
        current.release = retValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutdown() {
        RunnableQueue runnableQueue = this.queue;
        synchronized (runnableQueue) {
            this.queue.clear();
            while (!this.activeRunLoops.isEmpty()) {
                RunLoopControl control = this.activeRunLoops.pop();
                control.active = false;
            }
            this.queue.notifyAll();
        }
    }

    static void runLater(Runnable r) {
        NativePlatformFactory.getNativePlatform().getRunnableProcessor().invokeLater(r);
    }

    static /* synthetic */ void lambda$invokeAndWait$84(Runnable runnable, CountDownLatch countDownLatch) {
        try {
            runnable.run();
        }
        finally {
            countDownLatch.countDown();
        }
    }

    private static class RunLoopControl {
        boolean active;
        Object release;

        private RunLoopControl() {
        }
    }
}

