/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.monocle;

import com.sun.glass.ui.GestureSupport;
import com.sun.glass.ui.TouchInputSupport;
import com.sun.glass.ui.View;
import com.sun.glass.ui.Window;
import com.sun.glass.ui.monocle.MonocleSettings;
import com.sun.glass.ui.monocle.MonocleTrace;
import com.sun.glass.ui.monocle.MonocleWindow;
import com.sun.glass.ui.monocle.MouseInputSynthesizer;
import com.sun.glass.ui.monocle.RunnableProcessor;
import com.sun.glass.ui.monocle.TouchInput$$Lambda$1;
import com.sun.glass.ui.monocle.TouchInput$$Lambda$2;
import com.sun.glass.ui.monocle.TouchInput$$Lambda$3;
import com.sun.glass.ui.monocle.TouchInput$$Lambda$4;
import com.sun.glass.ui.monocle.TouchInput$$Lambda$5;
import com.sun.glass.ui.monocle.TouchPipeline;
import com.sun.glass.ui.monocle.TouchState;
import java.security.AccessController;

class TouchInput {
    private final int touchRadius = (Integer)AccessController.doPrivileged(TouchInput$$Lambda$1.lambdaFactory$());
    private static TouchInput instance = new TouchInput();
    private TouchPipeline basePipeline;
    private TouchState state = new TouchState();
    private final GestureSupport gestures = new GestureSupport(false);
    private final TouchInputSupport touches = new TouchInputSupport(this.gestures.createTouchCountListener(), false);

    static TouchInput getInstance() {
        return instance;
    }

    private TouchInput() {
    }

    TouchPipeline getBasePipeline() {
        if (this.basePipeline == null) {
            this.basePipeline = new TouchPipeline();
            String[] touchFilterNames = ((String)AccessController.doPrivileged(TouchInput$$Lambda$2.lambdaFactory$())).split(",");
            if (touchFilterNames != null) {
                for (String touchFilterName : touchFilterNames) {
                    this.basePipeline.addNamedFilter(touchFilterName.trim());
                }
            }
        }
        return this.basePipeline;
    }

    void getState(TouchState result) {
        this.state.copyTo(result);
    }

    void setState(TouchState newState) {
        View view;
        MonocleSettings.settings.getClass();
        MonocleTrace.traceEvent("Set %s", newState);
        newState.sortPointsByID();
        newState.assignPrimaryID();
        MonocleWindow oldWindow = this.state.getWindow(false, null);
        boolean recalculateWindow = this.state.getPointCount() == 0;
        MonocleWindow window = newState.getWindow(recalculateWindow, oldWindow);
        View oldView = oldWindow == null ? null : oldWindow.getView();
        View view2 = view = window == null ? null : window.getView();
        if (!newState.equalsSorted(this.state)) {
            if (view != oldView) {
                this.postTouchEvent(this.state, 813);
                this.postTouchEvent(newState, 811);
            } else if (view != null) {
                this.postTouchEvent(window, view, newState);
            }
            MouseInputSynthesizer.getInstance().setState(newState);
        }
        newState.copyTo(this.state);
        newState.clearWindow();
    }

    private void dispatchPoint(Window window, View view, int state, int id, int x, int y) {
        this.touches.notifyNextTouchEvent(view, state, id, x - window.getX(), y - window.getY(), x, y);
    }

    private void postPoints(Window window, View view, int[] states, int[] ids, int[] xs, int[] ys) {
        RunnableProcessor.runLater(TouchInput$$Lambda$3.lambdaFactory$(this, view, states, window, ids, xs, ys));
    }

    private void postPoint(Window window, View view, int state, TouchState.Point p) {
        int id = p.id;
        int x = p.x;
        int y = p.y;
        RunnableProcessor.runLater(TouchInput$$Lambda$4.lambdaFactory$(this, view, window, state, id, x, y));
    }

    private void postNoPoints(View view) {
        RunnableProcessor.runLater(TouchInput$$Lambda$5.lambdaFactory$(this, view));
    }

    private void postTouchEvent(TouchState state, int eventType) {
        View view;
        MonocleWindow window = state.getWindow(false, null);
        View view2 = view = window == null ? null : window.getView();
        if (view != null) {
            switch (state.getPointCount()) {
                case 0: {
                    this.postNoPoints(view);
                    break;
                }
                case 1: {
                    this.postPoint(window, view, eventType, state.getPoint(0));
                    break;
                }
                default: {
                    int count = state.getPointCount();
                    int[] states = new int[count];
                    int[] ids = new int[count];
                    int[] xs = new int[count];
                    int[] ys = new int[count];
                    for (int i = 0; i < count; ++i) {
                        states[i] = eventType;
                        TouchState.Point p = state.getPoint(i);
                        ids[i] = p.id;
                        xs[i] = p.x;
                        ys[i] = p.y;
                    }
                    this.postPoints(window, view, states, ids, xs, ys);
                }
            }
        }
    }

    private void postTouchEvent(MonocleWindow window, View view, TouchState newState) {
        int count = this.countEvents(newState);
        switch (count) {
            case 0: {
                this.postNoPoints(view);
                break;
            }
            case 1: {
                if (this.state.getPointCount() == 1) {
                    TouchState.Point oldPoint = this.state.getPoint(0);
                    TouchState.Point newPoint = newState.getPointForID(oldPoint.id);
                    if (newPoint != null) {
                        if (newPoint.x == oldPoint.x && newPoint.y == oldPoint.y) {
                            this.postPoint(window, view, 814, newPoint);
                            break;
                        }
                        this.postPoint(window, view, 812, newPoint);
                        break;
                    }
                    this.postPoint(window, view, 813, oldPoint);
                    break;
                }
                this.postPoint(window, view, 811, newState.getPoint(0));
                break;
            }
            default: {
                TouchState.Point newPoint;
                int i;
                int[] states = new int[count];
                int[] ids = new int[count];
                int[] xs = new int[count];
                int[] ys = new int[count];
                for (i = 0; i < this.state.getPointCount(); ++i) {
                    TouchState.Point oldPoint = this.state.getPoint(i);
                    newPoint = newState.getPointForID(oldPoint.id);
                    if (newPoint != null) {
                        ids[i] = newPoint.id;
                        xs[i] = newPoint.x;
                        ys[i] = newPoint.y;
                        if (newPoint.x == oldPoint.x && newPoint.y == oldPoint.y) {
                            states[i] = 814;
                            continue;
                        }
                        states[i] = 812;
                        continue;
                    }
                    states[i] = 813;
                    ids[i] = oldPoint.id;
                    xs[i] = oldPoint.x;
                    ys[i] = oldPoint.y;
                }
                int j = this.state.getPointCount();
                for (i = 0; i < newState.getPointCount(); ++i) {
                    newPoint = newState.getPoint(i);
                    TouchState.Point oldPoint = this.state.getPointForID(newPoint.id);
                    if (oldPoint != null) continue;
                    states[j] = 811;
                    ids[j] = newPoint.id;
                    xs[j] = newPoint.x;
                    ys[j] = newPoint.y;
                    ++j;
                }
                this.postPoints(window, view, states, ids, xs, ys);
            }
        }
    }

    private int countEvents(TouchState newState) {
        int count = this.state.getPointCount();
        for (int i = 0; i < newState.getPointCount(); ++i) {
            TouchState.Point newPoint = newState.getPoint(i);
            TouchState.Point oldPoint = this.state.getPointForID(newPoint.id);
            if (oldPoint != null) continue;
            ++count;
        }
        return count;
    }

    int getTouchRadius() {
        return this.touchRadius;
    }

    /* synthetic */ void lambda$postNoPoints$82(View view) {
        this.touches.notifyBeginTouchEvent(view, 0, true, 0);
        this.touches.notifyEndTouchEvent(view);
    }

    /* synthetic */ void lambda$postPoint$81(View view, Window window, int n, int n2, int n3, int n4) {
        this.touches.notifyBeginTouchEvent(view, 0, true, 1);
        this.dispatchPoint(window, view, n, n2, n3, n4);
        this.touches.notifyEndTouchEvent(view);
    }

    /* synthetic */ void lambda$postPoints$80(View view, int[] nArray, Window window, int[] nArray2, int[] nArray3, int[] nArray4) {
        this.touches.notifyBeginTouchEvent(view, 0, true, nArray.length);
        for (int i = 0; i < nArray.length; ++i) {
            this.dispatchPoint(window, view, nArray[i], nArray2[i], nArray3[i], nArray4[i]);
        }
        this.touches.notifyEndTouchEvent(view);
    }

    static /* synthetic */ String lambda$getBasePipeline$79() {
        return System.getProperty("monocle.input.touchFilters", "SmallMove");
    }

    static /* synthetic */ Integer lambda$new$78() {
        return Integer.getInteger("monocle.input.touchRadius", 20);
    }
}

