/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.utils;

import com.sun.glass.utils.NativeLibLoader$$Lambda$1;
import java.io.File;
import java.net.URI;
import java.security.AccessController;
import java.util.HashSet;

public class NativeLibLoader {
    private static final HashSet<String> loaded = new HashSet();
    private static boolean verbose = false;
    private static File libDir = null;
    private static String libPrefix = "";
    private static String libSuffix = "";

    public static synchronized void loadLibrary(String libname) {
        if (!loaded.contains(libname)) {
            NativeLibLoader.loadLibraryInternal(libname);
            loaded.add(libname);
        }
    }

    private static String[] initializePath(String propname) {
        String ldpath = System.getProperty(propname, "");
        String ps = File.pathSeparator;
        int ldlen = ldpath.length();
        int i = ldpath.indexOf(ps);
        int n = 0;
        while (i >= 0) {
            ++n;
            i = ldpath.indexOf(ps, i + 1);
        }
        String[] paths = new String[n + 1];
        i = 0;
        n = 0;
        int j = ldpath.indexOf(ps);
        while (j >= 0) {
            if (j - i > 0) {
                paths[n++] = ldpath.substring(i, j);
            } else if (j - i == 0) {
                paths[n++] = ".";
            }
            i = j + 1;
            j = ldpath.indexOf(ps, i);
        }
        paths[n] = ldpath.substring(i, ldlen);
        return paths;
    }

    private static void loadLibraryInternal(String libraryName) {
        try {
            NativeLibLoader.loadLibraryFullPath(libraryName);
        }
        catch (UnsatisfiedLinkError ex) {
            String[] libPath = NativeLibLoader.initializePath("java.library.path");
            for (int i = 0; i < libPath.length; ++i) {
                try {
                    String path = libPath[i];
                    if (!path.endsWith(File.separator)) {
                        path = path + File.separator;
                    }
                    String fileName = System.mapLibraryName(libraryName);
                    File libFile = new File(path + fileName);
                    System.load(libFile.getAbsolutePath());
                    if (verbose) {
                        System.err.println("Loaded " + libFile.getAbsolutePath() + " from java.library.path");
                    }
                    return;
                }
                catch (UnsatisfiedLinkError ex3) {
                    continue;
                }
            }
            try {
                System.loadLibrary(libraryName);
                if (verbose) {
                    System.err.println("WARNING: " + ex.toString());
                    System.err.println("    using System.loadLibrary(" + libraryName + ") as a fallback");
                }
            }
            catch (UnsatisfiedLinkError ex2) {
                if ("iOS".equals(System.getProperty("os.name")) && libraryName.contains("-")) {
                    libraryName = libraryName.replace("-", "_");
                    System.loadLibrary(libraryName);
                    return;
                }
                throw ex;
            }
        }
    }

    private static void loadLibraryFullPath(String libraryName) {
        try {
            if (libDir == null) {
                Class<NativeLibLoader> theClass = NativeLibLoader.class;
                String theClassFile = "NativeLibLoader.class";
                String classUrlString = theClass.getResource(theClassFile).toString();
                if (!classUrlString.startsWith("jar:file:") || classUrlString.indexOf(33) == -1) {
                    throw new UnsatisfiedLinkError("Invalid URL for class: " + classUrlString);
                }
                String tmpStr = classUrlString.substring(4, classUrlString.lastIndexOf(33));
                int lastIndexOfSlash = Math.max(tmpStr.lastIndexOf(47), tmpStr.lastIndexOf(92));
                String osName = System.getProperty("os.name");
                String relativeDir = null;
                if (osName.startsWith("Windows")) {
                    relativeDir = "../../bin";
                } else if (osName.startsWith("Mac")) {
                    relativeDir = "..";
                } else if (osName.startsWith("Linux")) {
                    relativeDir = "../" + System.getProperty("os.arch");
                }
                String libDirUrlString = tmpStr.substring(0, lastIndexOfSlash) + "/" + relativeDir;
                libDir = new File(new URI(libDirUrlString).getPath());
                if (osName.startsWith("Windows")) {
                    libPrefix = "";
                    libSuffix = ".dll";
                } else if (osName.startsWith("Mac")) {
                    libPrefix = "lib";
                    libSuffix = ".dylib";
                } else if (osName.startsWith("Linux")) {
                    libPrefix = "lib";
                    libSuffix = ".so";
                }
            }
            File libFile = new File(libDir, libPrefix + libraryName + libSuffix);
            String libFileName = libFile.getCanonicalPath();
            System.load(libFileName);
            if (verbose) {
                System.err.println("Loaded " + libFile.getAbsolutePath() + " from relative path");
            }
        }
        catch (Exception e) {
            throw (UnsatisfiedLinkError)new UnsatisfiedLinkError().initCause(e);
        }
    }

    static /* synthetic */ Object lambda$static$131() {
        verbose = Boolean.getBoolean("javafx.verbose");
        return null;
    }

    static {
        AccessController.doPrivileged(NativeLibLoader$$Lambda$1.lambdaFactory$());
    }
}

