/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.application;

import com.sun.javafx.application.LauncherImpl$$Lambda$1;
import com.sun.javafx.application.LauncherImpl$$Lambda$10;
import com.sun.javafx.application.LauncherImpl$$Lambda$11;
import com.sun.javafx.application.LauncherImpl$$Lambda$12;
import com.sun.javafx.application.LauncherImpl$$Lambda$13;
import com.sun.javafx.application.LauncherImpl$$Lambda$14;
import com.sun.javafx.application.LauncherImpl$$Lambda$2;
import com.sun.javafx.application.LauncherImpl$$Lambda$3;
import com.sun.javafx.application.LauncherImpl$$Lambda$4;
import com.sun.javafx.application.LauncherImpl$$Lambda$5;
import com.sun.javafx.application.LauncherImpl$$Lambda$6;
import com.sun.javafx.application.LauncherImpl$$Lambda$7;
import com.sun.javafx.application.LauncherImpl$$Lambda$8;
import com.sun.javafx.application.LauncherImpl$$Lambda$9;
import com.sun.javafx.application.ParametersImpl;
import com.sun.javafx.application.PlatformImpl;
import com.sun.javafx.jmx.MXExtension;
import com.sun.javafx.runtime.SystemProperties;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Base64;
import java.util.LinkedList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javafx.application.Application;
import javafx.application.Preloader;
import javafx.stage.Stage;

public class LauncherImpl {
    public static final String LAUNCH_MODE_CLASS = "LM_CLASS";
    public static final String LAUNCH_MODE_JAR = "LM_JAR";
    private static final boolean trace = false;
    private static boolean verbose = false;
    private static final String MF_MAIN_CLASS = "Main-Class";
    private static final String MF_JAVAFX_MAIN = "JavaFX-Application-Class";
    private static final String MF_JAVAFX_PRELOADER = "JavaFX-Preloader-Class";
    private static final String MF_JAVAFX_CLASS_PATH = "JavaFX-Class-Path";
    private static final String MF_JAVAFX_FEATURE_PROXY = "JavaFX-Feature-Proxy";
    private static final String MF_JAVAFX_ARGUMENT_PREFIX = "JavaFX-Argument-";
    private static final String MF_JAVAFX_PARAMETER_NAME_PREFIX = "JavaFX-Parameter-Name-";
    private static final String MF_JAVAFX_PARAMETER_VALUE_PREFIX = "JavaFX-Parameter-Value-";
    private static final boolean simulateSlowProgress = false;
    private static AtomicBoolean launchCalled = new AtomicBoolean(false);
    private static final AtomicBoolean toolkitStarted = new AtomicBoolean(false);
    private static volatile RuntimeException launchException = null;
    private static Preloader currentPreloader = null;
    private static Class<? extends Preloader> savedPreloaderClass = null;
    private static ClassLoader savedMainCcl = null;
    private static volatile boolean error = false;
    private static volatile Throwable pConstructorError = null;
    private static volatile Throwable pInitError = null;
    private static volatile Throwable pStartError = null;
    private static volatile Throwable pStopError = null;
    private static volatile Throwable constructorError = null;
    private static volatile Throwable initError = null;
    private static volatile Throwable startError = null;
    private static volatile Throwable stopError = null;
    private static Method notifyMethod = null;

    public static void launchApplication(Class<? extends Application> appClass, String[] args) {
        String preloaderByProperty;
        Class<Preloader> preloaderClass = savedPreloaderClass;
        if (preloaderClass == null && (preloaderByProperty = (String)AccessController.doPrivileged(LauncherImpl$$Lambda$1.lambdaFactory$())) != null) {
            try {
                preloaderClass = Class.forName(preloaderByProperty, false, appClass.getClassLoader());
            }
            catch (Exception e) {
                System.err.printf("Could not load preloader class '" + preloaderByProperty + "', continuing without preloader.", new Object[0]);
                e.printStackTrace();
            }
        }
        LauncherImpl.launchApplication(appClass, preloaderClass, args);
    }

    public static void launchApplication(Class<? extends Application> appClass, Class<? extends Preloader> preloaderClass, String[] args) {
        if (launchCalled.getAndSet(true)) {
            throw new IllegalStateException("Application launch must not be called more than once");
        }
        if (!Application.class.isAssignableFrom(appClass)) {
            throw new IllegalArgumentException("Error: " + appClass.getName() + " is not a subclass of javafx.application.Application");
        }
        if (preloaderClass != null && !Preloader.class.isAssignableFrom(preloaderClass)) {
            throw new IllegalArgumentException("Error: " + preloaderClass.getName() + " is not a subclass of javafx.application.Preloader");
        }
        CountDownLatch launchLatch = new CountDownLatch(1);
        Thread launcherThread = new Thread(LauncherImpl$$Lambda$2.lambdaFactory$(appClass, preloaderClass, args, launchLatch));
        launcherThread.setName("JavaFX-Launcher");
        launcherThread.start();
        try {
            launchLatch.await();
        }
        catch (InterruptedException ex) {
            throw new RuntimeException("Unexpected exception: ", ex);
        }
        if (launchException != null) {
            throw launchException;
        }
    }

    public static void launchApplication(String launchName, String launchMode, String[] args) {
        if (verbose) {
            System.err.println("Java 8 launchApplication method: launchMode=" + launchMode);
        }
        String mainClassName = null;
        String preloaderClassName = null;
        String[] appArgs = args;
        ClassLoader appLoader = null;
        verbose = Boolean.getBoolean("javafx.verbose");
        if (launchMode.equals(LAUNCH_MODE_JAR)) {
            String proxySetting;
            String fxClassPath;
            Attributes jarAttrs = LauncherImpl.getJarAttributes(launchName);
            if (jarAttrs == null) {
                LauncherImpl.abort(null, "Can't get manifest attributes from jar", new Object[0]);
            }
            if ((fxClassPath = jarAttrs.getValue(MF_JAVAFX_CLASS_PATH)) != null) {
                if (fxClassPath.trim().length() == 0) {
                    fxClassPath = null;
                } else {
                    if (verbose) {
                        System.err.println("WARNING: Application jar uses deprecated JavaFX-Class-Path attribute. Please use Class-Path instead.");
                    }
                    appLoader = LauncherImpl.setupJavaFXClassLoader(new File(launchName), fxClassPath);
                }
            }
            if ((proxySetting = jarAttrs.getValue(MF_JAVAFX_FEATURE_PROXY)) != null && "auto".equals(proxySetting.toLowerCase())) {
                LauncherImpl.trySetAutoProxy();
            }
            if (args.length == 0) {
                appArgs = LauncherImpl.getAppArguments(jarAttrs);
            }
            if ((mainClassName = jarAttrs.getValue(MF_JAVAFX_MAIN)) == null && (mainClassName = jarAttrs.getValue(MF_MAIN_CLASS)) == null) {
                LauncherImpl.abort(null, "JavaFX jar manifest requires a valid JavaFX-Appliation-Class or Main-Class entry", new Object[0]);
            }
            mainClassName = mainClassName.trim();
            preloaderClassName = jarAttrs.getValue(MF_JAVAFX_PRELOADER);
            if (preloaderClassName != null) {
                preloaderClassName = preloaderClassName.trim();
            }
        } else if (launchMode.equals(LAUNCH_MODE_CLASS)) {
            mainClassName = launchName;
            preloaderClassName = System.getProperty("javafx.preloader");
        } else {
            LauncherImpl.abort(new IllegalArgumentException("The launchMode argument must be one of LM_CLASS or LM_JAR"), "Invalid launch mode: %1$s", launchMode);
        }
        if (mainClassName == null) {
            LauncherImpl.abort(null, "No main JavaFX class to launch", new Object[0]);
        }
        if (appLoader != null) {
            try {
                Class<?> launcherClass = appLoader.loadClass(LauncherImpl.class.getName());
                Method lawa = launcherClass.getMethod("launchApplicationWithArgs", String.class, String.class, new String[0].getClass());
                Thread.currentThread().setContextClassLoader(appLoader);
                lawa.invoke(null, mainClassName, preloaderClassName, appArgs);
            }
            catch (Exception e) {
                LauncherImpl.abort(e, "Exception while launching application", new Object[0]);
            }
        } else {
            LauncherImpl.launchApplicationWithArgs(mainClassName, preloaderClassName, appArgs);
        }
    }

    public static void launchApplicationWithArgs(String mainClassName, String preloaderClassName, String[] args) {
        try {
            LauncherImpl.startToolkit();
        }
        catch (InterruptedException ex) {
            LauncherImpl.abort(ex, "Toolkit initialization error", mainClassName);
        }
        Class preClass = null;
        Class tempAppClass = null;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        AtomicReference tmpClassRef = new AtomicReference();
        AtomicReference preClassRef = new AtomicReference();
        PlatformImpl.runAndWait(LauncherImpl$$Lambda$3.lambdaFactory$(mainClassName, loader, tmpClassRef, preloaderClassName, preClassRef));
        preClass = (Class)preClassRef.get();
        tempAppClass = (Class)tmpClassRef.get();
        savedPreloaderClass = preClass;
        ReflectiveOperationException theEx = null;
        try {
            Method mainMethod = tempAppClass.getMethod("main", new String[0].getClass());
            if (verbose) {
                System.err.println("Calling main(String[]) method");
            }
            savedMainCcl = Thread.currentThread().getContextClassLoader();
            mainMethod.invoke(null, new Object[]{args});
            return;
        }
        catch (IllegalAccessException | NoSuchMethodException ex) {
            theEx = ex;
            savedPreloaderClass = null;
        }
        catch (InvocationTargetException ex) {
            ex.printStackTrace();
            LauncherImpl.abort(null, "Exception running application %1$s", tempAppClass.getName());
            return;
        }
        if (!Application.class.isAssignableFrom(tempAppClass)) {
            LauncherImpl.abort(theEx, "JavaFX application class %1$s does not extend javafx.application.Application", tempAppClass.getName());
        }
        Class<Application> appClass = tempAppClass.asSubclass(Application.class);
        if (verbose) {
            System.err.println("Launching application directly");
        }
        LauncherImpl.launchApplication(appClass, preClass, args);
    }

    private static URL fileToURL(File file) throws IOException {
        return file.getCanonicalFile().toURI().toURL();
    }

    private static ClassLoader setupJavaFXClassLoader(File appJar, String fxClassPath) {
        try {
            File baseDir = appJar.getParentFile();
            ArrayList<URL> jcpList = new ArrayList<URL>();
            String cp = fxClassPath;
            if (cp != null) {
                while (cp.length() > 0) {
                    File f;
                    String pathElem;
                    int pathSepIdx = cp.indexOf(" ");
                    if (pathSepIdx < 0) {
                        pathElem = cp;
                        File file = f = baseDir == null ? new File(pathElem) : new File(baseDir, pathElem);
                        if (f.exists()) {
                            jcpList.add(LauncherImpl.fileToURL(f));
                            break;
                        }
                        if (!verbose) break;
                        System.err.println("Class Path entry \"" + pathElem + "\" does not exist, ignoring");
                        break;
                    }
                    if (pathSepIdx > 0) {
                        pathElem = cp.substring(0, pathSepIdx);
                        File file = f = baseDir == null ? new File(pathElem) : new File(baseDir, pathElem);
                        if (f.exists()) {
                            jcpList.add(LauncherImpl.fileToURL(f));
                        } else if (verbose) {
                            System.err.println("Class Path entry \"" + pathElem + "\" does not exist, ignoring");
                        }
                    }
                    cp = cp.substring(pathSepIdx + 1);
                }
            }
            if (!jcpList.isEmpty()) {
                ArrayList<URL> urlList = new ArrayList<URL>();
                cp = System.getProperty("java.class.path");
                if (cp != null) {
                    while (cp.length() > 0) {
                        String pathElem;
                        int pathSepIdx = cp.indexOf(File.pathSeparatorChar);
                        if (pathSepIdx < 0) {
                            pathElem = cp;
                            urlList.add(LauncherImpl.fileToURL(new File(pathElem)));
                            break;
                        }
                        if (pathSepIdx > 0) {
                            pathElem = cp.substring(0, pathSepIdx);
                            urlList.add(LauncherImpl.fileToURL(new File(pathElem)));
                        }
                        cp = cp.substring(pathSepIdx + 1);
                    }
                }
                URL jfxRtURL = LauncherImpl.class.getProtectionDomain().getCodeSource().getLocation();
                urlList.add(jfxRtURL);
                urlList.addAll(jcpList);
                URL[] urls = urlList.toArray(new URL[0]);
                if (verbose) {
                    System.err.println("===== URL list");
                    for (int i = 0; i < urls.length; ++i) {
                        System.err.println("" + urls[i]);
                    }
                    System.err.println("=====");
                }
                return new URLClassLoader(urls, null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static void trySetAutoProxy() {
        block9: {
            URL[] deployURLs;
            if (System.getProperty("http.proxyHost") != null || System.getProperty("https.proxyHost") != null || System.getProperty("ftp.proxyHost") != null || System.getProperty("socksProxyHost") != null) {
                if (verbose) {
                    System.out.println("Explicit proxy settings detected. Skip autoconfig.");
                    System.out.println("  http.proxyHost=" + System.getProperty("http.proxyHost"));
                    System.out.println("  https.proxyHost=" + System.getProperty("https.proxyHost"));
                    System.out.println("  ftp.proxyHost=" + System.getProperty("ftp.proxyHost"));
                    System.out.println("  socksProxyHost=" + System.getProperty("socksProxyHost"));
                }
                return;
            }
            if (System.getProperty("javafx.autoproxy.disable") != null) {
                if (verbose) {
                    System.out.println("Disable autoproxy on request.");
                }
                return;
            }
            String javaHome = System.getProperty("java.home");
            File jreLibDir = new File(javaHome, "lib");
            File deployJar = new File(jreLibDir, "deploy.jar");
            try {
                deployURLs = new URL[]{deployJar.toURI().toURL()};
            }
            catch (MalformedURLException ex) {
                return;
            }
            try {
                URLClassLoader dcl = new URLClassLoader(deployURLs);
                Class<?> sm = Class.forName("com.sun.deploy.services.ServiceManager", true, dcl);
                Class[] params = new Class[]{Integer.TYPE};
                Method setservice = sm.getDeclaredMethod("setService", params);
                String osname = System.getProperty("os.name");
                String servicename = osname.startsWith("Win") ? "STANDALONE_TIGER_WIN32" : (osname.contains("Mac") ? "STANDALONE_TIGER_MACOSX" : "STANDALONE_TIGER_UNIX");
                Object[] values = new Object[1];
                Class<?> pt = Class.forName("com.sun.deploy.services.PlatformType", true, dcl);
                values[0] = pt.getField(servicename).get(null);
                setservice.invoke(null, values);
                Class<?> dps = Class.forName("com.sun.deploy.net.proxy.DeployProxySelector", true, dcl);
                Method m = dps.getDeclaredMethod("reset", new Class[0]);
                m.invoke(null, new Object[0]);
                if (verbose) {
                    System.out.println("Autoconfig of proxy is completed.");
                }
            }
            catch (Exception e) {
                if (!verbose) break block9;
                System.err.println("Failed to autoconfig proxy due to " + e);
            }
        }
    }

    private static String decodeBase64(String inp) throws IOException {
        return new String(Base64.getDecoder().decode(inp));
    }

    private static String[] getAppArguments(Attributes attrs) {
        LinkedList<String> args = new LinkedList<String>();
        try {
            int idx = 1;
            String argNamePrefix = MF_JAVAFX_ARGUMENT_PREFIX;
            while (attrs.getValue(argNamePrefix + idx) != null) {
                args.add(LauncherImpl.decodeBase64(attrs.getValue(argNamePrefix + idx)));
                ++idx;
            }
            String paramNamePrefix = MF_JAVAFX_PARAMETER_NAME_PREFIX;
            String paramValuePrefix = MF_JAVAFX_PARAMETER_VALUE_PREFIX;
            idx = 1;
            while (attrs.getValue(paramNamePrefix + idx) != null) {
                String k = LauncherImpl.decodeBase64(attrs.getValue(paramNamePrefix + idx));
                String v = null;
                if (attrs.getValue(paramValuePrefix + idx) != null) {
                    v = LauncherImpl.decodeBase64(attrs.getValue(paramValuePrefix + idx));
                }
                args.add("--" + k + "=" + (v != null ? v : ""));
                ++idx;
            }
        }
        catch (IOException ioe) {
            if (verbose) {
                System.err.println("Failed to extract application parameters");
            }
            ioe.printStackTrace();
        }
        return args.toArray(new String[0]);
    }

    private static void abort(Throwable cause, String fmt, Object ... args) {
        String msg = String.format(fmt, args);
        if (msg != null) {
            System.err.println(msg);
        }
        System.exit(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Attributes getJarAttributes(String jarPath) {
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(jarPath);
            Manifest manifest = jarFile.getManifest();
            if (manifest == null) {
                LauncherImpl.abort(null, "No manifest in jar file %1$s", jarPath);
            }
            Attributes attributes = manifest.getMainAttributes();
            return attributes;
        }
        catch (IOException ioe) {
            LauncherImpl.abort(ioe, "Error launching jar file %1%s", jarPath);
        }
        finally {
            try {
                jarFile.close();
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    private static void startToolkit() throws InterruptedException {
        if (toolkitStarted.getAndSet(true)) {
            return;
        }
        if (SystemProperties.isDebug()) {
            MXExtension.initializeIfAvailable();
        }
        CountDownLatch startupLatch = new CountDownLatch(1);
        PlatformImpl.startup(LauncherImpl$$Lambda$4.lambdaFactory$(startupLatch));
        startupLatch.await();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void launchApplication1(Class<? extends Application> appClass, Class<? extends Preloader> preloaderClass, String[] args) throws Exception {
        boolean isJavaws;
        PlatformImpl.FinishListener listener;
        block33: {
            ClassLoader ccl;
            LauncherImpl.startToolkit();
            if (savedMainCcl != null && (ccl = Thread.currentThread().getContextClassLoader()) != null && ccl != savedMainCcl) {
                PlatformImpl.runLater(LauncherImpl$$Lambda$5.lambdaFactory$(ccl));
            }
            final AtomicBoolean pStartCalled = new AtomicBoolean(false);
            final AtomicBoolean startCalled = new AtomicBoolean(false);
            final AtomicBoolean exitCalled = new AtomicBoolean(false);
            AtomicBoolean pExitCalled = new AtomicBoolean(false);
            final CountDownLatch shutdownLatch = new CountDownLatch(1);
            final CountDownLatch pShutdownLatch = new CountDownLatch(1);
            listener = new PlatformImpl.FinishListener(){

                @Override
                public void idle(boolean implicitExit) {
                    if (!implicitExit) {
                        return;
                    }
                    if (startCalled.get()) {
                        shutdownLatch.countDown();
                    } else if (pStartCalled.get()) {
                        pShutdownLatch.countDown();
                    }
                }

                @Override
                public void exitCalled() {
                    exitCalled.set(true);
                    shutdownLatch.countDown();
                }
            };
            PlatformImpl.addListener(listener);
            try {
                String msg;
                AtomicReference pldr = new AtomicReference();
                if (preloaderClass != null) {
                    PlatformImpl.runAndWait(LauncherImpl$$Lambda$6.lambdaFactory$(preloaderClass, pldr, args));
                }
                if ((currentPreloader = (Preloader)pldr.get()) != null && !error && !exitCalled.get()) {
                    try {
                        currentPreloader.init();
                    }
                    catch (Throwable t) {
                        System.err.println("Exception in Preloader init method");
                        pInitError = t;
                        error = true;
                    }
                }
                if (currentPreloader != null && !error && !exitCalled.get()) {
                    PlatformImpl.runAndWait(LauncherImpl$$Lambda$7.lambdaFactory$(pStartCalled));
                    if (!error && !exitCalled.get()) {
                        LauncherImpl.notifyProgress(currentPreloader, 0.0);
                    }
                }
                AtomicReference app = new AtomicReference();
                if (!error && !exitCalled.get()) {
                    if (currentPreloader != null) {
                        LauncherImpl.notifyProgress(currentPreloader, 1.0);
                        LauncherImpl.notifyStateChange(currentPreloader, Preloader.StateChangeNotification.Type.BEFORE_LOAD, null);
                    }
                    PlatformImpl.runAndWait(LauncherImpl$$Lambda$8.lambdaFactory$(appClass, app, args));
                }
                Application theApp = (Application)app.get();
                if (!error && !exitCalled.get()) {
                    if (currentPreloader != null) {
                        LauncherImpl.notifyStateChange(currentPreloader, Preloader.StateChangeNotification.Type.BEFORE_INIT, theApp);
                    }
                    try {
                        theApp.init();
                    }
                    catch (Throwable t) {
                        System.err.println("Exception in Application init method");
                        initError = t;
                        error = true;
                    }
                }
                if (!error && !exitCalled.get()) {
                    if (currentPreloader != null) {
                        LauncherImpl.notifyStateChange(currentPreloader, Preloader.StateChangeNotification.Type.BEFORE_START, theApp);
                    }
                    PlatformImpl.runAndWait(LauncherImpl$$Lambda$9.lambdaFactory$(startCalled, theApp));
                }
                if (!error) {
                    shutdownLatch.await();
                }
                if (startCalled.get()) {
                    PlatformImpl.runAndWait(LauncherImpl$$Lambda$10.lambdaFactory$(theApp));
                }
                if (!error) break block33;
                if (pConstructorError != null) {
                    throw new RuntimeException("Unable to construct Preloader instance: " + appClass, pConstructorError);
                }
                if (pInitError != null) {
                    throw new RuntimeException("Exception in Preloader init method", pInitError);
                }
                if (pStartError != null) {
                    throw new RuntimeException("Exception in Preloader start method", pStartError);
                }
                if (pStopError != null) {
                    throw new RuntimeException("Exception in Preloader stop method", pStopError);
                }
                if (constructorError != null) {
                    String msg2 = "Unable to construct Application instance: " + appClass;
                    if (!LauncherImpl.notifyError(msg2, constructorError)) {
                        throw new RuntimeException(msg2, constructorError);
                    }
                    break block33;
                }
                if (initError != null) {
                    String msg3 = "Exception in Application init method";
                    if (!LauncherImpl.notifyError(msg3, initError)) {
                        throw new RuntimeException(msg3, initError);
                    }
                    break block33;
                }
                if (startError != null) {
                    String msg4 = "Exception in Application start method";
                    if (!LauncherImpl.notifyError(msg4, startError)) {
                        throw new RuntimeException(msg4, startError);
                    }
                    break block33;
                }
                if (stopError == null || LauncherImpl.notifyError(msg = "Exception in Application stop method", stopError)) break block33;
                throw new RuntimeException(msg, stopError);
            }
            catch (Throwable throwable) {
                boolean isJavaws2;
                PlatformImpl.removeListener(listener);
                boolean bl = isJavaws2 = System.getSecurityManager() != null;
                if (error && isJavaws2) {
                    System.err.println("Workaround until RT-13281 is implemented: keep toolkit alive");
                } else {
                    PlatformImpl.tkExit();
                }
                throw throwable;
            }
        }
        PlatformImpl.removeListener(listener);
        boolean bl = isJavaws = System.getSecurityManager() != null;
        if (error && isJavaws) {
            System.err.println("Workaround until RT-13281 is implemented: keep toolkit alive");
        } else {
            PlatformImpl.tkExit();
        }
    }

    private static void notifyStateChange(Preloader preloader, Preloader.StateChangeNotification.Type type, Application app) {
        PlatformImpl.runAndWait(LauncherImpl$$Lambda$11.lambdaFactory$(preloader, type, app));
    }

    private static void notifyProgress(Preloader preloader, double d) {
        PlatformImpl.runAndWait(LauncherImpl$$Lambda$12.lambdaFactory$(preloader, d));
    }

    private static boolean notifyError(String msg, Throwable constructorError) {
        AtomicBoolean result = new AtomicBoolean(false);
        PlatformImpl.runAndWait(LauncherImpl$$Lambda$13.lambdaFactory$(msg, constructorError, result));
        return result.get();
    }

    private static void notifyCurrentPreloader(Preloader.PreloaderNotification pe) {
        PlatformImpl.runAndWait(LauncherImpl$$Lambda$14.lambdaFactory$(pe));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void notifyPreloader(Application app, Preloader.PreloaderNotification info) {
        if (launchCalled.get()) {
            LauncherImpl.notifyCurrentPreloader(info);
            return;
        }
        Class<LauncherImpl> clazz = LauncherImpl.class;
        synchronized (LauncherImpl.class) {
            if (notifyMethod == null) {
                String fxPreloaderClassName = "com.sun.deploy.uitoolkit.impl.fx.FXPreloader";
                try {
                    Class<?> fxPreloaderClass = Class.forName("com.sun.deploy.uitoolkit.impl.fx.FXPreloader");
                    notifyMethod = fxPreloaderClass.getMethod("notifyCurrentPreloader", Preloader.PreloaderNotification.class);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            try {
                notifyMethod.invoke(null, info);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            return;
        }
    }

    private LauncherImpl() {
        throw new InternalError();
    }

    static /* synthetic */ void lambda$notifyCurrentPreloader$147(Preloader.PreloaderNotification preloaderNotification) {
        if (currentPreloader != null) {
            currentPreloader.handleApplicationNotification(preloaderNotification);
        }
    }

    static /* synthetic */ void lambda$notifyError$146(String string, Throwable throwable, AtomicBoolean atomicBoolean) {
        if (currentPreloader != null) {
            try {
                Preloader.ErrorNotification evt = new Preloader.ErrorNotification(null, string, throwable);
                boolean rval = currentPreloader.handleErrorNotification(evt);
                atomicBoolean.set(rval);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    static /* synthetic */ void lambda$notifyProgress$145(Preloader preloader, double d) {
        preloader.handleProgressNotification(new Preloader.ProgressNotification(d));
    }

    static /* synthetic */ void lambda$notifyStateChange$144(Preloader preloader, Preloader.StateChangeNotification.Type type, Application application) {
        preloader.handleStateChangeNotification(new Preloader.StateChangeNotification(type, application));
    }

    static /* synthetic */ void lambda$launchApplication1$143(Application application) {
        try {
            application.stop();
        }
        catch (Throwable t) {
            System.err.println("Exception in Application stop method");
            stopError = t;
            error = true;
        }
    }

    static /* synthetic */ void lambda$launchApplication1$142(AtomicBoolean atomicBoolean, Application application) {
        try {
            atomicBoolean.set(true);
            Stage primaryStage = new Stage();
            primaryStage.impl_setPrimary(true);
            application.start(primaryStage);
        }
        catch (Throwable t) {
            System.err.println("Exception in Application start method");
            startError = t;
            error = true;
        }
    }

    static /* synthetic */ void lambda$launchApplication1$141(Class clazz, AtomicReference atomicReference, String[] stringArray) {
        try {
            Constructor c = clazz.getConstructor(new Class[0]);
            atomicReference.set(c.newInstance(new Object[0]));
            ParametersImpl.registerParameters((Application)atomicReference.get(), new ParametersImpl(stringArray));
            PlatformImpl.setApplicationName(clazz);
        }
        catch (Throwable t) {
            System.err.println("Exception in Application constructor");
            constructorError = t;
            error = true;
        }
    }

    static /* synthetic */ void lambda$launchApplication1$140(AtomicBoolean atomicBoolean) {
        try {
            atomicBoolean.set(true);
            Stage primaryStage = new Stage();
            primaryStage.impl_setPrimary(true);
            currentPreloader.start(primaryStage);
        }
        catch (Throwable t) {
            System.err.println("Exception in Preloader start method");
            pStartError = t;
            error = true;
        }
    }

    static /* synthetic */ void lambda$launchApplication1$139(Class clazz, AtomicReference atomicReference, String[] stringArray) {
        try {
            Constructor c = clazz.getConstructor(new Class[0]);
            atomicReference.set(c.newInstance(new Object[0]));
            ParametersImpl.registerParameters((Application)atomicReference.get(), new ParametersImpl(stringArray));
        }
        catch (Throwable t) {
            System.err.println("Exception in Preloader constructor");
            pConstructorError = t;
            error = true;
        }
    }

    static /* synthetic */ void lambda$launchApplication1$138(ClassLoader classLoader) {
        Thread.currentThread().setContextClassLoader(classLoader);
    }

    static /* synthetic */ void lambda$startToolkit$137(CountDownLatch countDownLatch) {
        countDownLatch.countDown();
    }

    static /* synthetic */ void lambda$launchApplicationWithArgs$136(String string, ClassLoader classLoader, AtomicReference atomicReference, String string2, AtomicReference atomicReference2) {
        Class<?> clz = null;
        try {
            clz = Class.forName(string, true, classLoader);
        }
        catch (ClassNotFoundException cnfe) {
            LauncherImpl.abort(cnfe, "Missing JavaFX application class %1$s", string);
        }
        atomicReference.set(clz);
        if (string2 != null) {
            try {
                clz = Class.forName(string2, true, classLoader);
            }
            catch (ClassNotFoundException cnfe) {
                LauncherImpl.abort(cnfe, "Missing JavaFX preloader class %1$s", string2);
            }
            if (!Preloader.class.isAssignableFrom(clz)) {
                LauncherImpl.abort(null, "JavaFX preloader class %1$s does not extend javafx.application.Preloader", clz.getName());
            }
            atomicReference2.set(clz.asSubclass(Preloader.class));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static /* synthetic */ void lambda$launchApplication$135(Class clazz, Class clazz2, String[] stringArray, CountDownLatch countDownLatch) {
        try {
            LauncherImpl.launchApplication1(clazz, clazz2, stringArray);
        }
        catch (RuntimeException rte) {
            launchException = rte;
        }
        catch (Exception ex) {
            launchException = new RuntimeException("Application launch exception", ex);
        }
        catch (Error err) {
            launchException = new RuntimeException("Application launch error", err);
        }
        finally {
            countDownLatch.countDown();
        }
    }

    static /* synthetic */ String lambda$launchApplication$134() {
        return System.getProperty("javafx.preloader");
    }
}

