/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.css.parser;

import com.sun.javafx.Logging;
import com.sun.javafx.Utils;
import com.sun.javafx.css.Combinator;
import com.sun.javafx.css.CompoundSelector;
import com.sun.javafx.css.CssError;
import com.sun.javafx.css.Declaration;
import com.sun.javafx.css.FontFace;
import com.sun.javafx.css.ParsedValueImpl;
import com.sun.javafx.css.Rule;
import com.sun.javafx.css.Selector;
import com.sun.javafx.css.SimpleSelector;
import com.sun.javafx.css.Size;
import com.sun.javafx.css.SizeUnits;
import com.sun.javafx.css.StyleManager;
import com.sun.javafx.css.Stylesheet;
import com.sun.javafx.css.converters.BooleanConverter;
import com.sun.javafx.css.converters.DurationConverter;
import com.sun.javafx.css.converters.EffectConverter;
import com.sun.javafx.css.converters.EnumConverter;
import com.sun.javafx.css.converters.FontConverter;
import com.sun.javafx.css.converters.InsetsConverter;
import com.sun.javafx.css.converters.PaintConverter;
import com.sun.javafx.css.converters.SizeConverter;
import com.sun.javafx.css.converters.StringConverter;
import com.sun.javafx.css.converters.URLConverter;
import com.sun.javafx.css.parser.CSSLexer;
import com.sun.javafx.css.parser.DeriveColorConverter;
import com.sun.javafx.css.parser.LadderConverter;
import com.sun.javafx.css.parser.StopConverter;
import com.sun.javafx.css.parser.Token;
import com.sun.javafx.scene.layout.region.BackgroundPositionConverter;
import com.sun.javafx.scene.layout.region.BackgroundSizeConverter;
import com.sun.javafx.scene.layout.region.BorderImageSliceConverter;
import com.sun.javafx.scene.layout.region.BorderImageSlices;
import com.sun.javafx.scene.layout.region.BorderImageWidthConverter;
import com.sun.javafx.scene.layout.region.BorderImageWidthsSequenceConverter;
import com.sun.javafx.scene.layout.region.BorderStrokeStyleSequenceConverter;
import com.sun.javafx.scene.layout.region.BorderStyleConverter;
import com.sun.javafx.scene.layout.region.LayeredBackgroundPositionConverter;
import com.sun.javafx.scene.layout.region.LayeredBackgroundSizeConverter;
import com.sun.javafx.scene.layout.region.LayeredBorderPaintConverter;
import com.sun.javafx.scene.layout.region.LayeredBorderStyleConverter;
import com.sun.javafx.scene.layout.region.Margins;
import com.sun.javafx.scene.layout.region.RepeatStruct;
import com.sun.javafx.scene.layout.region.RepeatStructConverter;
import com.sun.javafx.scene.layout.region.SliceSequenceConverter;
import com.sun.javafx.scene.layout.region.StrokeBorderPaintConverter;
import java.io.BufferedReader;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;
import javafx.collections.ObservableList;
import javafx.css.ParsedValue;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.geometry.Insets;
import javafx.scene.effect.BlurType;
import javafx.scene.effect.Effect;
import javafx.scene.layout.BackgroundPosition;
import javafx.scene.layout.BackgroundRepeat;
import javafx.scene.layout.BackgroundSize;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.CornerRadiiConverter;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.Paint;
import javafx.scene.paint.Stop;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.shape.StrokeLineJoin;
import javafx.scene.shape.StrokeType;
import javafx.scene.text.Font;
import javafx.scene.text.FontPosture;
import javafx.scene.text.FontWeight;
import sun.util.logging.PlatformLogger;

public final class CSSParser {
    private String stylesheetAsText;
    private String sourceOfStylesheet;
    private Styleable sourceOfInlineStyle;
    private static final PlatformLogger LOGGER = Logging.getCSSLogger();
    private final Map<String, String> properties = new HashMap<String, String>();
    private static final ParsedValueImpl<Size, Size> ZERO_PERCENT = new ParsedValueImpl(new Size(0.0, SizeUnits.PERCENT), null);
    private static final ParsedValueImpl<Size, Size> FIFTY_PERCENT = new ParsedValueImpl(new Size(50.0, SizeUnits.PERCENT), null);
    private static final ParsedValueImpl<Size, Size> ONE_HUNDRED_PERCENT = new ParsedValueImpl(new Size(100.0, SizeUnits.PERCENT), null);
    public static final String SPECIAL_REGION_URL_PREFIX = "SPECIAL-REGION-URL:";
    Token currentToken = null;
    private static Stack<String> imports;

    @Deprecated
    public static CSSParser getInstance() {
        return InstanceHolder.INSTANCE;
    }

    private void setInputSource(String url, String str) {
        this.stylesheetAsText = str;
        this.sourceOfStylesheet = url;
        this.sourceOfInlineStyle = null;
    }

    private void setInputSource(String str) {
        this.stylesheetAsText = str;
        this.sourceOfStylesheet = null;
        this.sourceOfInlineStyle = null;
    }

    private void setInputSource(Styleable styleable) {
        this.stylesheetAsText = styleable != null ? styleable.getStyle() : null;
        this.sourceOfStylesheet = null;
        this.sourceOfInlineStyle = styleable;
    }

    public Stylesheet parse(String stylesheetText) {
        Stylesheet stylesheet = new Stylesheet();
        if (stylesheetText != null && !stylesheetText.trim().isEmpty()) {
            this.setInputSource(stylesheetText);
            try (CharArrayReader reader = new CharArrayReader(stylesheetText.toCharArray());){
                this.parse(stylesheet, reader);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return stylesheet;
    }

    public Stylesheet parse(String docbase, String stylesheetText) throws IOException {
        Stylesheet stylesheet = new Stylesheet(docbase);
        if (stylesheetText != null && !stylesheetText.trim().isEmpty()) {
            this.setInputSource(docbase, stylesheetText);
            try (CharArrayReader reader = new CharArrayReader(stylesheetText.toCharArray());){
                this.parse(stylesheet, reader);
            }
        }
        return stylesheet;
    }

    public Stylesheet parse(URL url) throws IOException {
        String path = url != null ? url.toExternalForm() : null;
        Stylesheet stylesheet = new Stylesheet(path);
        if (url != null) {
            this.setInputSource(path, null);
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));){
                this.parse(stylesheet, reader);
            }
        }
        return stylesheet;
    }

    private void parse(Stylesheet stylesheet, Reader reader) {
        CSSLexer lex = new CSSLexer();
        lex.setReader(reader);
        try {
            this.parse(stylesheet, lex);
        }
        catch (Exception ex) {
            this.reportException(ex);
        }
    }

    public Stylesheet parseInlineStyle(Styleable node) {
        String stylesheetText;
        Stylesheet stylesheet = new Stylesheet();
        String string = stylesheetText = node != null ? node.getStyle() : null;
        if (stylesheetText != null && !stylesheetText.trim().isEmpty()) {
            this.setInputSource(node);
            ArrayList<Rule> rules = new ArrayList<Rule>();
            try (CharArrayReader reader = new CharArrayReader(stylesheetText.toCharArray());){
                CSSLexer lexer = CSSLexer.getInstance();
                lexer.setReader(reader);
                this.currentToken = this.nextToken(lexer);
                List<Declaration> declarations = this.declarations(lexer);
                if (declarations != null && !declarations.isEmpty()) {
                    Selector selector = Selector.getUniversalSelector();
                    Rule rule = new Rule(Collections.singletonList(selector), declarations);
                    rules.add(rule);
                }
            }
            catch (IOException ioe) {
            }
            catch (Exception ex) {
                this.reportException(ex);
            }
            stylesheet.getRules().addAll(rules);
        }
        this.setInputSource((Styleable)null);
        return stylesheet;
    }

    public ParsedValueImpl parseExpr(String property, String expr) {
        if (property == null || expr == null) {
            return null;
        }
        ParsedValueImpl value = null;
        this.setInputSource(null, property + ": " + expr);
        char[] buf = new char[expr.length() + 1];
        System.arraycopy(expr.toCharArray(), 0, buf, 0, expr.length());
        buf[buf.length - 1] = 59;
        try (CharArrayReader reader = new CharArrayReader(buf);){
            CSSLexer lex = CSSLexer.getInstance();
            lex.setReader(reader);
            this.currentToken = this.nextToken(lex);
            Term term = this.expr(lex);
            value = this.valueFor(property, term, lex);
        }
        catch (IOException ioe) {
        }
        catch (ParseException e) {
            if (LOGGER.isLoggable(PlatformLogger.Level.WARNING)) {
                LOGGER.warning("\"" + property + ": " + expr + "\" " + e.toString());
            }
        }
        catch (Exception ex) {
            this.reportException(ex);
        }
        return value;
    }

    private CssError createError(String msg) {
        CssError error = null;
        error = this.sourceOfStylesheet != null ? new CssError.StylesheetParsingError(this.sourceOfStylesheet, msg) : (this.sourceOfInlineStyle != null ? new CssError.InlineStyleParsingError(this.sourceOfInlineStyle, msg) : new CssError.StringParsingError(this.stylesheetAsText, msg));
        return error;
    }

    private void reportError(CssError error) {
        ObservableList<CssError> errors = null;
        errors = StyleManager.getErrors();
        if (errors != null) {
            errors.add(error);
        }
    }

    private void error(Term root, String msg) throws ParseException {
        Token token = root != null ? root.token : null;
        ParseException pe = new ParseException(msg, token, this);
        this.reportError(this.createError(pe.toString()));
        throw pe;
    }

    private void reportException(Exception exception) {
        StackTraceElement[] stea;
        if (LOGGER.isLoggable(PlatformLogger.Level.WARNING) && (stea = exception.getStackTrace()).length > 0) {
            StringBuilder buf = new StringBuilder("Please report ");
            buf.append(exception.getClass().getName()).append(" at:");
            int end = 0;
            while (end < stea.length && this.getClass().getName().equals(stea[end].getClassName())) {
                buf.append("\n\t").append(stea[end++].toString());
            }
            LOGGER.warning(buf.toString());
        }
    }

    private String formatDeprecatedMessage(Term root, String syntax) {
        StringBuilder buf = new StringBuilder("Using deprecated syntax for ");
        buf.append(syntax);
        if (this.sourceOfStylesheet != null) {
            buf.append(" at ").append(this.sourceOfStylesheet).append("[").append(root.token.getLine()).append(',').append(root.token.getOffset()).append("]");
        }
        buf.append(". Refer to the CSS Reference Guide.");
        return buf.toString();
    }

    private ParsedValueImpl<Color, Color> colorValueOfString(String str) {
        if (str.startsWith("#") || str.startsWith("0x")) {
            double a = 1.0;
            String c = str;
            int prefixLength = str.startsWith("#") ? 1 : 2;
            int len = c.length();
            if (len - prefixLength == 4) {
                a = (float)Integer.parseInt(c.substring(len - 1), 16) / 15.0f;
                c = c.substring(0, len - 1);
            } else if (len - prefixLength == 8) {
                a = (float)Integer.parseInt(c.substring(len - 2), 16) / 255.0f;
                c = c.substring(0, len - 2);
            }
            return new ParsedValueImpl<Color, Color>(Color.web(c, a), null);
        }
        try {
            return new ParsedValueImpl<Color, Color>(Color.web(str), null);
        }
        catch (IllegalArgumentException e) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return null;
    }

    private String stripQuotes(String string) {
        return Utils.stripQuotes(string);
    }

    private double clamp(double min, double val, double max) {
        if (val < min) {
            return min;
        }
        if (max < val) {
            return max;
        }
        return val;
    }

    private boolean isSize(Token token) {
        int ttype = token.getType();
        switch (ttype) {
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                return true;
            }
        }
        return token.getType() == 11;
    }

    private Size size(Token token) throws ParseException {
        SizeUnits units = SizeUnits.PX;
        int trim = 2;
        String sval = token.getText().trim();
        int len = sval.length();
        int ttype = token.getType();
        switch (ttype) {
            case 13: {
                units = SizeUnits.PX;
                trim = 0;
                break;
            }
            case 22: {
                units = SizeUnits.PERCENT;
                trim = 1;
                break;
            }
            case 15: {
                units = SizeUnits.EM;
                break;
            }
            case 16: {
                units = SizeUnits.EX;
                break;
            }
            case 21: {
                units = SizeUnits.PX;
                break;
            }
            case 14: {
                units = SizeUnits.CM;
                break;
            }
            case 18: {
                units = SizeUnits.MM;
                break;
            }
            case 17: {
                units = SizeUnits.IN;
                break;
            }
            case 20: {
                units = SizeUnits.PT;
                break;
            }
            case 19: {
                units = SizeUnits.PC;
                break;
            }
            case 23: {
                units = SizeUnits.DEG;
                trim = 3;
                break;
            }
            case 24: {
                units = SizeUnits.GRAD;
                trim = 4;
                break;
            }
            case 25: {
                units = SizeUnits.RAD;
                trim = 3;
                break;
            }
            case 26: {
                units = SizeUnits.TURN;
                trim = 4;
                break;
            }
            case 45: {
                units = SizeUnits.S;
                trim = 1;
                break;
            }
            case 46: {
                units = SizeUnits.MS;
                break;
            }
            default: {
                if (LOGGER.isLoggable(PlatformLogger.Level.FINEST)) {
                    LOGGER.finest("Expected '<number>'");
                }
                ParseException re = new ParseException("Expected '<number>'", token, this);
                this.reportError(this.createError(re.toString()));
                throw re;
            }
        }
        return new Size(Double.parseDouble(sval.substring(0, len - trim)), units);
    }

    private int numberOfTerms(Term root) {
        if (root == null) {
            return 0;
        }
        int nTerms = 0;
        Term term = root;
        do {
            ++nTerms;
        } while ((term = term.nextInSeries) != null);
        return nTerms;
    }

    private int numberOfLayers(Term root) {
        if (root == null) {
            return 0;
        }
        int nLayers = 0;
        Term term = root;
        do {
            ++nLayers;
            while (term.nextInSeries != null) {
                term = term.nextInSeries;
            }
        } while ((term = term.nextLayer) != null);
        return nLayers;
    }

    private int numberOfArgs(Term root) {
        if (root == null) {
            return 0;
        }
        int nArgs = 0;
        Term term = root.firstArg;
        while (term != null) {
            ++nArgs;
            term = term.nextArg;
        }
        return nArgs;
    }

    private Term nextLayer(Term root) {
        if (root == null) {
            return null;
        }
        Term term = root;
        while (term.nextInSeries != null) {
            term = term.nextInSeries;
        }
        return term.nextLayer;
    }

    ParsedValueImpl valueFor(String property, Term root, CSSLexer lexer) throws ParseException {
        ParsedValueImpl<String, Enum> value;
        ParsedValueImpl<?, Size>[] sides;
        String prop = property.toLowerCase(Locale.ROOT);
        this.properties.put(prop, prop);
        if (root == null || root.token == null) {
            this.error(root, "Expected value for property '" + prop + "'");
        }
        if (root.token.getType() == 11) {
            String txt = root.token.getText();
            if ("inherit".equalsIgnoreCase(txt)) {
                return new ParsedValueImpl("inherit", null);
            }
            if ("null".equalsIgnoreCase(txt) || "none".equalsIgnoreCase(txt)) {
                return new ParsedValueImpl("null", null);
            }
        }
        if ("-fx-fill".equals(prop)) {
            ParsedValueImpl<ParsedValue[], Paint> pv = this.parse(root);
            if (pv.getConverter() == StyleConverter.getUrlConverter()) {
                pv = new ParsedValueImpl<ParsedValue[], Paint>(new ParsedValue[]{pv}, PaintConverter.ImagePatternConverter.getInstance());
            }
            return pv;
        }
        if ("-fx-background-color".equals(prop)) {
            return this.parsePaintLayers(root);
        }
        if ("-fx-background-image".equals(prop)) {
            return this.parseURILayers(root);
        }
        if ("-fx-background-insets".equals(prop)) {
            return this.parseInsetsLayers(root);
        }
        if ("-fx-opaque-insets".equals(prop)) {
            return this.parseInsetsLayer(root);
        }
        if ("-fx-background-position".equals(prop)) {
            return this.parseBackgroundPositionLayers(root);
        }
        if ("-fx-background-radius".equals(prop)) {
            return this.parseCornerRadius(root);
        }
        if ("-fx-background-repeat".equals(prop)) {
            return this.parseBackgroundRepeatStyleLayers(root);
        }
        if ("-fx-background-size".equals(prop)) {
            return this.parseBackgroundSizeLayers(root);
        }
        if ("-fx-border-color".equals(prop)) {
            return this.parseBorderPaintLayers(root);
        }
        if ("-fx-border-insets".equals(prop)) {
            return this.parseInsetsLayers(root);
        }
        if ("-fx-border-radius".equals(prop)) {
            return this.parseCornerRadius(root);
        }
        if ("-fx-border-style".equals(prop)) {
            return this.parseBorderStyleLayers(root);
        }
        if ("-fx-border-width".equals(prop)) {
            return this.parseMarginsLayers(root);
        }
        if ("-fx-border-image-insets".equals(prop)) {
            return this.parseInsetsLayers(root);
        }
        if ("-fx-border-image-repeat".equals(prop)) {
            return this.parseBorderImageRepeatStyleLayers(root);
        }
        if ("-fx-border-image-slice".equals(prop)) {
            return this.parseBorderImageSliceLayers(root);
        }
        if ("-fx-border-image-source".equals(prop)) {
            return this.parseURILayers(root);
        }
        if ("-fx-border-image-width".equals(prop)) {
            return this.parseBorderImageWidthLayers(root);
        }
        if ("-fx-padding".equals(prop)) {
            sides = this.parseSize1to4(root);
            return new ParsedValueImpl<ParsedValue[], Insets>(sides, InsetsConverter.getInstance());
        }
        if ("-fx-label-padding".equals(prop)) {
            sides = this.parseSize1to4(root);
            return new ParsedValueImpl<ParsedValue[], Insets>(sides, InsetsConverter.getInstance());
        }
        if (prop.endsWith("font-family")) {
            return this.parseFontFamily(root);
        }
        if (prop.endsWith("font-size")) {
            ParsedValueImpl<ParsedValue<?, Size>, Number> fsize = this.parseFontSize(root);
            if (fsize == null) {
                this.error(root, "Expected '<font-size>'");
            }
            return fsize;
        }
        if (prop.endsWith("font-style")) {
            ParsedValueImpl<String, FontPosture> fstyle = this.parseFontStyle(root);
            if (fstyle == null) {
                this.error(root, "Expected '<font-style>'");
            }
            return fstyle;
        }
        if (prop.endsWith("font-weight")) {
            ParsedValueImpl<String, FontWeight> fweight = this.parseFontWeight(root);
            if (fweight == null) {
                this.error(root, "Expected '<font-style>'");
            }
            return fweight;
        }
        if (prop.endsWith("font")) {
            return this.parseFont(root);
        }
        if ("-fx-stroke-dash-array".equals(prop)) {
            Term term = root;
            int nArgs = this.numberOfTerms(term);
            ParsedValueImpl[] segments = new ParsedValueImpl[nArgs];
            int segment = 0;
            while (term != null) {
                segments[segment++] = this.parseSize(term);
                term = term.nextInSeries;
            }
            return new ParsedValueImpl<ParsedValue[], Number[]>(segments, SizeConverter.SequenceConverter.getInstance());
        }
        if ("-fx-stroke-line-join".equals(prop)) {
            ParsedValueImpl[] values = this.parseStrokeLineJoin(root);
            if (values == null) {
                this.error(root, "Expected 'miter', 'bevel' or 'round'");
            }
            return values[0];
        }
        if ("-fx-stroke-line-cap".equals(prop)) {
            value = this.parseStrokeLineCap(root);
            if (value == null) {
                this.error(root, "Expected 'square', 'butt' or 'round'");
            }
            return value;
        }
        if ("-fx-stroke-type".equals(prop)) {
            value = this.parseStrokeType(root);
            if (value == null) {
                this.error(root, "Expected 'centered', 'inside' or 'outside'");
            }
            return value;
        }
        if ("-fx-font-smoothing-type".equals(prop)) {
            String str = null;
            int ttype = -1;
            Token token = root.token;
            if (root.token == null || (ttype = root.token.getType()) != 10 && ttype != 11 || (str = root.token.getText()) == null || str.isEmpty()) {
                this.error(root, "Expected STRING or IDENT");
            }
            return new ParsedValueImpl(this.stripQuotes(str), null, false);
        }
        return this.parse(root);
    }

    private ParsedValueImpl parse(Term root) throws ParseException {
        if (root.token == null) {
            this.error(root, "Parse error");
        }
        Token token = root.token;
        ParsedValueImpl<Object, Object> value = null;
        int ttype = token.getType();
        switch (ttype) {
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                if (root.nextInSeries == null) {
                    ParsedValueImpl sizeValue = new ParsedValueImpl(this.size(token), null);
                    value = new ParsedValueImpl(sizeValue, SizeConverter.getInstance());
                    break;
                }
                ParsedValueImpl<Size, Size>[] sizeValue = this.parseSizeSeries(root);
                value = new ParsedValueImpl<ParsedValue[], Number[]>(sizeValue, SizeConverter.SequenceConverter.getInstance());
                break;
            }
            case 45: 
            case 46: {
                ParsedValueImpl sizeValue = new ParsedValueImpl(this.size(token), null);
                value = new ParsedValueImpl(sizeValue, DurationConverter.getInstance());
                break;
            }
            case 10: 
            case 11: {
                boolean needsLookup;
                boolean isIdent = ttype == 11;
                String str = this.stripQuotes(token.getText());
                String text = str.toLowerCase(Locale.ROOT);
                if ("ladder".equals(text)) {
                    value = this.ladder(root);
                    break;
                }
                if ("linear".equals(text) && root.nextInSeries != null) {
                    value = this.linearGradient(root);
                    break;
                }
                if ("radial".equals(text) && root.nextInSeries != null) {
                    value = this.radialGradient(root);
                    break;
                }
                if ("infinity".equals(text)) {
                    Size size = new Size(Double.MAX_VALUE, SizeUnits.PX);
                    ParsedValueImpl sizeValue = new ParsedValueImpl(size, null);
                    value = new ParsedValueImpl(sizeValue, SizeConverter.getInstance());
                    break;
                }
                if ("indefinite".equals(text)) {
                    Size size = new Size(Double.POSITIVE_INFINITY, SizeUnits.PX);
                    ParsedValueImpl sizeValue = new ParsedValueImpl(size, null);
                    value = new ParsedValueImpl(sizeValue, DurationConverter.getInstance());
                    break;
                }
                if ("true".equals(text)) {
                    value = new ParsedValueImpl<String, Boolean>("true", BooleanConverter.getInstance());
                    break;
                }
                if ("false".equals(text)) {
                    value = new ParsedValueImpl<String, Boolean>("false", BooleanConverter.getInstance());
                    break;
                }
                boolean bl = needsLookup = isIdent && this.properties.containsKey(text);
                if (!needsLookup && (value = this.colorValueOfString(str)) != null) break;
                value = new ParsedValueImpl(needsLookup ? text : str, null, isIdent || needsLookup);
                break;
            }
            case 37: {
                String clr = token.getText();
                try {
                    value = new ParsedValueImpl(Color.web(clr), null);
                }
                catch (IllegalArgumentException e) {
                    this.error(root, e.getMessage());
                }
                break;
            }
            case 12: {
                return this.parseFunction(root);
            }
            case 43: {
                return this.parseURI(root);
            }
            default: {
                String msg = "Unknown token type: '" + ttype + "'";
                this.error(root, msg);
            }
        }
        return value;
    }

    private ParsedValueImpl<?, Size> parseSize(Term root) throws ParseException {
        if (root.token == null || !this.isSize(root.token)) {
            this.error(root, "Expected '<size>'");
        }
        ParsedValueImpl value = null;
        if (root.token.getType() != 11) {
            Size size = this.size(root.token);
            value = new ParsedValueImpl(size, null);
        } else {
            String key = root.token.getText();
            value = new ParsedValueImpl(key, null, true);
        }
        return value;
    }

    private ParsedValueImpl<?, Color> parseColor(Term root) throws ParseException {
        ParsedValueImpl color = null;
        if (root.token != null && (root.token.getType() == 11 || root.token.getType() == 37 || root.token.getType() == 12)) {
            color = this.parse(root);
        } else {
            this.error(root, "Expected '<color>'");
        }
        return color;
    }

    private ParsedValueImpl rgb(Term root) throws ParseException {
        int argType;
        Token atok;
        Token btok;
        Token gtok;
        Token rtok;
        String fn;
        String string = fn = root.token != null ? root.token.getText() : null;
        if (fn == null || !"rgb".regionMatches(true, 0, fn, 0, 3)) {
            String msg = "Expected 'rgb' or 'rgba'";
            this.error(root, "Expected 'rgb' or 'rgba'");
        }
        Term arg = root;
        arg = arg.firstArg;
        if (arg == null) {
            this.error(root, "Expected '<number>' or '<percentage>'");
        }
        if ((rtok = arg.token) == null || rtok.getType() != 13 && rtok.getType() != 22) {
            this.error(arg, "Expected '<number>' or '<percentage>'");
        }
        root = arg;
        arg = arg.nextArg;
        if (arg == null) {
            this.error(root, "Expected '<number>' or '<percentage>'");
        }
        if ((gtok = arg.token) == null || gtok.getType() != 13 && gtok.getType() != 22) {
            this.error(arg, "Expected '<number>' or '<percentage>'");
        }
        root = arg;
        arg = arg.nextArg;
        if (arg == null) {
            this.error(root, "Expected '<number>' or '<percentage>'");
        }
        if ((btok = arg.token) == null || btok.getType() != 13 && btok.getType() != 22) {
            this.error(arg, "Expected '<number>' or '<percentage>'");
        }
        root = arg;
        arg = arg.nextArg;
        if (arg != null) {
            atok = arg.token;
            if (atok == null || atok.getType() != 13) {
                this.error(arg, "Expected '<number>'");
            }
        } else {
            atok = null;
        }
        if ((argType = rtok.getType()) != gtok.getType() || argType != btok.getType() || argType != 13 && argType != 22) {
            this.error(root, "Argument type mistmatch");
        }
        String rtext = rtok.getText();
        String gtext = gtok.getText();
        String btext = btok.getText();
        double rval = 0.0;
        double gval = 0.0;
        double bval = 0.0;
        if (argType == 13) {
            rval = this.clamp(0.0, Double.parseDouble(rtext) / 255.0, 1.0);
            gval = this.clamp(0.0, Double.parseDouble(gtext) / 255.0, 1.0);
            bval = this.clamp(0.0, Double.parseDouble(btext) / 255.0, 1.0);
        } else {
            rval = this.clamp(0.0, Double.parseDouble(rtext.substring(0, rtext.length() - 1)) / 100.0, 1.0);
            gval = this.clamp(0.0, Double.parseDouble(gtext.substring(0, gtext.length() - 1)) / 100.0, 1.0);
            bval = this.clamp(0.0, Double.parseDouble(btext.substring(0, btext.length() - 1)) / 100.0, 1.0);
        }
        String atext = atok != null ? atok.getText() : null;
        double aval = atext != null ? this.clamp(0.0, Double.parseDouble(atext), 1.0) : 1.0;
        return new ParsedValueImpl(Color.color(rval, gval, bval, aval), null);
    }

    private ParsedValueImpl hsb(Term root) throws ParseException {
        Token atok;
        Token btok;
        Token stok;
        Token htok;
        String fn;
        String string = fn = root.token != null ? root.token.getText() : null;
        if (fn == null || !"hsb".regionMatches(true, 0, fn, 0, 3)) {
            String msg = "Expected 'hsb' or 'hsba'";
            this.error(root, "Expected 'hsb' or 'hsba'");
        }
        Term arg = root;
        arg = arg.firstArg;
        if (arg == null) {
            this.error(root, "Expected '<number>'");
        }
        if ((htok = arg.token) == null || htok.getType() != 13) {
            this.error(arg, "Expected '<number>'");
        }
        root = arg;
        arg = arg.nextArg;
        if (arg == null) {
            this.error(root, "Expected '<percent>'");
        }
        if ((stok = arg.token) == null || stok.getType() != 22) {
            this.error(arg, "Expected '<percent>'");
        }
        root = arg;
        arg = arg.nextArg;
        if (arg == null) {
            this.error(root, "Expected '<percent>'");
        }
        if ((btok = arg.token) == null || btok.getType() != 22) {
            this.error(arg, "Expected '<percent>'");
        }
        root = arg;
        arg = arg.nextArg;
        if (arg != null) {
            atok = arg.token;
            if (atok == null || atok.getType() != 13) {
                this.error(arg, "Expected '<number>'");
            }
        } else {
            atok = null;
        }
        Size hval = this.size(htok);
        Size sval = this.size(stok);
        Size bval = this.size(btok);
        double hue = hval.pixels();
        double saturation = this.clamp(0.0, sval.pixels(), 1.0);
        double brightness = this.clamp(0.0, bval.pixels(), 1.0);
        Size aval = atok != null ? this.size(atok) : null;
        double opacity = aval != null ? this.clamp(0.0, aval.pixels(), 1.0) : 1.0;
        return new ParsedValueImpl(Color.hsb(hue, saturation, brightness, opacity), null);
    }

    private ParsedValueImpl<ParsedValue[], Color> derive(Term root) throws ParseException {
        String fn;
        String string = fn = root.token != null ? root.token.getText() : null;
        if (fn == null || !"derive".regionMatches(true, 0, fn, 0, 6)) {
            String msg = "Expected 'derive'";
            this.error(root, "Expected 'derive'");
        }
        Term arg = root;
        arg = arg.firstArg;
        if (arg == null) {
            this.error(root, "Expected '<color>'");
        }
        ParsedValueImpl<?, Color> color = this.parseColor(arg);
        Term prev = arg;
        arg = arg.nextArg;
        if (arg == null) {
            this.error(prev, "Expected '<percent'");
        }
        ParsedValueImpl<?, Size> brightness = this.parseSize(arg);
        ParsedValueImpl[] values = new ParsedValueImpl[]{color, brightness};
        return new ParsedValueImpl<ParsedValue[], Color>(values, DeriveColorConverter.getInstance());
    }

    private ParsedValueImpl<ParsedValue[], Color> ladder(Term root) throws ParseException {
        String fn;
        String string = fn = root.token != null ? root.token.getText() : null;
        if (fn == null || !"ladder".regionMatches(true, 0, fn, 0, 6)) {
            String msg = "Expected 'ladder'";
            this.error(root, "Expected 'ladder'");
        }
        if (LOGGER.isLoggable(PlatformLogger.Level.WARNING)) {
            LOGGER.warning(this.formatDeprecatedMessage(root, "ladder"));
        }
        Term term = root;
        term = term.nextInSeries;
        if (term == null) {
            this.error(root, "Expected '<color>'");
        }
        ParsedValueImpl color = this.parse(term);
        Term prev = term;
        term = term.nextInSeries;
        if (term == null) {
            this.error(prev, "Expected 'stops'");
        }
        if (term.token == null || term.token.getType() != 11 || !"stops".equalsIgnoreCase(term.token.getText())) {
            this.error(term, "Expected 'stops'");
        }
        prev = term;
        term = term.nextInSeries;
        if (term == null) {
            this.error(prev, "Expected '(<number>, <color>)'");
        }
        int nStops = 0;
        Term temp = term;
        do {
            ++nStops;
        } while ((temp = temp.nextInSeries) != null && temp.token != null && temp.token.getType() == 34);
        ParsedValueImpl[] values = new ParsedValueImpl[nStops + 1];
        values[0] = color;
        int stopIndex = 1;
        do {
            ParsedValueImpl<ParsedValue[], Stop> stop;
            if ((stop = this.stop(term)) != null) {
                values[stopIndex++] = stop;
            }
            prev = term;
        } while ((term = term.nextInSeries) != null && term.token.getType() == 34);
        if (term != null) {
            root.nextInSeries = term;
        } else {
            root.nextInSeries = null;
            root.nextLayer = prev.nextLayer;
        }
        return new ParsedValueImpl<ParsedValue[], Color>(values, LadderConverter.getInstance());
    }

    private ParsedValueImpl<ParsedValue[], Color> parseLadder(Term root) throws ParseException {
        String fn;
        String string = fn = root.token != null ? root.token.getText() : null;
        if (fn == null || !"ladder".regionMatches(true, 0, fn, 0, 6)) {
            String msg = "Expected 'ladder'";
            this.error(root, "Expected 'ladder'");
        }
        Term term = root;
        term = term.firstArg;
        if (term == null) {
            this.error(root, "Expected '<color>'");
        }
        ParsedValueImpl color = this.parse(term);
        Term prev = term;
        term = term.nextArg;
        if (term == null) {
            this.error(prev, "Expected '<color-stop>[, <color-stop>]+'");
        }
        ParsedValueImpl<ParsedValue[], Stop>[] stops = this.parseColorStops(term);
        ParsedValueImpl[] values = new ParsedValueImpl[stops.length + 1];
        values[0] = color;
        System.arraycopy(stops, 0, values, 1, stops.length);
        return new ParsedValueImpl<ParsedValue[], Color>(values, LadderConverter.getInstance());
    }

    private ParsedValueImpl<ParsedValue[], Stop> stop(Term root) throws ParseException {
        String fn;
        String string = fn = root.token != null ? root.token.getText() : null;
        if (fn == null || !"(".equals(fn)) {
            String msg = "Expected '('";
            this.error(root, "Expected '('");
        }
        Term arg = null;
        arg = root.firstArg;
        if (arg == null) {
            this.error(root, "Expected '<number>'");
        }
        ParsedValueImpl<?, Size> size = this.parseSize(arg);
        Term prev = arg;
        arg = arg.nextArg;
        if (arg == null) {
            this.error(prev, "Expected '<color>'");
        }
        ParsedValueImpl<?, Color> color = this.parseColor(arg);
        ParsedValueImpl[] values = new ParsedValueImpl[]{size, color};
        return new ParsedValueImpl<ParsedValue[], Stop>(values, StopConverter.getInstance());
    }

    private ParsedValueImpl<ParsedValue[], Stop>[] parseColorStops(Term root) throws ParseException {
        int nArgs = 1;
        Term temp = root;
        while (temp != null) {
            if (temp.nextArg != null) {
                ++nArgs;
                temp = temp.nextArg;
                continue;
            }
            if (temp.nextInSeries == null) break;
            temp = temp.nextInSeries;
        }
        if (nArgs < 2) {
            this.error(root, "Expected '<color-stop>'");
        }
        ParsedValueImpl[] colors = new ParsedValueImpl[nArgs];
        Object[] positions = new Size[nArgs];
        Arrays.fill(positions, null);
        Term stop = root;
        Term prev = root;
        Object units = null;
        for (int n = 0; n < nArgs; ++n) {
            colors[n] = this.parseColor(stop);
            prev = stop;
            Term term = stop.nextInSeries;
            if (term != null) {
                if (this.isSize(term.token)) {
                    positions[n] = this.size(term.token);
                    if (units != null && units != ((Size)positions[n]).getUnits()) {
                        this.error(term, "Parser unable to handle mixed '<percent>' and '<length>'");
                    }
                } else {
                    this.error(prev, "Expected '<percent>' or '<length>'");
                }
                prev = term;
                stop = term.nextArg;
                continue;
            }
            prev = stop;
            stop = stop.nextArg;
        }
        if (positions[0] == null) {
            positions[0] = new Size(0.0, SizeUnits.PERCENT);
        }
        if (positions[nArgs - 1] == null) {
            positions[nArgs - 1] = new Size(100.0, SizeUnits.PERCENT);
        }
        Object max = null;
        for (int n = 1; n < nArgs; ++n) {
            Object pos1;
            Object pos0 = positions[n - 1];
            if (pos0 == null) continue;
            if (max == null || ((Size)max).getValue() < ((Size)pos0).getValue()) {
                max = pos0;
            }
            if ((pos1 = positions[n]) == null || !(((Size)pos1).getValue() < ((Size)max).getValue())) continue;
            positions[n] = max;
        }
        Object preceding = null;
        int withoutIndex = -1;
        for (int n = 0; n < nArgs; ++n) {
            Object pos = positions[n];
            if (pos == null) {
                if (withoutIndex != -1) continue;
                withoutIndex = n;
                continue;
            }
            if (withoutIndex > -1) {
                int nWithout = n - withoutIndex;
                double precedingValue = ((Size)preceding).getValue();
                double delta = (((Size)pos).getValue() - precedingValue) / (double)(nWithout + 1);
                while (withoutIndex < n) {
                    positions[withoutIndex++] = new Size(precedingValue += delta, ((Size)pos).getUnits());
                }
                withoutIndex = -1;
                preceding = pos;
                continue;
            }
            preceding = pos;
        }
        ParsedValueImpl[] stops = new ParsedValueImpl[nArgs];
        for (int n = 0; n < nArgs; ++n) {
            stops[n] = new ParsedValueImpl<ParsedValue[], Stop>(new ParsedValueImpl[]{new ParsedValueImpl(positions[n], null), colors[n]}, StopConverter.getInstance());
        }
        return stops;
    }

    private ParsedValueImpl[] point(Term root) throws ParseException {
        String fn;
        if (root.token == null || root.token.getType() != 34) {
            this.error(root, "Expected '(<number>, <number>)'");
        }
        if ((fn = root.token.getText()) == null || !"(".equalsIgnoreCase(fn)) {
            String msg = "Expected '('";
            this.error(root, "Expected '('");
        }
        Term arg = null;
        arg = root.firstArg;
        if (arg == null) {
            this.error(root, "Expected '<number>'");
        }
        ParsedValueImpl<?, Size> ptX = this.parseSize(arg);
        Term prev = arg;
        arg = arg.nextArg;
        if (arg == null) {
            this.error(prev, "Expected '<number>'");
        }
        ParsedValueImpl<?, Size> ptY = this.parseSize(arg);
        return new ParsedValueImpl[]{ptX, ptY};
    }

    private ParsedValueImpl parseFunction(Term root) throws ParseException {
        String fcn;
        String string = fcn = root.token != null ? root.token.getText() : null;
        if (fcn == null) {
            this.error(root, "Expected function name");
        } else {
            if ("rgb".regionMatches(true, 0, fcn, 0, 3)) {
                return this.rgb(root);
            }
            if ("hsb".regionMatches(true, 0, fcn, 0, 3)) {
                return this.hsb(root);
            }
            if ("derive".regionMatches(true, 0, fcn, 0, 6)) {
                return this.derive(root);
            }
            if ("innershadow".regionMatches(true, 0, fcn, 0, 11)) {
                return this.innershadow(root);
            }
            if ("dropshadow".regionMatches(true, 0, fcn, 0, 10)) {
                return this.dropshadow(root);
            }
            if ("linear-gradient".regionMatches(true, 0, fcn, 0, 15)) {
                return this.parseLinearGradient(root);
            }
            if ("radial-gradient".regionMatches(true, 0, fcn, 0, 15)) {
                return this.parseRadialGradient(root);
            }
            if ("image-pattern".regionMatches(true, 0, fcn, 0, 13)) {
                return this.parseImagePattern(root);
            }
            if ("repeating-image-pattern".regionMatches(true, 0, fcn, 0, 23)) {
                return this.parseRepeatingImagePattern(root);
            }
            if ("ladder".regionMatches(true, 0, fcn, 0, 6)) {
                return this.parseLadder(root);
            }
            if ("region".regionMatches(true, 0, fcn, 0, 6)) {
                return this.parseRegion(root);
            }
            this.error(root, "Unexpected function '" + fcn + "'");
        }
        return null;
    }

    private ParsedValueImpl<String, BlurType> blurType(Term root) throws ParseException {
        if (root == null) {
            return null;
        }
        if (root.token == null || root.token.getType() != 11 || root.token.getText() == null || root.token.getText().isEmpty()) {
            String msg = "Expected 'gaussian', 'one-pass-box', 'two-pass-box', or 'three-pass-box'";
            this.error(root, "Expected 'gaussian', 'one-pass-box', 'two-pass-box', or 'three-pass-box'");
        }
        String blurStr = root.token.getText().toLowerCase(Locale.ROOT);
        BlurType blurType = BlurType.THREE_PASS_BOX;
        if ("gaussian".equals(blurStr)) {
            blurType = BlurType.GAUSSIAN;
        } else if ("one-pass-box".equals(blurStr)) {
            blurType = BlurType.ONE_PASS_BOX;
        } else if ("two-pass-box".equals(blurStr)) {
            blurType = BlurType.TWO_PASS_BOX;
        } else if ("three-pass-box".equals(blurStr)) {
            blurType = BlurType.THREE_PASS_BOX;
        } else {
            String msg = "Expected 'gaussian', 'one-pass-box', 'two-pass-box', or 'three-pass-box'";
            this.error(root, "Expected 'gaussian', 'one-pass-box', 'two-pass-box', or 'three-pass-box'");
        }
        return new ParsedValueImpl<String, BlurType>(blurType.name(), new EnumConverter<BlurType>(BlurType.class));
    }

    private ParsedValueImpl innershadow(Term root) throws ParseException {
        Term arg;
        String fn;
        String string = fn = root.token != null ? root.token.getText() : null;
        if (!"innershadow".regionMatches(true, 0, fn, 0, 11)) {
            String msg = "Expected 'innershadow'";
            this.error(root, "Expected 'innershadow'");
        }
        if ((arg = root.firstArg) == null) {
            this.error(root, "Expected '<blur-type>'");
        }
        ParsedValueImpl<String, BlurType> blurVal = this.blurType(arg);
        Term prev = arg;
        arg = arg.nextArg;
        if (arg == null) {
            this.error(prev, "Expected '<color>'");
        }
        ParsedValueImpl<?, Color> colorVal = this.parseColor(arg);
        prev = arg;
        arg = arg.nextArg;
        if (arg == null) {
            this.error(prev, "Expected '<number>'");
        }
        ParsedValueImpl<?, Size> radiusVal = this.parseSize(arg);
        prev = arg;
        arg = arg.nextArg;
        if (arg == null) {
            this.error(prev, "Expected '<number>'");
        }
        ParsedValueImpl<?, Size> chokeVal = this.parseSize(arg);
        prev = arg;
        arg = arg.nextArg;
        if (arg == null) {
            this.error(prev, "Expected '<number>'");
        }
        ParsedValueImpl<?, Size> offsetXVal = this.parseSize(arg);
        prev = arg;
        arg = arg.nextArg;
        if (arg == null) {
            this.error(prev, "Expected '<number>'");
        }
        ParsedValueImpl<?, Size> offsetYVal = this.parseSize(arg);
        ParsedValueImpl[] values = new ParsedValueImpl[]{blurVal, colorVal, radiusVal, chokeVal, offsetXVal, offsetYVal};
        return new ParsedValueImpl<ParsedValue[], Effect>(values, EffectConverter.InnerShadowConverter.getInstance());
    }

    private ParsedValueImpl dropshadow(Term root) throws ParseException {
        Term arg;
        String fn;
        String string = fn = root.token != null ? root.token.getText() : null;
        if (!"dropshadow".regionMatches(true, 0, fn, 0, 10)) {
            String msg = "Expected 'dropshadow'";
            this.error(root, "Expected 'dropshadow'");
        }
        if ((arg = root.firstArg) == null) {
            this.error(root, "Expected '<blur-type>'");
        }
        ParsedValueImpl<String, BlurType> blurVal = this.blurType(arg);
        Term prev = arg;
        arg = arg.nextArg;
        if (arg == null) {
            this.error(prev, "Expected '<color>'");
        }
        ParsedValueImpl<?, Color> colorVal = this.parseColor(arg);
        prev = arg;
        arg = arg.nextArg;
        if (arg == null) {
            this.error(prev, "Expected '<number>'");
        }
        ParsedValueImpl<?, Size> radiusVal = this.parseSize(arg);
        prev = arg;
        arg = arg.nextArg;
        if (arg == null) {
            this.error(prev, "Expected '<number>'");
        }
        ParsedValueImpl<?, Size> spreadVal = this.parseSize(arg);
        prev = arg;
        arg = arg.nextArg;
        if (arg == null) {
            this.error(prev, "Expected '<number>'");
        }
        ParsedValueImpl<?, Size> offsetXVal = this.parseSize(arg);
        prev = arg;
        arg = arg.nextArg;
        if (arg == null) {
            this.error(prev, "Expected '<number>'");
        }
        ParsedValueImpl<?, Size> offsetYVal = this.parseSize(arg);
        ParsedValueImpl[] values = new ParsedValueImpl[]{blurVal, colorVal, radiusVal, spreadVal, offsetXVal, offsetYVal};
        return new ParsedValueImpl<ParsedValue[], Effect>(values, EffectConverter.DropShadowConverter.getInstance());
    }

    private ParsedValueImpl<String, CycleMethod> cycleMethod(Term root) {
        Enum cycleMethod = null;
        if (root != null && root.token.getType() == 11) {
            String text = root.token.getText().toLowerCase(Locale.ROOT);
            if ("repeat".equals(text)) {
                cycleMethod = CycleMethod.REPEAT;
            } else if ("reflect".equals(text)) {
                cycleMethod = CycleMethod.REFLECT;
            } else if ("no-cycle".equals(text)) {
                cycleMethod = CycleMethod.NO_CYCLE;
            }
        }
        if (cycleMethod != null) {
            return new ParsedValueImpl<String, CycleMethod>(cycleMethod.name(), new EnumConverter<CycleMethod>(CycleMethod.class));
        }
        return null;
    }

    private ParsedValueImpl<ParsedValue[], Paint> linearGradient(Term root) throws ParseException {
        String fn;
        String string = fn = root.token != null ? root.token.getText() : null;
        if (fn == null || !"linear".equalsIgnoreCase(fn)) {
            String msg = "Expected 'linear'";
            this.error(root, "Expected 'linear'");
        }
        if (LOGGER.isLoggable(PlatformLogger.Level.WARNING)) {
            LOGGER.warning(this.formatDeprecatedMessage(root, "linear gradient"));
        }
        Term term = root;
        term = term.nextInSeries;
        if (term == null) {
            this.error(root, "Expected '(<number>, <number>)'");
        }
        ParsedValueImpl[] startPt = this.point(term);
        Term prev = term;
        term = term.nextInSeries;
        if (term == null) {
            this.error(prev, "Expected 'to'");
        }
        if (term.token == null || term.token.getType() != 11 || !"to".equalsIgnoreCase(term.token.getText())) {
            this.error(root, "Expected 'to'");
        }
        prev = term;
        term = term.nextInSeries;
        if (term == null) {
            this.error(prev, "Expected '(<number>, <number>)'");
        }
        ParsedValueImpl[] endPt = this.point(term);
        prev = term;
        term = term.nextInSeries;
        if (term == null) {
            this.error(prev, "Expected 'stops'");
        }
        if (term.token == null || term.token.getType() != 11 || !"stops".equalsIgnoreCase(term.token.getText())) {
            this.error(term, "Expected 'stops'");
        }
        prev = term;
        term = term.nextInSeries;
        if (term == null) {
            this.error(prev, "Expected '(<number>, <number>)'");
        }
        int nStops = 0;
        Term temp = term;
        do {
            ++nStops;
        } while ((temp = temp.nextInSeries) != null && temp.token != null && temp.token.getType() == 34);
        ParsedValueImpl[] stops = new ParsedValueImpl[nStops];
        int stopIndex = 0;
        do {
            ParsedValueImpl<ParsedValue[], Stop> stop;
            if ((stop = this.stop(term)) != null) {
                stops[stopIndex++] = stop;
            }
            prev = term;
        } while ((term = term.nextInSeries) != null && term.token.getType() == 34);
        ParsedValueImpl<String, CycleMethod> cycleMethod = this.cycleMethod(term);
        if (cycleMethod == null) {
            cycleMethod = new ParsedValueImpl(CycleMethod.NO_CYCLE.name(), new EnumConverter<CycleMethod>(CycleMethod.class));
            if (term != null) {
                root.nextInSeries = term;
            } else {
                root.nextInSeries = null;
                root.nextLayer = prev.nextLayer;
            }
        } else {
            root.nextInSeries = term.nextInSeries;
            root.nextLayer = term.nextLayer;
        }
        ParsedValueImpl[] values = new ParsedValueImpl[5 + stops.length];
        int index = 0;
        values[index++] = startPt != null ? startPt[0] : null;
        values[index++] = startPt != null ? startPt[1] : null;
        values[index++] = endPt != null ? endPt[0] : null;
        values[index++] = endPt != null ? endPt[1] : null;
        values[index++] = cycleMethod;
        for (int n = 0; n < stops.length; ++n) {
            values[index++] = stops[n];
        }
        return new ParsedValueImpl<ParsedValue[], Paint>(values, PaintConverter.LinearGradientConverter.getInstance());
    }

    private ParsedValueImpl parseLinearGradient(Term root) throws ParseException {
        Term arg;
        String fn;
        String string = fn = root.token != null ? root.token.getText() : null;
        if (!"linear-gradient".regionMatches(true, 0, fn, 0, 15)) {
            String msg = "Expected 'linear-gradient'";
            this.error(root, "Expected 'linear-gradient'");
        }
        if ((arg = root.firstArg) == null || arg.token == null || arg.token.getText().isEmpty()) {
            this.error(root, "Expected 'from <point> to <point>' or 'to <side-or-corner>' or '<cycle-method>' or '<color-stop>'");
        }
        Term prev = arg;
        ParsedValueImpl[] startPt = null;
        ParsedValueImpl[] endPt = null;
        if ("from".equalsIgnoreCase(arg.token.getText())) {
            prev = arg;
            arg = arg.nextInSeries;
            if (arg == null) {
                this.error(prev, "Expected '<point>'");
            }
            ParsedValueImpl<?, Size> ptX = this.parseSize(arg);
            prev = arg;
            arg = arg.nextInSeries;
            if (arg == null) {
                this.error(prev, "Expected '<point>'");
            }
            ParsedValueImpl<?, Size> ptY = this.parseSize(arg);
            startPt = new ParsedValueImpl[]{ptX, ptY};
            prev = arg;
            arg = arg.nextInSeries;
            if (arg == null) {
                this.error(prev, "Expected 'to'");
            }
            if (arg.token == null || arg.token.getType() != 11 || !"to".equalsIgnoreCase(arg.token.getText())) {
                this.error(prev, "Expected 'to'");
            }
            prev = arg;
            arg = arg.nextInSeries;
            if (arg == null) {
                this.error(prev, "Expected '<point>'");
            }
            ptX = this.parseSize(arg);
            prev = arg;
            arg = arg.nextInSeries;
            if (arg == null) {
                this.error(prev, "Expected '<point>'");
            }
            ptY = this.parseSize(arg);
            endPt = new ParsedValueImpl[]{ptX, ptY};
            prev = arg;
            arg = arg.nextArg;
        } else if ("to".equalsIgnoreCase(arg.token.getText())) {
            prev = arg;
            arg = arg.nextInSeries;
            if (arg == null || arg.token == null || arg.token.getType() != 11 || arg.token.getText().isEmpty()) {
                this.error(prev, "Expected '<side-or-corner>'");
            }
            int startX = 0;
            int startY = 0;
            int endX = 0;
            int endY = 0;
            String sideOrCorner1 = arg.token.getText().toLowerCase(Locale.ROOT);
            if ("top".equals(sideOrCorner1)) {
                startY = 100;
                endY = 0;
            } else if ("bottom".equals(sideOrCorner1)) {
                startY = 0;
                endY = 100;
            } else if ("right".equals(sideOrCorner1)) {
                startX = 0;
                endX = 100;
            } else if ("left".equals(sideOrCorner1)) {
                startX = 100;
                endX = 0;
            } else {
                this.error(arg, "Invalid '<side-or-corner>'");
            }
            prev = arg;
            if (arg.nextInSeries != null) {
                arg = arg.nextInSeries;
                if (arg.token != null && arg.token.getType() == 11 && !arg.token.getText().isEmpty()) {
                    String sideOrCorner2 = arg.token.getText().toLowerCase(Locale.ROOT);
                    if ("right".equals(sideOrCorner2) && startX == 0 && endX == 0) {
                        startX = 0;
                        endX = 100;
                    } else if ("left".equals(sideOrCorner2) && startX == 0 && endX == 0) {
                        startX = 100;
                        endX = 0;
                    } else if ("top".equals(sideOrCorner2) && startY == 0 && endY == 0) {
                        startY = 100;
                        endY = 0;
                    } else if ("bottom".equals(sideOrCorner2) && startY == 0 && endY == 0) {
                        startY = 0;
                        endY = 100;
                    } else {
                        this.error(arg, "Invalid '<side-or-corner>'");
                    }
                } else {
                    this.error(prev, "Expected '<side-or-corner>'");
                }
            }
            startPt = new ParsedValueImpl[]{new ParsedValueImpl(new Size(startX, SizeUnits.PERCENT), null), new ParsedValueImpl(new Size(startY, SizeUnits.PERCENT), null)};
            endPt = new ParsedValueImpl[]{new ParsedValueImpl(new Size(endX, SizeUnits.PERCENT), null), new ParsedValueImpl(new Size(endY, SizeUnits.PERCENT), null)};
            prev = arg;
            arg = arg.nextArg;
        }
        if (startPt == null && endPt == null) {
            startPt = new ParsedValueImpl[]{new ParsedValueImpl(new Size(0.0, SizeUnits.PERCENT), null), new ParsedValueImpl(new Size(0.0, SizeUnits.PERCENT), null)};
            endPt = new ParsedValueImpl[]{new ParsedValueImpl(new Size(0.0, SizeUnits.PERCENT), null), new ParsedValueImpl(new Size(100.0, SizeUnits.PERCENT), null)};
        }
        if (arg == null || arg.token == null || arg.token.getText().isEmpty()) {
            this.error(prev, "Expected '<cycle-method>' or '<color-stop>'");
        }
        CycleMethod cycleMethod = CycleMethod.NO_CYCLE;
        if ("reflect".equalsIgnoreCase(arg.token.getText())) {
            cycleMethod = CycleMethod.REFLECT;
            prev = arg;
            arg = arg.nextArg;
        } else if ("repeat".equalsIgnoreCase(arg.token.getText())) {
            cycleMethod = CycleMethod.REFLECT;
            prev = arg;
            arg = arg.nextArg;
        }
        if (arg == null || arg.token == null || arg.token.getText().isEmpty()) {
            this.error(prev, "Expected '<color-stop>'");
        }
        ParsedValueImpl<ParsedValue[], Stop>[] stops = this.parseColorStops(arg);
        ParsedValueImpl[] values = new ParsedValueImpl[5 + stops.length];
        int index = 0;
        values[index++] = startPt != null ? startPt[0] : null;
        values[index++] = startPt != null ? startPt[1] : null;
        values[index++] = endPt != null ? endPt[0] : null;
        values[index++] = endPt != null ? endPt[1] : null;
        values[index++] = new ParsedValueImpl(cycleMethod.name(), new EnumConverter<CycleMethod>(CycleMethod.class));
        for (int n = 0; n < stops.length; ++n) {
            values[index++] = stops[n];
        }
        return new ParsedValueImpl<ParsedValue[], Paint>(values, PaintConverter.LinearGradientConverter.getInstance());
    }

    private ParsedValueImpl<ParsedValue[], Paint> radialGradient(Term root) throws ParseException {
        String keyword;
        String keyword2;
        String keyword3;
        String fn;
        String string = fn = root.token != null ? root.token.getText() : null;
        if (fn == null || !"radial".equalsIgnoreCase(fn)) {
            String msg = "Expected 'radial'";
            this.error(root, "Expected 'radial'");
        }
        if (LOGGER.isLoggable(PlatformLogger.Level.WARNING)) {
            LOGGER.warning(this.formatDeprecatedMessage(root, "radial gradient"));
        }
        Term term = root;
        Term prev = root;
        term = term.nextInSeries;
        if (term == null) {
            this.error(root, "Expected 'focus-angle <number>', 'focus-distance <number>', 'center (<number>,<number>)' or '<size>'");
        }
        if (term.token == null) {
            this.error(term, "Expected 'focus-angle <number>', 'focus-distance <number>', 'center (<number>,<number>)' or '<size>'");
        }
        ParsedValueImpl<?, Size> focusAngle = null;
        if (term.token.getType() == 11 && "focus-angle".equals(keyword3 = term.token.getText().toLowerCase(Locale.ROOT))) {
            prev = term;
            term = term.nextInSeries;
            if (term == null) {
                this.error(prev, "Expected '<number>'");
            }
            if (term.token == null) {
                this.error(prev, "Expected '<number>'");
            }
            focusAngle = this.parseSize(term);
            prev = term;
            term = term.nextInSeries;
            if (term == null) {
                this.error(prev, "Expected 'focus-distance <number>', 'center (<number>,<number>)' or '<size>'");
            }
            if (term.token == null) {
                this.error(term, "Expected 'focus-distance <number>', 'center (<number>,<number>)' or '<size>'");
            }
        }
        ParsedValueImpl<?, Size> focusDistance = null;
        if (term.token.getType() == 11 && "focus-distance".equals(keyword2 = term.token.getText().toLowerCase(Locale.ROOT))) {
            prev = term;
            term = term.nextInSeries;
            if (term == null) {
                this.error(prev, "Expected '<number>'");
            }
            if (term.token == null) {
                this.error(prev, "Expected '<number>'");
            }
            focusDistance = this.parseSize(term);
            prev = term;
            term = term.nextInSeries;
            if (term == null) {
                this.error(prev, "Expected  'center (<number>,<number>)' or '<size>'");
            }
            if (term.token == null) {
                this.error(term, "Expected  'center (<number>,<number>)' or '<size>'");
            }
        }
        ParsedValueImpl[] centerPoint = null;
        if (term.token.getType() == 11 && "center".equals(keyword = term.token.getText().toLowerCase(Locale.ROOT))) {
            prev = term;
            term = term.nextInSeries;
            if (term == null) {
                this.error(prev, "Expected '(<number>,<number>)'");
            }
            if (term.token == null || term.token.getType() != 34) {
                this.error(term, "Expected '(<number>,<number>)'");
            }
            centerPoint = this.point(term);
            prev = term;
            term = term.nextInSeries;
            if (term == null) {
                this.error(prev, "Expected '<size>'");
            }
            if (term.token == null) {
                this.error(term, "Expected '<size>'");
            }
        }
        ParsedValueImpl<?, Size> radius = this.parseSize(term);
        prev = term;
        term = term.nextInSeries;
        if (term == null) {
            this.error(prev, "Expected 'stops' keyword");
        }
        if (term.token == null || term.token.getType() != 11) {
            this.error(term, "Expected 'stops' keyword");
        }
        if (!"stops".equalsIgnoreCase(term.token.getText())) {
            this.error(term, "Expected 'stops'");
        }
        prev = term;
        term = term.nextInSeries;
        if (term == null) {
            this.error(prev, "Expected '(<number>, <number>)'");
        }
        int nStops = 0;
        Term temp = term;
        do {
            ++nStops;
        } while ((temp = temp.nextInSeries) != null && temp.token != null && temp.token.getType() == 34);
        ParsedValueImpl[] stops = new ParsedValueImpl[nStops];
        int stopIndex = 0;
        do {
            ParsedValueImpl<ParsedValue[], Stop> stop;
            if ((stop = this.stop(term)) != null) {
                stops[stopIndex++] = stop;
            }
            prev = term;
        } while ((term = term.nextInSeries) != null && term.token.getType() == 34);
        ParsedValueImpl<String, CycleMethod> cycleMethod = this.cycleMethod(term);
        if (cycleMethod == null) {
            cycleMethod = new ParsedValueImpl(CycleMethod.NO_CYCLE.name(), new EnumConverter<CycleMethod>(CycleMethod.class));
            if (term != null) {
                root.nextInSeries = term;
            } else {
                root.nextInSeries = null;
                root.nextLayer = prev.nextLayer;
            }
        } else {
            root.nextInSeries = term.nextInSeries;
            root.nextLayer = term.nextLayer;
        }
        ParsedValueImpl[] values = new ParsedValueImpl[6 + stops.length];
        int index = 0;
        values[index++] = focusAngle;
        values[index++] = focusDistance;
        values[index++] = centerPoint != null ? centerPoint[0] : null;
        values[index++] = centerPoint != null ? centerPoint[1] : null;
        values[index++] = radius;
        values[index++] = cycleMethod;
        for (int n = 0; n < stops.length; ++n) {
            values[index++] = stops[n];
        }
        return new ParsedValueImpl<ParsedValue[], Paint>(values, PaintConverter.RadialGradientConverter.getInstance());
    }

    private ParsedValueImpl parseRadialGradient(Term root) throws ParseException {
        Term arg;
        String fn;
        String string = fn = root.token != null ? root.token.getText() : null;
        if (!"radial-gradient".regionMatches(true, 0, fn, 0, 15)) {
            String msg = "Expected 'radial-gradient'";
            this.error(root, "Expected 'radial-gradient'");
        }
        if ((arg = root.firstArg) == null || arg.token == null || arg.token.getText().isEmpty()) {
            this.error(root, "Expected 'focus-angle <angle>' or 'focus-distance <percentage>' or 'center <point>' or 'radius [<length> | <percentage>]'");
        }
        Term prev = arg;
        ParsedValueImpl focusAngle = null;
        ParsedValueImpl focusDistance = null;
        ParsedValueImpl[] centerPoint = null;
        ParsedValueImpl<?, Size> radius = null;
        if ("focus-angle".equalsIgnoreCase(arg.token.getText())) {
            prev = arg;
            arg = arg.nextInSeries;
            if (arg == null || !this.isSize(arg.token)) {
                this.error(prev, "Expected '<angle>'");
            }
            Size angle = this.size(arg.token);
            switch (angle.getUnits()) {
                case DEG: 
                case RAD: 
                case GRAD: 
                case TURN: 
                case PX: {
                    break;
                }
                default: {
                    this.error(arg, "Expected [deg | rad | grad | turn ]");
                }
            }
            focusAngle = new ParsedValueImpl(angle, null);
            prev = arg;
            arg = arg.nextArg;
            if (arg == null) {
                this.error(prev, "Expected 'focus-distance <percentage>' or 'center <point>' or 'radius [<length> | <percentage>]'");
            }
        }
        if ("focus-distance".equalsIgnoreCase(arg.token.getText())) {
            prev = arg;
            arg = arg.nextInSeries;
            if (arg == null || !this.isSize(arg.token)) {
                this.error(prev, "Expected '<percentage>'");
            }
            Size distance = this.size(arg.token);
            switch (distance.getUnits()) {
                case PERCENT: {
                    break;
                }
                default: {
                    this.error(arg, "Expected '%'");
                }
            }
            focusDistance = new ParsedValueImpl(distance, null);
            prev = arg;
            arg = arg.nextArg;
            if (arg == null) {
                this.error(prev, "Expected 'center <center>' or 'radius <length>'");
            }
        }
        if ("center".equalsIgnoreCase(arg.token.getText())) {
            prev = arg;
            arg = arg.nextInSeries;
            if (arg == null) {
                this.error(prev, "Expected '<point>'");
            }
            ParsedValueImpl<?, Size> ptX = this.parseSize(arg);
            prev = arg;
            arg = arg.nextInSeries;
            if (arg == null) {
                this.error(prev, "Expected '<point>'");
            }
            ParsedValueImpl<?, Size> ptY = this.parseSize(arg);
            centerPoint = new ParsedValueImpl[]{ptX, ptY};
            prev = arg;
            arg = arg.nextArg;
            if (arg == null) {
                this.error(prev, "Expected 'radius [<length> | <percentage>]'");
            }
        }
        if ("radius".equalsIgnoreCase(arg.token.getText())) {
            prev = arg;
            arg = arg.nextInSeries;
            if (arg == null || !this.isSize(arg.token)) {
                this.error(prev, "Expected '[<length> | <percentage>]'");
            }
            radius = this.parseSize(arg);
            prev = arg;
            arg = arg.nextArg;
            if (arg == null) {
                this.error(prev, "Expected 'radius [<length> | <percentage>]'");
            }
        }
        CycleMethod cycleMethod = CycleMethod.NO_CYCLE;
        if ("reflect".equalsIgnoreCase(arg.token.getText())) {
            cycleMethod = CycleMethod.REFLECT;
            prev = arg;
            arg = arg.nextArg;
        } else if ("repeat".equalsIgnoreCase(arg.token.getText())) {
            cycleMethod = CycleMethod.REFLECT;
            prev = arg;
            arg = arg.nextArg;
        }
        if (arg == null || arg.token == null || arg.token.getText().isEmpty()) {
            this.error(prev, "Expected '<color-stop>'");
        }
        ParsedValueImpl<ParsedValue[], Stop>[] stops = this.parseColorStops(arg);
        ParsedValueImpl[] values = new ParsedValueImpl[6 + stops.length];
        int index = 0;
        values[index++] = focusAngle;
        values[index++] = focusDistance;
        values[index++] = centerPoint != null ? centerPoint[0] : null;
        values[index++] = centerPoint != null ? centerPoint[1] : null;
        values[index++] = radius;
        values[index++] = new ParsedValueImpl(cycleMethod.name(), new EnumConverter<CycleMethod>(CycleMethod.class));
        for (int n = 0; n < stops.length; ++n) {
            values[index++] = stops[n];
        }
        return new ParsedValueImpl<ParsedValue[], Paint>(values, PaintConverter.RadialGradientConverter.getInstance());
    }

    private ParsedValueImpl<ParsedValue[], Paint> parseImagePattern(Term root) throws ParseException {
        Token token;
        Term arg;
        String fn;
        String string = fn = root.token != null ? root.token.getText() : null;
        if (!"image-pattern".regionMatches(true, 0, fn, 0, 13)) {
            String msg = "Expected 'image-pattern'";
            this.error(root, "Expected 'image-pattern'");
        }
        if ((arg = root.firstArg) == null || arg.token == null || arg.token.getText().isEmpty()) {
            this.error(root, "Expected '<uri-string>'");
        }
        Term prev = arg;
        String uri = arg.token.getText();
        ParsedValueImpl[] uriValues = new ParsedValueImpl[]{new ParsedValueImpl<String, String>(uri, StringConverter.getInstance()), null};
        ParsedValueImpl<ParsedValue[], String> parsedURI = new ParsedValueImpl<ParsedValue[], String>(uriValues, URLConverter.getInstance());
        if (arg.nextArg == null) {
            ParsedValueImpl[] values = new ParsedValueImpl[]{parsedURI};
            return new ParsedValueImpl<ParsedValue[], Paint>(values, PaintConverter.ImagePatternConverter.getInstance());
        }
        arg = arg.nextArg;
        if (arg == null) {
            this.error(prev, "Expected '<size>'");
        }
        ParsedValueImpl<?, Size> x = this.parseSize(arg);
        prev = arg;
        arg = arg.nextArg;
        if (arg == null) {
            this.error(prev, "Expected '<size>'");
        }
        ParsedValueImpl<?, Size> y = this.parseSize(arg);
        prev = arg;
        arg = arg.nextArg;
        if (arg == null) {
            this.error(prev, "Expected '<size>'");
        }
        ParsedValueImpl<?, Size> w = this.parseSize(arg);
        prev = arg;
        arg = arg.nextArg;
        if (arg == null) {
            this.error(prev, "Expected '<size>'");
        }
        ParsedValueImpl<?, Size> h = this.parseSize(arg);
        if (arg.nextArg == null) {
            ParsedValueImpl[] values = new ParsedValueImpl[]{parsedURI, x, y, w, h};
            return new ParsedValueImpl<ParsedValue[], Paint>(values, PaintConverter.ImagePatternConverter.getInstance());
        }
        prev = arg;
        arg = arg.nextArg;
        if (arg == null) {
            this.error(prev, "Expected '<boolean>'");
        }
        if ((token = arg.token) == null || token.getText() == null) {
            this.error(arg, "Expected '<boolean>'");
        }
        ParsedValueImpl[] values = new ParsedValueImpl[]{parsedURI, x, y, w, h, new ParsedValueImpl(Boolean.parseBoolean(token.getText()), null)};
        return new ParsedValueImpl<ParsedValue[], Paint>(values, PaintConverter.ImagePatternConverter.getInstance());
    }

    private ParsedValueImpl<ParsedValue[], Paint> parseRepeatingImagePattern(Term root) throws ParseException {
        Term arg;
        String fn;
        String string = fn = root.token != null ? root.token.getText() : null;
        if (!"repeating-image-pattern".regionMatches(true, 0, fn, 0, 23)) {
            String msg = "Expected 'repeating-image-pattern'";
            this.error(root, "Expected 'repeating-image-pattern'");
        }
        if ((arg = root.firstArg) == null || arg.token == null || arg.token.getText().isEmpty()) {
            this.error(root, "Expected '<uri-string>'");
        }
        String uri = arg.token.getText();
        ParsedValueImpl[] uriValues = new ParsedValueImpl[]{new ParsedValueImpl<String, String>(uri, StringConverter.getInstance()), null};
        ParsedValueImpl<ParsedValue[], String> parsedURI = new ParsedValueImpl<ParsedValue[], String>(uriValues, URLConverter.getInstance());
        ParsedValueImpl[] values = new ParsedValueImpl[]{parsedURI};
        return new ParsedValueImpl<ParsedValue[], Paint>(values, PaintConverter.RepeatingImagePatternConverter.getInstance());
    }

    private ParsedValueImpl<ParsedValue<?, Paint>[], Paint[]> parsePaintLayers(Term root) throws ParseException {
        int nPaints = this.numberOfLayers(root);
        ParsedValueImpl[] paints = new ParsedValueImpl[nPaints];
        Term temp = root;
        int paint = 0;
        do {
            if (temp.token == null || temp.token.getText() == null || temp.token.getText().isEmpty()) {
                this.error(temp, "Expected '<paint>'");
            }
            paints[paint++] = this.parse(temp);
        } while ((temp = this.nextLayer(temp)) != null);
        return new ParsedValueImpl<ParsedValue<?, Paint>[], Paint[]>(paints, PaintConverter.SequenceConverter.getInstance());
    }

    private ParsedValueImpl<?, Size>[] parseSize1to4(Term root) throws ParseException {
        Term temp = root;
        ParsedValueImpl[] sides = new ParsedValueImpl[4];
        int side = 0;
        while (side < 4 && temp != null) {
            sides[side++] = this.parseSize(temp);
            temp = temp.nextInSeries;
        }
        if (side < 2) {
            sides[1] = sides[0];
        }
        if (side < 3) {
            sides[2] = sides[0];
        }
        if (side < 4) {
            sides[3] = sides[1];
        }
        return sides;
    }

    private ParsedValueImpl<ParsedValue<ParsedValue[], Insets>[], Insets[]> parseInsetsLayers(Term root) throws ParseException {
        int nLayers = this.numberOfLayers(root);
        Term temp = root;
        int layer = 0;
        ParsedValueImpl[] layers = new ParsedValueImpl[nLayers];
        while (temp != null) {
            ParsedValueImpl<?, Size>[] sides = this.parseSize1to4(temp);
            layers[layer++] = new ParsedValueImpl<ParsedValue[], Insets>(sides, InsetsConverter.getInstance());
            while (temp.nextInSeries != null) {
                temp = temp.nextInSeries;
            }
            temp = this.nextLayer(temp);
        }
        return new ParsedValueImpl<ParsedValue<ParsedValue[], Insets>[], Insets[]>(layers, InsetsConverter.SequenceConverter.getInstance());
    }

    private ParsedValueImpl<ParsedValue[], Insets> parseInsetsLayer(Term root) throws ParseException {
        Term temp = root;
        ParsedValueImpl<ParsedValue[], Insets> layer = null;
        while (temp != null) {
            ParsedValueImpl<?, Size>[] sides = this.parseSize1to4(temp);
            layer = new ParsedValueImpl<ParsedValue[], Insets>(sides, InsetsConverter.getInstance());
            while (temp.nextInSeries != null) {
                temp = temp.nextInSeries;
            }
            temp = this.nextLayer(temp);
        }
        return layer;
    }

    private ParsedValueImpl<ParsedValue<ParsedValue[], Margins>[], Margins[]> parseMarginsLayers(Term root) throws ParseException {
        int nLayers = this.numberOfLayers(root);
        Term temp = root;
        int layer = 0;
        ParsedValueImpl[] layers = new ParsedValueImpl[nLayers];
        while (temp != null) {
            ParsedValueImpl<?, Size>[] sides = this.parseSize1to4(temp);
            layers[layer++] = new ParsedValueImpl<ParsedValue[], Margins>(sides, Margins.Converter.getInstance());
            while (temp.nextInSeries != null) {
                temp = temp.nextInSeries;
            }
            temp = this.nextLayer(temp);
        }
        return new ParsedValueImpl<ParsedValue<ParsedValue[], Margins>[], Margins[]>(layers, Margins.SequenceConverter.getInstance());
    }

    private ParsedValueImpl<Size, Size>[] parseSizeSeries(Term root) throws ParseException {
        if (root.token == null) {
            this.error(root, "Parse error");
        }
        ArrayList sizes = new ArrayList();
        Term term = root;
        while (term != null) {
            Token token = term.token;
            int ttype = token.getType();
            switch (ttype) {
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: {
                    ParsedValueImpl sizeValue = new ParsedValueImpl(this.size(token), null);
                    sizes.add(sizeValue);
                    break;
                }
                default: {
                    this.error(root, "expected series of <size>");
                }
            }
            term = term.nextInSeries;
        }
        return sizes.toArray(new ParsedValueImpl[sizes.size()]);
    }

    private ParsedValueImpl<ParsedValue<ParsedValue<?, Size>[][], CornerRadii>[], CornerRadii[]> parseCornerRadius(Term root) throws ParseException {
        int nLayers = this.numberOfLayers(root);
        Term term = root;
        int layer = 0;
        ParsedValueImpl[] layers = new ParsedValueImpl[nLayers];
        while (term != null) {
            int nHorizontalTerms = 0;
            Term temp = term;
            while (temp != null) {
                if (temp.token.getType() == 32) {
                    temp = temp.nextInSeries;
                    break;
                }
                ++nHorizontalTerms;
                temp = temp.nextInSeries;
            }
            int nVerticalTerms = 0;
            while (temp != null) {
                if (temp.token.getType() == 32) {
                    this.error(temp, "unexpected SOLIDUS");
                    break;
                }
                ++nVerticalTerms;
                temp = temp.nextInSeries;
            }
            if (nHorizontalTerms == 0 || nHorizontalTerms > 4 || nVerticalTerms > 4) {
                this.error(root, "expected [<length>|<percentage>]{1,4} [/ [<length>|<percentage>]{1,4}]?");
            }
            int orientation = 0;
            ParsedValueImpl[][] radii = new ParsedValueImpl[2][4];
            ParsedValueImpl zero = new ParsedValueImpl(new Size(0.0, SizeUnits.PX), null);
            for (int r = 0; r < 4; ++r) {
                radii[0][r] = zero;
                radii[1][r] = zero;
            }
            int hr = 0;
            int vr = 0;
            Term lastTerm = term;
            while (hr <= 4 && vr <= 4 && term != null) {
                if (term.token.getType() == 32) {
                    ++orientation;
                } else {
                    ParsedValueImpl<?, Size> parsedValue = this.parseSize(term);
                    if (orientation == 0) {
                        radii[orientation][hr++] = parsedValue;
                    } else {
                        radii[orientation][vr++] = parsedValue;
                    }
                }
                lastTerm = term;
                term = term.nextInSeries;
            }
            if (hr != 0) {
                if (hr < 2) {
                    radii[0][1] = radii[0][0];
                }
                if (hr < 3) {
                    radii[0][2] = radii[0][0];
                }
                if (hr < 4) {
                    radii[0][3] = radii[0][1];
                }
            } else assert (false);
            if (vr != 0) {
                if (vr < 2) {
                    radii[1][1] = radii[1][0];
                }
                if (vr < 3) {
                    radii[1][2] = radii[1][0];
                }
                if (vr < 4) {
                    radii[1][3] = radii[1][1];
                }
            } else {
                radii[1][0] = radii[0][0];
                radii[1][1] = radii[0][1];
                radii[1][2] = radii[0][2];
                radii[1][3] = radii[0][3];
            }
            if (zero.equals(radii[0][0]) || zero.equals(radii[1][0])) {
                ParsedValueImpl parsedValueImpl = zero;
                radii[0][0] = parsedValueImpl;
                radii[1][0] = parsedValueImpl;
            }
            if (zero.equals(radii[0][1]) || zero.equals(radii[1][1])) {
                ParsedValueImpl parsedValueImpl = zero;
                radii[0][1] = parsedValueImpl;
                radii[1][1] = parsedValueImpl;
            }
            if (zero.equals(radii[0][2]) || zero.equals(radii[1][2])) {
                ParsedValueImpl parsedValueImpl = zero;
                radii[0][2] = parsedValueImpl;
                radii[1][2] = parsedValueImpl;
            }
            if (zero.equals(radii[0][3]) || zero.equals(radii[1][3])) {
                ParsedValueImpl parsedValueImpl = zero;
                radii[0][3] = parsedValueImpl;
                radii[1][3] = parsedValueImpl;
            }
            layers[layer++] = new ParsedValueImpl(radii, null);
            term = this.nextLayer(lastTerm);
        }
        return new ParsedValueImpl<ParsedValue<ParsedValue<?, Size>[][], CornerRadii>[], CornerRadii[]>(layers, CornerRadiiConverter.getInstance());
    }

    private static boolean isPositionKeyWord(String value) {
        return "center".equalsIgnoreCase(value) || "top".equalsIgnoreCase(value) || "bottom".equalsIgnoreCase(value) || "left".equalsIgnoreCase(value) || "right".equalsIgnoreCase(value);
    }

    private ParsedValueImpl<ParsedValue[], BackgroundPosition> parseBackgroundPosition(Term term) throws ParseException {
        String v1;
        ParsedValueImpl<Size, Size> left;
        Token valueFour;
        if (term.token == null || term.token.getText() == null || term.token.getText().isEmpty()) {
            this.error(term, "Expected '<bg-position>'");
        }
        Object termOne = term;
        Token valueOne = term.token;
        Term termTwo = ((Term)termOne).nextInSeries;
        Token valueTwo = termTwo != null ? termTwo.token : null;
        Term termThree = termTwo != null ? termTwo.nextInSeries : null;
        Token valueThree = termThree != null ? termThree.token : null;
        Term termFour = termThree != null ? termThree.nextInSeries : null;
        Token token = valueFour = termFour != null ? termFour.token : null;
        if (valueOne != null && valueTwo != null && valueThree == null && valueFour == null) {
            String v12 = valueOne.getText();
            String v2 = valueTwo.getText();
            if (("top".equals(v12) || "bottom".equals(v12)) && ("left".equals(v2) || "right".equals(v2) || "center".equals(v2))) {
                Object tmp = valueTwo;
                valueTwo = valueOne;
                valueOne = tmp;
                tmp = termTwo;
                termTwo = termOne;
                termOne = tmp;
            }
        } else if (valueOne != null && valueTwo != null && valueThree != null) {
            Term[] termArray = null;
            Token[] tokeArray = null;
            if (valueFour != null) {
                if (("top".equals(valueOne.getText()) || "bottom".equals(valueOne.getText())) && ("left".equals(valueThree.getText()) || "right".equals(valueThree.getText()))) {
                    termArray = new Term[]{termThree, termFour, termOne, termTwo};
                    tokeArray = new Token[]{valueThree, valueFour, valueOne, valueTwo};
                }
            } else if ("top".equals(valueOne.getText()) || "bottom".equals(valueOne.getText())) {
                if ("left".equals(valueTwo.getText()) || "right".equals(valueTwo.getText())) {
                    termArray = new Term[]{termTwo, termThree, termOne, null};
                    tokeArray = new Token[]{valueTwo, valueThree, valueOne, null};
                } else {
                    termArray = new Term[]{termThree, termOne, termTwo, null};
                    tokeArray = new Token[]{valueThree, valueOne, valueTwo, null};
                }
            }
            if (termArray != null) {
                termOne = termArray[0];
                termTwo = termArray[1];
                termThree = termArray[2];
                termFour = termArray[3];
                valueOne = tokeArray[0];
                valueTwo = tokeArray[1];
                valueThree = tokeArray[2];
                valueFour = tokeArray[3];
            }
        }
        ParsedValueImpl<Size, Size> bottom = left = ZERO_PERCENT;
        ParsedValueImpl<Size, Size> right = left;
        ParsedValueImpl<Size, Size> top = left;
        if (valueOne == null && valueTwo == null && valueThree == null && valueFour == null) {
            this.error(term, "No value found for background-position");
        } else if (valueOne != null && valueTwo == null && valueThree == null && valueFour == null) {
            v1 = valueOne.getText();
            if ("center".equals(v1)) {
                left = FIFTY_PERCENT;
                right = ZERO_PERCENT;
                top = FIFTY_PERCENT;
                bottom = ZERO_PERCENT;
            } else if ("left".equals(v1)) {
                left = ZERO_PERCENT;
                right = ZERO_PERCENT;
                top = FIFTY_PERCENT;
                bottom = ZERO_PERCENT;
            } else if ("right".equals(v1)) {
                left = ONE_HUNDRED_PERCENT;
                right = ZERO_PERCENT;
                top = FIFTY_PERCENT;
                bottom = ZERO_PERCENT;
            } else if ("top".equals(v1)) {
                left = FIFTY_PERCENT;
                right = ZERO_PERCENT;
                top = ZERO_PERCENT;
                bottom = ZERO_PERCENT;
            } else if ("bottom".equals(v1)) {
                left = FIFTY_PERCENT;
                right = ZERO_PERCENT;
                top = ONE_HUNDRED_PERCENT;
                bottom = ZERO_PERCENT;
            } else {
                left = this.parseSize((Term)termOne);
                right = ZERO_PERCENT;
                top = FIFTY_PERCENT;
                bottom = ZERO_PERCENT;
            }
        } else if (valueOne != null && valueTwo != null && valueThree == null && valueFour == null) {
            v1 = valueOne.getText().toLowerCase(Locale.ROOT);
            String v2 = valueTwo.getText().toLowerCase(Locale.ROOT);
            if (!CSSParser.isPositionKeyWord(v1)) {
                left = this.parseSize((Term)termOne);
                right = ZERO_PERCENT;
                if ("top".equals(v2)) {
                    top = ZERO_PERCENT;
                    bottom = ZERO_PERCENT;
                } else if ("bottom".equals(v2)) {
                    top = ONE_HUNDRED_PERCENT;
                    bottom = ZERO_PERCENT;
                } else if ("center".equals(v2)) {
                    top = FIFTY_PERCENT;
                    bottom = ZERO_PERCENT;
                } else if (!CSSParser.isPositionKeyWord(v2)) {
                    top = this.parseSize(termTwo);
                    bottom = ZERO_PERCENT;
                } else {
                    this.error(termTwo, "Expected 'top', 'bottom', 'center' or <size>");
                }
            } else if (v1.equals("left") || v1.equals("right")) {
                left = v1.equals("right") ? ONE_HUNDRED_PERCENT : ZERO_PERCENT;
                right = ZERO_PERCENT;
                if (!CSSParser.isPositionKeyWord(v2)) {
                    top = this.parseSize(termTwo);
                    bottom = ZERO_PERCENT;
                } else if (v2.equals("top") || v2.equals("bottom") || v2.equals("center")) {
                    if (v2.equals("top")) {
                        top = ZERO_PERCENT;
                        bottom = ZERO_PERCENT;
                    } else if (v2.equals("center")) {
                        top = FIFTY_PERCENT;
                        bottom = ZERO_PERCENT;
                    } else {
                        top = ONE_HUNDRED_PERCENT;
                        bottom = ZERO_PERCENT;
                    }
                } else {
                    this.error(termTwo, "Expected 'top', 'bottom', 'center' or <size>");
                }
            } else if (v1.equals("center")) {
                left = FIFTY_PERCENT;
                right = ZERO_PERCENT;
                if (v2.equals("top")) {
                    top = ZERO_PERCENT;
                    bottom = ZERO_PERCENT;
                } else if (v2.equals("bottom")) {
                    top = ONE_HUNDRED_PERCENT;
                    bottom = ZERO_PERCENT;
                } else if (v2.equals("center")) {
                    top = FIFTY_PERCENT;
                    bottom = ZERO_PERCENT;
                } else if (!CSSParser.isPositionKeyWord(v2)) {
                    top = this.parseSize(termTwo);
                    bottom = ZERO_PERCENT;
                } else {
                    this.error(termTwo, "Expected 'top', 'bottom', 'center' or <size>");
                }
            }
        } else if (valueOne != null && valueTwo != null && valueThree != null && valueFour == null) {
            v1 = valueOne.getText().toLowerCase(Locale.ROOT);
            String v2 = valueTwo.getText().toLowerCase(Locale.ROOT);
            String v3 = valueThree.getText().toLowerCase(Locale.ROOT);
            if (!CSSParser.isPositionKeyWord(v1) || "center".equals(v1)) {
                left = "center".equals(v1) ? FIFTY_PERCENT : this.parseSize((Term)termOne);
                right = ZERO_PERCENT;
                if (!CSSParser.isPositionKeyWord(v3)) {
                    if ("top".equals(v2)) {
                        top = this.parseSize(termThree);
                        bottom = ZERO_PERCENT;
                    } else if ("bottom".equals(v2)) {
                        top = ZERO_PERCENT;
                        bottom = this.parseSize(termThree);
                    } else {
                        this.error(termTwo, "Expected 'top' or 'bottom'");
                    }
                } else {
                    this.error(termThree, "Expected <size>");
                }
            } else if ("left".equals(v1) || "right".equals(v1)) {
                if (!CSSParser.isPositionKeyWord(v2)) {
                    if ("left".equals(v1)) {
                        left = this.parseSize(termTwo);
                        right = ZERO_PERCENT;
                    } else {
                        left = ZERO_PERCENT;
                        right = this.parseSize(termTwo);
                    }
                    if ("top".equals(v3)) {
                        top = ZERO_PERCENT;
                        bottom = ZERO_PERCENT;
                    } else if ("bottom".equals(v3)) {
                        top = ONE_HUNDRED_PERCENT;
                        bottom = ZERO_PERCENT;
                    } else if ("center".equals(v3)) {
                        top = FIFTY_PERCENT;
                        bottom = ZERO_PERCENT;
                    } else {
                        this.error(termThree, "Expected 'top', 'bottom' or 'center'");
                    }
                } else {
                    if ("left".equals(v1)) {
                        left = ZERO_PERCENT;
                        right = ZERO_PERCENT;
                    } else {
                        left = ONE_HUNDRED_PERCENT;
                        right = ZERO_PERCENT;
                    }
                    if (!CSSParser.isPositionKeyWord(v3)) {
                        if ("top".equals(v2)) {
                            top = this.parseSize(termThree);
                            bottom = ZERO_PERCENT;
                        } else if ("bottom".equals(v2)) {
                            top = ZERO_PERCENT;
                            bottom = this.parseSize(termThree);
                        } else {
                            this.error(termTwo, "Expected 'top' or 'bottom'");
                        }
                    } else {
                        this.error(termThree, "Expected <size>");
                    }
                }
            }
        } else {
            v1 = valueOne.getText().toLowerCase(Locale.ROOT);
            String v2 = valueTwo.getText().toLowerCase(Locale.ROOT);
            String v3 = valueThree.getText().toLowerCase(Locale.ROOT);
            String v4 = valueFour.getText().toLowerCase(Locale.ROOT);
            if ((v1.equals("left") || v1.equals("right")) && (v3.equals("top") || v3.equals("bottom")) && !CSSParser.isPositionKeyWord(v2) && !CSSParser.isPositionKeyWord(v4)) {
                if (v1.equals("left")) {
                    left = this.parseSize(termTwo);
                    right = ZERO_PERCENT;
                } else {
                    left = ZERO_PERCENT;
                    right = this.parseSize(termTwo);
                }
                if (v3.equals("top")) {
                    top = this.parseSize(termFour);
                    bottom = ZERO_PERCENT;
                } else {
                    top = ZERO_PERCENT;
                    bottom = this.parseSize(termFour);
                }
            } else {
                this.error(term, "Expected 'left' or 'right' followed by <size> followed by 'top' or 'bottom' followed by <size>");
            }
        }
        ParsedValueImpl[] values = new ParsedValueImpl[]{top, right, bottom, left};
        return new ParsedValueImpl<ParsedValue[], BackgroundPosition>(values, BackgroundPositionConverter.getInstance());
    }

    private ParsedValueImpl<ParsedValue<ParsedValue[], BackgroundPosition>[], BackgroundPosition[]> parseBackgroundPositionLayers(Term root) throws ParseException {
        int nLayers = this.numberOfLayers(root);
        ParsedValueImpl[] layers = new ParsedValueImpl[nLayers];
        int layer = 0;
        Term term = root;
        while (term != null) {
            layers[layer++] = this.parseBackgroundPosition(term);
            term = this.nextLayer(term);
        }
        return new ParsedValueImpl<ParsedValue<ParsedValue[], BackgroundPosition>[], BackgroundPosition[]>(layers, LayeredBackgroundPositionConverter.getInstance());
    }

    private ParsedValueImpl<String, BackgroundRepeat>[] parseRepeatStyle(Term root) throws ParseException {
        String text;
        BackgroundRepeat yAxis;
        BackgroundRepeat xAxis = yAxis = BackgroundRepeat.NO_REPEAT;
        Term term = root;
        if (term.token == null || term.token.getType() != 11 || term.token.getText() == null || term.token.getText().isEmpty()) {
            this.error(term, "Expected '<repeat-style>'");
        }
        if ("repeat-x".equals(text = term.token.getText().toLowerCase(Locale.ROOT))) {
            xAxis = BackgroundRepeat.REPEAT;
            yAxis = BackgroundRepeat.NO_REPEAT;
        } else if ("repeat-y".equals(text)) {
            xAxis = BackgroundRepeat.NO_REPEAT;
            yAxis = BackgroundRepeat.REPEAT;
        } else if ("repeat".equals(text)) {
            xAxis = BackgroundRepeat.REPEAT;
            yAxis = BackgroundRepeat.REPEAT;
        } else if ("space".equals(text)) {
            xAxis = BackgroundRepeat.SPACE;
            yAxis = BackgroundRepeat.SPACE;
        } else if ("round".equals(text)) {
            xAxis = BackgroundRepeat.ROUND;
            yAxis = BackgroundRepeat.ROUND;
        } else if ("no-repeat".equals(text)) {
            xAxis = BackgroundRepeat.NO_REPEAT;
            yAxis = BackgroundRepeat.NO_REPEAT;
        } else if ("stretch".equals(text)) {
            xAxis = BackgroundRepeat.NO_REPEAT;
            yAxis = BackgroundRepeat.NO_REPEAT;
        } else {
            this.error(term, "Expected  '<repeat-style>' " + text);
        }
        term = term.nextInSeries;
        if (term != null && term.token != null && term.token.getType() == 11 && term.token.getText() != null && !term.token.getText().isEmpty()) {
            text = term.token.getText().toLowerCase(Locale.ROOT);
            if ("repeat-x".equals(text)) {
                this.error(term, "Unexpected 'repeat-x'");
            } else if ("repeat-y".equals(text)) {
                this.error(term, "Unexpected 'repeat-y'");
            } else if ("repeat".equals(text)) {
                yAxis = BackgroundRepeat.REPEAT;
            } else if ("space".equals(text)) {
                yAxis = BackgroundRepeat.SPACE;
            } else if ("round".equals(text)) {
                yAxis = BackgroundRepeat.ROUND;
            } else if ("no-repeat".equals(text)) {
                yAxis = BackgroundRepeat.NO_REPEAT;
            } else if ("stretch".equals(text)) {
                yAxis = BackgroundRepeat.NO_REPEAT;
            } else {
                this.error(term, "Expected  '<repeat-style>'");
            }
        }
        return new ParsedValueImpl[]{new ParsedValueImpl(xAxis.name(), new EnumConverter<BackgroundRepeat>(BackgroundRepeat.class)), new ParsedValueImpl(yAxis.name(), new EnumConverter<BackgroundRepeat>(BackgroundRepeat.class))};
    }

    private ParsedValueImpl<ParsedValue<String, BackgroundRepeat>[][], RepeatStruct[]> parseBorderImageRepeatStyleLayers(Term root) throws ParseException {
        int nLayers = this.numberOfLayers(root);
        ParsedValueImpl[][] layers = new ParsedValueImpl[nLayers][];
        int layer = 0;
        Term term = root;
        while (term != null) {
            layers[layer++] = this.parseRepeatStyle(term);
            term = this.nextLayer(term);
        }
        return new ParsedValueImpl<ParsedValue<String, BackgroundRepeat>[][], RepeatStruct[]>(layers, RepeatStructConverter.getInstance());
    }

    private ParsedValueImpl<ParsedValue<String, BackgroundRepeat>[][], RepeatStruct[]> parseBackgroundRepeatStyleLayers(Term root) throws ParseException {
        int nLayers = this.numberOfLayers(root);
        ParsedValueImpl[][] layers = new ParsedValueImpl[nLayers][];
        int layer = 0;
        Term term = root;
        while (term != null) {
            layers[layer++] = this.parseRepeatStyle(term);
            term = this.nextLayer(term);
        }
        return new ParsedValueImpl<ParsedValue<String, BackgroundRepeat>[][], RepeatStruct[]>(layers, RepeatStructConverter.getInstance());
    }

    private ParsedValueImpl<ParsedValue[], BackgroundSize> parseBackgroundSize(Term root) throws ParseException {
        String text;
        ParsedValueImpl<Size, Size> height = null;
        ParsedValueImpl<Object, Size> width = null;
        boolean cover = false;
        boolean contain = false;
        Term term = root;
        if (term.token == null) {
            this.error(term, "Expected '<bg-size>'");
        }
        if (term.token.getType() == 11) {
            String string = text = term.token.getText() != null ? term.token.getText().toLowerCase(Locale.ROOT) : null;
            if (!"auto".equals(text)) {
                if ("cover".equals(text)) {
                    cover = true;
                } else if ("contain".equals(text)) {
                    contain = true;
                } else if ("stretch".equals(text)) {
                    width = ONE_HUNDRED_PERCENT;
                    height = ONE_HUNDRED_PERCENT;
                } else {
                    this.error(term, "Expected 'auto', 'cover', 'contain', or  'stretch'");
                }
            }
        } else if (this.isSize(term.token)) {
            width = this.parseSize(term);
            height = null;
        } else {
            this.error(term, "Expected '<bg-size>'");
        }
        term = term.nextInSeries;
        if (term != null) {
            if (cover || contain) {
                this.error(term, "Unexpected '<bg-size>'");
            }
            if (term.token.getType() == 11) {
                String string = text = term.token.getText() != null ? term.token.getText().toLowerCase(Locale.ROOT) : null;
                if ("auto".equals(text)) {
                    height = null;
                } else if ("cover".equals(text)) {
                    this.error(term, "Unexpected 'cover'");
                } else if ("contain".equals(text)) {
                    this.error(term, "Unexpected 'contain'");
                } else if ("stretch".equals(text)) {
                    height = ONE_HUNDRED_PERCENT;
                } else {
                    this.error(term, "Expected 'auto' or 'stretch'");
                }
            } else if (this.isSize(term.token)) {
                height = this.parseSize(term);
            } else {
                this.error(term, "Expected '<bg-size>'");
            }
        }
        ParsedValueImpl[] values = new ParsedValueImpl[]{width, height, new ParsedValueImpl<String, Boolean>(cover ? "true" : "false", BooleanConverter.getInstance()), new ParsedValueImpl<String, Boolean>(contain ? "true" : "false", BooleanConverter.getInstance())};
        return new ParsedValueImpl<ParsedValue[], BackgroundSize>(values, BackgroundSizeConverter.getInstance());
    }

    private ParsedValueImpl<ParsedValue<ParsedValue[], BackgroundSize>[], BackgroundSize[]> parseBackgroundSizeLayers(Term root) throws ParseException {
        int nLayers = this.numberOfLayers(root);
        ParsedValueImpl[] layers = new ParsedValueImpl[nLayers];
        int layer = 0;
        Term term = root;
        while (term != null) {
            layers[layer++] = this.parseBackgroundSize(term);
            term = this.nextLayer(term);
        }
        return new ParsedValueImpl<ParsedValue<ParsedValue[], BackgroundSize>[], BackgroundSize[]>(layers, LayeredBackgroundSizeConverter.getInstance());
    }

    private ParsedValueImpl<ParsedValue<?, Paint>[], Paint[]> parseBorderPaint(Term root) throws ParseException {
        Term term = root;
        ParsedValueImpl[] paints = new ParsedValueImpl[4];
        int paint = 0;
        while (term != null) {
            if (term.token == null || paints.length <= paint) {
                this.error(term, "Expected '<paint>'");
            }
            paints[paint++] = this.parse(term);
            term = term.nextInSeries;
        }
        if (paint < 2) {
            paints[1] = paints[0];
        }
        if (paint < 3) {
            paints[2] = paints[0];
        }
        if (paint < 4) {
            paints[3] = paints[1];
        }
        return new ParsedValueImpl<ParsedValue<?, Paint>[], Paint[]>(paints, StrokeBorderPaintConverter.getInstance());
    }

    private ParsedValueImpl<ParsedValue<ParsedValue<?, Paint>[], Paint[]>[], Paint[][]> parseBorderPaintLayers(Term root) throws ParseException {
        int nLayers = this.numberOfLayers(root);
        ParsedValueImpl[] layers = new ParsedValueImpl[nLayers];
        int layer = 0;
        Term term = root;
        while (term != null) {
            layers[layer++] = this.parseBorderPaint(term);
            term = this.nextLayer(term);
        }
        return new ParsedValueImpl<ParsedValue<ParsedValue<?, Paint>[], Paint[]>[], Paint[][]>(layers, LayeredBorderPaintConverter.getInstance());
    }

    private ParsedValueImpl<ParsedValue<ParsedValue[], BorderStrokeStyle>[], BorderStrokeStyle[]> parseBorderStyleSeries(Term root) throws ParseException {
        Term term = root;
        ParsedValueImpl[] borders = new ParsedValueImpl[4];
        int border = 0;
        while (term != null) {
            borders[border++] = this.parseBorderStyle(term);
            term = term.nextInSeries;
        }
        if (border < 2) {
            borders[1] = borders[0];
        }
        if (border < 3) {
            borders[2] = borders[0];
        }
        if (border < 4) {
            borders[3] = borders[1];
        }
        return new ParsedValueImpl<ParsedValue<ParsedValue[], BorderStrokeStyle>[], BorderStrokeStyle[]>(borders, BorderStrokeStyleSequenceConverter.getInstance());
    }

    private ParsedValueImpl<ParsedValue<ParsedValue<ParsedValue[], BorderStrokeStyle>[], BorderStrokeStyle[]>[], BorderStrokeStyle[][]> parseBorderStyleLayers(Term root) throws ParseException {
        int nLayers = this.numberOfLayers(root);
        ParsedValueImpl[] layers = new ParsedValueImpl[nLayers];
        int layer = 0;
        Term term = root;
        while (term != null) {
            layers[layer++] = this.parseBorderStyleSeries(term);
            term = this.nextLayer(term);
        }
        return new ParsedValueImpl<ParsedValue<ParsedValue<ParsedValue[], BorderStrokeStyle>[], BorderStrokeStyle[]>[], BorderStrokeStyle[][]>(layers, LayeredBorderStyleConverter.getInstance());
    }

    private String getKeyword(Term term) {
        if (term != null && term.token != null && term.token.getType() == 11 && term.token.getText() != null && !term.token.getText().isEmpty()) {
            return term.token.getText().toLowerCase(Locale.ROOT);
        }
        return null;
    }

    private ParsedValueImpl<ParsedValue[], BorderStrokeStyle> parseBorderStyle(Term root) throws ParseException {
        ParsedValue<ParsedValue[], Number[]> dashStyle = null;
        ParsedValueImpl dashPhase = null;
        ParsedValueImpl<String, StrokeType> strokeType = null;
        ParsedValueImpl strokeLineJoin = null;
        ParsedValueImpl strokeMiterLimit = null;
        ParsedValueImpl<String, StrokeLineCap> strokeLineCap = null;
        Term term = root;
        dashStyle = this.dashStyle(term);
        Term prev = term;
        term = term.nextInSeries;
        String keyword = this.getKeyword(term);
        if ("phase".equals(keyword)) {
            prev = term;
            term = term.nextInSeries;
            if (term == null || term.token == null || !this.isSize(term.token)) {
                this.error(term, "Expected '<size>'");
            }
            ParsedValueImpl<?, Size> sizeVal = this.parseSize(term);
            dashPhase = new ParsedValueImpl(sizeVal, SizeConverter.getInstance());
            prev = term;
            term = term.nextInSeries;
        }
        if ((strokeType = this.parseStrokeType(term)) != null) {
            prev = term;
            term = term.nextInSeries;
        }
        if ("line-join".equals(keyword = this.getKeyword(term))) {
            prev = term;
            term = term.nextInSeries;
            ParsedValueImpl[] lineJoinValues = this.parseStrokeLineJoin(term);
            if (lineJoinValues != null) {
                strokeLineJoin = lineJoinValues[0];
                strokeMiterLimit = lineJoinValues[1];
            } else {
                this.error(term, "Expected 'miter <size>?', 'bevel' or 'round'");
            }
            prev = term;
            term = term.nextInSeries;
            keyword = this.getKeyword(term);
        }
        if ("line-cap".equals(keyword)) {
            prev = term;
            term = term.nextInSeries;
            strokeLineCap = this.parseStrokeLineCap(term);
            if (strokeLineCap == null) {
                this.error(term, "Expected 'square', 'butt' or 'round'");
            }
            prev = term;
            term = term.nextInSeries;
        }
        if (term != null) {
            root.nextInSeries = term;
        } else {
            root.nextInSeries = null;
            root.nextLayer = prev.nextLayer;
        }
        ParsedValue[] values = new ParsedValue[]{dashStyle, dashPhase, strokeType, strokeLineJoin, strokeMiterLimit, strokeLineCap};
        return new ParsedValueImpl<ParsedValue[], BorderStrokeStyle>(values, BorderStyleConverter.getInstance());
    }

    private ParsedValue<ParsedValue[], Number[]> dashStyle(Term root) throws ParseException {
        if (root.token == null) {
            this.error(root, "Expected '<dash-style>'");
        }
        int ttype = root.token.getType();
        ParsedValue<ParsedValue[], Number[]> segments = null;
        if (ttype == 11) {
            segments = this.borderStyle(root);
        } else if (ttype == 12) {
            segments = this.segments(root);
        } else {
            this.error(root, "Expected '<dash-style>'");
        }
        return segments;
    }

    private ParsedValue<ParsedValue[], Number[]> borderStyle(Term root) throws ParseException {
        String text;
        if (root.token == null || root.token.getType() != 11 || root.token.getText() == null || root.token.getText().isEmpty()) {
            this.error(root, "Expected '<border-style>'");
        }
        if ("none".equals(text = root.token.getText().toLowerCase(Locale.ROOT))) {
            return BorderStyleConverter.NONE;
        }
        if ("hidden".equals(text)) {
            return BorderStyleConverter.NONE;
        }
        if ("dotted".equals(text)) {
            return BorderStyleConverter.DOTTED;
        }
        if ("dashed".equals(text)) {
            return BorderStyleConverter.DASHED;
        }
        if ("solid".equals(text)) {
            return BorderStyleConverter.SOLID;
        }
        if ("double".equals(text)) {
            this.error(root, "Unsupported <border-style> 'double'");
        } else if ("groove".equals(text)) {
            this.error(root, "Unsupported <border-style> 'groove'");
        } else if ("ridge".equals(text)) {
            this.error(root, "Unsupported <border-style> 'ridge'");
        } else if ("inset".equals(text)) {
            this.error(root, "Unsupported <border-style> 'inset'");
        } else if ("outset".equals(text)) {
            this.error(root, "Unsupported <border-style> 'outset'");
        } else {
            this.error(root, "Unsupported <border-style> '" + text + "'");
        }
        return BorderStyleConverter.SOLID;
    }

    private ParsedValueImpl<ParsedValue[], Number[]> segments(Term root) throws ParseException {
        Term arg;
        String fn;
        String string = fn = root.token != null ? root.token.getText() : null;
        if (!"segments".regionMatches(true, 0, fn, 0, 8)) {
            this.error(root, "Expected 'segments'");
        }
        if ((arg = root.firstArg) == null) {
            this.error(null, "Expected '<size>'");
        }
        int nArgs = this.numberOfArgs(root);
        ParsedValueImpl[] segments = new ParsedValueImpl[nArgs];
        int segment = 0;
        while (arg != null) {
            segments[segment++] = this.parseSize(arg);
            arg = arg.nextArg;
        }
        return new ParsedValueImpl<ParsedValue[], Number[]>(segments, SizeConverter.SequenceConverter.getInstance());
    }

    private ParsedValueImpl<String, StrokeType> parseStrokeType(Term root) throws ParseException {
        String keyword = this.getKeyword(root);
        if ("centered".equals(keyword) || "inside".equals(keyword) || "outside".equals(keyword)) {
            return new ParsedValueImpl<String, StrokeType>(keyword, new EnumConverter<StrokeType>(StrokeType.class));
        }
        return null;
    }

    private ParsedValueImpl[] parseStrokeLineJoin(Term root) throws ParseException {
        String keyword = this.getKeyword(root);
        if ("miter".equals(keyword) || "bevel".equals(keyword) || "round".equals(keyword)) {
            Term next;
            ParsedValueImpl strokeLineJoin = new ParsedValueImpl(keyword, new EnumConverter<StrokeLineJoin>(StrokeLineJoin.class));
            ParsedValueImpl strokeMiterLimit = null;
            if ("miter".equals(keyword) && (next = root.nextInSeries) != null && next.token != null && this.isSize(next.token)) {
                root.nextInSeries = next.nextInSeries;
                ParsedValueImpl<?, Size> sizeVal = this.parseSize(next);
                strokeMiterLimit = new ParsedValueImpl(sizeVal, SizeConverter.getInstance());
            }
            return new ParsedValueImpl[]{strokeLineJoin, strokeMiterLimit};
        }
        return null;
    }

    private ParsedValueImpl<String, StrokeLineCap> parseStrokeLineCap(Term root) throws ParseException {
        String keyword = this.getKeyword(root);
        if ("square".equals(keyword) || "butt".equals(keyword) || "round".equals(keyword)) {
            return new ParsedValueImpl<String, StrokeLineCap>(keyword, new EnumConverter<StrokeLineCap>(StrokeLineCap.class));
        }
        return null;
    }

    private ParsedValueImpl<ParsedValue[], BorderImageSlices> parseBorderImageSlice(Term root) throws ParseException {
        Term term = root;
        if (term.token == null || !this.isSize(term.token)) {
            this.error(term, "Expected '<size>'");
        }
        ParsedValueImpl[] insets = new ParsedValueImpl[4];
        Boolean fill = Boolean.FALSE;
        int inset = 0;
        while (inset < 4 && term != null) {
            insets[inset++] = this.parseSize(term);
            term = term.nextInSeries;
            if (term == null || term.token == null || term.token.getType() != 11 || !"fill".equalsIgnoreCase(term.token.getText())) continue;
            fill = Boolean.TRUE;
            break;
        }
        if (inset < 2) {
            insets[1] = insets[0];
        }
        if (inset < 3) {
            insets[2] = insets[0];
        }
        if (inset < 4) {
            insets[3] = insets[1];
        }
        ParsedValueImpl[] values = new ParsedValueImpl[]{new ParsedValueImpl<ParsedValue[], Insets>(insets, InsetsConverter.getInstance()), new ParsedValueImpl(fill, null)};
        return new ParsedValueImpl<ParsedValue[], BorderImageSlices>(values, BorderImageSliceConverter.getInstance());
    }

    private ParsedValueImpl<ParsedValue<ParsedValue[], BorderImageSlices>[], BorderImageSlices[]> parseBorderImageSliceLayers(Term root) throws ParseException {
        int nLayers = this.numberOfLayers(root);
        ParsedValueImpl[] layers = new ParsedValueImpl[nLayers];
        int layer = 0;
        Term term = root;
        while (term != null) {
            layers[layer++] = this.parseBorderImageSlice(term);
            term = this.nextLayer(term);
        }
        return new ParsedValueImpl<ParsedValue<ParsedValue[], BorderImageSlices>[], BorderImageSlices[]>(layers, SliceSequenceConverter.getInstance());
    }

    private ParsedValueImpl<ParsedValue[], BorderWidths> parseBorderImageWidth(Term root) throws ParseException {
        Term term = root;
        if (term.token == null || !this.isSize(term.token)) {
            this.error(term, "Expected '<size>'");
        }
        ParsedValueImpl[] insets = new ParsedValueImpl[4];
        int inset = 0;
        while (inset < 4 && term != null) {
            insets[inset++] = this.parseSize(term);
            term = term.nextInSeries;
            if (term == null || term.token == null || term.token.getType() != 11) continue;
        }
        if (inset < 2) {
            insets[1] = insets[0];
        }
        if (inset < 3) {
            insets[2] = insets[0];
        }
        if (inset < 4) {
            insets[3] = insets[1];
        }
        return new ParsedValueImpl<ParsedValue[], BorderWidths>(insets, BorderImageWidthConverter.getInstance());
    }

    private ParsedValueImpl<ParsedValue<ParsedValue[], BorderWidths>[], BorderWidths[]> parseBorderImageWidthLayers(Term root) throws ParseException {
        int nLayers = this.numberOfLayers(root);
        ParsedValueImpl[] layers = new ParsedValueImpl[nLayers];
        int layer = 0;
        Term term = root;
        while (term != null) {
            layers[layer++] = this.parseBorderImageWidth(term);
            term = this.nextLayer(term);
        }
        return new ParsedValueImpl<ParsedValue<ParsedValue[], BorderWidths>[], BorderWidths[]>(layers, BorderImageWidthsSequenceConverter.getInstance());
    }

    private ParsedValueImpl<String, String> parseRegion(Term root) throws ParseException {
        Term arg;
        String fn;
        String string = fn = root.token != null ? root.token.getText() : null;
        if (!"region".regionMatches(true, 0, fn, 0, 6)) {
            this.error(root, "Expected 'region'");
        }
        if ((arg = root.firstArg) == null) {
            this.error(root, "Expected 'region(\"<styleclass-or-id-string>\")'");
        }
        if (arg.token == null || arg.token.getType() != 10 || arg.token.getText() == null || arg.token.getText().isEmpty()) {
            this.error(root, "Expected 'region(\"<styleclass-or-id-string>\")'");
        }
        String styleClassOrId = SPECIAL_REGION_URL_PREFIX + Utils.stripQuotes(arg.token.getText());
        return new ParsedValueImpl<String, String>(styleClassOrId, StringConverter.getInstance());
    }

    private ParsedValueImpl<ParsedValue[], String> parseURI(Term root) throws ParseException {
        if (root == null) {
            this.error(root, "Expected 'url(\"<uri-string>\")'");
        }
        if (root.token == null || root.token.getType() != 43 || root.token.getText() == null || root.token.getText().isEmpty()) {
            this.error(root, "Expected 'url(\"<uri-string>\")'");
        }
        String uri = root.token.getText();
        ParsedValueImpl[] uriValues = new ParsedValueImpl[]{new ParsedValueImpl<String, String>(uri, StringConverter.getInstance()), null};
        return new ParsedValueImpl<ParsedValue[], String>(uriValues, URLConverter.getInstance());
    }

    private ParsedValueImpl<ParsedValue<ParsedValue[], String>[], String[]> parseURILayers(Term root) throws ParseException {
        int nLayers = this.numberOfLayers(root);
        Term temp = root;
        int layer = 0;
        ParsedValueImpl[] layers = new ParsedValueImpl[nLayers];
        while (temp != null) {
            layers[layer++] = this.parseURI(temp);
            temp = this.nextLayer(temp);
        }
        return new ParsedValueImpl<ParsedValue<ParsedValue[], String>[], String[]>(layers, URLConverter.SequenceConverter.getInstance());
    }

    private ParsedValueImpl<ParsedValue<?, Size>, Number> parseFontSize(Term root) throws ParseException {
        if (root == null) {
            return null;
        }
        Token token = root.token;
        if (token == null || !this.isSize(token)) {
            this.error(root, "Expected '<font-size>'");
        }
        Size size = null;
        if (token.getType() == 11) {
            String ident = token.getText().toLowerCase(Locale.ROOT);
            double value = -1.0;
            if ("inherit".equals(ident)) {
                value = 100.0;
            } else if ("xx-small".equals(ident)) {
                value = 60.0;
            } else if ("x-small".equals(ident)) {
                value = 75.0;
            } else if ("small".equals(ident)) {
                value = 80.0;
            } else if ("medium".equals(ident)) {
                value = 100.0;
            } else if ("large".equals(ident)) {
                value = 120.0;
            } else if ("x-large".equals(ident)) {
                value = 150.0;
            } else if ("xx-large".equals(ident)) {
                value = 200.0;
            } else if ("smaller".equals(ident)) {
                value = 80.0;
            } else if ("larger".equals(ident)) {
                value = 120.0;
            }
            if (value > -1.0) {
                size = new Size(value, SizeUnits.PERCENT);
            }
        }
        if (size == null) {
            size = this.size(token);
        }
        ParsedValueImpl svalue = new ParsedValueImpl(size, null);
        return new ParsedValueImpl(svalue, FontConverter.FontSizeConverter.getInstance());
    }

    private ParsedValueImpl<String, FontPosture> parseFontStyle(Term root) throws ParseException {
        if (root == null) {
            return null;
        }
        Token token = root.token;
        if (token == null || token.getType() != 11 || token.getText() == null || token.getText().isEmpty()) {
            this.error(root, "Expected '<font-style>'");
        }
        String ident = token.getText().toLowerCase(Locale.ROOT);
        String posture = FontPosture.REGULAR.name();
        if ("normal".equals(ident)) {
            posture = FontPosture.REGULAR.name();
        } else if ("italic".equals(ident)) {
            posture = FontPosture.ITALIC.name();
        } else if ("oblique".equals(ident)) {
            posture = FontPosture.ITALIC.name();
        } else if ("inherit".equals(ident)) {
            posture = "inherit";
        } else {
            return null;
        }
        return new ParsedValueImpl<String, FontPosture>(posture, FontConverter.FontStyleConverter.getInstance());
    }

    private ParsedValueImpl<String, FontWeight> parseFontWeight(Term root) throws ParseException {
        if (root == null) {
            return null;
        }
        Token token = root.token;
        if (token == null || token.getText() == null || token.getText().isEmpty()) {
            this.error(root, "Expected '<font-weight>'");
        }
        String ident = token.getText().toLowerCase(Locale.ROOT);
        String weight = FontWeight.NORMAL.name();
        if ("inherit".equals(ident)) {
            weight = FontWeight.NORMAL.name();
        } else if ("normal".equals(ident)) {
            weight = FontWeight.NORMAL.name();
        } else if ("bold".equals(ident)) {
            weight = FontWeight.BOLD.name();
        } else if ("bolder".equals(ident)) {
            weight = FontWeight.BOLD.name();
        } else if ("lighter".equals(ident)) {
            weight = FontWeight.LIGHT.name();
        } else if ("100".equals(ident)) {
            weight = FontWeight.findByWeight(100).name();
        } else if ("200".equals(ident)) {
            weight = FontWeight.findByWeight(200).name();
        } else if ("300".equals(ident)) {
            weight = FontWeight.findByWeight(300).name();
        } else if ("400".equals(ident)) {
            weight = FontWeight.findByWeight(400).name();
        } else if ("500".equals(ident)) {
            weight = FontWeight.findByWeight(500).name();
        } else if ("600".equals(ident)) {
            weight = FontWeight.findByWeight(600).name();
        } else if ("700".equals(ident)) {
            weight = FontWeight.findByWeight(700).name();
        } else if ("800".equals(ident)) {
            weight = FontWeight.findByWeight(800).name();
        } else if ("900".equals(ident)) {
            weight = FontWeight.findByWeight(900).name();
        } else {
            this.error(root, "Expected '<font-weight>'");
        }
        return new ParsedValueImpl<String, FontWeight>(weight, FontConverter.FontWeightConverter.getInstance());
    }

    private ParsedValueImpl<String, String> parseFontFamily(Term root) throws ParseException {
        String fam;
        if (root == null) {
            return null;
        }
        Token token = root.token;
        String text = null;
        if (token == null || token.getType() != 11 && token.getType() != 10 || (text = token.getText()) == null || text.isEmpty()) {
            this.error(root, "Expected '<font-family>'");
        }
        if ("inherit".equals(fam = this.stripQuotes(text.toLowerCase(Locale.ROOT)))) {
            return new ParsedValueImpl<String, String>("inherit", StringConverter.getInstance());
        }
        if ("serif".equals(fam) || "sans-serif".equals(fam) || "cursive".equals(fam) || "fantasy".equals(fam) || "monospace".equals(fam)) {
            return new ParsedValueImpl<String, String>(fam, StringConverter.getInstance());
        }
        return new ParsedValueImpl<String, String>(token.getText(), StringConverter.getInstance());
    }

    private ParsedValueImpl<ParsedValue[], Font> parseFont(Term root) throws ParseException {
        ParsedValueImpl<ParsedValue<?, Size>, Number> fsize;
        Term temp;
        Term next = root.nextInSeries;
        root.nextInSeries = null;
        while (next != null) {
            Term temp2 = next.nextInSeries;
            next.nextInSeries = root;
            root = next;
            next = temp2;
        }
        Token token = root.token;
        int ttype = token.getType();
        if (ttype != 11 && ttype != 10) {
            this.error(root, "Expected '<font-family>'");
        }
        ParsedValueImpl<String, String> ffamily = this.parseFontFamily(root);
        Term term = root;
        term = term.nextInSeries;
        if (term == null) {
            this.error(root, "Expected '<size>'");
        }
        if (term.token == null || !this.isSize(term.token)) {
            this.error(term, "Expected '<size>'");
        }
        if ((temp = term.nextInSeries) != null && temp.token != null && temp.token.getType() == 32) {
            root = temp;
            term = temp.nextInSeries;
            if (term == null) {
                this.error(root, "Expected '<size>'");
            }
            if (term.token == null || !this.isSize(term.token)) {
                this.error(term, "Expected '<size>'");
            }
            token = term.token;
        }
        if ((fsize = this.parseFontSize(term)) == null) {
            this.error(root, "Expected '<size>'");
        }
        ParsedValueImpl<String, FontPosture> fstyle = null;
        ParsedValueImpl<String, FontWeight> fweight = null;
        String fvariant = null;
        while ((term = term.nextInSeries) != null) {
            if (term.token == null || term.token.getType() != 11 || term.token.getText() == null || term.token.getText().isEmpty()) {
                this.error(term, "Expected '<font-weight>', '<font-style>' or '<font-variant>'");
            }
            if (fstyle == null && (fstyle = this.parseFontStyle(term)) != null) continue;
            if (fvariant == null && "small-caps".equalsIgnoreCase(term.token.getText())) {
                fvariant = term.token.getText();
                continue;
            }
            if (fweight != null || (fweight = this.parseFontWeight(term)) == null) continue;
        }
        ParsedValueImpl[] values = new ParsedValueImpl[]{ffamily, fsize, fweight, fstyle};
        return new ParsedValueImpl<ParsedValue[], Font>(values, FontConverter.getInstance());
    }

    private Token nextToken(CSSLexer lexer) {
        Token token = null;
        while ((token = lexer.nextToken()) != null && token.getType() == 40 || token.getType() == 41) {
        }
        if (LOGGER.isLoggable(PlatformLogger.Level.FINEST)) {
            LOGGER.finest(token.toString());
        }
        return token;
    }

    private void parse(Stylesheet stylesheet, CSSLexer lexer) {
        CssError error;
        String msg;
        this.currentToken = this.nextToken(lexer);
        while (this.currentToken != null && this.currentToken.getType() == 47) {
            this.currentToken = this.nextToken(lexer);
            if (this.currentToken == null || this.currentToken.getType() != 11) {
                ParseException parseException = new ParseException("Expected IDENT", this.currentToken, this);
                String msg2 = parseException.toString();
                CssError error2 = this.createError(msg2);
                if (LOGGER.isLoggable(PlatformLogger.Level.WARNING)) {
                    LOGGER.warning(error2.toString());
                }
                this.reportError(error2);
                do {
                    this.currentToken = lexer.nextToken();
                } while (this.currentToken != null && this.currentToken.getType() == 30 || this.currentToken.getType() == 40 || this.currentToken.getType() == 41);
                continue;
            }
            String keyword = this.currentToken.getText().toLowerCase(Locale.ROOT);
            if ("font-face".equals(keyword)) {
                FontFace fontFace = this.fontFace(lexer);
                if (fontFace != null) {
                    stylesheet.getFontFaces().add(fontFace);
                }
                this.currentToken = this.nextToken(lexer);
                continue;
            }
            if (!"import".equals(keyword)) continue;
            if (imports == null) {
                imports = new Stack();
            }
            if (!imports.contains(this.sourceOfStylesheet)) {
                imports.push(this.sourceOfStylesheet);
                Stylesheet importedStylesheet = this.handleImport(lexer);
                if (importedStylesheet != null) {
                    stylesheet.importStylesheet(importedStylesheet);
                }
                imports.pop();
                if (imports.isEmpty()) {
                    imports = null;
                }
            } else {
                int line = this.currentToken.getLine();
                int pos = this.currentToken.getOffset();
                msg = MessageFormat.format("Recursive @import at {2} [{0,number,#},{1,number,#}]", line, pos, imports.peek());
                error = this.createError(msg);
                if (LOGGER.isLoggable(PlatformLogger.Level.WARNING)) {
                    LOGGER.warning(error.toString());
                }
                this.reportError(error);
            }
            do {
                this.currentToken = lexer.nextToken();
            } while (this.currentToken != null && this.currentToken.getType() == 30 || this.currentToken.getType() == 40 || this.currentToken.getType() == 41);
        }
        while (this.currentToken != null && this.currentToken.getType() != -1) {
            List<Selector> selectors = this.selectors(lexer);
            if (selectors == null) {
                return;
            }
            if (this.currentToken == null || this.currentToken.getType() != 28) {
                int line = this.currentToken != null ? this.currentToken.getLine() : -1;
                int pos = this.currentToken != null ? this.currentToken.getOffset() : -1;
                msg = MessageFormat.format("Expected LBRACE at [{0,number,#},{1,number,#}]", line, pos);
                error = this.createError(msg);
                if (LOGGER.isLoggable(PlatformLogger.Level.WARNING)) {
                    LOGGER.warning(error.toString());
                }
                this.reportError(error);
                this.currentToken = null;
                return;
            }
            this.currentToken = this.nextToken(lexer);
            List<Declaration> declarations = this.declarations(lexer);
            if (declarations == null) {
                return;
            }
            if (this.currentToken != null && this.currentToken.getType() != 29) {
                int line = this.currentToken.getLine();
                int pos = this.currentToken.getOffset();
                String msg3 = MessageFormat.format("Expected RBRACE at [{0,number,#},{1,number,#}]", line, pos);
                CssError error3 = this.createError(msg3);
                if (LOGGER.isLoggable(PlatformLogger.Level.WARNING)) {
                    LOGGER.warning(error3.toString());
                }
                this.reportError(error3);
                this.currentToken = null;
                return;
            }
            stylesheet.getRules().add(new Rule(selectors, declarations));
            this.currentToken = this.nextToken(lexer);
        }
        this.currentToken = null;
    }

    private FontFace fontFace(CSSLexer lexer) {
        HashMap<String, String> descriptors = new HashMap<String, String>();
        ArrayList<FontFace.FontFaceSrc> sources = new ArrayList<FontFace.FontFaceSrc>();
        do {
            this.currentToken = this.nextToken(lexer);
            if (this.currentToken.getType() != 11) continue;
            String key = this.currentToken.getText();
            this.currentToken = this.nextToken(lexer);
            this.currentToken = this.nextToken(lexer);
            if ("src".equalsIgnoreCase(key)) {
                while (this.currentToken != null && this.currentToken.getType() != 30 && this.currentToken.getType() != 29 && this.currentToken.getType() != -1) {
                    CssError error;
                    int pos;
                    if (this.currentToken.getType() == 11) {
                        sources.add(new FontFace.FontFaceSrc(FontFace.FontFaceSrcType.REFERENCE, this.currentToken.getText()));
                    } else if (this.currentToken.getType() == 43) {
                        ParsedValueImpl[] uriValues = new ParsedValueImpl[]{new ParsedValueImpl<String, String>(this.currentToken.getText(), StringConverter.getInstance()), new ParsedValueImpl(this.sourceOfStylesheet, null)};
                        ParsedValueImpl<ParsedValue[], String> parsedValue = new ParsedValueImpl<ParsedValue[], String>(uriValues, URLConverter.getInstance());
                        String urlStr = (String)((ParsedValue)parsedValue).convert(null);
                        URL url = null;
                        try {
                            URI fontUri = new URI(urlStr);
                            url = fontUri.toURL();
                        }
                        catch (MalformedURLException | URISyntaxException malf) {
                            int line = this.currentToken.getLine();
                            int pos2 = this.currentToken.getOffset();
                            String msg = MessageFormat.format("Could not resolve @font-face url [{2}] at [{0,number,#},{1,number,#}]", line, pos2, urlStr);
                            CssError error2 = this.createError(msg);
                            if (LOGGER.isLoggable(PlatformLogger.Level.WARNING)) {
                                LOGGER.warning(error2.toString());
                            }
                            this.reportError(error2);
                            while (this.currentToken != null) {
                                int ttype = this.currentToken.getType();
                                if (ttype == 29 || ttype == -1) {
                                    return null;
                                }
                                this.currentToken = this.nextToken(lexer);
                            }
                        }
                        String format = null;
                        while (true) {
                            int ttype;
                            this.currentToken = this.nextToken(lexer);
                            int n = ttype = this.currentToken != null ? this.currentToken.getType() : -1;
                            if (ttype == 12) {
                                if (!"format(".equalsIgnoreCase(this.currentToken.getText())) break;
                                continue;
                            }
                            if (ttype == 11 || ttype == 10) {
                                format = Utils.stripQuotes(this.currentToken.getText());
                                continue;
                            }
                            if (ttype != 35) break;
                        }
                        sources.add(new FontFace.FontFaceSrc(FontFace.FontFaceSrcType.URL, url.toExternalForm(), format));
                    } else if (this.currentToken.getType() == 12) {
                        if ("local(".equalsIgnoreCase(this.currentToken.getText())) {
                            this.currentToken = this.nextToken(lexer);
                            StringBuilder localSb = new StringBuilder();
                            while (this.currentToken != null && this.currentToken.getType() != 35 && this.currentToken.getType() != -1) {
                                localSb.append(this.currentToken.getText());
                                this.currentToken = this.nextToken(lexer);
                            }
                            int start = 0;
                            int end = localSb.length();
                            if (localSb.charAt(start) == '\'' || localSb.charAt(start) == '\"') {
                                ++start;
                            }
                            if (localSb.charAt(end - 1) == '\'' || localSb.charAt(end - 1) == '\"') {
                                --end;
                            }
                            String local = localSb.substring(start, end);
                            sources.add(new FontFace.FontFaceSrc(FontFace.FontFaceSrcType.LOCAL, local));
                        } else {
                            int line = this.currentToken.getLine();
                            pos = this.currentToken.getOffset();
                            String msg = MessageFormat.format("Unknown @font-face src type [" + this.currentToken.getText() + ")] at [{0,number,#},{1,number,#}]", line, pos);
                            error = this.createError(msg);
                            if (LOGGER.isLoggable(PlatformLogger.Level.WARNING)) {
                                LOGGER.warning(error.toString());
                            }
                            this.reportError(error);
                        }
                    } else if (this.currentToken.getType() != 36) {
                        int line = this.currentToken.getLine();
                        pos = this.currentToken.getOffset();
                        String msg = MessageFormat.format("Unexpected TOKEN [" + this.currentToken.getText() + "] at [{0,number,#},{1,number,#}]", line, pos);
                        error = this.createError(msg);
                        if (LOGGER.isLoggable(PlatformLogger.Level.WARNING)) {
                            LOGGER.warning(error.toString());
                        }
                        this.reportError(error);
                    }
                    this.currentToken = this.nextToken(lexer);
                }
                continue;
            }
            StringBuilder descriptorVal = new StringBuilder();
            while (this.currentToken != null && this.currentToken.getType() != 30 && this.currentToken.getType() != -1) {
                descriptorVal.append(this.currentToken.getText());
                this.currentToken = this.nextToken(lexer);
            }
            descriptors.put(key, descriptorVal.toString());
        } while (this.currentToken != null && this.currentToken.getType() != 29 && this.currentToken.getType() != -1);
        return new FontFace(descriptors, sources);
    }

    private Stylesheet handleImport(CSSLexer lexer) {
        this.currentToken = this.nextToken(lexer);
        if (this.currentToken == null || this.currentToken.getType() == -1) {
            return null;
        }
        int ttype = this.currentToken.getType();
        String fname = null;
        if (ttype == 10 || ttype == 43) {
            fname = this.currentToken.getText();
        }
        Stylesheet importedStylesheet = null;
        if (fname != null) {
            ParsedValueImpl[] uriValues = new ParsedValueImpl[]{new ParsedValueImpl<String, String>(fname, StringConverter.getInstance()), new ParsedValueImpl(this.sourceOfStylesheet, null)};
            ParsedValueImpl<ParsedValue[], String> parsedValue = new ParsedValueImpl<ParsedValue[], String>(uriValues, URLConverter.getInstance());
            String urlString = (String)((ParsedValue)parsedValue).convert(null);
            importedStylesheet = StyleManager.loadStylesheet(urlString);
        }
        if (importedStylesheet == null) {
            String msg = MessageFormat.format("Could not import {0}", fname);
            CssError error = this.createError(msg);
            if (LOGGER.isLoggable(PlatformLogger.Level.WARNING)) {
                LOGGER.warning(error.toString());
            }
            this.reportError(error);
        }
        return importedStylesheet;
    }

    private List<Selector> selectors(CSSLexer lexer) {
        ArrayList<Selector> selectors = new ArrayList<Selector>();
        while (true) {
            Selector selector;
            if ((selector = this.selector(lexer)) == null) {
                while (this.currentToken != null && this.currentToken.getType() != 29 && this.currentToken.getType() != -1) {
                    this.currentToken = this.nextToken(lexer);
                }
                this.currentToken = this.nextToken(lexer);
                if (this.currentToken != null && this.currentToken.getType() != -1) continue;
                this.currentToken = null;
                return null;
            }
            selectors.add(selector);
            if (this.currentToken == null || this.currentToken.getType() != 36) break;
            this.currentToken = this.nextToken(lexer);
        }
        return selectors;
    }

    private Selector selector(CSSLexer lexer) {
        Combinator comb;
        ArrayList<Combinator> combinators = null;
        ArrayList<SimpleSelector> sels = null;
        SimpleSelector ancestor = this.simpleSelector(lexer);
        if (ancestor == null) {
            return null;
        }
        while ((comb = this.combinator(lexer)) != null) {
            if (combinators == null) {
                combinators = new ArrayList<Combinator>();
            }
            combinators.add(comb);
            SimpleSelector descendant = this.simpleSelector(lexer);
            if (descendant == null) {
                return null;
            }
            if (sels == null) {
                sels = new ArrayList<SimpleSelector>();
                sels.add(ancestor);
            }
            sels.add(descendant);
        }
        if (this.currentToken != null && this.currentToken.getType() == 41) {
            this.currentToken = this.nextToken(lexer);
        }
        if (sels == null) {
            return ancestor;
        }
        return new CompoundSelector(sels, combinators);
    }

    private SimpleSelector simpleSelector(CSSLexer lexer) {
        String esel = "*";
        String isel = "";
        ArrayList<String> csels = null;
        ArrayList<String> pclasses = null;
        while (true) {
            int ttype = this.currentToken != null ? this.currentToken.getType() : 0;
            switch (ttype) {
                case 11: 
                case 33: {
                    esel = this.currentToken.getText();
                    break;
                }
                case 38: {
                    this.currentToken = this.nextToken(lexer);
                    if (this.currentToken != null && this.currentToken.getType() == 11) {
                        if (csels == null) {
                            csels = new ArrayList<String>();
                        }
                        csels.add(this.currentToken.getText());
                        break;
                    }
                    this.currentToken = Token.INVALID_TOKEN;
                    return null;
                }
                case 37: {
                    isel = this.currentToken.getText().substring(1);
                    break;
                }
                case 31: {
                    this.currentToken = this.nextToken(lexer);
                    if (this.currentToken != null && pclasses == null) {
                        pclasses = new ArrayList<String>();
                    }
                    if (this.currentToken.getType() == 11) {
                        pclasses.add(this.currentToken.getText());
                    } else if (this.currentToken.getType() == 12) {
                        String pclass = this.functionalPseudo(lexer);
                        pclasses.add(pclass);
                    } else {
                        this.currentToken = Token.INVALID_TOKEN;
                    }
                    if (this.currentToken.getType() != 0) break;
                    return null;
                }
                case -1: 
                case 27: 
                case 28: 
                case 36: 
                case 40: 
                case 41: {
                    return new SimpleSelector(esel, csels, pclasses, isel);
                }
                default: {
                    return null;
                }
            }
            this.currentToken = lexer.nextToken();
            if (!LOGGER.isLoggable(PlatformLogger.Level.FINEST)) continue;
            LOGGER.finest(this.currentToken.toString());
        }
    }

    private String functionalPseudo(CSSLexer lexer) {
        StringBuilder pclass = new StringBuilder(this.currentToken.getText());
        block4: while (true) {
            this.currentToken = this.nextToken(lexer);
            switch (this.currentToken.getType()) {
                case 10: 
                case 11: {
                    pclass.append(this.currentToken.getText());
                    continue block4;
                }
                case 35: {
                    pclass.append(')');
                    return pclass.toString();
                }
            }
            break;
        }
        this.currentToken = Token.INVALID_TOKEN;
        return null;
    }

    private Combinator combinator(CSSLexer lexer) {
        Combinator combinator = null;
        while (true) {
            int ttype = this.currentToken != null ? this.currentToken.getType() : 0;
            switch (ttype) {
                case 40: {
                    if (combinator != null || !" ".equals(this.currentToken.getText())) break;
                    combinator = Combinator.DESCENDANT;
                    break;
                }
                case 27: {
                    combinator = Combinator.CHILD;
                    break;
                }
                case 11: 
                case 31: 
                case 33: 
                case 37: 
                case 38: {
                    return combinator;
                }
                default: {
                    return null;
                }
            }
            this.currentToken = lexer.nextToken();
            if (!LOGGER.isLoggable(PlatformLogger.Level.FINEST)) continue;
            LOGGER.finest(this.currentToken.toString());
        }
    }

    private List<Declaration> declarations(CSSLexer lexer) {
        ArrayList<Declaration> declarations = new ArrayList<Declaration>();
        do {
            Declaration decl;
            if ((decl = this.declaration(lexer)) != null) {
                declarations.add(decl);
            } else {
                while (this.currentToken != null && this.currentToken.getType() != 30 && this.currentToken.getType() != 29 && this.currentToken.getType() != -1) {
                    this.currentToken = this.nextToken(lexer);
                }
                if (this.currentToken != null && this.currentToken.getType() != 30) {
                    return declarations;
                }
            }
            while (this.currentToken != null && this.currentToken.getType() == 30) {
                this.currentToken = this.nextToken(lexer);
            }
        } while (this.currentToken != null && this.currentToken.getType() == 11);
        return declarations;
    }

    private Declaration declaration(CSSLexer lexer) {
        boolean important;
        int ttype;
        int n = ttype = this.currentToken != null ? this.currentToken.getType() : 0;
        if (this.currentToken == null || this.currentToken.getType() != 11) {
            return null;
        }
        String property = this.currentToken.getText();
        this.currentToken = this.nextToken(lexer);
        if (this.currentToken == null || this.currentToken.getType() != 31) {
            int line = this.currentToken.getLine();
            int pos = this.currentToken.getOffset();
            String msg = MessageFormat.format("Expected COLON at [{0,number,#},{1,number,#}]", line, pos);
            CssError error = this.createError(msg);
            if (LOGGER.isLoggable(PlatformLogger.Level.WARNING)) {
                LOGGER.warning(error.toString());
            }
            this.reportError(error);
            return null;
        }
        this.currentToken = this.nextToken(lexer);
        Term root = this.expr(lexer);
        ParsedValueImpl value = null;
        try {
            value = root != null ? this.valueFor(property, root, lexer) : null;
        }
        catch (ParseException re) {
            Token badToken = re.tok;
            int line = badToken != null ? badToken.getLine() : -1;
            int pos = badToken != null ? badToken.getOffset() : -1;
            String msg = MessageFormat.format("{2} while parsing ''{3}'' at [{0,number,#},{1,number,#}]", line, pos, re.getMessage(), property);
            CssError error = this.createError(msg);
            if (LOGGER.isLoggable(PlatformLogger.Level.WARNING)) {
                LOGGER.warning(error.toString());
            }
            this.reportError(error);
            return null;
        }
        boolean bl = important = this.currentToken.getType() == 39;
        if (important) {
            this.currentToken = this.nextToken(lexer);
        }
        Declaration decl = value != null ? new Declaration(property.toLowerCase(Locale.ROOT), value, important) : null;
        return decl;
    }

    private Term expr(CSSLexer lexer) {
        Term expr;
        Term current = expr = this.term(lexer);
        while (true) {
            int ttype;
            int n = ttype = current != null && this.currentToken != null ? this.currentToken.getType() : 0;
            if (ttype == 0) {
                this.skipExpr(lexer);
                return null;
            }
            if (ttype == 30 || ttype == 39 || ttype == 29 || ttype == -1) {
                return expr;
            }
            if (ttype == 36) {
                this.currentToken = this.nextToken(lexer);
                current = current.nextLayer = this.term(lexer);
                continue;
            }
            current = current.nextInSeries = this.term(lexer);
        }
    }

    private void skipExpr(CSSLexer lexer) {
        int ttype;
        do {
            this.currentToken = this.nextToken(lexer);
            int n = ttype = this.currentToken != null ? this.currentToken.getType() : 0;
        } while (ttype != 30 && ttype != 29 && ttype != -1);
    }

    private Term term(CSSLexer lexer) {
        int ttype = this.currentToken != null ? this.currentToken.getType() : 0;
        switch (ttype) {
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 45: 
            case 46: {
                break;
            }
            case 10: {
                break;
            }
            case 11: {
                break;
            }
            case 37: {
                break;
            }
            case 12: 
            case 34: {
                Term arg;
                Term function = new Term(this.currentToken);
                this.currentToken = this.nextToken(lexer);
                function.firstArg = arg = this.term(lexer);
                while (true) {
                    int operator;
                    int n = operator = this.currentToken != null ? this.currentToken.getType() : 0;
                    if (operator == 35) {
                        this.currentToken = this.nextToken(lexer);
                        return function;
                    }
                    if (operator == 36) {
                        this.currentToken = this.nextToken(lexer);
                        arg = arg.nextArg = this.term(lexer);
                        continue;
                    }
                    arg = arg.nextInSeries = this.term(lexer);
                }
            }
            case 43: {
                break;
            }
            case 32: {
                break;
            }
            default: {
                int line = this.currentToken != null ? this.currentToken.getLine() : -1;
                int pos = this.currentToken != null ? this.currentToken.getOffset() : -1;
                String text = this.currentToken != null ? this.currentToken.getText() : "";
                String msg = MessageFormat.format("Unexpected token {0}{1}{0} at [{2,number,#},{3,number,#}]", "'", text, line, pos);
                CssError error = this.createError(msg);
                if (LOGGER.isLoggable(PlatformLogger.Level.WARNING)) {
                    LOGGER.warning(error.toString());
                }
                this.reportError(error);
                return null;
            }
        }
        Term term = new Term(this.currentToken);
        this.currentToken = this.nextToken(lexer);
        return term;
    }

    static class Term {
        final Token token;
        Term nextInSeries;
        Term nextLayer;
        Term firstArg;
        Term nextArg;

        Term(Token token) {
            this.token = token;
            this.nextLayer = null;
            this.nextInSeries = null;
            this.firstArg = null;
            this.nextArg = null;
        }

        Term() {
            this(null);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            if (this.token != null) {
                buf.append(String.valueOf(this.token.getText()));
            }
            if (this.nextInSeries != null) {
                buf.append("<nextInSeries>");
                buf.append(this.nextInSeries.toString());
                buf.append("</nextInSeries>\n");
            }
            if (this.nextLayer != null) {
                buf.append("<nextLayer>");
                buf.append(this.nextLayer.toString());
                buf.append("</nextLayer>\n");
            }
            if (this.firstArg != null) {
                buf.append("<args>");
                buf.append(this.firstArg.toString());
                if (this.nextArg != null) {
                    buf.append(this.nextArg.toString());
                }
                buf.append("</args>");
            }
            return buf.toString();
        }
    }

    private static final class ParseException
    extends Exception {
        private final Token tok;
        private final String source;

        ParseException(String message) {
            this(message, null, null);
        }

        ParseException(String message, Token tok, CSSParser parser) {
            super(message);
            this.tok = tok;
            this.source = parser.sourceOfStylesheet != null ? parser.sourceOfStylesheet : (parser.sourceOfInlineStyle != null ? parser.sourceOfInlineStyle.toString() : (parser.stylesheetAsText != null ? parser.stylesheetAsText : "?"));
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder(super.getMessage());
            builder.append(this.source);
            if (this.tok != null) {
                builder.append(": ").append(this.tok.toString());
            }
            return builder.toString();
        }
    }

    private static class InstanceHolder {
        static final CSSParser INSTANCE = new CSSParser();

        private InstanceHolder() {
        }
    }
}

