/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.css.parser;

import com.sun.javafx.Utils;
import com.sun.javafx.css.Size;
import com.sun.javafx.css.StyleConverterImpl;
import javafx.css.ParsedValue;
import javafx.scene.paint.Color;
import javafx.scene.text.Font;

public final class DeriveColorConverter
extends StyleConverterImpl<ParsedValue[], Color> {
    public static DeriveColorConverter getInstance() {
        return Holder.INSTANCE;
    }

    private DeriveColorConverter() {
    }

    @Override
    public Color convert(ParsedValue<ParsedValue[], Color> value, Font font) {
        ParsedValue[] values = value.getValue();
        Color color = (Color)values[0].convert(font);
        Size brightness = (Size)values[1].convert(font);
        return Utils.deriveColor(color, brightness.pixels(font));
    }

    public String toString() {
        return "DeriveColorConverter";
    }

    private static class Holder {
        static final DeriveColorConverter INSTANCE = new DeriveColorConverter();

        private Holder() {
        }
    }
}

