/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.css.parser;

import com.sun.javafx.Utils;
import com.sun.javafx.css.StyleConverterImpl;
import javafx.css.ParsedValue;
import javafx.scene.paint.Color;
import javafx.scene.paint.Stop;
import javafx.scene.text.Font;

public final class LadderConverter
extends StyleConverterImpl<ParsedValue[], Color> {
    public static LadderConverter getInstance() {
        return Holder.INSTANCE;
    }

    private LadderConverter() {
    }

    @Override
    public Color convert(ParsedValue<ParsedValue[], Color> value, Font font) {
        ParsedValue[] values = value.getValue();
        Color color = (Color)values[0].convert(font);
        Stop[] stops = new Stop[values.length - 1];
        for (int v = 1; v < values.length; ++v) {
            stops[v - 1] = (Stop)values[v].convert(font);
        }
        return Utils.ladder(color, stops);
    }

    public String toString() {
        return "LadderConverter";
    }

    private static class Holder {
        static final LadderConverter INSTANCE = new LadderConverter();

        private Holder() {
        }
    }
}

