/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.font;

import com.sun.glass.utils.NativeLibLoader;
import com.sun.javafx.font.DFontDecoder$$Lambda$1;
import com.sun.javafx.font.FontFileWriter;
import java.io.IOException;
import java.security.AccessController;

class DFontDecoder
extends FontFileWriter {
    private static native long createCTFont(String var0);

    private static native void releaseCTFont(long var0);

    private static native int getCTFontFormat(long var0);

    private static native int[] getCTFontTags(long var0);

    private static native byte[] getCTFontTable(long var0, int var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decode(String fontName) throws IOException {
        if (fontName == null) {
            throw new IOException("Invalid font name");
        }
        long fontRef = 0L;
        try {
            fontRef = DFontDecoder.createCTFont(fontName);
            if (fontRef == 0L) {
                throw new IOException("Failure creating CTFont");
            }
            int format = DFontDecoder.getCTFontFormat(fontRef);
            if (format != 1953658213 && format != 65536 && format != 0x4F54544F) {
                throw new IOException("Unsupported Dfont");
            }
            int[] tags = DFontDecoder.getCTFontTags(fontRef);
            int numTables = tags.length;
            int size = 12 + 16 * numTables;
            byte[][] tableData = new byte[numTables][];
            for (int i = 0; i < tags.length; ++i) {
                int tag = tags[i];
                tableData[i] = DFontDecoder.getCTFontTable(fontRef, tag);
                int length = tableData[i].length;
                size += length + 3 & 0xFFFFFFFC;
            }
            DFontDecoder.releaseCTFont(fontRef);
            fontRef = 0L;
            this.setLength(size);
            this.writeHeader(format, (short)numTables);
            int dataOffset = 12 + 16 * numTables;
            for (int i = 0; i < numTables; ++i) {
                int tag = tags[i];
                byte[] data = tableData[i];
                this.writeDirectoryEntry(i, tag, 0, dataOffset, data.length);
                this.seek(dataOffset);
                this.writeBytes(data);
                dataOffset += data.length + 3 & 0xFFFFFFFC;
            }
        }
        finally {
            if (fontRef != 0L) {
                DFontDecoder.releaseCTFont(fontRef);
            }
        }
    }

    static /* synthetic */ Void lambda$static$234() {
        NativeLibLoader.loadLibrary("javafx_font");
        return null;
    }

    static {
        AccessController.doPrivileged(DFontDecoder$$Lambda$1.lambdaFactory$());
    }
}

