/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.font;

import com.sun.javafx.font.FontConfigManager$$Lambda$1;
import com.sun.javafx.font.FontConfigManager$EmbeddedFontSupport$$Lambda$1;
import com.sun.javafx.font.FontConfigManager$EmbeddedFontSupport$$Lambda$2;
import com.sun.javafx.font.FontConfigManager$EmbeddedFontSupport$$Lambda$3;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Properties;

class FontConfigManager {
    static boolean debugFonts = false;
    static boolean useFontConfig = true;
    static boolean fontConfigFailed = false;
    static boolean useEmbeddedFontSupport = false;
    private static final String[] fontConfigNames;
    private static FcCompFont[] fontConfigFonts;
    private static String defaultFontFile;

    private FontConfigManager() {
    }

    private static String[] getFontConfigNames() {
        return fontConfigNames;
    }

    private static String getFCLocaleStr() {
        Locale l = Locale.getDefault();
        String localeStr = l.getLanguage();
        String country = l.getCountry();
        if (!country.equals("")) {
            localeStr = localeStr + "-" + country;
        }
        return localeStr;
    }

    private static native boolean getFontConfig(String var0, FcCompFont[] var1, boolean var2);

    private static synchronized void initFontConfigLogFonts() {
        int i;
        if (fontConfigFonts != null || fontConfigFailed) {
            return;
        }
        long t0 = 0L;
        if (debugFonts) {
            t0 = System.nanoTime();
        }
        String[] fontConfigNames = FontConfigManager.getFontConfigNames();
        FcCompFont[] fontArr = new FcCompFont[fontConfigNames.length];
        for (int i2 = 0; i2 < fontArr.length; ++i2) {
            fontArr[i2] = new FcCompFont();
            fontArr[i2].fcName = fontConfigNames[i2];
            int colonPos = fontArr[i2].fcName.indexOf(58);
            fontArr[i2].fcFamily = fontArr[i2].fcName.substring(0, colonPos);
            fontArr[i2].style = i2 % 4;
        }
        boolean foundFontConfig = false;
        if (useFontConfig) {
            foundFontConfig = FontConfigManager.getFontConfig(FontConfigManager.getFCLocaleStr(), fontArr, true);
        } else if (debugFonts) {
            System.err.println("Not using FontConfig");
        }
        if (useEmbeddedFontSupport || !foundFontConfig) {
            EmbeddedFontSupport.initLogicalFonts(fontArr);
        }
        FontConfigFont anyFont = null;
        for (i = 0; i < fontArr.length; ++i) {
            FcCompFont fci = fontArr[i];
            if (fci.firstFont == null) {
                if (debugFonts) {
                    System.err.println("Fontconfig returned no font for " + fontArr[i].fcName);
                }
                fontConfigFailed = true;
                continue;
            }
            if (anyFont != null) continue;
            anyFont = fci.firstFont;
            defaultFontFile = anyFont.fontFile;
        }
        if (anyFont == null) {
            fontConfigFailed = true;
            System.err.println("Error: JavaFX detected no fonts! Please refer to release notes for proper font configuration");
            return;
        }
        if (fontConfigFailed) {
            for (i = 0; i < fontArr.length; ++i) {
                if (fontArr[i].firstFont != null) continue;
                fontArr[i].firstFont = anyFont;
            }
        }
        fontConfigFonts = fontArr;
        if (debugFonts) {
            long t1 = System.nanoTime();
            System.err.println("Time spent accessing fontconfig=" + (t1 - t0) / 1000000L + "ms.");
            for (int i3 = 0; i3 < fontConfigFonts.length; ++i3) {
                FcCompFont fci = fontConfigFonts[i3];
                System.err.println("FC font " + fci.fcName + " maps to " + fci.firstFont.fullName + " in file " + fci.firstFont.fontFile);
                if (fci.allFonts == null) continue;
                for (int f = 0; f < fci.allFonts.length; ++f) {
                    FontConfigFont fcf = fci.allFonts[f];
                    System.err.println(" " + f + ") Family=" + fcf.familyName + ", Style=" + fcf.styleStr + ", Fullname=" + fcf.fullName + ", File=" + fcf.fontFile);
                }
            }
        }
    }

    private static native boolean populateMapsNative(HashMap<String, String> var0, HashMap<String, String> var1, HashMap<String, ArrayList<String>> var2, Locale var3);

    public static void populateMaps(HashMap<String, String> fontToFileMap, HashMap<String, String> fontToFamilyNameMap, HashMap<String, ArrayList<String>> familyToFontListMap, Locale locale) {
        boolean pnm = false;
        if (useFontConfig && !fontConfigFailed) {
            pnm = FontConfigManager.populateMapsNative(fontToFileMap, fontToFamilyNameMap, familyToFontListMap, locale);
        }
        if (fontConfigFailed || useEmbeddedFontSupport || !pnm) {
            EmbeddedFontSupport.populateMaps(fontToFileMap, fontToFamilyNameMap, familyToFontListMap, locale);
        }
    }

    private static String mapFxToFcLogicalFamilyName(String fxName) {
        if (fxName.equals("serif")) {
            return "serif";
        }
        if (fxName.equals("monospaced")) {
            return "monospace";
        }
        return "sans";
    }

    public static FcCompFont getFontConfigFont(String fxFamilyName, boolean bold, boolean italic) {
        int style;
        FontConfigManager.initFontConfigLogFonts();
        if (fontConfigFonts == null) {
            return null;
        }
        String name = FontConfigManager.mapFxToFcLogicalFamilyName(fxFamilyName.toLowerCase());
        int n = style = bold ? 1 : 0;
        if (italic) {
            style += 2;
        }
        FcCompFont fcInfo = null;
        for (int i = 0; i < fontConfigFonts.length; ++i) {
            if (!name.equals(FontConfigManager.fontConfigFonts[i].fcFamily) || style != FontConfigManager.fontConfigFonts[i].style) continue;
            fcInfo = fontConfigFonts[i];
            break;
        }
        if (fcInfo == null) {
            fcInfo = fontConfigFonts[0];
        }
        if (debugFonts) {
            System.err.println("FC name=" + name + " style=" + style + " uses " + fcInfo.firstFont.fullName + " in file: " + fcInfo.firstFont.fontFile);
        }
        return fcInfo;
    }

    public static String getDefaultFontPath() {
        if (fontConfigFonts == null && !fontConfigFailed) {
            FontConfigManager.getFontConfigFont("System", false, false);
        }
        return defaultFontFile;
    }

    public static ArrayList<String> getFileNames(FcCompFont font, boolean fallBacksOnly) {
        ArrayList<String> fileList = new ArrayList<String>();
        if (font.allFonts != null) {
            int start;
            for (int i = start = fallBacksOnly ? 1 : 0; i < font.allFonts.length; ++i) {
                fileList.add(font.allFonts[i].fontFile);
            }
        }
        return fileList;
    }

    public static ArrayList<String> getFontNames(FcCompFont font, boolean fallBacksOnly) {
        ArrayList<String> fontList = new ArrayList<String>();
        if (font.allFonts != null) {
            int start;
            for (int i = start = fallBacksOnly ? 1 : 0; i < font.allFonts.length; ++i) {
                fontList.add(font.allFonts[i].fullName);
            }
        }
        return fontList;
    }

    static /* synthetic */ Void lambda$static$235() {
        String dbg = System.getProperty("prism.debugfonts", "");
        debugFonts = "true".equals(dbg);
        String ufc = System.getProperty("prism.useFontConfig", "true");
        useFontConfig = "true".equals(ufc);
        String emb = System.getProperty("prism.embeddedfonts", "");
        useEmbeddedFontSupport = "true".equals(emb);
        return null;
    }

    static {
        AccessController.doPrivileged(FontConfigManager$$Lambda$1.lambdaFactory$());
        fontConfigNames = new String[]{"sans:regular:roman", "sans:bold:roman", "sans:regular:italic", "sans:bold:italic", "serif:regular:roman", "serif:bold:roman", "serif:regular:italic", "serif:bold:italic", "monospace:regular:roman", "monospace:bold:roman", "monospace:regular:italic", "monospace:bold:italic"};
    }

    private static class EmbeddedFontSupport {
        private static String fontDirProp = null;
        private static String fontDir;
        private static boolean fontDirFromJRE;
        static String[] jreFontsProperties;

        private EmbeddedFontSupport() {
        }

        private static void initEmbeddedFonts() {
            fontDirProp = System.getProperty("prism.fontdir");
            if (fontDirProp != null) {
                fontDir = fontDirProp;
            } else {
                try {
                    String javaHome = System.getProperty("java.home");
                    if (javaHome == null) {
                        return;
                    }
                    File fontDirectory = new File(javaHome, "lib/fonts");
                    if (fontDirectory.exists()) {
                        fontDirFromJRE = true;
                        fontDir = fontDirectory.getPath();
                    }
                    if (debugFonts) {
                        System.err.println("Fallback fontDir is " + fontDirectory + " exists = " + fontDirectory.exists());
                    }
                }
                catch (Exception e) {
                    if (debugFonts) {
                        e.printStackTrace();
                    }
                    fontDir = "/";
                }
            }
        }

        private static String getStyleStr(int style) {
            switch (style) {
                case 0: {
                    return "regular";
                }
                case 1: {
                    return "bold";
                }
                case 2: {
                    return "italic";
                }
                case 3: {
                    return "bolditalic";
                }
            }
            return "regular";
        }

        private static boolean exists(File f) {
            return (Boolean)AccessController.doPrivileged(FontConfigManager$EmbeddedFontSupport$$Lambda$1.lambdaFactory$(f));
        }

        static void initLogicalFonts(FcCompFont[] fonts) {
            Properties props;
            block11: {
                props = new Properties();
                try {
                    File f = new File(fontDir, "logicalfonts.properties");
                    if (f.exists()) {
                        FileInputStream fis = new FileInputStream(f);
                        props.load(fis);
                        fis.close();
                    } else if (fontDirFromJRE) {
                        for (int i = 0; i < jreFontsProperties.length; i += 2) {
                            props.setProperty(jreFontsProperties[i], jreFontsProperties[i + 1]);
                        }
                        if (debugFonts) {
                            System.err.println("Using fallback implied logicalfonts.properties");
                        }
                    }
                }
                catch (IOException ioe) {
                    if (!debugFonts) break block11;
                    System.err.println(ioe);
                    return;
                }
            }
            for (int f = 0; f < fonts.length; ++f) {
                String fcFamily = fonts[f].fcFamily;
                String styleStr = EmbeddedFontSupport.getStyleStr(fonts[f].style);
                String key = fcFamily + "." + styleStr + ".";
                ArrayList<FontConfigFont> allFonts = new ArrayList<FontConfigFont>();
                int i = 0;
                while (true) {
                    String file = props.getProperty(key + i + ".file");
                    String font = props.getProperty(key + i + ".font");
                    ++i;
                    if (file == null) break;
                    File ff = new File(fontDir, file);
                    if (!EmbeddedFontSupport.exists(ff)) {
                        if (!debugFonts) continue;
                        System.out.println("Failed to find logical font file " + ff);
                        continue;
                    }
                    FontConfigFont fcFont = new FontConfigFont();
                    fcFont.fontFile = ff.getPath();
                    fcFont.fullName = font;
                    fcFont.familyName = null;
                    fcFont.styleStr = null;
                    if (fonts[f].firstFont == null) {
                        fonts[f].firstFont = fcFont;
                    }
                    allFonts.add(fcFont);
                }
                if (allFonts.size() <= 0) continue;
                fonts[f].allFonts = new FontConfigFont[allFonts.size()];
                allFonts.toArray(fonts[f].allFonts);
            }
        }

        static void populateMaps(HashMap<String, String> fontToFileMap, HashMap<String, String> fontToFamilyNameMap, HashMap<String, ArrayList<String>> familyToFontListMap, Locale locale) {
            Properties props = new Properties();
            AccessController.doPrivileged(FontConfigManager$EmbeddedFontSupport$$Lambda$2.lambdaFactory$(props));
            if (!props.isEmpty()) {
                int maxFont = Integer.MAX_VALUE;
                try {
                    maxFont = Integer.parseInt(props.getProperty("maxFont", ""));
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
                if (maxFont <= 0) {
                    maxFont = Integer.MAX_VALUE;
                }
                for (int f = 0; f < maxFont; ++f) {
                    String family = props.getProperty("family." + f);
                    String font = props.getProperty("font." + f);
                    String file = props.getProperty("file." + f);
                    if (file == null) break;
                    File ff = new File(fontDir, file);
                    if (!EmbeddedFontSupport.exists(ff) || family == null || font == null) continue;
                    String fontLC = font.toLowerCase(Locale.ENGLISH);
                    String familyLC = family.toLowerCase(Locale.ENGLISH);
                    fontToFileMap.put(fontLC, ff.getPath());
                    fontToFamilyNameMap.put(fontLC, family);
                    ArrayList<String> familyArr = familyToFontListMap.get(familyLC);
                    if (familyArr == null) {
                        familyArr = new ArrayList(4);
                        familyToFontListMap.put(familyLC, familyArr);
                    }
                    familyArr.add(font);
                }
            }
        }

        static /* synthetic */ Void lambda$populateMaps$238(Properties properties) {
            block2: {
                try {
                    String lFile = fontDir + "/allfonts.properties";
                    FileInputStream fis = new FileInputStream(lFile);
                    properties.load(fis);
                    fis.close();
                }
                catch (IOException ioe) {
                    properties.clear();
                    if (!debugFonts) break block2;
                    System.err.println(ioe);
                    System.err.println("Fall back to opening the files");
                }
            }
            return null;
        }

        static /* synthetic */ Boolean lambda$exists$237(File file) {
            return file.exists();
        }

        static /* synthetic */ Void lambda$static$236() {
            EmbeddedFontSupport.initEmbeddedFonts();
            return null;
        }

        static {
            fontDirFromJRE = false;
            AccessController.doPrivileged(FontConfigManager$EmbeddedFontSupport$$Lambda$3.lambdaFactory$());
            jreFontsProperties = new String[]{"sans.regular.0.font", "Lucida Sans Regular", "sans.regular.0.file", "LucidaSansRegular.ttf", "sans.bold.0.font", "Lucida Sans Bold", "sans.bold.0.file", "LucidaSansDemiBold.ttf", "monospace.regular.0.font", "Lucida Typewriter Regular", "monospace.regular.0.file", "LucidaTypewriterRegular.ttf", "monospace.bold.0.font", "Lucida Typewriter Bold", "monospace.bold.0.file", "LucidaTypewriterBold.ttf", "serif.regular.0.font", "Lucida Bright", "serif.regular.0.file", "LucidaBrightRegular.ttf", "serif.bold.0.font", "Lucida Bright Demibold", "serif.bold.0.file", "LucidaBrightDemiBold.ttf", "serif.italic.0.font", "Lucida Bright Italic", "serif.italic.0.file", "LucidaBrightItalic.ttf", "serif.bolditalic.0.font", "Lucida Bright Demibold Italic", "serif.bolditalic.0.file", "LucidaBrightDemiItalic.ttf"};
        }
    }

    public static class FcCompFont {
        public String fcName;
        public String fcFamily;
        public int style;
        public FontConfigFont firstFont;
        public FontConfigFont[] allFonts;
    }

    public static class FontConfigFont {
        public String familyName;
        public String styleStr;
        public String fullName;
        public String fontFile;
    }
}

