/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.font;

import com.sun.javafx.font.FontConstants;
import com.sun.javafx.font.FontFileReader$$Lambda$1;
import com.sun.javafx.font.PrismFontFactory;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.security.AccessController;
import java.security.PrivilegedActionException;

class FontFileReader
implements FontConstants {
    String filename;
    long filesize;
    RandomAccessFile raFile;
    private static final int READBUFFERSIZE = 1024;
    private byte[] readBuffer;
    private int readBufferLen;
    private int readBufferStart;

    public FontFileReader(String filename) {
        this.filename = filename;
    }

    public String getFilename() {
        return this.filename;
    }

    public synchronized boolean openFile() throws PrivilegedActionException {
        if (this.raFile != null) {
            return false;
        }
        this.raFile = (RandomAccessFile)AccessController.doPrivileged(FontFileReader$$Lambda$1.lambdaFactory$(this));
        if (this.raFile != null) {
            try {
                this.filesize = this.raFile.length();
                return true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    public synchronized void closeFile() throws IOException {
        if (this.raFile != null) {
            this.raFile.close();
            this.raFile = null;
            this.readBuffer = null;
        }
    }

    public synchronized long getLength() {
        return this.filesize;
    }

    public synchronized void reset() throws IOException {
        if (this.raFile != null) {
            this.raFile.seek(0L);
        }
    }

    private synchronized int readFromFile(byte[] buffer, long seekPos, int requestedLen) {
        try {
            this.raFile.seek(seekPos);
            int bytesRead = this.raFile.read(buffer, 0, requestedLen);
            return bytesRead;
        }
        catch (IOException e) {
            if (PrismFontFactory.debugFonts) {
                e.printStackTrace();
            }
            return 0;
        }
    }

    public synchronized Buffer readBlock(int offset, int len) {
        if (this.readBuffer == null) {
            this.readBuffer = new byte[1024];
            this.readBufferLen = 0;
        }
        if (len <= 1024) {
            if (this.readBufferStart <= offset && this.readBufferStart + this.readBufferLen >= offset + len) {
                return new Buffer(this.readBuffer, offset - this.readBufferStart);
            }
            this.readBufferStart = offset;
            this.readBufferLen = (long)(offset + 1024) > this.filesize ? (int)this.filesize - offset : 1024;
            this.readFromFile(this.readBuffer, this.readBufferStart, this.readBufferLen);
            return new Buffer(this.readBuffer, 0);
        }
        byte[] data = new byte[len];
        this.readFromFile(data, offset, len);
        return new Buffer(data, 0);
    }

    /* synthetic */ RandomAccessFile lambda$openFile$222() {
        try {
            return new RandomAccessFile(this.filename, "r");
        }
        catch (FileNotFoundException fnfe) {
            return null;
        }
    }

    static class Buffer {
        byte[] data;
        int pos;
        int orig;

        Buffer(byte[] data, int bufStart) {
            this.orig = this.pos = bufStart;
            this.data = data;
        }

        int getInt(int tpos) {
            tpos += this.orig;
            int val = this.data[tpos++] & 0xFF;
            val <<= 8;
            val |= this.data[tpos++] & 0xFF;
            val <<= 8;
            val |= this.data[tpos++] & 0xFF;
            val <<= 8;
            return val |= this.data[tpos++] & 0xFF;
        }

        int getInt() {
            int val = this.data[this.pos++] & 0xFF;
            val <<= 8;
            val |= this.data[this.pos++] & 0xFF;
            val <<= 8;
            val |= this.data[this.pos++] & 0xFF;
            val <<= 8;
            return val |= this.data[this.pos++] & 0xFF;
        }

        short getShort(int tpos) {
            tpos += this.orig;
            int val = this.data[tpos++] & 0xFF;
            val <<= 8;
            return (short)(val |= this.data[tpos++] & 0xFF);
        }

        short getShort() {
            int val = this.data[this.pos++] & 0xFF;
            val <<= 8;
            return (short)(val |= this.data[this.pos++] & 0xFF);
        }

        char getChar(int tpos) {
            tpos += this.orig;
            int val = this.data[tpos++] & 0xFF;
            val <<= 8;
            return (char)(val |= this.data[tpos++] & 0xFF);
        }

        char getChar() {
            int val = this.data[this.pos++] & 0xFF;
            val <<= 8;
            return (char)(val |= this.data[this.pos++] & 0xFF);
        }

        void position(int newPos) {
            this.pos = this.orig + newPos;
        }

        int capacity() {
            return this.data.length - this.orig;
        }

        byte get() {
            return this.data[this.pos++];
        }

        byte get(int tpos) {
            return this.data[tpos += this.orig];
        }

        void skip(int nbytes) {
            this.pos += nbytes;
        }

        void get(int startPos, byte[] dest, int destPos, int destLen) {
            System.arraycopy(this.data, this.orig + startPos, dest, destPos, destLen);
        }
    }
}

