/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.iio;

import com.sun.javafx.PlatformUtil;
import com.sun.javafx.iio.ImageFormatDescription;
import com.sun.javafx.iio.ImageFrame;
import com.sun.javafx.iio.ImageLoadListener;
import com.sun.javafx.iio.ImageLoader;
import com.sun.javafx.iio.ImageLoaderFactory;
import com.sun.javafx.iio.ImageStorageException;
import com.sun.javafx.iio.bmp.BMPImageLoaderFactory;
import com.sun.javafx.iio.common.ImageTools;
import com.sun.javafx.iio.gif.GIFImageLoaderFactory;
import com.sun.javafx.iio.ios.IosImageLoaderFactory;
import com.sun.javafx.iio.jpeg.JPEGImageLoaderFactory;
import com.sun.javafx.iio.png.PNGImageLoaderFactory;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class ImageStorage {
    private static final HashMap<ImageFormatDescription.Signature, ImageLoaderFactory> loaderFactoriesBySignature;
    private static final ImageLoaderFactory[] loaderFactories;
    private static final boolean isIOS;
    private static int maxSignatureLength;

    public static ImageFormatDescription[] getSupportedDescriptions() {
        ImageFormatDescription[] formats = new ImageFormatDescription[loaderFactories.length];
        for (int i = 0; i < loaderFactories.length; ++i) {
            formats[i] = loaderFactories[i].getFormatDescription();
        }
        return formats;
    }

    public static int getNumBands(ImageType type) {
        int numBands = -1;
        switch (type) {
            case GRAY: 
            case PALETTE: 
            case PALETTE_ALPHA: 
            case PALETTE_ALPHA_PRE: 
            case PALETTE_TRANS: {
                numBands = 1;
                break;
            }
            case GRAY_ALPHA: 
            case GRAY_ALPHA_PRE: {
                numBands = 2;
                break;
            }
            case RGB: {
                numBands = 3;
                break;
            }
            case RGBA: 
            case RGBA_PRE: {
                numBands = 4;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown ImageType " + (Object)((Object)type));
            }
        }
        return numBands;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addImageLoaderFactory(ImageLoaderFactory factory) {
        ImageFormatDescription desc = factory.getFormatDescription();
        for (ImageFormatDescription.Signature signature : desc.getSignatures()) {
            loaderFactoriesBySignature.put(signature, factory);
        }
        Class<ImageStorage> clazz = ImageStorage.class;
        synchronized (ImageStorage.class) {
            maxSignatureLength = -1;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public static ImageFrame[] loadAll(InputStream input, ImageLoadListener listener, int width, int height, boolean preserveAspectRatio, float pixelScale, boolean smooth) throws ImageStorageException {
        ImageLoader loader = null;
        try {
            loader = isIOS ? IosImageLoaderFactory.getInstance().createImageLoader(input) : ImageStorage.getLoaderBySignature(input, listener);
        }
        catch (IOException e) {
            throw new ImageStorageException(e.getMessage(), e);
        }
        ImageFrame[] images = null;
        if (loader == null) {
            throw new ImageStorageException("No loader for image data");
        }
        images = ImageStorage.loadAll(loader, width, height, preserveAspectRatio, pixelScale, smooth);
        return images;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImageFrame[] loadAll(String input, ImageLoadListener listener, int width, int height, boolean preserveAspectRatio, float pixelScale, boolean smooth) throws ImageStorageException {
        ImageFrame[] images;
        block16: {
            if (input == null || input.isEmpty()) {
                throw new ImageStorageException("URL can't be null or empty");
            }
            images = null;
            InputStream theStream = null;
            ImageLoader loader = null;
            try {
                try {
                    if (pixelScale > 1.9f) {
                        try {
                            String name2x = ImageTools.getScaledImageName(input);
                            theStream = ImageTools.createInputStream(name2x);
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                    }
                    if (theStream == null) {
                        theStream = ImageTools.createInputStream(input);
                        pixelScale = 1.0f;
                    }
                    loader = isIOS ? IosImageLoaderFactory.getInstance().createImageLoader(theStream) : ImageStorage.getLoaderBySignature(theStream, listener);
                }
                catch (IOException e) {
                    throw new ImageStorageException(e.getMessage(), e);
                }
                if (loader != null) {
                    images = ImageStorage.loadAll(loader, width, height, preserveAspectRatio, pixelScale, smooth);
                    break block16;
                }
                throw new ImageStorageException("No loader for image data");
            }
            finally {
                try {
                    if (theStream != null) {
                        theStream.close();
                    }
                }
                catch (IOException e) {}
            }
        }
        return images;
    }

    private static synchronized int getMaxSignatureLength() {
        if (maxSignatureLength < 0) {
            maxSignatureLength = 0;
            for (ImageFormatDescription.Signature signature : loaderFactoriesBySignature.keySet()) {
                int signatureLength = signature.getLength();
                if (maxSignatureLength >= signatureLength) continue;
                maxSignatureLength = signatureLength;
            }
        }
        return maxSignatureLength;
    }

    private static ImageFrame[] loadAll(ImageLoader loader, int width, int height, boolean preserveAspectRatio, float pixelScale, boolean smooth) throws ImageStorageException {
        ImageFrame[] images = null;
        ArrayList<ImageFrame> list = new ArrayList<ImageFrame>();
        int imageIndex = 0;
        ImageFrame image = null;
        while (true) {
            try {
                image = loader.load(imageIndex++, width, height, preserveAspectRatio, smooth);
            }
            catch (Exception e) {
                if (imageIndex > 1) break;
                throw new ImageStorageException(e.getMessage(), e);
            }
            if (image == null) break;
            image.setPixelScale(pixelScale);
            list.add(image);
        }
        int numImages = list.size();
        if (numImages > 0) {
            images = new ImageFrame[numImages];
            list.toArray(images);
        }
        return images;
    }

    private static ImageLoader getLoaderBySignature(InputStream stream, ImageLoadListener listener) throws IOException {
        byte[] header = new byte[ImageStorage.getMaxSignatureLength()];
        ImageTools.readFully(stream, header);
        for (Map.Entry<ImageFormatDescription.Signature, ImageLoaderFactory> factoryRegistration : loaderFactoriesBySignature.entrySet()) {
            if (!factoryRegistration.getKey().matches(header)) continue;
            ByteArrayInputStream headerStream = new ByteArrayInputStream(header);
            SequenceInputStream seqStream = new SequenceInputStream(headerStream, stream);
            ImageLoader loader = factoryRegistration.getValue().createImageLoader(seqStream);
            if (listener != null) {
                loader.addListener(listener);
            }
            return loader;
        }
        return null;
    }

    private ImageStorage() {
    }

    static {
        isIOS = PlatformUtil.isIOS();
        loaderFactories = isIOS ? new ImageLoaderFactory[]{IosImageLoaderFactory.getInstance()} : new ImageLoaderFactory[]{GIFImageLoaderFactory.getInstance(), JPEGImageLoaderFactory.getInstance(), PNGImageLoaderFactory.getInstance(), BMPImageLoaderFactory.getInstance()};
        loaderFactoriesBySignature = new HashMap(loaderFactories.length);
        for (int i = 0; i < loaderFactories.length; ++i) {
            ImageStorage.addImageLoaderFactory(loaderFactories[i]);
        }
    }

    public static enum ImageType {
        GRAY,
        GRAY_ALPHA,
        GRAY_ALPHA_PRE,
        PALETTE,
        PALETTE_ALPHA,
        PALETTE_ALPHA_PRE,
        PALETTE_TRANS,
        RGB,
        RGBA,
        RGBA_PRE;

    }
}

