/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.iio.ios;

import com.sun.glass.utils.NativeLibLoader;
import com.sun.javafx.iio.ImageFrame;
import com.sun.javafx.iio.ImageMetadata;
import com.sun.javafx.iio.ImageStorage;
import com.sun.javafx.iio.common.ImageDescriptor;
import com.sun.javafx.iio.common.ImageLoaderImpl;
import com.sun.javafx.iio.common.ImageTools;
import com.sun.javafx.iio.ios.IosImageLoader$$Lambda$1;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Map;

public class IosImageLoader
extends ImageLoaderImpl {
    public static final int GRAY = 0;
    public static final int GRAY_ALPHA = 1;
    public static final int GRAY_ALPHA_PRE = 2;
    public static final int PALETTE = 3;
    public static final int PALETTE_ALPHA = 4;
    public static final int PALETTE_ALPHA_PRE = 5;
    public static final int PALETTE_TRANS = 6;
    public static final int RGB = 7;
    public static final int RGBA = 8;
    public static final int RGBA_PRE = 9;
    private static final Map<Integer, ImageStorage.ImageType> colorSpaceMapping = new HashMap<Integer, ImageStorage.ImageType>();
    private long structPointer;
    private int inWidth;
    private int inHeight;
    private int nImages;
    private boolean isDisposed = false;
    private int delayTime;

    private static native void initNativeLoading();

    private native long loadImage(InputStream var1, boolean var2) throws IOException;

    private native long loadImageFromURL(String var1, boolean var2) throws IOException;

    private native void resizeImage(long var1, int var3, int var4);

    private native byte[] getImageBuffer(long var1, int var3);

    private native int getNumberOfComponents(long var1);

    private native int getColorSpaceCode(long var1);

    private native int getDelayTime(long var1);

    private static native void disposeLoader(long var0);

    private void setInputParameters(int width, int height, int imageCount) {
        this.inWidth = width;
        this.inHeight = height;
        this.nImages = imageCount;
    }

    private void updateProgress(float progressPercentage) {
        this.updateImageProgress(progressPercentage);
    }

    private boolean shouldReportProgress() {
        return this.listeners != null && !this.listeners.isEmpty();
    }

    private void checkNativePointer() throws IOException {
        if (this.structPointer == 0L) {
            throw new IOException("Unable to initialize image native loader!");
        }
    }

    private void retrieveDelayTime() {
        if (this.nImages > 1) {
            this.delayTime = this.getDelayTime(this.structPointer);
        }
    }

    public IosImageLoader(String urlString, ImageDescriptor desc) throws IOException {
        super(desc);
        try {
            URL url = new URL(urlString);
        }
        catch (MalformedURLException mue) {
            throw new IllegalArgumentException("Image loader: Malformed URL!");
        }
        try {
            this.structPointer = this.loadImageFromURL(urlString, this.shouldReportProgress());
        }
        catch (IOException e) {
            this.dispose();
            throw e;
        }
        this.checkNativePointer();
        this.retrieveDelayTime();
    }

    public IosImageLoader(InputStream inputStream, ImageDescriptor desc) throws IOException {
        super(desc);
        if (inputStream == null) {
            throw new IllegalArgumentException("Image loader: input stream == null");
        }
        try {
            this.structPointer = this.loadImage(inputStream, this.shouldReportProgress());
        }
        catch (IOException e) {
            this.dispose();
            throw e;
        }
        this.checkNativePointer();
        this.retrieveDelayTime();
    }

    @Override
    public synchronized void dispose() {
        if (!this.isDisposed && this.structPointer != 0L) {
            this.isDisposed = true;
            IosImageLoader.disposeLoader(this.structPointer);
            this.structPointer = 0L;
        }
    }

    protected void finalize() {
        this.dispose();
    }

    @Override
    public ImageFrame load(int imageIndex, int width, int height, boolean preserveAspectRatio, boolean smooth) throws IOException {
        if (imageIndex >= this.nImages) {
            this.dispose();
            return null;
        }
        int[] widthHeight = ImageTools.computeDimensions(this.inWidth, this.inHeight, width, height, preserveAspectRatio);
        width = widthHeight[0];
        height = widthHeight[1];
        ImageMetadata md = new ImageMetadata(null, true, null, null, null, this.delayTime == 0 ? null : Integer.valueOf(this.delayTime), this.inWidth, this.inHeight, null, null, null);
        this.updateImageMetadata(md);
        this.resizeImage(this.structPointer, width, height);
        int nComponents = this.getNumberOfComponents(this.structPointer);
        int colorSpaceCode = this.getColorSpaceCode(this.structPointer);
        ImageStorage.ImageType imageType = colorSpaceMapping.get(colorSpaceCode);
        byte[] pixels = this.getImageBuffer(this.structPointer, imageIndex);
        return new ImageFrame(imageType, ByteBuffer.wrap(pixels), width, height, width * nComponents, null, md);
    }

    static /* synthetic */ Object lambda$static$246() {
        NativeLibLoader.loadLibrary("nativeiio");
        return null;
    }

    static {
        AccessController.doPrivileged(IosImageLoader$$Lambda$1.lambdaFactory$());
        colorSpaceMapping.put(0, ImageStorage.ImageType.GRAY);
        colorSpaceMapping.put(1, ImageStorage.ImageType.GRAY_ALPHA);
        colorSpaceMapping.put(2, ImageStorage.ImageType.GRAY_ALPHA_PRE);
        colorSpaceMapping.put(3, ImageStorage.ImageType.PALETTE);
        colorSpaceMapping.put(4, ImageStorage.ImageType.PALETTE_ALPHA);
        colorSpaceMapping.put(5, ImageStorage.ImageType.PALETTE_ALPHA_PRE);
        colorSpaceMapping.put(6, ImageStorage.ImageType.PALETTE_TRANS);
        colorSpaceMapping.put(7, ImageStorage.ImageType.RGB);
        colorSpaceMapping.put(8, ImageStorage.ImageType.RGBA);
        colorSpaceMapping.put(9, ImageStorage.ImageType.RGBA_PRE);
        IosImageLoader.initNativeLoading();
    }
}

