/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.iio.png;

import com.sun.javafx.iio.ImageFrame;
import com.sun.javafx.iio.ImageMetadata;
import com.sun.javafx.iio.ImageStorage;
import com.sun.javafx.iio.common.ImageLoaderImpl;
import com.sun.javafx.iio.common.ImageTools;
import com.sun.javafx.iio.common.PushbroomScaler;
import com.sun.javafx.iio.common.ScalerFactory;
import com.sun.javafx.iio.png.PNGDescriptor;
import com.sun.javafx.iio.png.PNGIDATChunkInputStream;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;

public final class PNGImageLoader2
extends ImageLoaderImpl {
    static final byte[] FILE_SIG = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
    static final int IHDR_TYPE = 1229472850;
    static final int PLTE_TYPE = 1347179589;
    static final int IDAT_TYPE = 1229209940;
    static final int IEND_TYPE = 1229278788;
    static final int tRNS_TYPE = 1951551059;
    static final int PNG_COLOR_GRAY = 0;
    static final int PNG_COLOR_RGB = 2;
    static final int PNG_COLOR_PALETTE = 3;
    static final int PNG_COLOR_GRAY_ALPHA = 4;
    static final int PNG_COLOR_RGB_ALPHA = 6;
    static final int[] numBandsPerColorType = new int[]{1, -1, 3, 1, 2, -1, 4};
    static final int PNG_FILTER_NONE = 0;
    static final int PNG_FILTER_SUB = 1;
    static final int PNG_FILTER_UP = 2;
    static final int PNG_FILTER_AVERAGE = 3;
    static final int PNG_FILTER_PAETH = 4;
    private final DataInputStream stream;
    private int width;
    private int height;
    private int bitDepth;
    private int colorType;
    private boolean isInterlaced;
    private boolean tRNS_present = false;
    private boolean tRNS_GRAY_RGB = false;
    private int trnsR;
    private int trnsG;
    private int trnsB;
    private byte[][] palette;
    private static final int[] starting_y = new int[]{0, 0, 4, 0, 2, 0, 1, 0};
    private static final int[] starting_x = new int[]{0, 4, 0, 2, 0, 1, 0, 0};
    private static final int[] increment_y = new int[]{8, 8, 8, 4, 4, 2, 2, 1};
    private static final int[] increment_x = new int[]{8, 8, 4, 4, 2, 2, 1, 1};

    public PNGImageLoader2(InputStream input) throws IOException {
        super(PNGDescriptor.getInstance());
        this.stream = new DataInputStream(input);
        byte[] signature = this.readBytes(new byte[8]);
        if (!Arrays.equals(FILE_SIG, signature)) {
            throw new IOException("Bad PNG signature!");
        }
        this.readHeader();
    }

    private void readHeader() throws IOException {
        int[] hdrData = this.readChunk();
        if (hdrData[1] != 1229472850 && hdrData[0] != 13) {
            throw new IOException("Bad PNG header!");
        }
        this.width = this.stream.readInt();
        this.height = this.stream.readInt();
        if (this.width == 0 || this.height == 0) {
            throw new IOException("Bad PNG image size!");
        }
        this.bitDepth = this.stream.readByte();
        if (this.bitDepth != 1 && this.bitDepth != 2 && this.bitDepth != 4 && this.bitDepth != 8 && this.bitDepth != 16) {
            throw new IOException("Bad PNG bit depth");
        }
        this.colorType = this.stream.readByte();
        if (this.colorType > 6 || this.colorType == 1 || this.colorType == 5) {
            throw new IOException("Bad PNG color type");
        }
        if (this.colorType != 3 && this.colorType != 0 && this.bitDepth < 8 || this.colorType == 3 && this.bitDepth == 16) {
            throw new IOException("Bad color type/bit depth combination!");
        }
        byte compressionMethod = this.stream.readByte();
        if (compressionMethod != 0) {
            throw new IOException("Bad PNG comression!");
        }
        byte filterMethod = this.stream.readByte();
        if (filterMethod != 0) {
            throw new IOException("Bad PNG filter method!");
        }
        byte interlaceMethod = this.stream.readByte();
        if (interlaceMethod != 0 && interlaceMethod != 1) {
            throw new IOException("Unknown interlace method (not 0 or 1)!");
        }
        int crc = this.stream.readInt();
        this.isInterlaced = interlaceMethod == 1;
    }

    private int[] readChunk() throws IOException {
        return new int[]{this.stream.readInt(), this.stream.readInt()};
    }

    private byte[] readBytes(byte[] data) throws IOException {
        return this.readBytes(data, 0, data.length);
    }

    private byte[] readBytes(byte[] data, int offs, int size) throws IOException {
        if (this.stream.read(data, offs, size) != size) {
            throw new EOFException();
        }
        return data;
    }

    private void skip(int n) throws IOException {
        if (n != this.stream.skipBytes(n)) {
            throw new EOFException();
        }
    }

    private void readPaletteChunk(int chunkLength) throws IOException {
        int numEntries = chunkLength / 3;
        int paletteEntries = 1 << this.bitDepth;
        if (numEntries > paletteEntries) {
            this.emitWarning("PLTE chunk contains too many entries for bit depth, ignoring extras.");
            numEntries = paletteEntries;
        }
        this.palette = new byte[3][paletteEntries];
        byte[] paletteData = this.readBytes(new byte[chunkLength]);
        int idx = 0;
        for (int i = 0; i != numEntries; ++i) {
            for (int k = 0; k != 3; ++k) {
                this.palette[k][i] = paletteData[idx++];
            }
        }
    }

    private void parsePaletteChunk(int chunkLength) throws IOException {
        if (this.palette != null) {
            this.emitWarning("A PNG image may not contain more than one PLTE chunk.\nThe chunk wil be ignored.");
            this.skip(chunkLength);
            return;
        }
        switch (this.colorType) {
            case 3: {
                this.readPaletteChunk(chunkLength);
                return;
            }
            case 0: 
            case 4: {
                this.emitWarning("A PNG gray or gray alpha image cannot have a PLTE chunk.\nThe chunk wil be ignored.");
            }
        }
        this.skip(chunkLength);
    }

    private boolean readPaletteTransparency(int chunkLength) throws IOException {
        if (this.palette == null) {
            this.emitWarning("tRNS chunk without prior PLTE chunk, ignoring it.");
            this.skip(chunkLength);
            return false;
        }
        byte[][] newPal = new byte[4][];
        System.arraycopy(this.palette, 0, newPal, 0, 3);
        int paletteLength = this.palette[0].length;
        newPal[3] = new byte[paletteLength];
        int nRead = chunkLength < paletteLength ? chunkLength : paletteLength;
        this.readBytes(newPal[3], 0, nRead);
        for (int i = nRead; i < paletteLength; ++i) {
            newPal[3][i] = -1;
        }
        if (nRead < chunkLength) {
            this.skip(chunkLength - nRead);
        }
        this.palette = newPal;
        return true;
    }

    private boolean readGrayTransparency(int chunkLength) throws IOException {
        if (chunkLength == 2) {
            this.trnsG = this.stream.readShort();
            return true;
        }
        return false;
    }

    private boolean readRgbTransparency(int chunkLength) throws IOException {
        if (chunkLength == 6) {
            this.trnsR = this.stream.readShort();
            this.trnsG = this.stream.readShort();
            this.trnsB = this.stream.readShort();
            return true;
        }
        return false;
    }

    private void parseTransparencyChunk(int chunkLength) throws IOException {
        switch (this.colorType) {
            case 3: {
                this.tRNS_present = this.readPaletteTransparency(chunkLength);
                break;
            }
            case 0: {
                this.tRNS_GRAY_RGB = this.tRNS_present = this.readGrayTransparency(chunkLength);
                break;
            }
            case 2: {
                this.tRNS_GRAY_RGB = this.tRNS_present = this.readRgbTransparency(chunkLength);
                break;
            }
            default: {
                this.emitWarning("TransparencyChunk may not present when alpha explicitly defined");
                this.skip(chunkLength);
            }
        }
    }

    private int parsePngMeta() throws IOException {
        while (true) {
            int[] chunk = this.readChunk();
            switch (chunk[1]) {
                case 1229209940: {
                    return chunk[0];
                }
                case 1229278788: {
                    return 0;
                }
                case 1347179589: {
                    this.parsePaletteChunk(chunk[0]);
                    break;
                }
                case 1951551059: {
                    this.parseTransparencyChunk(chunk[0]);
                    break;
                }
                default: {
                    this.skip(chunk[0]);
                }
            }
            int n = this.stream.readInt();
        }
    }

    @Override
    public void dispose() {
    }

    private ImageMetadata updateMetadata() {
        ImageMetadata metaData = new ImageMetadata(null, true, null, null, null, null, this.width, this.height, null, null, null);
        this.updateImageMetadata(metaData);
        return metaData;
    }

    private ImageStorage.ImageType getType() {
        switch (this.colorType) {
            case 0: {
                return this.tRNS_present ? ImageStorage.ImageType.GRAY_ALPHA : ImageStorage.ImageType.GRAY;
            }
            case 2: {
                return this.tRNS_present ? ImageStorage.ImageType.RGBA : ImageStorage.ImageType.RGB;
            }
            case 3: {
                return ImageStorage.ImageType.PALETTE;
            }
            case 4: {
                return ImageStorage.ImageType.GRAY_ALPHA;
            }
            case 6: {
                return ImageStorage.ImageType.RGBA;
            }
        }
        throw new RuntimeException();
    }

    private void doSubFilter(byte[] line, int bpp) {
        int l = line.length;
        for (int i = bpp; i != l; ++i) {
            line[i] = (byte)(line[i] + line[i - bpp]);
        }
    }

    private void doUpFilter(byte[] line, byte[] pline) {
        int l = line.length;
        for (int i = 0; i != l; ++i) {
            line[i] = (byte)(line[i] + pline[i]);
        }
    }

    private void doAvrgFilter(byte[] line, byte[] pline, int bpp) {
        int i;
        int l = line.length;
        for (i = 0; i != bpp; ++i) {
            line[i] = (byte)(line[i] + (pline[i] & 0xFF) / 2);
        }
        for (i = bpp; i != l; ++i) {
            line[i] = (byte)(line[i] + ((line[i - bpp] & 0xFF) + (pline[i] & 0xFF)) / 2);
        }
    }

    private static int paethPr(int a, int b, int c) {
        int pa = Math.abs(b - c);
        int pb = Math.abs(a - c);
        int pc = Math.abs(b - c + a - c);
        return pa <= pb && pa <= pc ? a : (pb <= pc ? b : c);
    }

    private void doPaethFilter(byte[] line, byte[] pline, int bpp) {
        int i;
        int l = line.length;
        for (i = 0; i != bpp; ++i) {
            line[i] = (byte)(line[i] + pline[i]);
        }
        for (i = bpp; i != l; ++i) {
            line[i] = (byte)(line[i] + PNGImageLoader2.paethPr(line[i - bpp] & 0xFF, pline[i] & 0xFF, pline[i - bpp] & 0xFF));
        }
    }

    private void doFilter(byte[] line, byte[] pline, int fType, int bpp) {
        switch (fType) {
            case 1: {
                this.doSubFilter(line, bpp);
                break;
            }
            case 2: {
                this.doUpFilter(line, pline);
                break;
            }
            case 3: {
                this.doAvrgFilter(line, pline, bpp);
                break;
            }
            case 4: {
                this.doPaethFilter(line, pline, bpp);
            }
        }
    }

    private void downsample16to8trns_gray(byte[] line, byte[] image, int pos, int step) {
        int l = line.length / 2;
        int oPos = pos;
        for (int i = 0; i < l; ++i) {
            short gray16 = (short)((line[i * 2] & 0xFF) * 256 + (line[i * 2 + 1] & 0xFF));
            image[oPos + 0] = line[i * 2];
            image[oPos + 1] = gray16 == this.trnsG ? 0 : -1;
            oPos += step * 2;
        }
    }

    private void downsample16to8trns_rgb(byte[] line, byte[] image, int pos, int step) {
        int l = line.length / 2 / 3;
        int oPos = pos;
        for (int i = 0; i < l; ++i) {
            int iPos = i * 6;
            short r16 = (short)((line[iPos + 0] & 0xFF) * 256 + (line[iPos + 1] & 0xFF));
            short g16 = (short)((line[iPos + 2] & 0xFF) * 256 + (line[iPos + 3] & 0xFF));
            short b16 = (short)((line[iPos + 4] & 0xFF) * 256 + (line[iPos + 5] & 0xFF));
            image[oPos + 0] = line[iPos + 0];
            image[oPos + 1] = line[iPos + 2];
            image[oPos + 2] = line[iPos + 4];
            image[oPos + 3] = r16 == this.trnsR && g16 == this.trnsG && b16 == this.trnsB ? 0 : -1;
            oPos += step * 4;
        }
    }

    private void downsample16to8_plain(byte[] line, byte[] image, int pos, int step, int bpp) {
        int l = line.length / 2 / bpp * bpp;
        int stepBpp = step * bpp;
        int oPos = pos;
        for (int i = 0; i != l; i += bpp) {
            for (int b = 0; b != bpp; ++b) {
                image[oPos + b] = line[(i + b) * 2];
            }
            oPos += stepBpp;
        }
    }

    private void downsample16to8(byte[] line, byte[] image, int pos, int step, int bpp) {
        if (!this.tRNS_GRAY_RGB) {
            this.downsample16to8_plain(line, image, pos, step, bpp);
        } else if (this.colorType == 0) {
            this.downsample16to8trns_gray(line, image, pos, step);
        } else if (this.colorType == 2) {
            this.downsample16to8trns_rgb(line, image, pos, step);
        }
    }

    private void copyTrns_gray(byte[] line, byte[] image, int pos, int step) {
        byte tG = (byte)this.trnsG;
        int oPos = pos;
        int l = line.length;
        for (int i = 0; i < l; ++i) {
            byte gray;
            image[oPos] = gray = line[i];
            image[oPos + 1] = gray == tG ? 0 : -1;
            oPos += 2 * step;
        }
    }

    private void copyTrns_rgb(byte[] line, byte[] image, int pos, int step) {
        byte tR = (byte)this.trnsR;
        byte tG = (byte)this.trnsG;
        byte tB = (byte)this.trnsB;
        int l = line.length / 3;
        int oPos = pos;
        for (int i = 0; i < l; ++i) {
            byte r = line[i * 3];
            byte g = line[i * 3 + 1];
            byte b = line[i * 3 + 2];
            image[oPos + 0] = r;
            image[oPos + 1] = g;
            image[oPos + 2] = b;
            image[oPos + 3] = r == tR && g == tG && b == tB ? 0 : -1;
            oPos += step * 4;
        }
    }

    private void copy_plain(byte[] line, byte[] image, int pos, int step, int bpp) {
        int l = line.length;
        int stepBpp = step * bpp;
        int oPos = pos;
        for (int i = 0; i != l; i += bpp) {
            for (int b = 0; b != bpp; ++b) {
                image[oPos + b] = line[i + b];
            }
            oPos += stepBpp;
        }
    }

    private void copy(byte[] line, byte[] image, int pos, int step, int resultBpp) {
        if (!this.tRNS_GRAY_RGB) {
            if (step == 1) {
                System.arraycopy(line, 0, image, pos, line.length);
            } else {
                this.copy_plain(line, image, pos, step, resultBpp);
            }
        } else if (this.colorType == 0) {
            this.copyTrns_gray(line, image, pos, step);
        } else if (this.colorType == 2) {
            this.copyTrns_rgb(line, image, pos, step);
        }
    }

    private void upsampleTo8Palette(byte[] line, byte[] image, int pos, int w, int step) {
        int samplesInByte = 8 / this.bitDepth;
        int maxV = (1 << this.bitDepth) - 1;
        int k = 0;
        for (int i = 0; i < w; i += samplesInByte) {
            int p = w - i < samplesInByte ? w - i : samplesInByte;
            int in = line[k] >> (samplesInByte - p) * this.bitDepth;
            for (int pp = p - 1; pp >= 0; --pp) {
                image[pos + (i + pp) * step] = (byte)(in & maxV);
                in >>= this.bitDepth;
            }
            ++k;
        }
    }

    private void upsampleTo8Gray(byte[] line, byte[] image, int pos, int w, int step) {
        int samplesInByte = 8 / this.bitDepth;
        int maxV = (1 << this.bitDepth) - 1;
        int hmaxV = maxV / 2;
        int k = 0;
        for (int i = 0; i < w; i += samplesInByte) {
            int p = w - i < samplesInByte ? w - i : samplesInByte;
            int in = line[k] >> (samplesInByte - p) * this.bitDepth;
            for (int pp = p - 1; pp >= 0; --pp) {
                image[pos + (i + pp) * step] = (byte)(((in & maxV) * 255 + hmaxV) / maxV);
                in >>= this.bitDepth;
            }
            ++k;
        }
    }

    private void upsampleTo8GrayTrns(byte[] line, byte[] image, int pos, int w, int step) {
        int samplesInByte = 8 / this.bitDepth;
        int maxV = (1 << this.bitDepth) - 1;
        int hmaxV = maxV / 2;
        int k = 0;
        for (int i = 0; i < w; i += samplesInByte) {
            int p = w - i < samplesInByte ? w - i : samplesInByte;
            int in = line[k] >> (samplesInByte - p) * this.bitDepth;
            for (int pp = p - 1; pp >= 0; --pp) {
                int idx = pos + (i + pp) * step * 2;
                int value = in & maxV;
                image[idx] = (byte)((value * 255 + hmaxV) / maxV);
                image[idx + 1] = value == this.trnsG ? 0 : -1;
                in >>= this.bitDepth;
            }
            ++k;
        }
    }

    private void upsampleTo8(byte[] line, byte[] image, int pos, int w, int step, int bpp) {
        if (this.colorType == 3) {
            this.upsampleTo8Palette(line, image, pos, w, step);
        } else if (bpp == 1) {
            this.upsampleTo8Gray(line, image, pos, w, step);
        } else if (this.tRNS_GRAY_RGB && bpp == 2) {
            this.upsampleTo8GrayTrns(line, image, pos, w, step);
        }
    }

    private static int mipSize(int size, int mip, int[] start, int[] increment) {
        return (size - start[mip] + increment[mip] - 1) / increment[mip];
    }

    private static int mipPos(int pos, int mip, int[] start, int[] increment) {
        return start[mip] + pos * increment[mip];
    }

    private void loadMip(byte[] image, InputStream data, int mip) throws IOException {
        int mipWidth = PNGImageLoader2.mipSize(this.width, mip, starting_x, increment_x);
        int mipHeight = PNGImageLoader2.mipSize(this.height, mip, starting_y, increment_y);
        int scanLineSize = (mipWidth * this.bitDepth * numBandsPerColorType[this.colorType] + 7) / 8;
        byte[] scanLine0 = new byte[scanLineSize];
        byte[] scanLine1 = new byte[scanLineSize];
        int resultBpp = this.bpp();
        int srcBpp = numBandsPerColorType[this.colorType] * this.bytesPerColor();
        for (int y = 0; y != mipHeight; ++y) {
            int filterByte = data.read();
            if (filterByte == -1) {
                throw new EOFException();
            }
            if (data.read(scanLine0) != scanLineSize) {
                throw new EOFException();
            }
            this.doFilter(scanLine0, scanLine1, filterByte, srcBpp);
            int pos = (PNGImageLoader2.mipPos(y, mip, starting_y, increment_y) * this.width + starting_x[mip]) * resultBpp;
            int step = increment_x[mip];
            if (this.bitDepth == 16) {
                this.downsample16to8(scanLine0, image, pos, step, resultBpp);
            } else if (this.bitDepth < 8) {
                this.upsampleTo8(scanLine0, image, pos, mipWidth, step, resultBpp);
            } else {
                this.copy(scanLine0, image, pos, step, resultBpp);
            }
            byte[] scanLineSwp = scanLine0;
            scanLine0 = scanLine1;
            scanLine1 = scanLineSwp;
        }
    }

    private void load(byte[] image, InputStream data) throws IOException {
        if (this.isInterlaced) {
            for (int mip = 0; mip != 7; ++mip) {
                if (this.width <= starting_x[mip] || this.height <= starting_y[mip]) continue;
                this.loadMip(image, data, mip);
            }
        } else {
            this.loadMip(image, data, 7);
        }
    }

    private ImageFrame decodePalette(byte[] srcImage, ImageMetadata metadata) {
        int i;
        int bpp = this.tRNS_present ? 4 : 3;
        byte[] newImage = new byte[this.width * this.height * bpp];
        int l = this.width * this.height;
        if (this.tRNS_present) {
            int j = 0;
            for (i = 0; i != l; ++i) {
                int index = 0xFF & srcImage[i];
                newImage[j + 0] = this.palette[0][index];
                newImage[j + 1] = this.palette[1][index];
                newImage[j + 2] = this.palette[2][index];
                newImage[j + 3] = this.palette[3][index];
                j += 4;
            }
        } else {
            int j = 0;
            for (i = 0; i != l; ++i) {
                int index = 0xFF & srcImage[i];
                newImage[j + 0] = this.palette[0][index];
                newImage[j + 1] = this.palette[1][index];
                newImage[j + 2] = this.palette[2][index];
                j += 3;
            }
        }
        ImageStorage.ImageType type = this.tRNS_present ? ImageStorage.ImageType.RGBA : ImageStorage.ImageType.RGB;
        return new ImageFrame(type, ByteBuffer.wrap(newImage), this.width, this.height, this.width * bpp, null, metadata);
    }

    private int bpp() {
        return numBandsPerColorType[this.colorType] + (this.tRNS_GRAY_RGB ? 1 : 0);
    }

    private int bytesPerColor() {
        return this.bitDepth == 16 ? 2 : 1;
    }

    @Override
    public ImageFrame load(int imageIndex, int rWidth, int rHeight, boolean preserveAspectRatio, boolean smooth) throws IOException {
        if (imageIndex != 0) {
            return null;
        }
        int dataSize = this.parsePngMeta();
        if (dataSize == 0) {
            this.emitWarning("No image data in PNG");
            return null;
        }
        int bpp = this.bpp();
        ByteBuffer bb = ByteBuffer.allocate(bpp * this.width * this.height);
        ImageMetadata metadata = this.updateMetadata();
        PNGIDATChunkInputStream iDat = new PNGIDATChunkInputStream(this.stream, dataSize);
        Inflater inf = new Inflater();
        BufferedInputStream data = new BufferedInputStream(new InflaterInputStream(iDat, inf));
        try {
            this.load(bb.array(), data);
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (inf != null) {
                inf.end();
            }
        }
        ImageFrame imgPNG = this.colorType == 3 ? this.decodePalette(bb.array(), metadata) : new ImageFrame(this.getType(), bb, this.width, this.height, bpp * this.width, this.palette, metadata);
        int[] outWH = ImageTools.computeDimensions(this.width, this.height, rWidth, rHeight, preserveAspectRatio);
        if (this.width != outWH[0] || this.height != outWH[1]) {
            imgPNG = this.scaleImage(imgPNG, outWH[0], outWH[1], smooth);
        }
        return imgPNG;
    }

    private ImageFrame scaleImage(ImageFrame imgPNG, int rWidth, int rHeight, boolean smooth) {
        byte[] image = ((ByteBuffer)imgPNG.getImageData()).array();
        int bpp = ImageStorage.getNumBands(imgPNG.getImageType());
        PushbroomScaler scaler = ScalerFactory.createScaler(this.width, this.height, bpp, rWidth, rHeight, smooth);
        for (int y = 0; y != this.height; ++y) {
            scaler.putSourceScanline(image, y * this.width * bpp);
        }
        return new ImageFrame(imgPNG.getImageType(), scaler.getDestination(), rWidth, rHeight, rWidth * bpp, null, imgPNG.getMetadata());
    }
}

