/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.property;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import javafx.beans.property.ReadOnlyProperty;
import sun.reflect.misc.MethodUtil;
import sun.reflect.misc.ReflectUtil;

public final class PropertyReference<T> {
    private String name;
    private Method getter;
    private Method setter;
    private Method propertyGetter;
    private Class<?> clazz;
    private Class<?> type;
    private boolean reflected = false;

    public PropertyReference(Class<?> clazz, String name) {
        if (name == null) {
            throw new NullPointerException("Name must be specified");
        }
        if (name.trim().length() == 0) {
            throw new IllegalArgumentException("Name must be specified");
        }
        if (clazz == null) {
            throw new NullPointerException("Class must be specified");
        }
        ReflectUtil.checkPackageAccess(clazz);
        this.name = name;
        this.clazz = clazz;
    }

    public boolean isWritable() {
        this.reflect();
        return this.setter != null;
    }

    public boolean isReadable() {
        this.reflect();
        return this.getter != null;
    }

    public boolean hasProperty() {
        this.reflect();
        return this.propertyGetter != null;
    }

    public String getName() {
        return this.name;
    }

    public Class<?> getContainingClass() {
        return this.clazz;
    }

    public Class<?> getType() {
        this.reflect();
        return this.type;
    }

    public void set(Object bean, T value) {
        if (!this.isWritable()) {
            throw new IllegalStateException("Cannot write to readonly property " + this.name);
        }
        assert (this.setter != null);
        try {
            MethodUtil.invoke(this.setter, bean, new Object[]{value});
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public T get(Object bean) {
        if (!this.isReadable()) {
            throw new IllegalStateException("Cannot read from unreadable property " + this.name);
        }
        assert (this.getter != null);
        try {
            return (T)MethodUtil.invoke(this.getter, bean, null);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public ReadOnlyProperty<T> getProperty(Object bean) {
        if (!this.hasProperty()) {
            throw new IllegalStateException("Cannot get property " + this.name);
        }
        assert (this.propertyGetter != null);
        try {
            return (ReadOnlyProperty)MethodUtil.invoke(this.propertyGetter, bean, null);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public String toString() {
        return this.name;
    }

    private void reflect() {
        block19: {
            if (!this.reflected) {
                this.reflected = true;
                try {
                    Method m;
                    String properName = this.name.length() == 1 ? this.name.substring(0, 1).toUpperCase() : Character.toUpperCase(this.name.charAt(0)) + this.name.substring(1);
                    this.type = null;
                    String getterName = "get" + properName;
                    try {
                        m = this.clazz.getMethod(getterName, new Class[0]);
                        if (Modifier.isPublic(m.getModifiers())) {
                            this.getter = m;
                        }
                    }
                    catch (NoSuchMethodException ex) {
                        // empty catch block
                    }
                    if (this.getter == null) {
                        getterName = "is" + properName;
                        try {
                            m = this.clazz.getMethod(getterName, new Class[0]);
                            if (Modifier.isPublic(m.getModifiers())) {
                                this.getter = m;
                            }
                        }
                        catch (NoSuchMethodException ex) {
                            // empty catch block
                        }
                    }
                    String setterName = "set" + properName;
                    if (this.getter != null) {
                        this.type = this.getter.getReturnType();
                        try {
                            Method m2 = this.clazz.getMethod(setterName, this.type);
                            if (Modifier.isPublic(m2.getModifiers())) {
                                this.setter = m2;
                            }
                        }
                        catch (NoSuchMethodException ex) {}
                    } else {
                        Method[] methods;
                        for (Method m3 : methods = this.clazz.getMethods()) {
                            Class<?>[] parameters = m3.getParameterTypes();
                            if (!setterName.equals(m3.getName()) || parameters.length != 1 || !Modifier.isPublic(m3.getModifiers())) continue;
                            this.setter = m3;
                            this.type = parameters[0];
                            break;
                        }
                    }
                    String propertyGetterName = this.name + "Property";
                    try {
                        Method m4 = this.clazz.getMethod(propertyGetterName, new Class[0]);
                        if (Modifier.isPublic(m4.getModifiers())) {
                            this.propertyGetter = m4;
                            break block19;
                        }
                        this.propertyGetter = null;
                    }
                    catch (NoSuchMethodException ex) {}
                }
                catch (RuntimeException e) {
                    System.err.println("Failed to introspect property " + this.name);
                }
            }
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PropertyReference)) {
            return false;
        }
        PropertyReference other = (PropertyReference)obj;
        if (!(this.name == other.name || this.name != null && this.name.equals(other.name))) {
            return false;
        }
        return this.clazz == other.clazz || this.clazz != null && this.clazz.equals(other.clazz);
    }

    public int hashCode() {
        int hash = 5;
        hash = 97 * hash + (this.name != null ? this.name.hashCode() : 0);
        hash = 97 * hash + (this.clazz != null ? this.clazz.hashCode() : 0);
        return hash;
    }
}

