/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.robot.impl;

import com.sun.javafx.application.PlatformImpl;
import com.sun.javafx.robot.FXRobot;
import com.sun.javafx.robot.FXRobotImage;
import com.sun.javafx.robot.impl.BaseFXRobot$$Lambda$1;
import com.sun.javafx.robot.impl.BaseFXRobot$$Lambda$2;
import com.sun.javafx.robot.impl.BaseFXRobot$$Lambda$3;
import com.sun.javafx.robot.impl.BaseFXRobot$$Lambda$4;
import com.sun.javafx.robot.impl.FXRobotHelper;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import javafx.event.EventType;
import javafx.scene.Scene;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;

public class BaseFXRobot
extends FXRobot {
    private static final boolean debugOut;
    private static Map<KeyCode, String> keyTextMap;
    private Scene target;
    private boolean isShiftDown = false;
    private boolean isControlDown = false;
    private boolean isAltDown = false;
    private boolean isMetaDown = false;
    private boolean isButton1Pressed = false;
    private boolean isButton2Pressed = false;
    private boolean isButton3Pressed = false;
    private MouseButton lastButtonPressed = null;
    private double sceneMouseX;
    private double sceneMouseY;
    private double screenMouseX;
    private double screenMouseY;
    private Object lastImage;
    private FXRobotImage lastConvertedImage;

    private static boolean computeDebugOut() {
        boolean debug = false;
        try {
            debug = "true".equals(System.getProperty("fxrobot.verbose", "false"));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return debug;
    }

    private static void out(String s) {
        if (debugOut) {
            System.out.println("[FXRobot] " + s);
        }
    }

    private static String getKeyText(KeyCode keyCode) {
        return keyCode.getName();
    }

    public BaseFXRobot(Scene target) {
        this.target = target;
    }

    @Override
    public void waitForIdle() {
        CountDownLatch latch = new CountDownLatch(1);
        PlatformImpl.runLater(BaseFXRobot$$Lambda$1.lambdaFactory$(latch));
        while (true) {
            try {
                latch.await();
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    @Override
    public void keyPress(KeyCode keyCode) {
        this.doKeyEvent(KeyEvent.KEY_PRESSED, keyCode, "");
    }

    @Override
    public void keyRelease(KeyCode keyCode) {
        this.doKeyEvent(KeyEvent.KEY_RELEASED, keyCode, "");
    }

    @Override
    public void keyType(KeyCode keyCode, String keyChar) {
        this.doKeyEvent(KeyEvent.KEY_TYPED, keyCode, keyChar);
    }

    @Override
    public void mouseMove(int x, int y) {
        this.doMouseEvent(x, y, this.lastButtonPressed, 0, MouseEvent.MOUSE_MOVED);
    }

    @Override
    public void mousePress(MouseButton button, int clickCount) {
        this.doMouseEvent(this.sceneMouseX, this.sceneMouseY, button, clickCount, MouseEvent.MOUSE_PRESSED);
    }

    @Override
    public void mouseRelease(MouseButton button, int clickCount) {
        this.doMouseEvent(this.sceneMouseX, this.sceneMouseY, button, clickCount, MouseEvent.MOUSE_RELEASED);
    }

    @Override
    public void mouseClick(MouseButton button, int clickCount) {
        this.doMouseEvent(this.sceneMouseX, this.sceneMouseY, button, clickCount, MouseEvent.MOUSE_CLICKED);
    }

    @Override
    public void mouseDrag(MouseButton button) {
        this.doMouseEvent(this.sceneMouseX, this.sceneMouseY, button, 0, MouseEvent.MOUSE_DRAGGED);
    }

    @Override
    public void mouseWheel(int wheelAmt) {
        this.doScrollEvent(this.sceneMouseX, this.sceneMouseY, wheelAmt, ScrollEvent.SCROLL);
    }

    @Override
    public int getPixelColor(int x, int y) {
        FXRobotImage image = this.getSceneCapture(0, 0, 100, 100);
        if (image != null) {
            return image.getArgb(x, y);
        }
        return 0;
    }

    @Override
    public FXRobotImage getSceneCapture(int x, int y, int w, int h) {
        Object ret = FXRobotHelper.sceneAccessor.renderToImage(this.target, this.lastImage);
        if (ret != null) {
            this.lastImage = ret;
            this.lastConvertedImage = FXRobotHelper.imageConvertor.convertToFXRobotImage(ret);
        }
        return this.lastConvertedImage;
    }

    private void doKeyEvent(EventType<KeyEvent> eventType, KeyCode keyCode, String character) {
        boolean typed;
        boolean pressed = eventType == KeyEvent.KEY_PRESSED;
        boolean bl = typed = eventType == KeyEvent.KEY_TYPED;
        if (keyCode == KeyCode.SHIFT) {
            this.isShiftDown = pressed;
        }
        if (keyCode == KeyCode.CONTROL) {
            this.isControlDown = pressed;
        }
        if (keyCode == KeyCode.ALT) {
            this.isAltDown = pressed;
        }
        if (keyCode == KeyCode.META) {
            this.isMetaDown = pressed;
        }
        String keyText = typed ? "" : BaseFXRobot.getKeyText(keyCode);
        String keyChar = typed ? character : KeyEvent.CHAR_UNDEFINED;
        KeyEvent e = FXRobotHelper.inputAccessor.createKeyEvent(eventType, keyCode, keyChar, keyText, this.isShiftDown, this.isControlDown, this.isAltDown, this.isMetaDown);
        PlatformImpl.runLater(BaseFXRobot$$Lambda$2.lambdaFactory$(this, e));
        if (this.autoWait) {
            this.waitForIdle();
        }
    }

    private void doMouseEvent(double x, double y, MouseButton passedButton, int clickCount, EventType<MouseEvent> passedType) {
        this.screenMouseX = this.target.getWindow().getX() + this.target.getX() + x;
        this.screenMouseY = this.target.getWindow().getY() + this.target.getY() + y;
        this.sceneMouseX = x;
        this.sceneMouseY = y;
        MouseButton button = passedButton;
        EventType<MouseEvent> type = passedType;
        if (type == MouseEvent.MOUSE_PRESSED || type == MouseEvent.MOUSE_RELEASED) {
            boolean pressed;
            boolean bl = pressed = type == MouseEvent.MOUSE_PRESSED;
            if (button == MouseButton.PRIMARY) {
                this.isButton1Pressed = pressed;
            } else if (button == MouseButton.MIDDLE) {
                this.isButton2Pressed = pressed;
            } else if (button == MouseButton.SECONDARY) {
                this.isButton3Pressed = pressed;
            }
            if (pressed) {
                this.lastButtonPressed = button;
            } else if (!(this.isButton1Pressed || this.isButton2Pressed || this.isButton3Pressed)) {
                this.lastButtonPressed = MouseButton.NONE;
            }
        } else if (type == MouseEvent.MOUSE_MOVED) {
            boolean someButtonPressed;
            boolean bl = someButtonPressed = this.isButton1Pressed || this.isButton2Pressed || this.isButton3Pressed;
            if (someButtonPressed) {
                type = MouseEvent.MOUSE_DRAGGED;
                button = MouseButton.NONE;
            }
        }
        MouseEvent e = FXRobotHelper.inputAccessor.createMouseEvent(type, (int)this.sceneMouseX, (int)this.sceneMouseY, (int)this.screenMouseX, (int)this.screenMouseY, button, clickCount, this.isShiftDown, this.isControlDown, this.isAltDown, this.isMetaDown, button == MouseButton.SECONDARY, this.isButton1Pressed, this.isButton2Pressed, this.isButton3Pressed);
        PlatformImpl.runLater(BaseFXRobot$$Lambda$3.lambdaFactory$(this, e));
        if (this.autoWait) {
            this.waitForIdle();
        }
    }

    private void doScrollEvent(double x, double y, double rotation, EventType<ScrollEvent> type) {
        this.screenMouseX = this.target.getWindow().getX() + this.target.getX() + x;
        this.screenMouseY = this.target.getWindow().getY() + this.target.getY() + y;
        this.sceneMouseX = x;
        this.sceneMouseY = y;
        ScrollEvent e = FXRobotHelper.inputAccessor.createScrollEvent(type, 0, (int)rotation * 40, ScrollEvent.HorizontalTextScrollUnits.NONE, 0, ScrollEvent.VerticalTextScrollUnits.NONE, 0, (int)this.sceneMouseX, (int)this.sceneMouseY, (int)this.screenMouseX, (int)this.screenMouseY, this.isShiftDown, this.isControlDown, this.isAltDown, this.isMetaDown);
        PlatformImpl.runLater(BaseFXRobot$$Lambda$4.lambdaFactory$(this, e));
        if (this.autoWait) {
            this.waitForIdle();
        }
    }

    /* synthetic */ void lambda$doScrollEvent$251(ScrollEvent scrollEvent) {
        BaseFXRobot.out("doScrollEvent: injecting: " + scrollEvent);
        FXRobotHelper.sceneAccessor.processScrollEvent(this.target, scrollEvent);
    }

    /* synthetic */ void lambda$doMouseEvent$250(MouseEvent mouseEvent) {
        BaseFXRobot.out("doMouseEvent: injecting: " + mouseEvent);
        FXRobotHelper.sceneAccessor.processMouseEvent(this.target, mouseEvent);
    }

    /* synthetic */ void lambda$doKeyEvent$249(KeyEvent keyEvent) {
        BaseFXRobot.out("doKeyEvent: injecting: {e}");
        FXRobotHelper.sceneAccessor.processKeyEvent(this.target, keyEvent);
    }

    static /* synthetic */ void lambda$waitForIdle$248(CountDownLatch countDownLatch) {
        countDownLatch.countDown();
    }

    static {
        String string = KeyEvent.CHAR_UNDEFINED;
        debugOut = BaseFXRobot.computeDebugOut();
    }
}

