/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control;

import com.sun.javafx.scene.control.ControlAcceleratorSupport$$Lambda$1;
import com.sun.javafx.scene.control.ControlAcceleratorSupport$$Lambda$2;
import com.sun.javafx.scene.control.ControlAcceleratorSupport$$Lambda$3;
import java.util.List;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.event.Event;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.Control;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.RadioMenuItem;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableColumnBase;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.input.KeyCombination;

public class ControlAcceleratorSupport {
    public static void addAcceleratorsIntoScene(ObservableList<MenuItem> items, Tab anchor) {
        ControlAcceleratorSupport.addAcceleratorsIntoScene(items, (Object)anchor);
    }

    public static void addAcceleratorsIntoScene(ObservableList<MenuItem> items, TableColumnBase<?, ?> anchor) {
        ControlAcceleratorSupport.addAcceleratorsIntoScene(items, anchor);
    }

    public static void addAcceleratorsIntoScene(final ObservableList<MenuItem> items, final Node anchor) {
        if (items == null) {
            return;
        }
        if (anchor == null) {
            throw new IllegalArgumentException("Anchor cannot be null");
        }
        Scene scene = anchor.getScene();
        if (scene == null) {
            anchor.sceneProperty().addListener(new InvalidationListener(){

                @Override
                public void invalidated(Observable observable) {
                    Scene scene = anchor.getScene();
                    if (scene != null) {
                        anchor.sceneProperty().removeListener(this);
                        ControlAcceleratorSupport.doAcceleratorInstall(items, scene);
                    }
                }
            });
        } else {
            ControlAcceleratorSupport.doAcceleratorInstall(items, scene);
        }
    }

    private static void addAcceleratorsIntoScene(final ObservableList<MenuItem> items, Object anchor) {
        if (anchor == null) {
            throw new IllegalArgumentException("Anchor cannot be null");
        }
        final ReadOnlyObjectProperty<? extends Control> controlProperty = ControlAcceleratorSupport.getControlProperty(anchor);
        Control control = (Control)controlProperty.get();
        if (control == null) {
            controlProperty.addListener(new InvalidationListener(){

                @Override
                public void invalidated(Observable observable) {
                    Control control = (Control)controlProperty.get();
                    if (control != null) {
                        controlProperty.removeListener(this);
                        ControlAcceleratorSupport.addAcceleratorsIntoScene((ObservableList<MenuItem>)items, control);
                    }
                }
            });
        } else {
            ControlAcceleratorSupport.addAcceleratorsIntoScene(items, control);
        }
    }

    private static void doAcceleratorInstall(ObservableList<MenuItem> items, Scene scene) {
        items.addListener(ControlAcceleratorSupport$$Lambda$1.lambdaFactory$(scene));
        ControlAcceleratorSupport.doAcceleratorInstall(items, scene);
    }

    private static void doAcceleratorInstall(List<? extends MenuItem> items, Scene scene) {
        for (MenuItem menuItem : items) {
            if (menuItem instanceof Menu) {
                ControlAcceleratorSupport.doAcceleratorInstall(((Menu)menuItem).getItems(), scene);
                continue;
            }
            if (menuItem.getAccelerator() != null) {
                ObservableMap<KeyCombination, Runnable> accelerators = scene.getAccelerators();
                Runnable acceleratorRunnable = ControlAcceleratorSupport$$Lambda$2.lambdaFactory$(menuItem);
                accelerators.put(menuItem.getAccelerator(), acceleratorRunnable);
            }
            menuItem.acceleratorProperty().addListener(ControlAcceleratorSupport$$Lambda$3.lambdaFactory$(scene));
        }
    }

    public static void removeAcceleratorsFromScene(List<? extends MenuItem> items, Tab anchor) {
        TabPane tabPane = anchor.getTabPane();
        if (tabPane == null) {
            return;
        }
        Scene scene = tabPane.getScene();
        ControlAcceleratorSupport.removeAcceleratorsFromScene(items, scene);
    }

    public static void removeAcceleratorsFromScene(List<? extends MenuItem> items, TableColumnBase<?, ?> anchor) {
        ReadOnlyObjectProperty<? extends Control> controlProperty = ControlAcceleratorSupport.getControlProperty(anchor);
        if (controlProperty == null) {
            return;
        }
        Control control = (Control)controlProperty.get();
        if (control == null) {
            return;
        }
        Scene scene = control.getScene();
        ControlAcceleratorSupport.removeAcceleratorsFromScene(items, scene);
    }

    public static void removeAcceleratorsFromScene(List<? extends MenuItem> items, Node anchor) {
        Scene scene = anchor.getScene();
        ControlAcceleratorSupport.removeAcceleratorsFromScene(items, scene);
    }

    public static void removeAcceleratorsFromScene(List<? extends MenuItem> items, Scene scene) {
        if (scene == null) {
            return;
        }
        for (MenuItem menuItem : items) {
            if (menuItem instanceof Menu) {
                ControlAcceleratorSupport.removeAcceleratorsFromScene(((Menu)menuItem).getItems(), scene);
                continue;
            }
            ObservableMap<KeyCombination, Runnable> accelerators = scene.getAccelerators();
            accelerators.remove(menuItem.getAccelerator());
        }
    }

    private static ReadOnlyObjectProperty<? extends Control> getControlProperty(Object obj) {
        if (obj instanceof TableColumn) {
            return ((TableColumn)obj).tableViewProperty();
        }
        if (obj instanceof TreeTableColumn) {
            return ((TreeTableColumn)obj).treeTableViewProperty();
        }
        if (obj instanceof Tab) {
            return ((Tab)obj).tabPaneProperty();
        }
        return null;
    }

    static /* synthetic */ void lambda$doAcceleratorInstall$13(Scene scene, ObservableValue observable, KeyCombination oldValue, KeyCombination newValue) {
        ObservableMap<KeyCombination, Runnable> accelerators = scene.getAccelerators();
        Runnable _acceleratorRunnable = (Runnable)accelerators.remove(oldValue);
        if (newValue != null) {
            accelerators.put(newValue, _acceleratorRunnable);
        }
    }

    static /* synthetic */ void lambda$doAcceleratorInstall$12(MenuItem menuItem) {
        Menu target;
        if (menuItem.getOnMenuValidation() != null) {
            Event.fireEvent(menuItem, new Event(MenuItem.MENU_VALIDATION_EVENT));
        }
        if ((target = menuItem.getParentMenu()) != null && target.getOnMenuValidation() != null) {
            Event.fireEvent(target, new Event(MenuItem.MENU_VALIDATION_EVENT));
        }
        if (!menuItem.isDisable()) {
            if (menuItem instanceof RadioMenuItem) {
                ((RadioMenuItem)menuItem).setSelected(!((RadioMenuItem)menuItem).isSelected());
            } else if (menuItem instanceof CheckMenuItem) {
                ((CheckMenuItem)menuItem).setSelected(!((CheckMenuItem)menuItem).isSelected());
            }
            menuItem.fire();
        }
    }

    static /* synthetic */ void lambda$doAcceleratorInstall$11(Scene scene, ListChangeListener.Change c) {
        while (c.next()) {
            if (c.wasRemoved()) {
                ControlAcceleratorSupport.removeAcceleratorsFromScene(c.getRemoved(), scene);
            }
            if (!c.wasAdded()) continue;
            ControlAcceleratorSupport.doAcceleratorInstall(c.getAddedSubList(), scene);
        }
    }
}

