/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.behavior;

import com.sun.javafx.PlatformUtil;
import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.behavior.KeyBinding;
import com.sun.javafx.scene.control.behavior.ListCellBehavior;
import com.sun.javafx.scene.control.behavior.ListViewBehavior$$Lambda$1;
import com.sun.javafx.scene.control.behavior.ListViewBehavior$$Lambda$2;
import com.sun.javafx.scene.control.behavior.OrientedKeyBinding;
import com.sun.javafx.scene.control.behavior.TwoLevelFocusListBehavior;
import com.sun.javafx.scene.control.skin.Utils;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WeakChangeListener;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.WeakListChangeListener;
import javafx.event.EventType;
import javafx.geometry.NodeOrientation;
import javafx.geometry.Orientation;
import javafx.scene.control.Control;
import javafx.scene.control.FocusModel;
import javafx.scene.control.ListView;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.control.SelectionMode;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.util.Callback;

public class ListViewBehavior<T>
extends BehaviorBase<ListView<T>> {
    protected static final List<KeyBinding> LIST_VIEW_BINDINGS = new ArrayList<KeyBinding>();
    private boolean isShiftDown = false;
    private boolean isShortcutDown = false;
    private Callback<Boolean, Integer> onScrollPageUp;
    private Callback<Boolean, Integer> onScrollPageDown;
    private Runnable onFocusPreviousRow;
    private Runnable onFocusNextRow;
    private Runnable onSelectPreviousRow;
    private Runnable onSelectNextRow;
    private Runnable onMoveToFirstCell;
    private Runnable onMoveToLastCell;
    private boolean selectionChanging = false;
    private final ListChangeListener<Integer> selectedIndicesListener = ListViewBehavior$$Lambda$1.lambdaFactory$(this);
    private final ListChangeListener<T> itemsListListener = ListViewBehavior$$Lambda$2.lambdaFactory$(this);
    private final ChangeListener<ObservableList<T>> itemsListener = new ChangeListener<ObservableList<T>>(){

        @Override
        public void changed(ObservableValue<? extends ObservableList<T>> observable, ObservableList<T> oldValue, ObservableList<T> newValue) {
            if (oldValue != null) {
                oldValue.removeListener(ListViewBehavior.this.weakItemsListListener);
            }
            if (newValue != null) {
                newValue.addListener(ListViewBehavior.this.weakItemsListListener);
            }
        }
    };
    private final ChangeListener<MultipleSelectionModel<T>> selectionModelListener = new ChangeListener<MultipleSelectionModel<T>>(){

        @Override
        public void changed(ObservableValue<? extends MultipleSelectionModel<T>> observable, MultipleSelectionModel<T> oldValue, MultipleSelectionModel<T> newValue) {
            if (oldValue != null) {
                oldValue.getSelectedIndices().removeListener(ListViewBehavior.this.weakSelectedIndicesListener);
            }
            if (newValue != null) {
                newValue.getSelectedIndices().addListener(ListViewBehavior.this.weakSelectedIndicesListener);
            }
        }
    };
    private final WeakChangeListener<ObservableList<T>> weakItemsListener = new WeakChangeListener<ObservableList<ObservableList<T>>>(this.itemsListener);
    private final WeakListChangeListener<Integer> weakSelectedIndicesListener = new WeakListChangeListener<Integer>(this.selectedIndicesListener);
    private final WeakListChangeListener<T> weakItemsListListener = new WeakListChangeListener<T>(this.itemsListListener);
    private final WeakChangeListener<MultipleSelectionModel<T>> weakSelectionModelListener = new WeakChangeListener<MultipleSelectionModel<MultipleSelectionModel<T>>>(this.selectionModelListener);
    private TwoLevelFocusListBehavior tlFocus;

    @Override
    protected String matchActionForEvent(KeyEvent e) {
        String action = super.matchActionForEvent(e);
        if (action != null) {
            if (e.getCode() == KeyCode.LEFT || e.getCode() == KeyCode.KP_LEFT) {
                if (((ListView)this.getControl()).getEffectiveNodeOrientation() == NodeOrientation.RIGHT_TO_LEFT) {
                    action = e.isShiftDown() ? "AlsoSelectNextRow" : (e.isShortcutDown() ? "FocusNextRow" : (((ListView)this.getControl()).getOrientation() == Orientation.HORIZONTAL ? "SelectNextRow" : "TraverseRight"));
                }
            } else if ((e.getCode() == KeyCode.RIGHT || e.getCode() == KeyCode.KP_RIGHT) && ((ListView)this.getControl()).getEffectiveNodeOrientation() == NodeOrientation.RIGHT_TO_LEFT) {
                action = e.isShiftDown() ? "AlsoSelectPreviousRow" : (e.isShortcutDown() ? "FocusPreviousRow" : (((ListView)this.getControl()).getOrientation() == Orientation.HORIZONTAL ? "SelectPreviousRow" : "TraverseLeft"));
            }
        }
        return action;
    }

    @Override
    protected void callAction(String name) {
        if ("SelectPreviousRow".equals(name)) {
            this.selectPreviousRow();
        } else if ("SelectNextRow".equals(name)) {
            this.selectNextRow();
        } else if ("SelectFirstRow".equals(name)) {
            this.selectFirstRow();
        } else if ("SelectLastRow".equals(name)) {
            this.selectLastRow();
        } else if ("SelectAllToFirstRow".equals(name)) {
            this.selectAllToFirstRow();
        } else if ("SelectAllToLastRow".equals(name)) {
            this.selectAllToLastRow();
        } else if ("SelectAllPageUp".equals(name)) {
            this.selectAllPageUp();
        } else if ("SelectAllPageDown".equals(name)) {
            this.selectAllPageDown();
        } else if ("AlsoSelectNextRow".equals(name)) {
            this.alsoSelectNextRow();
        } else if ("AlsoSelectPreviousRow".equals(name)) {
            this.alsoSelectPreviousRow();
        } else if ("ClearSelection".equals(name)) {
            this.clearSelection();
        } else if ("SelectAll".equals(name)) {
            this.selectAll();
        } else if ("ScrollUp".equals(name)) {
            this.scrollPageUp();
        } else if ("ScrollDown".equals(name)) {
            this.scrollPageDown();
        } else if ("FocusPreviousRow".equals(name)) {
            this.focusPreviousRow();
        } else if ("FocusNextRow".equals(name)) {
            this.focusNextRow();
        } else if ("FocusPageUp".equals(name)) {
            this.focusPageUp();
        } else if ("FocusPageDown".equals(name)) {
            this.focusPageDown();
        } else if ("Activate".equals(name)) {
            this.activate();
        } else if ("CancelEdit".equals(name)) {
            this.cancelEdit();
        } else if ("FocusFirstRow".equals(name)) {
            this.focusFirstRow();
        } else if ("FocusLastRow".equals(name)) {
            this.focusLastRow();
        } else if ("toggleFocusOwnerSelection".equals(name)) {
            this.toggleFocusOwnerSelection();
        } else if ("SelectAllToFocus".equals(name)) {
            this.selectAllToFocus(false);
        } else if ("SelectAllToFocusAndSetAnchor".equals(name)) {
            this.selectAllToFocus(true);
        } else if ("DiscontinuousSelectNextRow".equals(name)) {
            this.discontinuousSelectNextRow();
        } else if ("DiscontinuousSelectPreviousRow".equals(name)) {
            this.discontinuousSelectPreviousRow();
        } else if ("DiscontinuousSelectPageUp".equals(name)) {
            this.discontinuousSelectPageUp();
        } else if ("DiscontinuousSelectPageDown".equals(name)) {
            this.discontinuousSelectPageDown();
        } else if ("DiscontinuousSelectAllToLastRow".equals(name)) {
            this.discontinuousSelectAllToLastRow();
        } else if ("DiscontinuousSelectAllToFirstRow".equals(name)) {
            this.discontinuousSelectAllToFirstRow();
        } else {
            super.callAction(name);
        }
    }

    @Override
    protected void callActionForEvent(KeyEvent e) {
        this.isShiftDown = e.getEventType() == KeyEvent.KEY_PRESSED && e.isShiftDown();
        this.isShortcutDown = e.getEventType() == KeyEvent.KEY_PRESSED && e.isShortcutDown();
        super.callActionForEvent(e);
    }

    public void setOnScrollPageUp(Callback<Boolean, Integer> c) {
        this.onScrollPageUp = c;
    }

    public void setOnScrollPageDown(Callback<Boolean, Integer> c) {
        this.onScrollPageDown = c;
    }

    public void setOnFocusPreviousRow(Runnable r) {
        this.onFocusPreviousRow = r;
    }

    public void setOnFocusNextRow(Runnable r) {
        this.onFocusNextRow = r;
    }

    public void setOnSelectPreviousRow(Runnable r) {
        this.onSelectPreviousRow = r;
    }

    public void setOnSelectNextRow(Runnable r) {
        this.onSelectNextRow = r;
    }

    public void setOnMoveToFirstCell(Runnable r) {
        this.onMoveToFirstCell = r;
    }

    public void setOnMoveToLastCell(Runnable r) {
        this.onMoveToLastCell = r;
    }

    public ListViewBehavior(ListView<T> control) {
        super(control, LIST_VIEW_BINDINGS);
        control.itemsProperty().addListener(this.weakItemsListener);
        if (control.getItems() != null) {
            control.getItems().addListener(this.weakItemsListListener);
        }
        ((ListView)this.getControl()).selectionModelProperty().addListener(this.weakSelectionModelListener);
        if (control.getSelectionModel() != null) {
            control.getSelectionModel().getSelectedIndices().addListener(this.weakSelectedIndicesListener);
        }
        if (Utils.isTwoLevelFocus()) {
            this.tlFocus = new TwoLevelFocusListBehavior(control);
        }
    }

    @Override
    public void dispose() {
        ListCellBehavior.removeAnchor(this.getControl());
        if (this.tlFocus != null) {
            this.tlFocus.dispose();
        }
        super.dispose();
    }

    private void setAnchor(int anchor) {
        ListCellBehavior.setAnchor(this.getControl(), anchor < 0 ? null : Integer.valueOf(anchor), false);
    }

    private int getAnchor() {
        return ListCellBehavior.getAnchor(this.getControl(), ((ListView)this.getControl()).getFocusModel().getFocusedIndex());
    }

    private boolean hasAnchor() {
        return ListCellBehavior.hasNonDefaultAnchor(this.getControl());
    }

    @Override
    public void mousePressed(MouseEvent e) {
        super.mousePressed(e);
        if (!e.isShiftDown() && !e.isSynthesized()) {
            int index = ((ListView)this.getControl()).getSelectionModel().getSelectedIndex();
            this.setAnchor(index);
        }
        if (!((ListView)this.getControl()).isFocused() && ((ListView)this.getControl()).isFocusTraversable()) {
            ((ListView)this.getControl()).requestFocus();
        }
    }

    private int getRowCount() {
        return ((ListView)this.getControl()).getItems() == null ? 0 : ((ListView)this.getControl()).getItems().size();
    }

    private void clearSelection() {
        ((ListView)this.getControl()).getSelectionModel().clearSelection();
    }

    private void scrollPageUp() {
        int newSelectedIndex = -1;
        if (this.onScrollPageUp != null) {
            newSelectedIndex = this.onScrollPageUp.call(false);
        }
        if (newSelectedIndex == -1) {
            return;
        }
        MultipleSelectionModel sm = ((ListView)this.getControl()).getSelectionModel();
        if (sm == null) {
            return;
        }
        sm.clearAndSelect(newSelectedIndex);
    }

    private void scrollPageDown() {
        int newSelectedIndex = -1;
        if (this.onScrollPageDown != null) {
            newSelectedIndex = this.onScrollPageDown.call(false);
        }
        if (newSelectedIndex == -1) {
            return;
        }
        MultipleSelectionModel sm = ((ListView)this.getControl()).getSelectionModel();
        if (sm == null) {
            return;
        }
        sm.clearAndSelect(newSelectedIndex);
    }

    private void focusFirstRow() {
        FocusModel fm = ((ListView)this.getControl()).getFocusModel();
        if (fm == null) {
            return;
        }
        fm.focus(0);
        if (this.onMoveToFirstCell != null) {
            this.onMoveToFirstCell.run();
        }
    }

    private void focusLastRow() {
        FocusModel fm = ((ListView)this.getControl()).getFocusModel();
        if (fm == null) {
            return;
        }
        fm.focus(this.getRowCount() - 1);
        if (this.onMoveToLastCell != null) {
            this.onMoveToLastCell.run();
        }
    }

    private void focusPreviousRow() {
        FocusModel fm = ((ListView)this.getControl()).getFocusModel();
        if (fm == null) {
            return;
        }
        MultipleSelectionModel sm = ((ListView)this.getControl()).getSelectionModel();
        if (sm == null) {
            return;
        }
        fm.focusPrevious();
        if (!this.isShortcutDown || this.getAnchor() == -1) {
            this.setAnchor(fm.getFocusedIndex());
        }
        if (this.onFocusPreviousRow != null) {
            this.onFocusPreviousRow.run();
        }
    }

    private void focusNextRow() {
        FocusModel fm = ((ListView)this.getControl()).getFocusModel();
        if (fm == null) {
            return;
        }
        MultipleSelectionModel sm = ((ListView)this.getControl()).getSelectionModel();
        if (sm == null) {
            return;
        }
        fm.focusNext();
        if (!this.isShortcutDown || this.getAnchor() == -1) {
            this.setAnchor(fm.getFocusedIndex());
        }
        if (this.onFocusNextRow != null) {
            this.onFocusNextRow.run();
        }
    }

    private void focusPageUp() {
        int newFocusIndex = this.onScrollPageUp.call(true);
        FocusModel fm = ((ListView)this.getControl()).getFocusModel();
        if (fm == null) {
            return;
        }
        fm.focus(newFocusIndex);
    }

    private void focusPageDown() {
        int newFocusIndex = this.onScrollPageDown.call(true);
        FocusModel fm = ((ListView)this.getControl()).getFocusModel();
        if (fm == null) {
            return;
        }
        fm.focus(newFocusIndex);
    }

    private void alsoSelectPreviousRow() {
        FocusModel fm = ((ListView)this.getControl()).getFocusModel();
        if (fm == null) {
            return;
        }
        MultipleSelectionModel sm = ((ListView)this.getControl()).getSelectionModel();
        if (sm == null) {
            return;
        }
        if (this.isShiftDown && this.getAnchor() != -1) {
            int newRow = fm.getFocusedIndex() - 1;
            if (newRow < 0) {
                return;
            }
            int anchor = this.getAnchor();
            if (!this.hasAnchor()) {
                this.setAnchor(fm.getFocusedIndex());
            }
            if (sm.getSelectedIndices().size() > 1) {
                this.clearSelectionOutsideRange(anchor, newRow);
            }
            if (anchor > newRow) {
                sm.selectRange(anchor, newRow - 1);
            } else {
                sm.selectRange(anchor, newRow + 1);
            }
        } else {
            sm.selectPrevious();
        }
        this.onSelectPreviousRow.run();
    }

    private void alsoSelectNextRow() {
        FocusModel fm = ((ListView)this.getControl()).getFocusModel();
        if (fm == null) {
            return;
        }
        MultipleSelectionModel sm = ((ListView)this.getControl()).getSelectionModel();
        if (sm == null) {
            return;
        }
        if (this.isShiftDown && this.getAnchor() != -1) {
            int newRow = fm.getFocusedIndex() + 1;
            int anchor = this.getAnchor();
            if (!this.hasAnchor()) {
                this.setAnchor(fm.getFocusedIndex());
            }
            if (sm.getSelectedIndices().size() > 1) {
                this.clearSelectionOutsideRange(anchor, newRow);
            }
            if (anchor > newRow) {
                sm.selectRange(anchor, newRow - 1);
            } else {
                sm.selectRange(anchor, newRow + 1);
            }
        } else {
            sm.selectNext();
        }
        this.onSelectNextRow.run();
    }

    private void clearSelectionOutsideRange(int start, int end) {
        MultipleSelectionModel sm = ((ListView)this.getControl()).getSelectionModel();
        if (sm == null) {
            return;
        }
        int min = Math.min(start, end);
        int max = Math.max(start, end);
        ArrayList<Integer> indices = new ArrayList<Integer>(sm.getSelectedIndices());
        this.selectionChanging = true;
        for (int i = 0; i < indices.size(); ++i) {
            int index = (Integer)indices.get(i);
            if (index >= min && index <= max) continue;
            sm.clearSelection(index);
        }
        this.selectionChanging = false;
    }

    private void selectPreviousRow() {
        FocusModel fm = ((ListView)this.getControl()).getFocusModel();
        if (fm == null) {
            return;
        }
        int focusIndex = fm.getFocusedIndex();
        if (focusIndex <= 0) {
            return;
        }
        this.setAnchor(focusIndex - 1);
        ((ListView)this.getControl()).getSelectionModel().clearAndSelect(focusIndex - 1);
        this.onSelectPreviousRow.run();
    }

    private void selectNextRow() {
        ListView listView = (ListView)this.getControl();
        FocusModel fm = listView.getFocusModel();
        if (fm == null) {
            return;
        }
        int focusIndex = fm.getFocusedIndex();
        if (focusIndex == this.getRowCount() - 1) {
            return;
        }
        MultipleSelectionModel sm = listView.getSelectionModel();
        if (sm == null) {
            return;
        }
        this.setAnchor(focusIndex + 1);
        sm.clearAndSelect(focusIndex + 1);
        if (this.onSelectNextRow != null) {
            this.onSelectNextRow.run();
        }
    }

    private void selectFirstRow() {
        if (this.getRowCount() > 0) {
            ((ListView)this.getControl()).getSelectionModel().clearAndSelect(0);
            if (this.onMoveToFirstCell != null) {
                this.onMoveToFirstCell.run();
            }
        }
    }

    private void selectLastRow() {
        ((ListView)this.getControl()).getSelectionModel().clearAndSelect(this.getRowCount() - 1);
        if (this.onMoveToLastCell != null) {
            this.onMoveToLastCell.run();
        }
    }

    private void selectAllPageUp() {
        int leadSelectedIndex;
        FocusModel fm = ((ListView)this.getControl()).getFocusModel();
        if (fm == null) {
            return;
        }
        int leadIndex = fm.getFocusedIndex();
        if (this.isShiftDown) {
            leadIndex = this.getAnchor() == -1 ? leadIndex : this.getAnchor();
            this.setAnchor(leadIndex);
        }
        int adjust = leadIndex < (leadSelectedIndex = this.onScrollPageUp.call(false).intValue()) ? 1 : -1;
        MultipleSelectionModel sm = ((ListView)this.getControl()).getSelectionModel();
        if (sm == null) {
            return;
        }
        this.selectionChanging = true;
        if (sm.getSelectionMode() == SelectionMode.SINGLE) {
            sm.select(leadSelectedIndex);
        } else {
            sm.clearSelection();
            sm.selectRange(leadIndex, leadSelectedIndex + adjust);
        }
        this.selectionChanging = false;
    }

    private void selectAllPageDown() {
        int leadSelectedIndex;
        FocusModel fm = ((ListView)this.getControl()).getFocusModel();
        if (fm == null) {
            return;
        }
        int leadIndex = fm.getFocusedIndex();
        if (this.isShiftDown) {
            leadIndex = this.getAnchor() == -1 ? leadIndex : this.getAnchor();
            this.setAnchor(leadIndex);
        }
        int adjust = leadIndex < (leadSelectedIndex = this.onScrollPageDown.call(false).intValue()) ? 1 : -1;
        MultipleSelectionModel sm = ((ListView)this.getControl()).getSelectionModel();
        if (sm == null) {
            return;
        }
        this.selectionChanging = true;
        if (sm.getSelectionMode() == SelectionMode.SINGLE) {
            sm.select(leadSelectedIndex);
        } else {
            sm.clearSelection();
            sm.selectRange(leadIndex, leadSelectedIndex + adjust);
        }
        this.selectionChanging = false;
    }

    private void selectAllToFirstRow() {
        MultipleSelectionModel sm = ((ListView)this.getControl()).getSelectionModel();
        if (sm == null) {
            return;
        }
        int leadIndex = sm.getSelectedIndex();
        if (this.isShiftDown) {
            leadIndex = this.getAnchor() == -1 ? sm.getSelectedIndex() : this.getAnchor();
        }
        sm.clearSelection();
        sm.selectRange(0, leadIndex + 1);
        if (this.isShiftDown) {
            this.setAnchor(leadIndex);
        }
        ((ListView)this.getControl()).getFocusModel().focus(0);
        if (this.onMoveToFirstCell != null) {
            this.onMoveToFirstCell.run();
        }
    }

    private void selectAllToLastRow() {
        MultipleSelectionModel sm = ((ListView)this.getControl()).getSelectionModel();
        if (sm == null) {
            return;
        }
        int leadIndex = sm.getSelectedIndex();
        if (this.isShiftDown) {
            leadIndex = this.hasAnchor() ? sm.getSelectedIndex() : this.getAnchor();
        }
        sm.clearSelection();
        sm.selectRange(leadIndex, this.getRowCount());
        if (this.isShiftDown) {
            this.setAnchor(leadIndex);
        }
        if (this.onMoveToLastCell != null) {
            this.onMoveToLastCell.run();
        }
    }

    private void selectAll() {
        MultipleSelectionModel sm = ((ListView)this.getControl()).getSelectionModel();
        if (sm == null) {
            return;
        }
        sm.selectAll();
    }

    private void selectAllToFocus(boolean setAnchorToFocusIndex) {
        ListView listView = (ListView)this.getControl();
        if (listView.getEditingIndex() >= 0) {
            return;
        }
        MultipleSelectionModel sm = listView.getSelectionModel();
        if (sm == null) {
            return;
        }
        FocusModel fm = listView.getFocusModel();
        if (fm == null) {
            return;
        }
        int focusIndex = fm.getFocusedIndex();
        int anchor = this.getAnchor();
        sm.clearSelection();
        int startPos = anchor;
        int endPos = anchor > focusIndex ? focusIndex - 1 : focusIndex + 1;
        sm.selectRange(startPos, endPos);
        this.setAnchor(setAnchorToFocusIndex ? focusIndex : anchor);
    }

    private void cancelEdit() {
        ((ListView)this.getControl()).edit(-1);
    }

    private void activate() {
        int focusedIndex = ((ListView)this.getControl()).getFocusModel().getFocusedIndex();
        ((ListView)this.getControl()).getSelectionModel().select(focusedIndex);
        this.setAnchor(focusedIndex);
        if (focusedIndex >= 0) {
            ((ListView)this.getControl()).edit(focusedIndex);
        }
    }

    private void toggleFocusOwnerSelection() {
        MultipleSelectionModel sm = ((ListView)this.getControl()).getSelectionModel();
        if (sm == null) {
            return;
        }
        FocusModel fm = ((ListView)this.getControl()).getFocusModel();
        if (fm == null) {
            return;
        }
        int focusedIndex = fm.getFocusedIndex();
        if (sm.isSelected(focusedIndex)) {
            sm.clearSelection(focusedIndex);
            fm.focus(focusedIndex);
        } else {
            sm.select(focusedIndex);
        }
        this.setAnchor(focusedIndex);
    }

    private void discontinuousSelectPreviousRow() {
        MultipleSelectionModel sm = ((ListView)this.getControl()).getSelectionModel();
        if (sm == null) {
            return;
        }
        if (sm.getSelectionMode() != SelectionMode.MULTIPLE) {
            this.selectPreviousRow();
            return;
        }
        FocusModel fm = ((ListView)this.getControl()).getFocusModel();
        if (fm == null) {
            return;
        }
        int focusIndex = fm.getFocusedIndex();
        int newFocusIndex = focusIndex - 1;
        if (newFocusIndex < 0) {
            return;
        }
        int startIndex = focusIndex;
        if (this.isShiftDown) {
            startIndex = this.getAnchor() == -1 ? focusIndex : this.getAnchor();
        }
        sm.selectRange(newFocusIndex, startIndex + 1);
        fm.focus(newFocusIndex);
        if (this.onFocusPreviousRow != null) {
            this.onFocusPreviousRow.run();
        }
    }

    private void discontinuousSelectNextRow() {
        MultipleSelectionModel sm = ((ListView)this.getControl()).getSelectionModel();
        if (sm == null) {
            return;
        }
        if (sm.getSelectionMode() != SelectionMode.MULTIPLE) {
            this.selectNextRow();
            return;
        }
        FocusModel fm = ((ListView)this.getControl()).getFocusModel();
        if (fm == null) {
            return;
        }
        int focusIndex = fm.getFocusedIndex();
        int newFocusIndex = focusIndex + 1;
        if (newFocusIndex >= this.getRowCount()) {
            return;
        }
        int startIndex = focusIndex;
        if (this.isShiftDown) {
            startIndex = this.getAnchor() == -1 ? focusIndex : this.getAnchor();
        }
        sm.selectRange(startIndex, newFocusIndex + 1);
        fm.focus(newFocusIndex);
        if (this.onFocusNextRow != null) {
            this.onFocusNextRow.run();
        }
    }

    private void discontinuousSelectPageUp() {
        MultipleSelectionModel sm = ((ListView)this.getControl()).getSelectionModel();
        if (sm == null) {
            return;
        }
        FocusModel fm = ((ListView)this.getControl()).getFocusModel();
        if (fm == null) {
            return;
        }
        int leadIndex = fm.getFocusedIndex();
        int leadSelectedIndex = this.onScrollPageUp.call(false);
        sm.selectRange(leadIndex, leadSelectedIndex - 1);
    }

    private void discontinuousSelectPageDown() {
        MultipleSelectionModel sm = ((ListView)this.getControl()).getSelectionModel();
        if (sm == null) {
            return;
        }
        FocusModel fm = ((ListView)this.getControl()).getFocusModel();
        if (fm == null) {
            return;
        }
        int leadIndex = fm.getFocusedIndex();
        int leadSelectedIndex = this.onScrollPageDown.call(false);
        sm.selectRange(leadIndex, leadSelectedIndex + 1);
    }

    private void discontinuousSelectAllToFirstRow() {
        MultipleSelectionModel sm = ((ListView)this.getControl()).getSelectionModel();
        if (sm == null) {
            return;
        }
        FocusModel fm = ((ListView)this.getControl()).getFocusModel();
        if (fm == null) {
            return;
        }
        int index = fm.getFocusedIndex();
        sm.selectRange(0, index);
        fm.focus(0);
        if (this.onMoveToFirstCell != null) {
            this.onMoveToFirstCell.run();
        }
    }

    private void discontinuousSelectAllToLastRow() {
        MultipleSelectionModel sm = ((ListView)this.getControl()).getSelectionModel();
        if (sm == null) {
            return;
        }
        FocusModel fm = ((ListView)this.getControl()).getFocusModel();
        if (fm == null) {
            return;
        }
        int index = fm.getFocusedIndex() + 1;
        sm.selectRange(index, this.getRowCount());
        if (this.onMoveToLastCell != null) {
            this.onMoveToLastCell.run();
        }
    }

    /* synthetic */ void lambda$new$179(ListChangeListener.Change c) {
        while (c.next()) {
            if (c.wasAdded() && c.getFrom() <= this.getAnchor()) {
                this.setAnchor(this.getAnchor() + c.getAddedSize());
                continue;
            }
            if (!c.wasRemoved() || c.getFrom() > this.getAnchor()) continue;
            this.setAnchor(this.getAnchor() - c.getRemovedSize());
        }
    }

    /* synthetic */ void lambda$new$178(ListChangeListener.Change c) {
        while (c.next()) {
            int addedSize;
            if (c.wasReplaced() && ListCellBehavior.hasDefaultAnchor(this.getControl())) {
                ListCellBehavior.removeAnchor(this.getControl());
            }
            int shift = c.wasPermutated() ? c.getTo() - c.getFrom() : 0;
            MultipleSelectionModel sm = ((ListView)this.getControl()).getSelectionModel();
            if (!this.selectionChanging) {
                if (sm.isEmpty()) {
                    this.setAnchor(-1);
                } else if (this.hasAnchor() && !sm.isSelected(this.getAnchor() + shift)) {
                    this.setAnchor(-1);
                }
            }
            if ((addedSize = c.getAddedSize()) <= 0 || this.hasAnchor()) continue;
            List addedSubList = c.getAddedSubList();
            int index = (Integer)addedSubList.get(addedSize - 1);
            this.setAnchor(index);
        }
    }

    static {
        LIST_VIEW_BINDINGS.add(new KeyBinding(KeyCode.HOME, "SelectFirstRow"));
        LIST_VIEW_BINDINGS.add(new KeyBinding(KeyCode.END, "SelectLastRow"));
        LIST_VIEW_BINDINGS.add(new KeyBinding(KeyCode.HOME, "SelectAllToFirstRow").shift());
        LIST_VIEW_BINDINGS.add(new KeyBinding(KeyCode.END, "SelectAllToLastRow").shift());
        LIST_VIEW_BINDINGS.add(new KeyBinding(KeyCode.PAGE_UP, "SelectAllPageUp").shift());
        LIST_VIEW_BINDINGS.add(new KeyBinding(KeyCode.PAGE_DOWN, "SelectAllPageDown").shift());
        LIST_VIEW_BINDINGS.add(new KeyBinding(KeyCode.SPACE, "SelectAllToFocus").shift());
        LIST_VIEW_BINDINGS.add(new KeyBinding(KeyCode.SPACE, "SelectAllToFocusAndSetAnchor").shortcut().shift());
        LIST_VIEW_BINDINGS.add(new KeyBinding(KeyCode.PAGE_UP, "ScrollUp"));
        LIST_VIEW_BINDINGS.add(new KeyBinding(KeyCode.PAGE_DOWN, "ScrollDown"));
        LIST_VIEW_BINDINGS.add(new KeyBinding(KeyCode.ENTER, "Activate"));
        LIST_VIEW_BINDINGS.add(new KeyBinding(KeyCode.SPACE, "Activate"));
        LIST_VIEW_BINDINGS.add(new KeyBinding(KeyCode.F2, "Activate"));
        LIST_VIEW_BINDINGS.add(new KeyBinding(KeyCode.ESCAPE, "CancelEdit"));
        LIST_VIEW_BINDINGS.add(new KeyBinding(KeyCode.A, "SelectAll").shortcut());
        LIST_VIEW_BINDINGS.add(new KeyBinding(KeyCode.HOME, "FocusFirstRow").shortcut());
        LIST_VIEW_BINDINGS.add(new KeyBinding(KeyCode.END, "FocusLastRow").shortcut());
        LIST_VIEW_BINDINGS.add(new KeyBinding(KeyCode.PAGE_UP, "FocusPageUp").shortcut());
        LIST_VIEW_BINDINGS.add(new KeyBinding(KeyCode.PAGE_DOWN, "FocusPageDown").shortcut());
        if (PlatformUtil.isMac()) {
            LIST_VIEW_BINDINGS.add(new KeyBinding(KeyCode.SPACE, "toggleFocusOwnerSelection").ctrl().shortcut());
        } else {
            LIST_VIEW_BINDINGS.add(new KeyBinding(KeyCode.SPACE, "toggleFocusOwnerSelection").ctrl());
        }
        LIST_VIEW_BINDINGS.add(new ListViewKeyBinding(KeyCode.UP, "SelectPreviousRow").vertical());
        LIST_VIEW_BINDINGS.add(new ListViewKeyBinding(KeyCode.KP_UP, "SelectPreviousRow").vertical());
        LIST_VIEW_BINDINGS.add(new ListViewKeyBinding(KeyCode.DOWN, "SelectNextRow").vertical());
        LIST_VIEW_BINDINGS.add(new ListViewKeyBinding(KeyCode.KP_DOWN, "SelectNextRow").vertical());
        LIST_VIEW_BINDINGS.add(new ListViewKeyBinding(KeyCode.UP, "AlsoSelectPreviousRow").vertical().shift());
        LIST_VIEW_BINDINGS.add(new ListViewKeyBinding(KeyCode.KP_UP, "AlsoSelectPreviousRow").vertical().shift());
        LIST_VIEW_BINDINGS.add(new ListViewKeyBinding(KeyCode.DOWN, "AlsoSelectNextRow").vertical().shift());
        LIST_VIEW_BINDINGS.add(new ListViewKeyBinding(KeyCode.KP_DOWN, "AlsoSelectNextRow").vertical().shift());
        LIST_VIEW_BINDINGS.add(new ListViewKeyBinding(KeyCode.UP, "FocusPreviousRow").vertical().shortcut());
        LIST_VIEW_BINDINGS.add(new ListViewKeyBinding(KeyCode.DOWN, "FocusNextRow").vertical().shortcut());
        LIST_VIEW_BINDINGS.add(new ListViewKeyBinding(KeyCode.UP, "DiscontinuousSelectPreviousRow").vertical().shortcut().shift());
        LIST_VIEW_BINDINGS.add(new ListViewKeyBinding(KeyCode.DOWN, "DiscontinuousSelectNextRow").vertical().shortcut().shift());
        LIST_VIEW_BINDINGS.add(new ListViewKeyBinding(KeyCode.PAGE_UP, "DiscontinuousSelectPageUp").vertical().shortcut().shift());
        LIST_VIEW_BINDINGS.add(new ListViewKeyBinding(KeyCode.PAGE_DOWN, "DiscontinuousSelectPageDown").vertical().shortcut().shift());
        LIST_VIEW_BINDINGS.add(new ListViewKeyBinding(KeyCode.HOME, "DiscontinuousSelectAllToFirstRow").vertical().shortcut().shift());
        LIST_VIEW_BINDINGS.add(new ListViewKeyBinding(KeyCode.END, "DiscontinuousSelectAllToLastRow").vertical().shortcut().shift());
        LIST_VIEW_BINDINGS.add(new ListViewKeyBinding(KeyCode.LEFT, "SelectPreviousRow"));
        LIST_VIEW_BINDINGS.add(new ListViewKeyBinding(KeyCode.KP_LEFT, "SelectPreviousRow"));
        LIST_VIEW_BINDINGS.add(new ListViewKeyBinding(KeyCode.RIGHT, "SelectNextRow"));
        LIST_VIEW_BINDINGS.add(new ListViewKeyBinding(KeyCode.KP_RIGHT, "SelectNextRow"));
        LIST_VIEW_BINDINGS.add(new ListViewKeyBinding(KeyCode.LEFT, "AlsoSelectPreviousRow").shift());
        LIST_VIEW_BINDINGS.add(new ListViewKeyBinding(KeyCode.KP_LEFT, "AlsoSelectPreviousRow").shift());
        LIST_VIEW_BINDINGS.add(new ListViewKeyBinding(KeyCode.RIGHT, "AlsoSelectNextRow").shift());
        LIST_VIEW_BINDINGS.add(new ListViewKeyBinding(KeyCode.KP_RIGHT, "AlsoSelectNextRow").shift());
        LIST_VIEW_BINDINGS.add(new ListViewKeyBinding(KeyCode.LEFT, "FocusPreviousRow").shortcut());
        LIST_VIEW_BINDINGS.add(new ListViewKeyBinding(KeyCode.RIGHT, "FocusNextRow").shortcut());
        LIST_VIEW_BINDINGS.add(new KeyBinding(KeyCode.BACK_SLASH, "ClearSelection").shortcut());
    }

    private static class ListViewKeyBinding
    extends OrientedKeyBinding {
        public ListViewKeyBinding(KeyCode code, String action) {
            super(code, action);
        }

        public ListViewKeyBinding(KeyCode code, EventType<KeyEvent> type, String action) {
            super(code, type, action);
        }

        @Override
        public boolean getVertical(Control control) {
            return ((ListView)control).getOrientation() == Orientation.VERTICAL;
        }
    }
}

