/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.behavior;

import com.sun.javafx.scene.control.behavior.ButtonBehavior;
import com.sun.javafx.scene.control.behavior.KeyBinding;
import java.util.ArrayList;
import java.util.List;
import javafx.geometry.NodeOrientation;
import javafx.geometry.Side;
import javafx.scene.control.MenuButton;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;

public abstract class MenuButtonBehaviorBase<C extends MenuButton>
extends ButtonBehavior<C> {
    protected static final String OPEN_ACTION = "Open";
    protected static final String CLOSE_ACTION = "Close";
    protected static final List<KeyBinding> BASE_MENU_BUTTON_BINDINGS = new ArrayList<KeyBinding>();

    public MenuButtonBehaviorBase(C menuButton, List<KeyBinding> bindings) {
        super(menuButton, bindings);
    }

    @Override
    protected void callAction(String name) {
        MenuButton button = (MenuButton)this.getControl();
        Side popupSide = button.getPopupSide();
        if (button.getEffectiveNodeOrientation() == NodeOrientation.RIGHT_TO_LEFT) {
            if (popupSide == Side.LEFT) {
                popupSide = Side.RIGHT;
            } else if (popupSide == Side.RIGHT) {
                popupSide = Side.LEFT;
            }
        }
        if (CLOSE_ACTION.equals(name)) {
            button.hide();
        } else if (OPEN_ACTION.equals(name)) {
            if (button.isShowing()) {
                button.hide();
            } else {
                button.show();
            }
        } else if (!button.isShowing() && "TraverseUp".equals(name) && popupSide == Side.TOP || "TraverseDown".equals(name) && (popupSide == Side.BOTTOM || popupSide == Side.TOP) || "TraverseLeft".equals(name) && popupSide == Side.LEFT || "TraverseRight".equals(name) && (popupSide == Side.RIGHT || popupSide == Side.LEFT)) {
            button.show();
        } else {
            super.callAction(name);
        }
    }

    public void mousePressed(MouseEvent e, boolean behaveLikeButton) {
        MenuButton control = (MenuButton)this.getControl();
        if (behaveLikeButton) {
            if (control.isShowing()) {
                control.hide();
            }
            super.mousePressed(e);
        } else {
            if (!control.isFocused() && control.isFocusTraversable()) {
                control.requestFocus();
            }
            if (control.isShowing()) {
                control.hide();
            } else if (e.getButton() == MouseButton.PRIMARY) {
                control.show();
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e, boolean behaveLikeButton) {
        if (behaveLikeButton) {
            super.mouseReleased(e);
        } else {
            if (((MenuButton)this.getControl()).isShowing() && !((MenuButton)this.getControl()).contains(e.getX(), e.getY())) {
                ((MenuButton)this.getControl()).hide();
            }
            ((MenuButton)this.getControl()).disarm();
        }
    }

    static {
        BASE_MENU_BUTTON_BINDINGS.add(new KeyBinding(KeyCode.UP, "TraverseUp"));
        BASE_MENU_BUTTON_BINDINGS.add(new KeyBinding(KeyCode.DOWN, "TraverseDown"));
        BASE_MENU_BUTTON_BINDINGS.add(new KeyBinding(KeyCode.LEFT, "TraverseLeft"));
        BASE_MENU_BUTTON_BINDINGS.add(new KeyBinding(KeyCode.RIGHT, "TraverseRight"));
        BASE_MENU_BUTTON_BINDINGS.add(new KeyBinding(KeyCode.ESCAPE, KeyEvent.KEY_PRESSED, CLOSE_ACTION));
        BASE_MENU_BUTTON_BINDINGS.add(new KeyBinding(KeyCode.CANCEL, KeyEvent.KEY_PRESSED, CLOSE_ACTION));
    }
}

