/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.behavior;

import com.sun.javafx.Utils;
import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.behavior.KeyBinding;
import com.sun.javafx.scene.control.behavior.OrientedKeyBinding;
import com.sun.javafx.scene.control.behavior.TwoLevelFocusBehavior;
import java.util.ArrayList;
import java.util.List;
import javafx.event.EventType;
import javafx.geometry.NodeOrientation;
import javafx.geometry.Orientation;
import javafx.scene.control.Control;
import javafx.scene.control.Slider;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;

public class SliderBehavior
extends BehaviorBase<Slider> {
    protected static final List<KeyBinding> SLIDER_BINDINGS = new ArrayList<KeyBinding>();
    private TwoLevelFocusBehavior tlFocus;

    @Override
    protected String matchActionForEvent(KeyEvent e) {
        String action = super.matchActionForEvent(e);
        if (action != null) {
            if (e.getCode() == KeyCode.LEFT || e.getCode() == KeyCode.KP_LEFT) {
                if (((Slider)this.getControl()).getEffectiveNodeOrientation() == NodeOrientation.RIGHT_TO_LEFT) {
                    action = ((Slider)this.getControl()).getOrientation() == Orientation.HORIZONTAL ? "IncrementValue" : "DecrementValue";
                }
            } else if ((e.getCode() == KeyCode.RIGHT || e.getCode() == KeyCode.KP_RIGHT) && ((Slider)this.getControl()).getEffectiveNodeOrientation() == NodeOrientation.RIGHT_TO_LEFT) {
                action = ((Slider)this.getControl()).getOrientation() == Orientation.HORIZONTAL ? "DecrementValue" : "IncrementValue";
            }
        }
        return action;
    }

    @Override
    protected void callAction(String name) {
        if ("Home".equals(name)) {
            this.home();
        } else if ("End".equals(name)) {
            this.end();
        } else if ("IncrementValue".equals(name)) {
            this.incrementValue();
        } else if ("DecrementValue".equals(name)) {
            this.decrementValue();
        } else {
            super.callAction(name);
        }
    }

    public SliderBehavior(Slider slider) {
        super(slider, SLIDER_BINDINGS);
        if (com.sun.javafx.scene.control.skin.Utils.isTwoLevelFocus()) {
            this.tlFocus = new TwoLevelFocusBehavior(slider);
        }
    }

    @Override
    public void dispose() {
        if (this.tlFocus != null) {
            this.tlFocus.dispose();
        }
        super.dispose();
    }

    public void trackPress(MouseEvent e, double position) {
        Slider slider = (Slider)this.getControl();
        if (!slider.isFocused()) {
            slider.requestFocus();
        }
        if (slider.getOrientation().equals((Object)Orientation.HORIZONTAL)) {
            slider.adjustValue(position * (slider.getMax() - slider.getMin()) + slider.getMin());
        } else {
            slider.adjustValue((1.0 - position) * (slider.getMax() - slider.getMin()) + slider.getMin());
        }
    }

    public void thumbPressed(MouseEvent e, double position) {
        Slider slider = (Slider)this.getControl();
        if (!slider.isFocused()) {
            slider.requestFocus();
        }
        slider.setValueChanging(true);
    }

    public void thumbDragged(MouseEvent e, double position) {
        Slider slider = (Slider)this.getControl();
        slider.setValue(Utils.clamp(slider.getMin(), position * (slider.getMax() - slider.getMin()) + slider.getMin(), slider.getMax()));
    }

    private double snapValueToTicks(double val) {
        Slider slider = (Slider)this.getControl();
        double v = val;
        double tickSpacing = 0.0;
        tickSpacing = slider.getMinorTickCount() != 0 ? slider.getMajorTickUnit() / (double)(Math.max(slider.getMinorTickCount(), 0) + 1) : slider.getMajorTickUnit();
        int prevTick = (int)((v - slider.getMin()) / tickSpacing);
        double prevTickValue = (double)prevTick * tickSpacing + slider.getMin();
        double nextTickValue = (double)(prevTick + 1) * tickSpacing + slider.getMin();
        v = Utils.nearest(prevTickValue, v, nextTickValue);
        return Utils.clamp(slider.getMin(), v, slider.getMax());
    }

    public void thumbReleased(MouseEvent e) {
        Slider slider = (Slider)this.getControl();
        slider.setValueChanging(false);
        if (slider.isSnapToTicks()) {
            slider.setValue(this.snapValueToTicks(slider.getValue()));
        }
    }

    void home() {
        Slider slider = (Slider)this.getControl();
        slider.adjustValue(slider.getMin());
    }

    void decrementValue() {
        Slider slider = (Slider)this.getControl();
        if (slider.isSnapToTicks()) {
            slider.adjustValue(slider.getValue() - this.computeIncrement());
        } else {
            slider.decrement();
        }
    }

    void end() {
        Slider slider = (Slider)this.getControl();
        slider.adjustValue(slider.getMax());
    }

    void incrementValue() {
        Slider slider = (Slider)this.getControl();
        if (slider.isSnapToTicks()) {
            slider.adjustValue(slider.getValue() + this.computeIncrement());
        } else {
            slider.increment();
        }
    }

    double computeIncrement() {
        Slider slider = (Slider)this.getControl();
        double tickSpacing = 0.0;
        tickSpacing = slider.getMinorTickCount() != 0 ? slider.getMajorTickUnit() / (double)(Math.max(slider.getMinorTickCount(), 0) + 1) : slider.getMajorTickUnit();
        if (slider.getBlockIncrement() > 0.0 && slider.getBlockIncrement() < tickSpacing) {
            return tickSpacing;
        }
        return slider.getBlockIncrement();
    }

    static {
        SLIDER_BINDINGS.add(new KeyBinding(KeyCode.F4, "TraverseDebug").alt().ctrl().shift());
        SLIDER_BINDINGS.add(new SliderKeyBinding(KeyCode.LEFT, "DecrementValue"));
        SLIDER_BINDINGS.add(new SliderKeyBinding(KeyCode.KP_LEFT, "DecrementValue"));
        SLIDER_BINDINGS.add(new SliderKeyBinding(KeyCode.UP, "IncrementValue").vertical());
        SLIDER_BINDINGS.add(new SliderKeyBinding(KeyCode.KP_UP, "IncrementValue").vertical());
        SLIDER_BINDINGS.add(new SliderKeyBinding(KeyCode.RIGHT, "IncrementValue"));
        SLIDER_BINDINGS.add(new SliderKeyBinding(KeyCode.KP_RIGHT, "IncrementValue"));
        SLIDER_BINDINGS.add(new SliderKeyBinding(KeyCode.DOWN, "DecrementValue").vertical());
        SLIDER_BINDINGS.add(new SliderKeyBinding(KeyCode.KP_DOWN, "DecrementValue").vertical());
        SLIDER_BINDINGS.add(new KeyBinding(KeyCode.HOME, KeyEvent.KEY_RELEASED, "Home"));
        SLIDER_BINDINGS.add(new KeyBinding(KeyCode.END, KeyEvent.KEY_RELEASED, "End"));
    }

    public static class SliderKeyBinding
    extends OrientedKeyBinding {
        public SliderKeyBinding(KeyCode code, String action) {
            super(code, action);
        }

        public SliderKeyBinding(KeyCode code, EventType<KeyEvent> type, String action) {
            super(code, type, action);
        }

        @Override
        public boolean getVertical(Control control) {
            return ((Slider)control).getOrientation() == Orientation.VERTICAL;
        }
    }
}

