/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.behavior;

import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.behavior.KeyBinding;
import com.sun.javafx.scene.control.behavior.SpinnerBehavior$$Lambda$1;
import java.util.ArrayList;
import java.util.List;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.control.Spinner;
import javafx.scene.control.SpinnerValueFactory;
import javafx.scene.input.KeyCode;
import javafx.util.Duration;

public class SpinnerBehavior<T>
extends BehaviorBase<Spinner<T>> {
    private static final double INITIAL_DURATION_MS = 750.0;
    private final int STEP_AMOUNT = 1;
    private boolean isIncrementing = false;
    private Timeline timeline;
    final EventHandler<ActionEvent> spinningKeyFrameEventHandler = SpinnerBehavior$$Lambda$1.lambdaFactory$(this);
    private boolean keyDown;
    protected static final List<KeyBinding> SPINNER_BINDINGS = new ArrayList<KeyBinding>();

    public SpinnerBehavior(Spinner<T> spinner) {
        super(spinner, SPINNER_BINDINGS);
    }

    @Override
    protected void callAction(String name) {
        boolean vertical = this.arrowsAreVertical();
        switch (name) {
            case "increment-up": {
                if (vertical) {
                    this.increment(1);
                    break;
                }
                this.traverseUp();
                break;
            }
            case "increment-right": {
                if (!vertical) {
                    this.increment(1);
                    break;
                }
                this.traverseRight();
                break;
            }
            case "decrement-down": {
                if (vertical) {
                    this.decrement(1);
                    break;
                }
                this.traverseDown();
                break;
            }
            case "decrement-left": {
                if (!vertical) {
                    this.decrement(1);
                    break;
                }
                this.traverseLeft();
                break;
            }
            default: {
                super.callAction(name);
            }
        }
    }

    public void increment(int steps) {
        ((Spinner)this.getControl()).increment(steps);
    }

    public void decrement(int steps) {
        ((Spinner)this.getControl()).decrement(steps);
    }

    public void startSpinning(boolean increment) {
        this.isIncrementing = increment;
        if (this.timeline != null) {
            this.timeline.stop();
        }
        this.timeline = new Timeline();
        this.timeline.setCycleCount(-1);
        KeyFrame kf = new KeyFrame(Duration.millis(750.0), this.spinningKeyFrameEventHandler, new KeyValue[0]);
        this.timeline.getKeyFrames().setAll((KeyFrame[])new KeyFrame[]{kf});
        this.timeline.playFromStart();
        this.timeline.play();
        this.spinningKeyFrameEventHandler.handle(null);
    }

    public void stopSpinning() {
        if (this.timeline != null) {
            this.timeline.stop();
        }
    }

    private boolean arrowsAreVertical() {
        ObservableList<String> styleClass = ((Spinner)this.getControl()).getStyleClass();
        return !styleClass.contains("arrows-on-left-horizontal") && !styleClass.contains("arrows-on-right-horizontal") && !styleClass.contains("split-arrows-horizontal");
    }

    /* synthetic */ void lambda$new$210(ActionEvent event) {
        SpinnerValueFactory valueFactory = ((Spinner)this.getControl()).getValueFactory();
        if (valueFactory == null) {
            return;
        }
        if (this.isIncrementing) {
            this.increment(1);
        } else {
            this.decrement(1);
        }
    }

    static {
        SPINNER_BINDINGS.add(new KeyBinding(KeyCode.UP, "increment-up"));
        SPINNER_BINDINGS.add(new KeyBinding(KeyCode.RIGHT, "increment-right"));
        SPINNER_BINDINGS.add(new KeyBinding(KeyCode.LEFT, "decrement-left"));
        SPINNER_BINDINGS.add(new KeyBinding(KeyCode.DOWN, "decrement-down"));
    }
}

