/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.behavior;

import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.behavior.KeyBinding;
import java.util.ArrayList;
import java.util.List;
import javafx.event.Event;
import javafx.geometry.NodeOrientation;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.SingleSelectionModel;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.input.KeyCode;
import javafx.scene.input.MouseEvent;

public class TabPaneBehavior
extends BehaviorBase<TabPane> {
    private static final String HOME = "Home";
    private static final String END = "End";
    private static final String CTRL_PAGE_UP = "Ctrl_Page_Up";
    private static final String CTRL_PAGE_DOWN = "Ctrl_Page_Down";
    private static final String CTRL_TAB = "Ctrl_Tab";
    private static final String CTRL_SHIFT_TAB = "Ctrl_Shift_Tab";
    protected static final List<KeyBinding> TAB_PANE_BINDINGS = new ArrayList<KeyBinding>();

    @Override
    protected void callAction(String name) {
        boolean rtl;
        boolean bl = rtl = ((TabPane)this.getControl()).getEffectiveNodeOrientation() == NodeOrientation.RIGHT_TO_LEFT;
        if ("TraverseLeft".equals(name) && !rtl || "TraverseRight".equals(name) && rtl || "TraverseUp".equals(name)) {
            if (((TabPane)this.getControl()).isFocused()) {
                this.selectPreviousTab();
            }
        } else if ("TraverseRight".equals(name) && !rtl || "TraverseLeft".equals(name) && rtl || "TraverseDown".equals(name)) {
            if (((TabPane)this.getControl()).isFocused()) {
                this.selectNextTab();
            }
        } else if (CTRL_TAB.equals(name) || CTRL_PAGE_DOWN.equals(name)) {
            TabPane tp = (TabPane)this.getControl();
            if (tp.getSelectionModel().getSelectedIndex() == tp.getTabs().size() - 1) {
                tp.getSelectionModel().selectFirst();
            } else {
                this.selectNextTab();
            }
            tp.requestFocus();
        } else if (CTRL_SHIFT_TAB.equals(name) || CTRL_PAGE_UP.equals(name)) {
            TabPane tp = (TabPane)this.getControl();
            if (tp.getSelectionModel().getSelectedIndex() == 0) {
                tp.getSelectionModel().selectLast();
            } else {
                this.selectPreviousTab();
            }
            tp.requestFocus();
        } else if (HOME.equals(name)) {
            if (((TabPane)this.getControl()).isFocused()) {
                ((TabPane)this.getControl()).getSelectionModel().selectFirst();
            }
        } else if (END.equals(name)) {
            if (((TabPane)this.getControl()).isFocused()) {
                ((TabPane)this.getControl()).getSelectionModel().selectLast();
            }
        } else {
            super.callAction(name);
        }
    }

    public static boolean isChildFocused(Node focusedNode, List<Node> children) {
        boolean answer = false;
        for (int i = 0; i < children.size(); ++i) {
            if (children.get(i) == focusedNode) {
                answer = true;
                break;
            }
            if (!(children.get(i) instanceof Parent) || !TabPaneBehavior.isChildFocused(focusedNode, ((Parent)children.get(i)).getChildrenUnmodifiable())) continue;
            return true;
        }
        return answer;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        super.mousePressed(e);
        TabPane tp = (TabPane)this.getControl();
        tp.requestFocus();
    }

    public TabPaneBehavior(TabPane tabPane) {
        super(tabPane, TAB_PANE_BINDINGS);
    }

    public void selectTab(Tab tab) {
        ((TabPane)this.getControl()).getSelectionModel().select(tab);
    }

    public boolean canCloseTab(Tab tab) {
        Event event = new Event(tab, tab, Tab.TAB_CLOSE_REQUEST_EVENT);
        Event.fireEvent(tab, event);
        return !event.isConsumed();
    }

    public void closeTab(Tab tab) {
        TabPane tabPane = (TabPane)this.getControl();
        int index = tabPane.getTabs().indexOf(tab);
        if (index != -1) {
            tabPane.getTabs().remove(index);
        }
        if (tab.getOnClosed() != null) {
            Event.fireEvent(tab, new Event(Tab.CLOSED_EVENT));
        }
    }

    public void selectNextTab() {
        int current;
        SingleSelectionModel<Tab> selectionModel = ((TabPane)this.getControl()).getSelectionModel();
        for (int index = current = selectionModel.getSelectedIndex(); index < ((TabPane)this.getControl()).getTabs().size(); ++index) {
            selectionModel.selectNext();
            if (((Tab)selectionModel.getSelectedItem()).isDisable()) continue;
            return;
        }
        selectionModel.select(current);
    }

    public void selectPreviousTab() {
        int current;
        SingleSelectionModel<Tab> selectionModel = ((TabPane)this.getControl()).getSelectionModel();
        for (int index = current = selectionModel.getSelectedIndex(); index > 0; --index) {
            selectionModel.selectPrevious();
            if (((Tab)selectionModel.getSelectedItem()).isDisable()) continue;
            return;
        }
        selectionModel.select(current);
    }

    static {
        TAB_PANE_BINDINGS.add(new KeyBinding(KeyCode.UP, "TraverseUp"));
        TAB_PANE_BINDINGS.add(new KeyBinding(KeyCode.DOWN, "TraverseDown"));
        TAB_PANE_BINDINGS.add(new KeyBinding(KeyCode.LEFT, "TraverseLeft"));
        TAB_PANE_BINDINGS.add(new KeyBinding(KeyCode.RIGHT, "TraverseRight"));
        TAB_PANE_BINDINGS.add(new KeyBinding(KeyCode.HOME, HOME));
        TAB_PANE_BINDINGS.add(new KeyBinding(KeyCode.END, END));
        TAB_PANE_BINDINGS.add(new KeyBinding(KeyCode.PAGE_UP, CTRL_PAGE_UP).ctrl());
        TAB_PANE_BINDINGS.add(new KeyBinding(KeyCode.PAGE_DOWN, CTRL_PAGE_DOWN).ctrl());
        TAB_PANE_BINDINGS.add(new KeyBinding(KeyCode.TAB, CTRL_TAB).ctrl());
        TAB_PANE_BINDINGS.add(new KeyBinding(KeyCode.TAB, CTRL_SHIFT_TAB).shift().ctrl());
    }
}

